/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.WriteLogUtils;

public class PurchasePriceVarianceRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(PurchasePriceVarianceRptPlugin.class);
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void registerListener(EventObject e) {
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit invorgs = (MulBasedataEdit)this.getControl("invorg");
        invorgs.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit purorder = (MulBasedataEdit)this.getControl("purorder");
        purorder.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.init();
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        switch (name) {
            case "org": {
                List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                QFilter idFilter = new QFilter("id", "in", (Object)permAccountOrgIds);
                listShowParameter.getListFilterParameter().getQFilters().add(idFilter);
                break;
            }
            case "costaccount": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PurchasePriceVarianceRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                listShowParameter.getListFilterParameter().getQFilters().add(StartCostHelper.getEndInitCostAccountIdsFilter((Long)Long.valueOf(org.getPkValue().toString()), (String)"sca"));
                break;
            }
            case "invorg": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PurchasePriceVarianceRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                List storageOrgIdList = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)((Long)org.getPkValue()));
                QFilter qf = new QFilter("id", "in", (Object)storageOrgIdList);
                listShowParameter.getListFilterParameter().getQFilters().add(qf);
                break;
            }
            case "purorder": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PurchasePriceVarianceRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter filter = new QFilter("billentry.entrysettleorg", "=", org.getPkValue());
                filter.and(new QFilter("billstatus", "=", (Object)"C"));
                DynamicObjectCollection poders = QueryServiceHelper.query((String)"pm_purorderbill", (String)"id", (QFilter[])filter.toArray());
                Set collect = poders.stream().map(a -> a.getLong("id")).collect(Collectors.toSet());
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", collect));
            }
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        try {
            String opName = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u67e5\u8be2", (String)"PurchasePriceVarianceRptPlugin_5", (String)"macc-sca-report", (Object[])new Object[0]), (String)"PurchasePriceVarianceRptPlugin_10", (String)"macc-sca-report", (Object[])new Object[0]);
            String opDescription = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"PurchasePriceVarianceRptPlugin_6", (String)"macc-sca-report", (Object[])new Object[0]), (String)"PurchasePriceVarianceRptPlugin_11", (String)"macc-sca-report", (Object[])new Object[0]);
            WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opName, (String)opDescription, (String)"sca_ppvrpt", (IDataModel)this.getModel());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("org");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PurchasePriceVarianceRptPlugin_1", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObject costaccount = filter.getDynamicObject("costaccount");
        if (costaccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"PurchasePriceVarianceRptPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        Date startDate = filter.getDate("startdate");
        if (startDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u65f6\u95f4\u8303\u56f4\u3002", (String)"PurchasePriceVarianceRptPlugin_3", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        Date endDate = filter.getDate("enddate");
        if (endDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u65f6\u95f4\u8303\u56f4\u3002", (String)"PurchasePriceVarianceRptPlugin_3", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObjectCollection invorg = filter.getDynamicObjectCollection("invorg");
        if (invorg == null || invorg.size() < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"PurchasePriceVarianceRptPlugin_4", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        return super.verifyQuery(queryParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyname = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyname) {
            case "org": {
                this.setCostAccount();
            }
        }
    }

    private void init() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            return;
        }
        this.getModel().setValue("startdate", (Object)new Date());
        this.getModel().setValue("enddate", (Object)new Date());
        this.getView().updateView("daterange");
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        if (isaccount) {
            this.getModel().setValue("org", (Object)currentOrgId);
            this.getView().updateView("org");
        }
        org = (DynamicObject)this.getModel().getValue("org");
        this.setCostAccount();
    }

    private void setCostAccount() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        this.getModel().setValue("costaccount", null);
        this.getModel().setValue("invorg", null);
        if (org == null) {
            return;
        }
        Long mainBookId = StartCostHelper.getCostAccountByAccoutOrg((Long)org.getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
        if (mainBookId != null && mainBookId != 0L) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
        } else {
            this.getModel().setValue("costaccount", null);
        }
        this.getView().updateView("costaccount");
        this.getView().updateView("invorg");
    }
}

