/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.report.helper.ScaRptHelper;

public class WipDiffSumRptQuery
extends AbstractReportListDataPlugin {
    private Long currencyId;
    private final String total = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"WipDiffSumRptQuery_0", (String)"macc-sca-report", (Object[])new Object[0]);
    private static String[] manuSelectFields = new String[]{"prodorg", "transactiontype", "billstatus", "material as manumaterial", "unit as manuunit", "qty", "planstatus", "entrytaskstatus", "bizstatus as manubizstatus", "inbillqty", "surplusqty", "transmittime", "startworktime", "endworktime", "closetime"};
    private static String[] SELECTED_FIELDS = new String[]{"entryperiod", "entrycostcenter", "entrycostcentername", "entrycostobject", "manubill", "manuentryseq", "entrycostobjectname", "orderbyfield", "unit", "elementid", "element", "subelement", "material", "matversion", "auxpty", "pdstartqty", "pdstartamount", "pdcurrqty", "pdcurramount", "pdcompqty", "pdcompanount", "pdendqty", "pdendamount", "totalqty", "totalamount", "stdqty", "stdamount", "diff", "diffqty", "diffamount", "totalupdatediff"};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        QFilter filter = this.getQFilter(reportQueryParam);
        ORM orm = ORM.create();
        String algoKey = ((Object)((Object)this)).getClass().getName() + ".query";
        String selectFields = this.getQueryFields();
        DataSet dataSet = orm.queryDataSet(algoKey, "sca_calcresult", selectFields, new QFilter[]{filter});
        Boolean isShowDetail = this.isShowDetail(reportQueryParam);
        DataSet dataSet_update = dataSet.copy().filter("difftype = '3'");
        dataSet_update = dataSet_update.groupBy(new String[]{"entryperiod", "entrycostcenter", "entrycostobject", "elementid", "subelement", "material", "matversion", "auxpty"}).sum("curupdatediff").finish();
        DataSet dataSet_update_sum = dataSet_update.groupBy(new String[]{"entryperiod", "entrycostcenter", "entrycostobject"}).sum("curupdatediff").finish().select("entryperiod,entrycostcenter,entrycostobject,null as elementid,null subelement,0L material,0L matversion,0L auxpty,curupdatediff");
        dataSet_update = dataSet_update.union(dataSet_update_sum);
        dataSet = this.getGroupData(dataSet, isShowDetail);
        dataSet = this.unionUnitDataSet(dataSet);
        dataSet = this.mergeDataSet(dataSet);
        dataSet = dataSet.join(dataSet_update, JoinType.LEFT).on("entryperiod", "entryperiod").on("entrycostcenter", "entrycostcenter").on("entrycostobject", "entrycostobject").on("elementid", "elementid").on("subelement", "subelement").on("material", "material").on("matversion", "matversion").on("auxpty", "auxpty").select(dataSet.getRowMeta().getFieldNames(), new String[]{"curupdatediff"}).finish();
        dataSet = dataSet.executeSql(this.getSelectFeilds(isShowDetail));
        dataSet = this.queryManuBill(dataSet);
        List<Object[]> dataList = this.count(dataSet, isShowDetail, reportQueryParam);
        dataSet = Algo.create((String)"macc.sca.CalcAllItemQueryPlugin").createDataSet(dataList.iterator(), this.getRowMeta(isShowDetail));
        return dataSet.orderBy(new String[]{"entrycostobject desc", "entryseq", "subelement asc"});
    }

    protected List<Object[]> count(DataSet dataSet, Boolean isShowDetail, ReportQueryParam reportQueryParam) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        HashSet<Long> costObjectIds = new HashSet<Long>();
        HashSet<Long> allCostObjectIds = new HashSet<Long>(16);
        HashSet<Long> elementIds = new HashSet<Long>();
        for (Row row : dataSet.copy()) {
            elementIds.add(row.getLong("elementid"));
            if (this.total.equals(row.getString("subelement"))) {
                costObjectIds.add(row.getLong("entrycostobject"));
            }
            allCostObjectIds.add(row.getLong("entrycostobject"));
        }
        FilterInfo filterInfo = reportQueryParam.getFilter();
        QFilter costObjectQf = new QFilter("costobject", "in", allCostObjectIds);
        QFilter costAccountQf = new QFilter("costaccount", "=", this.getFilterItemValue(filterInfo, "costaccount"));
        DynamicObjectCollection costObjectAccounts = QueryServiceHelper.query((String)"cad_costobjectaccount", (String)"costobject,bizstatus", (QFilter[])new QFilter[]{costObjectQf, costAccountQf});
        HashMap<Long, String> bizStatusMap = new HashMap<Long, String>(16);
        allCostObjectIds.clear();
        for (DynamicObject costObjectAccount : costObjectAccounts) {
            bizStatusMap.put(costObjectAccount.getLong("costobject"), costObjectAccount.getString("bizstatus"));
        }
        DynamicObjectCollection costObjet = QueryServiceHelper.query((String)"cad_costobject", (String)"id,material,bomversion matversion,auxpty", (QFilter[])new QFilter[]{new QFilter("id", "in", costObjectIds)});
        QFilter elementNameFilter = new QFilter("id", "in", elementIds);
        QFilter elementTypeFilter = new QFilter("type", "in", Arrays.asList("003", "004"));
        DynamicObjectCollection element = QueryServiceHelper.query((String)"cad_element", (String)"id", (QFilter[])new QFilter[]{elementNameFilter, elementTypeFilter});
        HashSet existsElementIds = new HashSet();
        element.forEach(p -> existsElementIds.add(p.getLong("id")));
        DynamicObjectCollection resource = QueryServiceHelper.query((String)"cad_resourcerate", (String)"element", (QFilter[])new QFilter[]{new QFilter("element", "in", existsElementIds), new QFilter("calcbasis", "=", (Object)"001")});
        HashSet existsEleIds = new HashSet();
        resource.forEach(p -> existsEleIds.add(p.getLong("element")));
        Field[] fields = this.getRowMeta(isShowDetail).getFields();
        DynamicObject curCostObject = null;
        for (Row row : dataSet) {
            curCostObject = this.total.equals(row.getString("subelement")) ? this.getCurCostObject(row.getLong("entrycostobject"), costObjet) : null;
            Object[] rowData = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                String name = fields[i].getName();
                Object val = row.get(name);
                switch (name) {
                    case "material": 
                    case "matversion": 
                    case "auxpty": {
                        if (curCostObject == null) break;
                        val = curCostObject.getLong(name);
                        break;
                    }
                    case "unit": {
                        Long elementId = row.getLong("elementid");
                        if (val == null && existsElementIds.contains(elementId) && existsEleIds.contains(elementId)) {
                            val = 9L;
                            break;
                        }
                        if (val != null || !existsElementIds.contains(elementId) || existsEleIds.contains(elementId)) break;
                        val = 11L;
                        break;
                    }
                    case "entrybizstatus": {
                        val = bizStatusMap.containsKey(row.getLong("entrycostobject")) ? bizStatusMap.get(row.getLong("entrycostobject")) : "A";
                    }
                }
                rowData[i] = val;
            }
            dataList.add(rowData);
        }
        return dataList;
    }

    private DataSet queryManuBill(DataSet result) {
        if (result != null) {
            DataSet copyTradebill = result.copy();
            HashSet<String> manuIds = new HashSet<String>();
            while (copyTradebill.hasNext()) {
                Row bill = copyTradebill.next();
                String manubill = bill.getString("manubill");
                if (!kd.bos.util.StringUtils.isNotEmpty((String)manubill)) continue;
                manuIds.add(manubill);
            }
            if (manuIds.size() > 0) {
                String manuFactureFields = ScaRptHelper.getManuFactureFields();
                QFilter filter = new QFilter("billno", "in", manuIds);
                DataSet pom_manufacturebill = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "_manufacturebill"), (String)"pom_mftorder", (String)manuFactureFields, (QFilter[])new QFilter[]{filter}, null);
                result = pom_manufacturebill.join(result, JoinType.LEFT).on("manubill", "manubill").on("manuentryseq", "manuentryseq").select(manuSelectFields, result.getRowMeta().getFieldNames()).finish();
            }
        }
        return result;
    }

    private DynamicObject getCurCostObject(Long costObjectId, DynamicObjectCollection costObject) {
        for (DynamicObject cost : costObject) {
            if (!costObjectId.equals(cost.getLong("id"))) continue;
            return cost;
        }
        return null;
    }

    protected RowMeta getRowMeta(Boolean isShowDetail) {
        List<Field> field = this.getRowMetaField(isShowDetail);
        return new RowMeta(field.toArray(new Field[0]));
    }

    protected List<Field> getRowMetaField(Boolean isShowDetail) {
        ArrayList<Field> field = new ArrayList<Field>(33);
        field.add(new Field("prodorg", (DataType)DataType.LongType));
        field.add(new Field("manubill", (DataType)DataType.StringType));
        field.add(new Field("transactiontype", (DataType)DataType.LongType));
        field.add(new Field("billstatus", (DataType)DataType.StringType));
        field.add(new Field("manumaterial", (DataType)DataType.LongType));
        field.add(new Field("manuunit", (DataType)DataType.LongType));
        field.add(new Field("qty", (DataType)DataType.BigDecimalType));
        field.add(new Field("planstatus", (DataType)DataType.StringType));
        field.add(new Field("entrytaskstatus", (DataType)DataType.StringType));
        field.add(new Field("manubizstatus", (DataType)DataType.StringType));
        field.add(new Field("inbillqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("surplusqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("startworktime", (DataType)DataType.DateType));
        field.add(new Field("transmittime", (DataType)DataType.DateType));
        field.add(new Field("endworktime", (DataType)DataType.DateType));
        field.add(new Field("closetime", (DataType)DataType.DateType));
        field.add(new Field("entrycurrency", (DataType)DataType.LongType));
        field.add(new Field("entryperiod", (DataType)DataType.StringType));
        field.add(new Field("entrycostcenter", (DataType)DataType.LongType));
        field.add(new Field("entrycostcentername", (DataType)DataType.StringType));
        field.add(new Field("entrycostobject", (DataType)DataType.LongType));
        field.add(new Field("entrybizstatus", (DataType)DataType.StringType));
        field.add(new Field("entrycostobjectname", (DataType)DataType.StringType));
        field.add(new Field("orderbyfield", (DataType)DataType.StringType));
        field.add(new Field("unit", (DataType)DataType.LongType));
        field.add(new Field("elementid", (DataType)DataType.LongType));
        field.add(new Field("element", (DataType)DataType.StringType));
        field.add(new Field("subelement", (DataType)DataType.StringType));
        if (isShowDetail.booleanValue()) {
            field.add(new Field("material", (DataType)DataType.LongType));
            field.add(new Field("matversion", (DataType)DataType.LongType));
            field.add(new Field("auxpty", (DataType)DataType.LongType));
        }
        field.add(new Field("pdstartqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("pdstartamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("pdcurrqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("pdcurramount", (DataType)DataType.BigDecimalType));
        field.add(new Field("pdcompqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("pdcompanount", (DataType)DataType.BigDecimalType));
        field.add(new Field("pdendqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("pdendamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("stdqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("stdamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("diff", (DataType)DataType.BigDecimalType));
        field.add(new Field("diffqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("diffamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalupdatediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("entryseq", (DataType)DataType.IntegerType));
        field.add(new Field("curupdatediff", (DataType)DataType.BigDecimalType));
        return field;
    }

    private String getQueryFields() {
        String fields = "period.name AS entryperiod,costcenter.id AS entrycostcenter,costcenter.name AS entrycostcentername,costobject AS entrycostobject,costobject.srcbillnumber as manubill,costobject.srcbillrow as manuentryseq,'' entrybizstatus,costobject.name AS entrycostobjectname,' ' AS orderbyfield,entryentity.element.id AS elementid,entryentity.element.name AS element,entryentity.subelement.name AS subelement,entryentity.material AS material,entryentity.matversion AS matversion,entryentity.auxpty AS auxpty,entryentity.pdstartqty AS pdstartqty,entryentity.pdstartamount AS pdstartamount,entryentity.pdcurrqty AS pdcurrqty,entryentity.pdcurramount AS pdcurramount,entryentity.pdcompqty AS pdcompqty,entryentity.pdcompanount AS pdcompanount,entryentity.pdendqty AS pdendqty,entryentity.pdendamount AS pdendamount,entryentity.totalqty AS totalqty,entryentity.totalamount AS totalamount,entryentity.stdqty AS stdqty,entryentity.stdamount AS stdamount,entryentity.diff AS diff,entryentity.difftype as difftype,entryentity.diffqty AS diffqty,entryentity.diff AS diffamount,entryentity.costupdatediffamt AS totalupdatediff,entryentity.pdcurramount as curupdatediff";
        return fields;
    }

    private DataSet getCostObjectUnit(DataSet data) {
        String algoKey = ((Object)((Object)this)).getClass().getName() + ".getCostObjectUnit";
        HashSet<Long> costObjectIds = new HashSet<Long>();
        for (Row row : data) {
            costObjectIds.add(row.getLong("entrycostobject"));
        }
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_costobject", (String)"id costobject,material.baseunit.id unit", (QFilter[])new QFilter[]{new QFilter("id", "in", costObjectIds)}, null);
    }

    private DataSet getGroupData(DataSet data, Boolean isShowDetail) {
        if (isShowDetail.booleanValue()) {
            return data;
        }
        String strSql = "select entryperiod,entrycostcenter,entrycostcentername,entrycostobject,'' entrybizstatus,entrycostobjectname,orderbyfield,elementid,element,subelement,0 AS material,0 AS matversion,0 AS auxpty,sum(pdstartqty) AS pdstartqty,sum(pdstartamount) AS pdstartamount,sum(pdcurrqty) AS pdcurrqty,sum(pdcurramount) AS pdcurramount,sum(pdcompqty) AS pdcompqty,sum(pdcompanount) AS pdcompanount,sum(pdendqty) AS pdendqty,sum(pdendamount) AS pdendamount,sum(totalqty) AS totalqty,sum(totalamount) AS totalamount,sum(stdqty) AS stdqty,sum(stdamount) AS stdamount,sum(diff) AS diff,sum(diffqty) AS diffqty,sum(diffamount) AS diffamount,sum(totalupdatediff) AS totalupdatediff group by entryperiod,entrycostcenter,entrycostcentername,entrycostobject,manubill,manuentryseq,entrycostobjectname,orderbyfield,elementid,element,subelement,material,matversion,auxpty";
        return data.executeSql(strSql);
    }

    private DataSet unionUnitDataSet(DataSet data) {
        DataSet costObject = data.copy();
        costObject = this.getCostObjectUnit(costObject);
        DataSet newData = data.leftJoin(costObject).on("entrycostobject", "costobject").select(SELECTED_FIELDS).finish();
        return newData;
    }

    private String getSelectFeilds(Boolean isShowDetail) {
        if (isShowDetail.booleanValue()) {
            return "select " + this.currencyId + " AS entrycurrency,entryperiod,entrycostcenter,entrybizstatus,entrycostcentername,entrycostobject,manubill,manuentryseq,entrycostobjectname,orderbyfield,case when subelement is null then unit when material > 0 then unit else null end unit,elementid,element,case when subelement is null then '" + this.total + "' else subelement end subelement,material,matversion,auxpty,case when subelement is null then 1 else 2 end entryseq,pdstartqty,pdstartamount,pdcurrqty,pdcurramount,pdcompqty,pdcompanount,pdendqty,pdendamount,totalqty,totalamount,stdqty,stdamount,diff,diffqty,diffamount,totalupdatediff,curupdatediff";
        }
        return "select " + this.currencyId + " AS entrycurrency,entryperiod,entrycostcenter,entrybizstatus,entrycostcentername,entrycostobject,manubill,manuentryseq,entrycostobjectname,orderbyfield,case when subelement is null then unit else null end unit,elementid,element,case when subelement is null then '" + this.total + "' else subelement end subelement,case when subelement is null then 1 else 2 end entryseq,pdstartqty,pdstartamount,pdcurrqty,pdcurramount,pdcompqty,pdcompanount,pdendqty,pdendamount,totalqty,totalamount,stdqty,stdamount,diff,diffqty,diffamount,totalupdatediff,curupdatediff";
    }

    private DataSet mergeDataSet(DataSet dataSet) {
        String strSql = "select entryperiod,entrycostcenter,entrycostcentername,entrycostobject,manubill,manuentryseq,'' entrybizstatus,entrycostobjectname,(entryperiod + entrycostcentername + entrycostobjectname + subelement) AS orderbyfield,unit,elementid,element,subelement,material,matversion,auxpty,sum(pdstartqty) AS pdstartqty,sum(pdstartamount) AS pdstartamount,sum(pdcurrqty) AS pdcurrqty,sum(pdcurramount) AS pdcurramount,sum(pdcompqty) AS pdcompqty,sum(pdcompanount) AS pdcompanount,sum(pdendqty) AS pdendqty,sum(pdendamount) AS pdendamount,sum(totalqty) AS totalqty,sum(totalamount) AS totalamount,sum(stdqty) AS stdqty,sum(stdamount) AS stdamount,sum(diff) AS diff,sum(diffqty) AS diffqty,sum(diffamount) AS diffamount,sum(totalupdatediff) AS totalupdatediff group by entryperiod,entrycostcenter,entrycostcentername,entrycostobject,manubill,manuentryseq,entrycostobjectname,orderbyfield,unit,elementid,element,subelement,material,matversion,auxpty";
        return dataSet.executeSql(strSql);
    }

    private Boolean isShowDetail(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        return (Boolean)this.getFilterItemValue(filterInfo, "isshowdetail");
    }

    private QFilter getQFilter(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        Object value = null;
        value = this.getFilterItemValue(filterInfo, "org");
        QFilter filter = new QFilter("org", "=", value);
        value = this.getFilterItemValue(filterInfo, "costaccount");
        filter.and(new QFilter("costaccount", "=", value));
        this.currencyId = (Long)this.getFilterItemValue(filterInfo, "currency");
        value = this.getFilterItemValue(filterInfo, "period");
        filter.and(new QFilter("period", "in", value));
        value = this.getFilterItemValue(filterInfo, "costcenter");
        if (value != null) {
            filter.and(new QFilter("costcenter", "in", value));
        }
        value = this.getFilterItemValue(filterInfo, "costobject");
        String bizstatus = (String)this.getFilterItemValue(filterInfo, "bizstatus");
        if (value != null) {
            if (!StringUtils.isEmpty((Object)bizstatus)) {
                value = this.filterCostObjectByBizStatus(value, bizstatus);
            }
            if (CollectionUtils.isEmpty((Collection)((List)value))) {
                filter.and(new QFilter("costobject", "=", (Object)0L));
            } else {
                filter.and(new QFilter("costobject", "in", value));
            }
        } else if (!StringUtils.isEmpty((Object)bizstatus)) {
            value = this.filterCostObjectByBizStatus(null, bizstatus);
            if (CollectionUtils.isEmpty((Collection)((List)value))) {
                filter.and(new QFilter("costobject", "=", (Object)0L));
            } else {
                filter.and(new QFilter("costobject", "in", value));
            }
        }
        value = this.getFilterItemValue(filterInfo, "pombillno");
        if (value != null && !"".equals(String.valueOf(value))) {
            filter.and(new QFilter("costobject.srcbillnumber", "in", (Object)String.valueOf(value).split(";")));
        }
        if ((value = this.getFilterItemValue(filterInfo, "headsubelement")) != null) {
            filter.and(new QFilter("entryentity.subelement", "=", value));
        }
        filter.and(new QFilter("entryentity.caltype", "in", (Object)new String[]{"1", "2", "3", "4", "5"}));
        filter.and(new QFilter("entryentity.datatype", "in", (Object)new String[]{"1", "98", "99"}));
        return filter;
    }

    private Object filterCostObjectByBizStatus(Object costObjectIds, Object bizstatus) {
        QFilter[] filters = null;
        List<Object> list = new ArrayList();
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter bizstatusFilter = new QFilter("bizstatus", "=", bizstatus);
        if (bizstatus != null && "ALL".equals(bizstatus)) {
            bizstatusFilter = new QFilter("bizstatus", "in", (Object)new String[]{"A", "B"});
        }
        if (costObjectIds != null) {
            QFilter idFilter = new QFilter("id", "in", costObjectIds);
            filters = new QFilter[]{billstatusFilter, bizstatusFilter, idFilter};
        } else {
            filters = new QFilter[]{billstatusFilter, bizstatusFilter};
        }
        DynamicObjectCollection ids = QueryServiceHelper.query((String)"cad_costobject", (String)"id", (QFilter[])filters);
        if (ids.size() > 0) {
            list = ids.stream().map(e -> e.get("id")).collect(Collectors.toList());
        }
        return list;
    }

    private Object getFilterItemValue(FilterInfo filterInfo, String propName) {
        FilterItemInfo filterItem = filterInfo.getFilterItem(propName);
        if (filterItem != null && filterItem.getValue() != null) {
            Object value = filterItem.getValue();
            if (value instanceof DynamicObject) {
                return ((DynamicObject)value).getPkValue();
            }
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection values = (DynamicObjectCollection)value;
                return values.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            }
            return value;
        }
        return null;
    }
}

