/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.sca.report.helper.ScaRptHelper;

public class WipRptQuery
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(WipRptQuery.class);
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        logger.info("wip\u53d1\u751f\u989d\u62a5\u8868\u67e5\u8be2");
        FilterInfo filterInfo = reportQueryParam.getFilter();
        String bustype = filterInfo.getString("bustype");
        DataSet tradeBillResult = null;
        switch (bustype) {
            case "ALL": {
                tradeBillResult = this.queryAllTradeBill(filterInfo);
                break;
            }
            case "TL": {
                tradeBillResult = this.queryMatAlloc(filterInfo);
                break;
            }
            case "WG": {
                tradeBillResult = this.queryFactnedOutPut(filterInfo);
                break;
            }
            case "BG": {
                tradeBillResult = this.queryResAbsorbBill(filterInfo);
                break;
            }
            case "GB": {
                tradeBillResult = this.queryFinishDiffBill(filterInfo);
                break;
            }
            case "GX": {
                tradeBillResult = this.queryCosChangeBill(filterInfo);
                break;
            }
        }
        String opName = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u67e5\u8be2", (String)"WipRptQuery_2", (String)"macc-sca-report", (Object[])new Object[0]), (String)"WipRptQuery_1", (String)"macc-sca-report", (Object[])new Object[0]);
        String opDescription = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"WipRptQuery_3", (String)"macc-sca-report", (Object[])new Object[0]), (String)"WipRptQuery_2", (String)"macc-sca-report", (Object[])new Object[0]);
        WriteLogUtils.addLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opName, (String)opDescription, (String)"sca_wipaccumamtrpt");
        if (tradeBillResult != null) {
            DataSet copyTradebill = tradeBillResult.copy();
            HashSet<String> manuIds = new HashSet<String>();
            while (copyTradebill.hasNext()) {
                Row bill = copyTradebill.next();
                String manubill = bill.getString("manubill");
                if (!StringUtils.isNotEmpty((String)manubill)) continue;
                manuIds.add(manubill);
            }
            if (manuIds.size() > 0) {
                String manuFactureFields = ScaRptHelper.getManuFactureFields();
                DynamicObject prudorg = filterInfo.getDynamicObject("prodorg");
                QFilter filter = new QFilter("billno", "in", manuIds);
                if (prudorg != null) {
                    filter.and(new QFilter("org", "=", prudorg.getPkValue()));
                }
                DataSet pom_manufacturebill = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "_manufacturebill"), (String)"pom_mftorder", (String)manuFactureFields, (QFilter[])new QFilter[]{filter}, null);
                String[] manuSelectFields = new String[]{"'" + filterInfo.getDynamicObject("org").getPkValue() + "' as settleorg", "'" + filterInfo.getDynamicObject("period").getPkValue() + "' as settleperiod", "prodorg", "manubill", "manuentryseq", "transactiontype", "billstatus", "material", "unit", "qty", "planstatus", "entrytaskstatus", "bizstatus", "inbillqty", "surplusqty", "transmittime", "startworktime", "endworktime", "closetime", "configuredcode", "tracknumber"};
                String[] tradeFields = new String[]{"tradetype", "applybillno", "tradebillno", "bookdate", "trademateriel", "resource", "tradeqty", "tradebaseunit", "subelement", "amount", "productcost", "updatedcost", "difftype", "'" + filterInfo.getDynamicObject("currency").getPkValue() + "' as entrycurrency"};
                tradeBillResult = pom_manufacturebill.join(tradeBillResult, JoinType.LEFT).on("manubill", "manubill").on("manuentryseq", "manuentryseq").select(manuSelectFields, tradeFields).finish();
            }
        }
        if (tradeBillResult == null) {
            return tradeBillResult;
        }
        return tradeBillResult.orderBy(new String[]{"manubill desc", "tradetype desc"});
    }

    private DataSet queryAllTradeBill(FilterInfo filterInfo) {
        logger.info("wip\u53d1\u751f\u989d\u62a5\u8868\u67e5\u8be2\u6240\u6709\u5355\u636e");
        DataSet matAllocResult = this.queryMatAlloc(filterInfo);
        DataSet factnedOutPutResult = this.queryFactnedOutPut(filterInfo);
        DataSet resAbsorbResult = this.queryResAbsorbBill(filterInfo);
        DataSet finishDiffResult = this.queryFinishDiffBill(filterInfo);
        DataSet cosChangeResult = this.queryCosChangeBill(filterInfo);
        return matAllocResult.union(factnedOutPutResult).union(resAbsorbResult).union(finishDiffResult).union(cosChangeResult);
    }

    private DataSet queryFactnedOutPut(FilterInfo filterInfo) {
        logger.info("wip\u53d1\u751f\u989d\u62a5\u8868\u67e5\u8be2\u5b8c\u5de5\u5165\u5e93\u6570\u91cf\u5f52\u96c6\u5355");
        List<QFilter> factnedOutPutFilters = ScaRptHelper.getFactnedOutPutFilters(filterInfo);
        String entryentityFields = ScaRptHelper.getFactnedOutPutEntryentityFields();
        List<QFilter> newList = factnedOutPutFilters;
        String pombillno = filterInfo.getString("pombillno");
        StringJoiner billnos = new StringJoiner(",");
        if (StringUtils.isNotEmpty((String)pombillno)) {
            String[] split;
            for (String s : split = pombillno.split(";")) {
                billnos.add("'" + s + "'");
            }
        }
        pombillno = billnos.toString();
        DataSet entryentity = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "_queryFactnedOutPut_1"), (String)"cad_factnedoutputbill", (String)entryentityFields, (QFilter[])newList.toArray(new QFilter[newList.size()]), null);
        DynamicObject costaccount = filterInfo.getDynamicObject("costaccount");
        if (costaccount != null) {
            factnedOutPutFilters.add(new QFilter("entrycost.costaccount", "=", costaccount.getPkValue()));
        }
        String mftManuBillFields = ScaRptHelper.getFactnedOutPutEntryCostFields();
        DataSet im_mdc_mftproord = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "__queryFactnedOutPut_2"), (String)"cad_factnedoutputbill", (String)mftManuBillFields, (QFilter[])factnedOutPutFilters.toArray(new QFilter[factnedOutPutFilters.size()]), null);
        im_mdc_mftproord = im_mdc_mftproord.join(entryentity, JoinType.LEFT).on("tradebillno", "tradebillno").select(new String[]{"tradetype", "manubill", "manuentryseq", "tradebillno", "bookdate", "trademateriel", "resource", "tradeqty", "tradebaseunit", "subelement", "stdprice*qty as amount", "productcost", "updatedcost", "difftype", "'' as applybillno"}).finish();
        if (StringUtils.isNotEmpty((String)pombillno)) {
            im_mdc_mftproord = im_mdc_mftproord.filter("manubill in (" + billnos + ")");
        }
        return im_mdc_mftproord;
    }

    private DataSet queryMatAlloc(FilterInfo filterInfo) {
        logger.info("wip\u53d1\u751f\u989d\u62a5\u8868\u67e5\u8be2\u6750\u6599\u8017\u7528\u5206\u914d\u4fe1\u606f");
        List<QFilter> filters = ScaRptHelper.getMatAllocFilters(filterInfo);
        String feedingOrderFields = ScaRptHelper.getMatAllocFields();
        DataSet aca_matalloc = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "_queryMatAlloc"), (String)"sca_matalloc", (String)feedingOrderFields, (QFilter[])filters.toArray(new QFilter[filters.size()]), null);
        Long orgId = filterInfo.getDynamicObject("org").getLong("id");
        Long costAccountId = filterInfo.getDynamicObject("costaccount").getLong("id");
        DataSet amountDataSet = this.getAmountDataSet(aca_matalloc.copy(), orgId, costAccountId);
        aca_matalloc = aca_matalloc.leftJoin(amountDataSet).on("tradebillno", "tradebillno").on("product", "product").on("trademateriel", "trademateriel").select(aca_matalloc.getRowMeta().getFieldNames(), new String[]{"subelement", "amount"}).finish();
        DataSet subelement = aca_matalloc.groupBy(new String[]{"tradetype", "manubill", "manuentryseq", "applybillno", "tradebillno", "bookdate", "trademateriel", "resource", "productcost", "updatedcost", "difftype", "tradeqty", "tradebaseunit", "subelement"}).sum("amount").finish().select(new String[]{"tradetype", "manubill", "manuentryseq", "tradebillno", "bookdate", "trademateriel", "resource", "tradeqty", "tradebaseunit", "subelement", "amount", "productcost", "updatedcost", "difftype", "applybillno"});
        return subelement;
    }

    private DataSet getAmountDataSet(DataSet srcDataSet, Long orgId, Long costAccountId) {
        List<Map<String, Object>> params = this.getMatCostParams(srcDataSet, orgId);
        ArrayList<Object[]> dataSetList = new ArrayList<Object[]>(10);
        List partyParams = Lists.partition(new ArrayList<Map<String, Object>>(params), (int)10000);
        for (List partyParam : partyParams) {
            Map<String, List<Map<String, Object>>> result = this.getMatCost(orgId, costAccountId, partyParam);
            for (Map.Entry<String, List<Map<String, Object>>> entry : result.entrySet()) {
                String keyValue = entry.getKey();
                for (Map<String, Object> map : entry.getValue()) {
                    if (!"4".equals(map.get("datatype"))) continue;
                    ArrayList<Object> temp = new ArrayList<Object>(16);
                    temp.add(keyValue);
                    temp.add(map.get("subelement"));
                    temp.add(map.get("material"));
                    temp.add(map.get("submaterial"));
                    temp.add(map.get("stdprice"));
                    dataSetList.add(temp.toArray());
                }
            }
        }
        DataSet dataSetTemp = Algo.create((String)"mn").createDataSet(dataSetList.iterator(), this.getRowMeta());
        return dataSetTemp;
    }

    private Map<String, List<Map<String, Object>>> getMatCost(Long orgId, Long costAccountId, List<Map<String, Object>> partyParam) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"MatCostInfoPriceService", (String)"getMatCost", (Object[])new Object[]{partyParam, orgId, costAccountId, "3", "sca"});
        return result;
    }

    private RowMeta getRowMeta() {
        Field[] fields = new Field[]{new Field("tradebillno", (DataType)DataType.StringType), new Field("subelement", (DataType)DataType.LongType), new Field("product", (DataType)DataType.LongType), new Field("trademateriel", (DataType)DataType.LongType), new Field("amount", (DataType)DataType.BigDecimalType)};
        return new RowMeta(fields);
    }

    private List<Map<String, Object>> getMatCostParams(DataSet srcDataSet, Long orgId) {
        boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
        HashMap<Long, Long> manuorgMap = new HashMap<Long, Long>(2);
        Long invOrgId = 0L;
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        while (srcDataSet.hasNext()) {
            Row row = srcDataSet.next();
            if (enableMulFactory) {
                Long manuOrgId = row.getLong("manuorg");
                if (CadEmptyUtils.isEmpty((Long)((Long)manuorgMap.get(manuOrgId)))) {
                    List invList = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)manuOrgId, (boolean)true);
                    if (invList != null && invList.size() > 0) {
                        invOrgId = (Long)invList.get(0);
                        manuorgMap.put(manuOrgId, invOrgId);
                    }
                } else {
                    invOrgId = (Long)manuorgMap.get(manuOrgId);
                }
            }
            param = new HashMap(8);
            param.put("uniqueID", row.getString("tradebillno"));
            param.put("invorg", invOrgId);
            param.put("date", row.getDate("bookdate"));
            param.put("material", row.getLong("product"));
            param.put("assist", row.getLong("auxpty"));
            param.put("configuredcode", row.getLong("configuredcode"));
            param.put("tracknumber", row.getLong("tracknumber"));
            param.put("lot", row.getString("lot"));
            param.put("project", row.getLong("projectnumber"));
            params.add(param);
        }
        return params;
    }

    private DataSet queryResAbsorbBill(FilterInfo filterInfo) {
        logger.info("wip\u53d1\u751f\u989d\u62a5\u8868\u67e5\u8be2\u8d44\u6e90\u8d39\u7528\u5438\u6536\u6210\u672c\u5355");
        QFilter[] filters = ScaRptHelper.getResAbsorbBillFilters(filterInfo);
        String fields = ScaRptHelper.getResAbsorbBillFields();
        DataSet dataset = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "_queryResAbsorbBill"), (String)"sca_resourceabsorb", (String)fields, (QFilter[])filters, null);
        return dataset;
    }

    private DataSet queryCosChangeBill(FilterInfo filterInfo) {
        logger.info("wip\u53d1\u751f\u989d\u62a5\u8868\u67e5\u8be2\u66f4\u65b0\u6210\u672c\u786e\u8ba4\u5355");
        QFilter[] filters = ScaRptHelper.getCosChangeBillFilters(filterInfo);
        String fields = ScaRptHelper.getCosChangeBillFields();
        DataSet dataset = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "_queryCosChangeBill"), (String)"cad_costupdateestablished", (String)fields, (QFilter[])filters, null);
        DataSet updateApplyBillResult = this.queryUpdateApplyBill();
        DataSet tradeBillResult = dataset.join(updateApplyBillResult, JoinType.LEFT).on("id", "updatebillid").select(new String[]{"tradetype", "manubill", "manuentryseq", "tradebillno", "bookdate", "trademateriel", "resource", "tradeqty", "tradebaseunit", "subelement", "amount", "productcost", "updatedcost", "difftype"}, new String[]{"applybillno"}).finish();
        return tradeBillResult;
    }

    private DataSet queryUpdateApplyBill() {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cad_costupdatenew", (String)"billno as applybillno ,updatebillid as updatebillid", null, null);
        return dataSet;
    }

    private DataSet queryFinishDiffBill(FilterInfo filterInfo) {
        logger.info("wip\u53d1\u751f\u989d\u62a5\u8868\u67e5\u8be2\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355");
        QFilter[] filters = ScaRptHelper.getFinishDiffBillFilters(filterInfo);
        String fields = ScaRptHelper.getFinishDiffBillFields();
        DataSet dataset = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "_queryFinishDiffBill"), (String)"sca_finishdiffbill", (String)fields, (QFilter[])filters, null);
        return dataset;
    }
}

