/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.anal;

import java.math.BigDecimal;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.utils.BigDecimalUtils;

public class ProExecutionClacDealFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private boolean isDiffClac;
    private int amtPrecision;

    public ProExecutionClacDealFunction(boolean isDiffClac, int amtPrecision) {
        this.isDiffClac = isDiffClac;
        this.amtPrecision = amtPrecision;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public RowX map(RowX rowx) {
        int sumRowIndex = this.getSourceRowMeta().getFieldIndex("sumrow");
        int inputQtyIndex = this.getSourceRowMeta().getFieldIndex("inputqty");
        BigDecimal inputqtyValue = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)rowx.getBigDecimal(inputQtyIndex));
        int outputQtyIndex = this.getSourceRowMeta().getFieldIndex("outputqty");
        BigDecimal outputQtyValue = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)rowx.getBigDecimal(outputQtyIndex));
        int sumPlanQtyIndex = this.getSourceRowMeta().getFieldIndex("sumplanqty");
        int sumPlanAmtIndex = this.getSourceRowMeta().getFieldIndex("sumplanamt");
        int sumStandardQtyIndex = this.getSourceRowMeta().getFieldIndex("sumstandardqty");
        int sumStandardAmtIndex = this.getSourceRowMeta().getFieldIndex("sumstandardamt");
        int actualQtyIndex = this.getSourceRowMeta().getFieldIndex("actualqty");
        BigDecimal actualQtyValue = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)rowx.getBigDecimal(actualQtyIndex));
        int actualAmtIndex = this.getSourceRowMeta().getFieldIndex("actualamt");
        BigDecimal actualAmtValue = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)rowx.getBigDecimal(actualAmtIndex));
        int planQtyIndex = this.getSourceRowMeta().getFieldIndex("planqty");
        BigDecimal planQtyValue = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)rowx.getBigDecimal(planQtyIndex));
        int planAmtIndex = this.getSourceRowMeta().getFieldIndex("planamt");
        BigDecimal planAmtValue = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)rowx.getBigDecimal(planAmtIndex));
        int planQtyDiffIndex = this.getSourceRowMeta().getFieldIndex("planqtydiff");
        int planAmtDiffIndex = this.getSourceRowMeta().getFieldIndex("planamtdiff");
        int standardQtyIndex = this.getSourceRowMeta().getFieldIndex("standardqty");
        BigDecimal standardQtyValue = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)rowx.getBigDecimal(standardQtyIndex));
        int standardAmtIndex = this.getSourceRowMeta().getFieldIndex("standardamt");
        BigDecimal standardAmtValue = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)rowx.getBigDecimal(standardAmtIndex));
        int standardQtyDiffIndex = this.getSourceRowMeta().getFieldIndex("standardqtydiff");
        int standardAmtDiffIndex = this.getSourceRowMeta().getFieldIndex("standardamtdiff");
        int lastPlanQtyIndex = this.getSourceRowMeta().getFieldIndex("lastplanqty");
        BigDecimal lastPlanQtyValue = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)rowx.getBigDecimal(lastPlanQtyIndex));
        int lastPlanAmtIndex = this.getSourceRowMeta().getFieldIndex("lastplanamt");
        BigDecimal lastPlanAmtValue = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)rowx.getBigDecimal(lastPlanAmtIndex));
        int lastStandardQtyIndex = this.getSourceRowMeta().getFieldIndex("laststandardqty");
        BigDecimal lastStandardQtyValue = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)rowx.getBigDecimal(lastStandardQtyIndex));
        int lastStandardAmtIndex = this.getSourceRowMeta().getFieldIndex("lastStandardamt");
        BigDecimal lastStandardAmtValue = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)rowx.getBigDecimal(lastStandardAmtIndex));
        int resourceIndex = this.getSourceRowMeta().getFieldIndex("resource");
        if (rowx.get(resourceIndex) != null && rowx.getLong(resourceIndex) != 0L) {
            rowx.set(this.getSourceRowMeta().getFieldIndex("precision"), (Object)2);
            rowx.set(this.getSourceRowMeta().getFieldIndex("baseunit"), (Object)10);
        }
        if (rowx.getInteger(sumRowIndex) == 0 && !this.isDiffClac) {
            rowx.set(sumPlanQtyIndex, (Object)lastPlanQtyValue);
            rowx.set(sumPlanAmtIndex, (Object)lastPlanAmtValue);
            rowx.set(sumStandardQtyIndex, (Object)lastStandardQtyValue.multiply(inputqtyValue));
            rowx.set(sumStandardAmtIndex, (Object)lastStandardAmtValue.multiply(inputqtyValue));
            rowx.set(planQtyIndex, (Object)(inputqtyValue.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : planQtyValue.divide(inputqtyValue, 10, 4).multiply(outputQtyValue)));
            rowx.set(planAmtIndex, (Object)(inputqtyValue.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : planAmtValue.divide(inputqtyValue, 10, 4).multiply(outputQtyValue)));
            rowx.set(standardQtyIndex, (Object)standardQtyValue.multiply(outputQtyValue));
            rowx.set(standardAmtIndex, (Object)standardAmtValue.multiply(outputQtyValue));
        } else if (rowx.getInteger(sumRowIndex) == 0 && this.isDiffClac) {
            int precision = rowx.getInteger(this.getSourceRowMeta().getFieldIndex("precision"));
            rowx.set(planQtyDiffIndex, (Object)actualQtyValue.subtract(planQtyValue).divide(BigDecimal.ONE, precision, 4));
            rowx.set(planAmtDiffIndex, (Object)actualAmtValue.subtract(planAmtValue).setScale(this.amtPrecision, 4));
            rowx.set(standardQtyDiffIndex, (Object)actualQtyValue.subtract(standardQtyValue).divide(BigDecimal.ONE, precision, 4));
            rowx.set(standardAmtDiffIndex, (Object)actualAmtValue.subtract(standardAmtValue));
            int planStandardQtydiffIndex = this.getSourceRowMeta().getFieldIndex("planstandardqtydiff");
            int planStandardAmtdiffIndex = this.getSourceRowMeta().getFieldIndex("planstandardamtdiff");
            rowx.set(planStandardQtydiffIndex, (Object)standardQtyValue.subtract(planQtyValue).divide(BigDecimal.ONE, precision, 4));
            rowx.set(planStandardAmtdiffIndex, (Object)standardAmtValue.subtract(planAmtValue));
        } else {
            int outputQtySumIndex = this.getSourceRowMeta().getFieldIndex("outputqtysum");
            BigDecimal outputQtySumValue = rowx.getBigDecimal(outputQtySumIndex);
            int baseunitIndex = this.getSourceRowMeta().getFieldIndex("baseunit");
            int unitIndex = this.getSourceRowMeta().getFieldIndex("unit");
            rowx.set(actualQtyIndex, (Object)outputQtySumValue);
            rowx.set(baseunitIndex, (Object)rowx.getLong(unitIndex));
            if (rowx.getBigDecimal(sumPlanAmtIndex).compareTo(BigDecimal.ZERO) > 0) {
                rowx.set(sumPlanQtyIndex, (Object)inputqtyValue);
                rowx.set(planQtyIndex, (Object)outputQtySumValue);
            }
            if (rowx.getBigDecimal(sumStandardAmtIndex).compareTo(BigDecimal.ZERO) > 0) {
                rowx.set(sumStandardQtyIndex, (Object)inputqtyValue);
                rowx.set(standardQtyIndex, (Object)outputQtySumValue);
            }
            int precision = rowx.getInteger(this.getSourceRowMeta().getFieldIndex("precision"));
            actualQtyValue = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)rowx.getBigDecimal(actualQtyIndex));
            standardQtyValue = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)rowx.getBigDecimal(standardQtyIndex));
            planQtyValue = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)rowx.getBigDecimal(planQtyIndex));
            rowx.set(planQtyDiffIndex, (Object)actualQtyValue.subtract(planQtyValue).divide(BigDecimal.ONE, precision, 4));
            rowx.set(standardQtyDiffIndex, (Object)actualQtyValue.subtract(standardQtyValue).divide(BigDecimal.ONE, precision, 4));
            int planStandardQtydiffIndex = this.getSourceRowMeta().getFieldIndex("planstandardqtydiff");
            int planStandardAmtdiffIndex = this.getSourceRowMeta().getFieldIndex("planstandardamtdiff");
            rowx.set(planStandardQtydiffIndex, (Object)standardQtyValue.subtract(planQtyValue).divide(BigDecimal.ONE, precision, 4));
            rowx.set(planStandardAmtdiffIndex, (Object)standardAmtValue.subtract(planAmtValue));
        }
        return rowx;
    }
}

