/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.anal;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import kd.macc.cad.common.utils.DataSetXHelper;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.sca.report.anal.ProExecutionClacDealFunction;
import kd.macc.sca.report.anal.ProExecutionCostAnalParam;
import kd.macc.sca.report.anal.ProExecutionNullFunction;

public class ProExecutionHandleDataRow
implements IDataXTransform {
    private final Log logger = LogFactory.getLog(ProExecutionHandleDataRow.class);
    private ReportDataCtx ctx;
    private String[] sumGroupCols = new String[]{"costobject", "product", "costobjectnumber", "configuredcode", "currency", "bizstatus", "srcbillnumber", "srcbillrow", "tracknumber", "tracknumbernum", "unit", "inputqty", "outputqty", "outputqtysum"};
    private static String[] removeFields_Std = new String[]{"baseunit", "precision", "mfgelement", "mfgsubelement", "mat", "matname", "matnum", "matunit", "resource", "resourcenum", "resourcename", "matresource", "matresourcenum", "standardqty", "standardamt"};
    private static String[] removeFields_Std_Last = new String[]{"baseunit", "precision", "mfgelement", "mfgsubelement", "mat", "matname", "matnum", "matunit", "resource", "resourcenum", "resourcename", "matresource", "matresourcenum", "laststandardqty", "laststandardamt"};
    private static String[] queryFields_Std = new String[]{"baseunit", "precision", "mfgelement", "mfgsubelement", "mat", "matname", "matnum", "matunit", "resource", "resourcenum", "resourcename", "matresource", "matresourcenum", "standardqty", "standardamt", "effectdate", "expdate", "effectdateunit", "expdateunit"};
    private static String[] queryFields_Std_Last = new String[]{"baseunit", "precision", "mfgelement", "mfgsubelement", "mat", "matname", "matnum", "matunit", "resource", "resourcenum", "resourcename", "matresource", "matresourcenum", "laststandardqty", "laststandardamt"};
    private static String[] costObject_Query = new String[]{"costobject", "probill", "auxpty", "projectnumber", "lot", "configuredcode", "tracknumber", "precision", "basprecision"};
    private ProExecutionCostAnalParam proExecutionCostAnalParam;

    public ProExecutionHandleDataRow(ProExecutionCostAnalParam proExecutionCostAnalParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.proExecutionCostAnalParam = proExecutionCostAnalParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        srcData = this.relationCostObjectDataSetX(srcData);
        srcData = this.relationInputDataSetX(srcData);
        srcData = this.relationOutputDataSetX(srcData);
        srcData = srcData.addFields(new Field[]{new Field("lastplanqty", (DataType)DataType.BigDecimalType), new Field("lastplanamt", (DataType)DataType.BigDecimalType), new Field("laststandardqty", (DataType)DataType.BigDecimalType), new Field("laststandardamt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        DataSetX actualDataSetX = this.relationActualDataSetX(srcData).map((MapFunction)new ProExecutionNullFunction("1"));
        HashSet<String> groupCols = new HashSet<String>(16);
        Set showKeyCols = this.ctx.getShowKeyCols();
        groupCols.addAll(showKeyCols);
        groupCols.add("precision");
        groupCols.add("basprecision");
        groupCols.add("inputqty");
        groupCols.add("outputqty");
        groupCols.add("outputqtysum");
        groupCols.add("sumrow");
        groupCols.add("srcauditdate");
        groupCols.add("sourcebill");
        String[] keyCols = groupCols.toArray(new String[groupCols.size()]);
        if (this.proExecutionCostAnalParam.getShowPlanCost().booleanValue() || this.proExecutionCostAnalParam.getShowStandardCost().booleanValue()) {
            DataSet resUnitDataSet = this.getResoureUnitDataSet(false);
            DataSet resUnitDataSetLast = this.getResoureUnitDataSet(true);
            if (this.proExecutionCostAnalParam.getShowPlanCost().booleanValue()) {
                DataSetX planDataSetX = this.relationPlanDataSetX(srcData, resUnitDataSet.copy(), resUnitDataSetLast.copy()).map((MapFunction)new ProExecutionNullFunction("2"));
                actualDataSetX = DataSetXHelper.union((DataSetX)actualDataSetX, (DataSetX)planDataSetX);
            }
            if (this.proExecutionCostAnalParam.getShowStandardCost().booleanValue()) {
                DataSetX standardDataSetX = this.relationStandardDataSetX(srcData, resUnitDataSet, resUnitDataSetLast).map((MapFunction)new ProExecutionNullFunction("3"));
                actualDataSetX = DataSetXHelper.union((DataSetX)actualDataSetX, (DataSetX)standardDataSetX);
            }
        }
        actualDataSetX = actualDataSetX.map((MapFunction)new ProExecutionNullFunction("0"));
        actualDataSetX = actualDataSetX.groupBy(keyCols).sum("actualqty").sum("actualamt").sum("sumplanqty").sum("sumplanamt").sum("sumstandardqty").sum("sumstandardamt").sum("planqty").sum("planamt").sum("planamtdiff").sum("standardqty").sum("standardamt").sum("standardamtdiff").sum("lastplanqty").sum("lastplanamt").sum("laststandardqty").sum("laststandardamt").sum("planqtydiff").sum("standardqtydiff").sum("planstandardqtydiff").sum("planstandardamtdiff");
        int amtPrecision = this.proExecutionCostAnalParam.getAmtPrecision();
        actualDataSetX = actualDataSetX.map((MapFunction)new ProExecutionClacDealFunction(false, amtPrecision));
        groupCols.remove("sourcebill");
        groupCols.remove("srcauditdate");
        groupCols.remove("inputqty");
        groupCols.remove("outputqty");
        groupCols.remove("outputqtysum");
        keyCols = groupCols.toArray(new String[groupCols.size()]);
        actualDataSetX = actualDataSetX.groupBy(keyCols).max("inputqty").max("outputqty").max("outputqtysum").max("actualqty").max("actualamt").max("sumplanqty").max("sumplanamt").max("sumstandardqty").max("sumstandardamt").sum("planqty").sum("planamt").sum("planamtdiff").sum("standardqty").sum("standardamt").sum("standardamtdiff").sum("lastplanqty").sum("lastplanamt").sum("laststandardqty").sum("laststandardamt").sum("planqtydiff").sum("standardqtydiff").sum("planstandardqtydiff").sum("planstandardamtdiff");
        actualDataSetX = actualDataSetX.map((MapFunction)new ProExecutionClacDealFunction(true, amtPrecision));
        if (this.proExecutionCostAnalParam.getShowStandardCost().booleanValue()) {
            groupCols.remove("mat");
            groupCols.remove("matnum");
            groupCols.remove("matname");
            groupCols.remove("matunit");
            keyCols = groupCols.toArray(new String[groupCols.size()]);
            actualDataSetX = actualDataSetX.groupBy(keyCols).max("inputqty").max("outputqty").max("mat").max("outputqtysum").max("actualqty").max("actualamt").max("sumplanqty").max("sumplanamt").max("sumstandardqty").max("sumstandardamt").max("planqty").max("planamt").max("planamtdiff").max("standardqty").max("standardamt").max("standardamtdiff").max("lastplanqty").max("lastplanamt").max("laststandardqty").max("laststandardamt").max("planqtydiff").max("standardqtydiff").max("planstandardqtydiff").max("planstandardamtdiff");
        }
        DataSetX sumDataSetX = actualDataSetX.groupBy(this.sumGroupCols).sum("actualamt").sum("sumplanamt").sum("sumstandardamt").sum("planamt").sum("planqtydiff").sum("planamtdiff").sum("standardamt").sum("standardqtydiff").sum("standardamtdiff").sum("planstandardqtydiff").sum("planstandardamtdiff").addFields(new Field[]{new Field("sumrow", (DataType)DataType.IntegerType)}, new Object[]{1});
        sumDataSetX = ProExecutionHandleDataRow.addRowDiff(actualDataSetX, sumDataSetX);
        sumDataSetX = sumDataSetX.map((MapFunction)new ProExecutionClacDealFunction(false, amtPrecision));
        actualDataSetX = DataSetXHelper.unionIfRowDiff((DataSetX)actualDataSetX, (DataSetX)sumDataSetX);
        return actualDataSetX;
    }

    private DataSet getResoureUnitDataSet(Boolean isLast) {
        Long costTypeId = this.proExecutionCostAnalParam.getCostTypeId();
        QFilter qFilter = new QFilter("costtype", "=", (Object)costTypeId);
        qFilter.and("billstatus", "=", (Object)"C");
        if (isLast.booleanValue()) {
            qFilter.and(new QFilter("expdate", "=", (Object)DateUtils.getDeFaultExpDate()));
        }
        String queryFields = "resource,subelement,10 as resourceunit,2 as resprecision,effectdate effectdateunit,expdate expdateunit";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getResoureUnitDataSet", (String)"cad_resourcerate", (String)queryFields, (QFilter[])qFilter.toArray(), null);
        String queryEntryFields = "resource,entryentity.attasubelement subelement,10 as resourceunit,2 as resprecision,effectdate effectdateunit,expdate expdateunit";
        DataSet dataSetEntry = QueryServiceHelper.queryDataSet((String)"getResoureUnitDataSet", (String)"cad_resourcerate", (String)queryEntryFields, (QFilter[])qFilter.toArray(), null).filter("subelement>0");
        dataSet = DataSetUtils.union((DataSet)dataSet, (DataSet)dataSetEntry);
        dataSet = dataSet.select("resource,subelement,resourceunit,resprecision");
        dataSet = dataSet.distinct();
        if (!isLast.booleanValue()) {
            dataSet = dataSet.addField("cast(to_date('2000-01-01 00:00:00','yyyy-MM-dd hh:mm:ss') as Timestamp)", "effectdateunit");
            dataSet = dataSet.addField("cast(to_date('2999-12-31 59:59:59','yyyy-MM-dd hh:mm:ss') as Timestamp)", "expdateunit");
        }
        return dataSet;
    }

    private List<Map<String, Object>> getMatCostParams(DataSet resultDs, Boolean isQueryLast) {
        Calendar c = Calendar.getInstance();
        c.add(1, 1);
        Date curDate = c.getTime();
        Long invOrgId = this.proExecutionCostAnalParam.getInvOrg();
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        while (resultDs.hasNext()) {
            Row row = resultDs.next();
            param = new HashMap(8);
            Date date = row.getDate("srcauditdate");
            if (date == null && !isQueryLast.booleanValue()) continue;
            param.put("uniqueID", row.getLong("costobject"));
            param.put("invorg", invOrgId);
            param.put("date", isQueryLast != false ? curDate : date);
            param.put("material", row.getLong("product"));
            param.put("assist", row.getLong("auxpty"));
            param.put("configuredcode", row.getLong("configuredcode"));
            param.put("tracknumber", row.getLong("tracknumber"));
            param.put("lot", row.getString("lot"));
            param.put("project", row.getLong("projectnumber"));
            params.add(param);
        }
        return params;
    }

    private RowMeta getRowMeta() {
        Field[] fields = new Field[]{new Field("costobject", (DataType)DataType.LongType), new Field("mfgelement", (DataType)DataType.LongType), new Field("mfgsubelement", (DataType)DataType.LongType), new Field("product", (DataType)DataType.LongType), new Field("mat", (DataType)DataType.LongType), new Field("resource", (DataType)DataType.LongType), new Field("datatype", (DataType)DataType.StringType), new Field("standardqty", (DataType)DataType.BigDecimalType), new Field("standardamt", (DataType)DataType.BigDecimalType), new Field("effectdate", (DataType)DataType.DateType), new Field("expdate", (DataType)DataType.DateType)};
        return new RowMeta(fields);
    }

    private DataSetX getSrcDataStandard(DataSet resultDs, Boolean isQueryLast, DataSetX srcData, DataSet resUnitDataSet) {
        List<Map<String, Object>> params = this.getMatCostParams(resultDs, isQueryLast);
        Long org = this.proExecutionCostAnalParam.getOrgId();
        Long costAccount = this.proExecutionCostAnalParam.getCostAccountId();
        String datatype = "3";
        ArrayList<Object[]> dataSetList = new ArrayList<Object[]>(10);
        HashSet<Long> matId = new HashSet<Long>(16);
        HashSet<Long> resourceId = new HashSet<Long>(16);
        List partyParams = Lists.partition(new ArrayList<Map<String, Object>>(params), (int)10000);
        for (List partyParam : partyParams) {
            HashSet costObjectIds = new HashSet(16);
            partyParam.forEach(e -> costObjectIds.add(Long.valueOf(e.get("uniqueID") + "")));
            Map<String, List<Map<String, Object>>> result = this.getMatCost(org, costAccount, partyParam, datatype);
            for (Long costObjectId : costObjectIds) {
                List<Map<String, Object>> dataList = result.get(costObjectId + "");
                if (CadEmptyUtils.isEmpty(dataList)) continue;
                for (Map<String, Object> map : dataList) {
                    if (!"2".equals(map.get("datatype")) && !"4".equals(map.get("datatype"))) continue;
                    ArrayList<Object> temp = new ArrayList<Object>(16);
                    matId.add(Long.valueOf(map.get("material") + ""));
                    matId.add(Long.valueOf(map.get("submaterial") + ""));
                    resourceId.add(Long.valueOf(map.get("resource") + ""));
                    temp.add(costObjectId);
                    temp.add(map.get("element"));
                    temp.add(map.get("subelement"));
                    temp.add(map.get("material"));
                    temp.add(map.get("submaterial"));
                    temp.add(map.get("resource"));
                    temp.add(map.get("datatype"));
                    temp.add(map.get("qty"));
                    temp.add(map.get("stdprice"));
                    temp.add(map.get("effectdate"));
                    temp.add(map.get("expdate"));
                    dataSetList.add(temp.toArray());
                }
            }
        }
        DataSet dataSetTemp = Algo.create((String)"mn").createDataSet(dataSetList.iterator(), this.getRowMeta());
        ArrayList<QFilter> matFilters = new ArrayList<QFilter>(10);
        matFilters.add(new QFilter("id", "in", matId));
        DataSet matDataSet = QueryServiceHelper.queryDataSet((String)"queryMatInfo", (String)"bd_material", (String)"id,number,name,baseunit,baseunit.precision precision", (QFilter[])matFilters.toArray(new QFilter[0]), null);
        dataSetTemp = dataSetTemp.leftJoin(matDataSet).on("product", "id").select(dataSetTemp.getRowMeta().getFieldNames(), new String[]{"baseunit unit", "precision unitprecision", "name productname", "number productnum"}).finish();
        dataSetTemp = dataSetTemp.leftJoin(matDataSet).on("mat", "id").select(dataSetTemp.getRowMeta().getFieldNames(), new String[]{"name matname", "number matnum", "baseunit matunit", "precision matprecision"}).finish();
        ArrayList<QFilter> resFilters = new ArrayList<QFilter>(10);
        resFilters.add(new QFilter("id", "in", resourceId));
        DataSet resourceDataSet = QueryServiceHelper.queryDataSet((String)"queryResourcetInfo", (String)"mpdm_resources", (String)"id,number,name", (QFilter[])resFilters.toArray(new QFilter[0]), null);
        dataSetTemp = dataSetTemp.leftJoin(resourceDataSet).on("resource", "id").select(dataSetTemp.getRowMeta().getFieldNames(), new String[]{"name resourcename", "number resourcenum"}).finish();
        String fields = "costobject,mfgelement,mfgsubelement,product,unit,mat,matname,matnum,matunit,resource,resourcenum,resourcename,case when datatype = '4' then matunit when resource is not null and resource>0 then resourceunit else unit end baseunit,case when datatype = '4' then matprecision when resource is not null and resource>0 then resprecision else unitprecision end precision,case when datatype = '4' then matnum when resource is not null and resource>0 then resourcenum else productnum end matresourcenum,case when datatype = '4' then matname when resource is not null and resource>0 then resourcename else productname end matresource,standardqty,standardamt,effectdate,expdate,effectdateunit,expdateunit";
        if (isQueryLast.booleanValue()) {
            fields = "costobject,mfgelement,mfgsubelement,product,unit,mat,matname,matnum,matunit,resource,resourcenum,resourcename,case when datatype = '4' then matunit when resource is not null and resource>0 then resourceunit else unit end baseunit,case when datatype = '4' then matprecision when resource is not null and resource>0 then resprecision else unitprecision end precision,case when datatype = '4' then matnum  when resource is not null and resource>0 then resourcenum else productnum end matresourcenum,case when datatype = '4' then matname when resource is not null and resource>0 then resourcename else productname end matresource,standardqty laststandardqty,standardamt laststandardamt";
            dataSetTemp = dataSetTemp.leftJoin(resUnitDataSet).on("resource", "resource").on("mfgsubelement", "subelement").select(dataSetTemp.getRowMeta().getFieldNames(), new String[]{"resourceunit", "resprecision"}).finish();
        } else {
            dataSetTemp = dataSetTemp.leftJoin(resUnitDataSet).on("resource", "resource").on("mfgsubelement", "subelement").select(dataSetTemp.getRowMeta().getFieldNames(), new String[]{"resourceunit", "resprecision", "effectdateunit", "expdateunit"}).finish();
        }
        dataSetTemp = dataSetTemp.select(fields);
        DataSetX standardDataSetX = this.ctx.getCurrentJob().fromInput((Input)new DataSetInput(dataSetTemp));
        DataSetX srcDataStandard = srcData.removeFields(isQueryLast != false ? removeFields_Std_Last : removeFields_Std);
        srcDataStandard = srcDataStandard.join(standardDataSetX).on("costobject", "costobject").on("product", "product").select(srcDataStandard.getRowMeta().getFieldNames(), isQueryLast != false ? queryFields_Std_Last : queryFields_Std);
        if (!isQueryLast.booleanValue()) {
            srcDataStandard = srcDataStandard.filter("srcauditdate>=effectdate and srcauditdate<=expdate and(effectdateunit is null or (srcauditdate>=effectdateunit and srcauditdate<=expdateunit))");
            srcDataStandard = srcDataStandard.removeFields(new String[]{"effectdate", "expdate", "effectdateunit", "expdateunit"});
        }
        return srcDataStandard;
    }

    private Map<String, List<Map<String, Object>>> getMatCost(Long orgId, Long costAccountId, List<Map<String, Object>> partyParam, String datatype) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"MatCostInfoPriceService", (String)"getMatCost", (Object[])new Object[]{partyParam, orgId, costAccountId, datatype, "sca"});
        return result;
    }

    private DataSetX relationStandardDataSetX(DataSetX srcData, DataSet resUnitDataSet, DataSet resUnitDataSetLast) {
        this.logger.info("\u83b7\u53d6\u6807\u51c6\u6210\u672c\u7ed3\u6784\u4fe1\u606f\u5f00\u59cb");
        JobSession currentJob = this.ctx.getCurrentJob();
        DataSetOutput dataSetOutput = new DataSetOutput(srcData.getRowMeta());
        String resultId = dataSetOutput.getId();
        srcData.output((Output)dataSetOutput);
        currentJob.commit(60, TimeUnit.MINUTES);
        DataSet resultDs = currentJob.readDataSet(resultId);
        DataSetX srcDataStandardLast = this.getSrcDataStandard(resultDs.copy(), true, srcData, resUnitDataSetLast);
        DataSetX srcDataStandard = this.getSrcDataStandard(resultDs, false, srcData, resUnitDataSet);
        DataSetX dataX = DataSetXHelper.union((DataSetX)srcDataStandardLast, (DataSetX)srcDataStandard);
        this.logger.info("\u83b7\u53d6\u6807\u51c6\u6210\u672c\u7ed3\u6784\u4fe1\u606f\u7ed3\u675f");
        return dataX;
    }

    private DataSetX relationPlanDataSetX(DataSetX srcData, DataSet resUnitDataSet, DataSet resUnitDataSetLast) {
        this.logger.info("\u83b7\u53d6\u8ba1\u5212\u6210\u672c\u7ed3\u6784\u4fe1\u606f\u5f00\u59cb");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        Long orgId = this.proExecutionCostAnalParam.getOrgId();
        filters.add(new QFilter("org", "=", (Object)orgId));
        Long manuOrgId = this.proExecutionCostAnalParam.getManuOrgId();
        if (!CadEmptyUtils.isEmpty((Long)manuOrgId)) {
            filters.add(new QFilter("manuorg", "=", (Object)manuOrgId));
        }
        Long costTypeId = this.proExecutionCostAnalParam.getCostTypeId();
        filters.add(new QFilter("costtype", "=", (Object)costTypeId));
        filters.add(new QFilter("orderentryid", "in", this.proExecutionCostAnalParam.getProBillIds()));
        filters.add(new QFilter("billstatus", "=", (Object)"B"));
        DataSet planCostMaterialDs = QueryServiceHelper.queryDataSet((String)"getPlanCostMaterial", (String)"sca_plancostcalcresult", (String)"material,entryentity.submaterial submaterial", (QFilter[])filters.toArray(new QFilter[0]), null);
        HashSet<Long> materialIds = new HashSet<Long>(16);
        for (Row row : planCostMaterialDs) {
            materialIds.add(row.getLong("material"));
            materialIds.add(row.getLong("submaterial"));
        }
        String queryFields = "orderentryid,entryentity.subelement mfgsubelement,material product,entryentity.submaterial mat,entryentity.resource resource,entryentity.resource.number resourcenum,entryentity.resource.name resourcename,entryentity.calcbasis calcbasis,entryentity.needqty srcqty,entryentity.needqty needqty,entryentity.needamount srcamount,entryentity.needamount needamount,effectdate,expdate";
        QFilter matQFilter = new QFilter("id", "in", materialIds);
        DataSet matDataSet = QueryServiceHelper.queryDataSet((String)"queryMatBaseInfo", (String)"bd_material", (String)"id,number,name,baseunit,baseunit.precision precision", (QFilter[])matQFilter.toArray(), null);
        ArrayList eleFilters = new ArrayList(10);
        OrmInput eleRelDataSet = new OrmInput("queryElementRelDataSetX", "cad_elementdetail", "element mfgelement,subelement", eleFilters.toArray(new QFilter[0]));
        DataSetX srcDataPlanLast = this.getSrcDataPlanLast(srcData, filters, queryFields, resUnitDataSetLast, matDataSet);
        DataSetX srcDataPlan = this.getSrcDataPlan(srcData, filters, queryFields, resUnitDataSet, matDataSet);
        DataSetX dataX = DataSetXHelper.union((DataSetX)srcDataPlanLast, (DataSetX)srcDataPlan);
        DataSetX eleRelDataSetX = this.ctx.getCurrentJob().fromInput((Input)eleRelDataSet);
        this.logger.info("\u83b7\u53d6\u8ba1\u5212\u6210\u672c\u7ed3\u6784\u4fe1\u606f\u7ed3\u675f");
        dataX = dataX.leftJoin(eleRelDataSetX).on("mfgsubelement", "subelement").select(dataX.getRowMeta().getFieldNames(), new String[]{"mfgelement"});
        return dataX;
    }

    private DataSetX getSrcDataPlan(DataSetX srcData, List<QFilter> filters, String queryFields, DataSet resUnitDataSet, DataSet matDataSet) {
        String fields = "orderentryid,mfgsubelement,product,unit,case when calcbasis = '0' then product else mat end mat,case when calcbasis = '0' then proname else matname end matname,case when calcbasis = '0' then pronum else matnum end matnum,case when calcbasis = '0' then unit else matunit end matunit,resource,resourcenum,resourcename,case when calcbasis = '0' then resourceunit else matunit end baseunit,case when calcbasis = '0' then resprecision else matprecision end precision,case when calcbasis = '0' then resourcenum else matnum end matresourcenum,case when calcbasis = '0' then resourcename else matname end matresource,needqty as planqty,needamount as planamt,effectdate,expdate,effectdateunit,expdateunit";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryPlanDataSetX", (String)"sca_plancostcalcresult", (String)queryFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        dataSet = dataSet.groupBy(new String[]{"orderentryid", "mfgsubelement", "product", "mat", "resource", "resourcenum", "resourcename", "calcbasis", "effectdate", "expdate"}).sum("srcqty").sum("needqty").sum("srcamount").sum("needamount").finish();
        dataSet = dataSet.join(matDataSet, JoinType.LEFT).on("product", "id").select(dataSet.getRowMeta().getFieldNames(), new String[]{"baseunit as unit", "precision", "name as proname", "number as pronum"}).finish();
        dataSet = dataSet.join(matDataSet, JoinType.LEFT).on("mat", "id").select(dataSet.getRowMeta().getFieldNames(), new String[]{"baseunit as matunit", "precision as matprecision", "name as matname", "number as matnum"}).finish();
        DataSet dataSetPlan = dataSet.leftJoin(resUnitDataSet).on("resource", "resource").on("mfgsubelement", "subelement").select(dataSet.getRowMeta().getFieldNames(), new String[]{"resourceunit", "resprecision", "effectdateunit", "expdateunit"}).finish().select(fields.split(",")).distinct();
        DataSetX planDataSetX = this.ctx.getCurrentJob().fromInput((Input)new DataSetInput(dataSetPlan));
        DataSetX srcDataPlan = srcData.removeFields(new String[]{"baseunit", "precision", "mfgelement", "mfgsubelement", "mat", "matname", "matnum", "matunit", "resource", "resourcenum", "resourcename", "matresource", "matresourcenum", "planqty", "planamt"});
        srcDataPlan = srcDataPlan.join(planDataSetX).on("product", "product").on("probill", "orderentryid").select(srcDataPlan.getRowMeta().getFieldNames(), new String[]{"baseunit", "precision", "mfgsubelement", "mat", "matname", "matnum", "matunit", "resource", "resourcenum", "resourcename", "matresource", "matresourcenum", "planqty", "planamt", "effectdate", "expdate", "effectdateunit", "expdateunit"}).filter("srcauditdate>=effectdate and srcauditdate<=expdate and (effectdateunit is null or (srcauditdate>=effectdateunit and srcauditdate<=expdateunit))");
        srcDataPlan = srcDataPlan.removeFields(new String[]{"effectdate", "expdate", "effectdateunit", "expdateunit"});
        srcDataPlan = srcDataPlan.distinct(srcDataPlan.getRowMeta().getFieldNames());
        return srcDataPlan;
    }

    private DataSetX getSrcDataPlanLast(DataSetX srcData, List<QFilter> filters, String queryFields, DataSet resUnitDataSetLast, DataSet matDataSet) {
        String lastFields = "orderentryid,mfgsubelement,product,unit,case when calcbasis = '0' then product else mat end mat,case when calcbasis = '0' then proname else matname end matname,case when calcbasis = '0' then pronum else matnum end matnum,case when calcbasis = '0' then unit else matunit end matunit,resource,resourcenum,resourcename,case when calcbasis = '0' then resprecision else matprecision end precision,case when calcbasis = '0' then resourceunit else matunit end baseunit,case when calcbasis = '0' then resourcenum else matnum end matresourcenum,case when calcbasis = '0' then resourcename else matname end matresource,needqty as lastplanqty,needamount as lastplanamt";
        ArrayList<QFilter> lastFilters = new ArrayList<QFilter>(10);
        lastFilters.addAll(filters);
        lastFilters.add(new QFilter("expdate", "=", (Object)DateUtils.getDeFaultExpDate()));
        DataSet lastDataSet = QueryServiceHelper.queryDataSet((String)"queryPlanDataSetX", (String)"sca_plancostcalcresult", (String)queryFields, (QFilter[])lastFilters.toArray(new QFilter[0]), null);
        lastDataSet = lastDataSet.groupBy(new String[]{"orderentryid", "mfgsubelement", "product", "mat", "resource", "resourcenum", "resourcename", "calcbasis", "effectdate", "expdate"}).sum("srcqty").sum("needqty").sum("srcamount").sum("needamount").finish();
        lastDataSet = lastDataSet.join(matDataSet, JoinType.LEFT).on("product", "id").select(lastDataSet.getRowMeta().getFieldNames(), new String[]{"baseunit as unit", "precision", "name as proname", "number as pronum"}).finish();
        lastDataSet = lastDataSet.join(matDataSet, JoinType.LEFT).on("mat", "id").select(lastDataSet.getRowMeta().getFieldNames(), new String[]{"baseunit as matunit", "precision as matprecision", "name as matname", "number as matnum"}).finish();
        lastDataSet = lastDataSet.leftJoin(resUnitDataSetLast).on("resource", "resource").on("mfgsubelement", "subelement").select(lastDataSet.getRowMeta().getFieldNames(), new String[]{"resourceunit", "resprecision"}).finish().select(lastFields.split(",")).distinct();
        DataSetX srcDataPlanLast = srcData.removeFields(new String[]{"baseunit", "precision", "mfgelement", "mfgsubelement", "mat", "matname", "matnum", "matunit", "resource", "resourcenum", "resourcename", "matresource", "matresourcenum", "lastplanqty", "lastplanamt"});
        DataSetX lastDataSetX = this.ctx.getCurrentJob().fromInput((Input)new DataSetInput(lastDataSet));
        srcDataPlanLast = srcDataPlanLast.join(lastDataSetX).on("product", "product").on("probill", "orderentryid").select(srcDataPlanLast.getRowMeta().getFieldNames(), new String[]{"baseunit", "precision", "mfgsubelement", "mat", "matname", "matnum", "matunit", "resource", "resourcenum", "resourcename", "matresource", "matresourcenum", "lastplanqty", "lastplanamt"});
        return srcDataPlanLast;
    }

    private DataSetX relationActualDataSetX(DataSetX srcData) {
        this.logger.info("\u5173\u8054\u5b9e\u9645\u6210\u672c\u5f00\u59cb");
        String fields = "costobject,baseunit,precision,mfgelement,mfgsubelement,product,unit,mat,matname,matnum,matunit,resource,resourcenum,resourcename,matresource,matresourcenum";
        DataSetX srcDataActual = srcData.removeFields(new String[]{"baseunit", "precision", "mfgelement", "mfgsubelement", "mat", "matname", "matnum", "matunit", "resource", "resourcenum", "resourcename", "matresource", "matresourcenum", "actualamt", "actualqty"});
        DataSetX matDataSetX = this.getMatDataSetX();
        DataSetX mfgDataSetX = this.getMfgDataSetX();
        DataSetX adjDataSetX = this.getAdjDataSetX();
        DataSetX actualDataSetX = DataSetXHelper.union((DataSetX)DataSetXHelper.union((DataSetX)matDataSetX, (DataSetX)mfgDataSetX), (DataSetX)adjDataSetX).groupBy(fields.split(",")).sum("actualamt").sum("actualqty");
        srcDataActual = srcDataActual.leftJoin(actualDataSetX).on("costobject", "costobject").select(srcDataActual.getRowMeta().getFieldNames(), new String[]{"baseunit", "precision", "mfgelement", "mfgsubelement", "mat", "matname", "matnum", "matunit", "resource", "resourcenum", "resourcename", "matresource", "matresourcenum", "actualamt", "actualqty"});
        this.logger.info("\u5173\u8054\u5b9e\u9645\u6210\u672c\u7ed3\u675f");
        return srcDataActual;
    }

    private DataSetX getAdjDataSetX() {
        List<Long> materialIds;
        Long costCenterId;
        this.logger.info("\u83b7\u53d6\u5438\u6536\u6210\u672c\u8c03\u6574\u5355\u4fe1\u606f");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        Long orgId = this.proExecutionCostAnalParam.getOrgId();
        filters.add(new QFilter("org", "=", (Object)orgId));
        Long costAccountId = this.proExecutionCostAnalParam.getCostAccountId();
        if (!CadEmptyUtils.isEmpty((Long)costAccountId)) {
            filters.add(new QFilter("costaccount", "=", (Object)costAccountId));
        }
        if (!CadEmptyUtils.isEmpty((Long)(costCenterId = this.proExecutionCostAnalParam.getCostCenterId()))) {
            filters.add(new QFilter("costcenter", "=", (Object)costCenterId));
        }
        if (!CadEmptyUtils.isEmpty(materialIds = this.proExecutionCostAnalParam.getMaterialIds())) {
            filters.add(new QFilter("costobject.material", "in", materialIds));
        }
        filters.add(new QFilter("costobject", "in", this.proExecutionCostAnalParam.getCostObjectIds()));
        String queryFields = "costobject,costobject.material.baseunit baseunit,costobject.material.baseunit.precision precision,entryentity.element mfgelement,entryentity.subelement mfgsubelement,costobject.material product,costobject.material.baseunit unit,resource,resource.number resourcenum,resource.name resourcename,resource.name matresource,resource.number matresourcenum,entryentity.amount actualamt,auditdate,costobject.material mat,costobject.material.baseunit matunit,costobject.material.name matname,costobject.material.number matnum";
        String fields = "costobject, case when resourceunit is not null then resourceunit else baseunit end baseunit,case when resourceunit is not null then resprecision else precision end precision,mfgelement,mfgsubelement,product,unit,resource,resourcenum,resourcename,matresource,matresourcenum,actualamt,mat,matunit,matname,matnum,0.0 as actualqty";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryAdjDataSetX", (String)"sca_absorbadjust", (String)queryFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        DataSet resUnitDataSet = this.getResoureUnitDataSet(false);
        dataSet = dataSet.leftJoin(resUnitDataSet).on("resource", "resource").on("mfgsubelement", "subelement").select(dataSet.getRowMeta().getFieldNames(), new String[]{"resourceunit", "resprecision", "effectdateunit", "expdateunit"}).finish().filter("effectdateunit is null or (auditdate>=effectdateunit and auditdate<=expdateunit)").select(fields.split(",")).distinct();
        DataSetX adjDataSetX = this.ctx.getCurrentJob().fromInput((Input)new DataSetInput(dataSet));
        return adjDataSetX;
    }

    private DataSetX getMfgDataSetX() {
        List<Long> materialIds;
        Long costCenterId;
        this.logger.info("\u83b7\u53d6\u8d39\u7528\u5438\u6536\u6210\u672c\u5355\u4fe1\u606f");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        Long orgId = this.proExecutionCostAnalParam.getOrgId();
        filters.add(new QFilter("org", "=", (Object)orgId));
        Long costAccountId = this.proExecutionCostAnalParam.getCostAccountId();
        if (!CadEmptyUtils.isEmpty((Long)costAccountId)) {
            filters.add(new QFilter("costaccount", "=", (Object)costAccountId));
        }
        if (!CadEmptyUtils.isEmpty((Long)(costCenterId = this.proExecutionCostAnalParam.getCostCenterId()))) {
            filters.add(new QFilter("costcenter", "=", (Object)costCenterId));
        }
        if (!CadEmptyUtils.isEmpty(materialIds = this.proExecutionCostAnalParam.getMaterialIds())) {
            filters.add(new QFilter("material", "in", materialIds));
        }
        filters.add(new QFilter("costobject", "in", this.proExecutionCostAnalParam.getCostObjectIds()));
        String queryFields = "costobject,entryentity.baseunit baseunit,entryentity.baseunit.precision precision,entryentity.element mfgelement,entryentity.subelement mfgsubelement,material product,material.baseunit unit,resource,resource.number resourcenum,resource.name resourcename,resource.name matresource,resource.number matresourcenum,entryentity.amount actualamt,entryentity.qty actualqty,costobject.isoutsource isoutsource, material mat,material.baseunit matunit,material.name matname,material.number matnum";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryAdjDataSetX", (String)"sca_resourceabsorb", (String)queryFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        dataSet = dataSet.select("costobject,baseunit,precision,mfgelement,mfgsubelement,product,unit,resource,resourcenum,resourcename,case when isoutsource then matname else resourcename end matresource,case when isoutsource then matnum else resourcenum end matresourcenum,actualamt,actualqty,mat,matunit,matname,matnum");
        DataSetX mfgDataSetX = this.ctx.getCurrentJob().fromInput((Input)new DataSetInput(dataSet));
        return mfgDataSetX;
    }

    private DataSetX getMatDataSetX() {
        List<Long> materialIds;
        Long costCenterId;
        Long costAccountId;
        this.logger.info("\u83b7\u53d6\u6750\u6599\u8017\u7528\u5206\u914d\u4fe1\u606f");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        Long orgId = this.proExecutionCostAnalParam.getOrgId();
        filters.add(new QFilter("org", "=", (Object)orgId));
        Long manuOrgId = this.proExecutionCostAnalParam.getManuOrgId();
        if (!CadEmptyUtils.isEmpty((Long)manuOrgId)) {
            filters.add(new QFilter("manuorg", "=", (Object)manuOrgId));
        }
        if (!CadEmptyUtils.isEmpty((Long)(costAccountId = this.proExecutionCostAnalParam.getCostAccountId()))) {
            filters.add(new QFilter("costaccount", "=", (Object)costAccountId));
        }
        if (!CadEmptyUtils.isEmpty((Long)(costCenterId = this.proExecutionCostAnalParam.getCostCenterId()))) {
            filters.add(new QFilter("costcenter", "=", (Object)costCenterId));
        }
        if (!CadEmptyUtils.isEmpty(materialIds = this.proExecutionCostAnalParam.getMaterialIds())) {
            filters.add(new QFilter("entryentity.costobejctentry.material", "in", materialIds));
        }
        filters.add(new QFilter("entryentity.costobejctentry", "in", this.proExecutionCostAnalParam.getCostObjectIds()));
        filters.add(new QFilter("appnum", "=", (Object)"sca"));
        String queryFields = "entryentity.costobejctentry costobject,baseunit,baseunit.precision precision,entryentity.elemententry mfgelement,entryentity.subelemententry mfgsubelement,entryentity.costobejctentry.material product,entryentity.costobejctentry.material.baseunit unit,material mat,material.name matname,material.number matnum,baseunit matunit,material.name matresource,material.number matresourcenum,entryentity.amount actualamt,entryentity.qty actualqty";
        OrmInput ormInputInit = new OrmInput("queryMatDataSetX", "sca_matalloc", queryFields, filters.toArray(new QFilter[0]));
        DataSetX matDataSetX = this.ctx.getCurrentJob().fromInput((Input)ormInputInit).addFields(new Field[]{new Field("resource", (DataType)DataType.LongType), new Field("resourcenum", (DataType)DataType.StringType), new Field("resourcename", (DataType)DataType.StringType)}, new Object[]{0L, "", ""});
        return matDataSetX;
    }

    private DataSetX relationOutputDataSetX(DataSetX srcData) {
        List<Long> materialIds;
        Long costCenterId;
        this.logger.info("\u5173\u8054\u4ea7\u54c1\u5b8c\u5de5\u6570\u91cf\u5f00\u59cb");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        Long orgId = this.proExecutionCostAnalParam.getOrgId();
        filters.add(new QFilter("org", "=", (Object)orgId));
        Long manuOrgId = this.proExecutionCostAnalParam.getManuOrgId();
        if (!CadEmptyUtils.isEmpty((Long)manuOrgId)) {
            filters.add(new QFilter("manuorg", "=", (Object)manuOrgId));
        }
        if (!CadEmptyUtils.isEmpty((Long)(costCenterId = this.proExecutionCostAnalParam.getCostCenterId()))) {
            filters.add(new QFilter("costcenter", "=", (Object)costCenterId));
        }
        if (!CadEmptyUtils.isEmpty(materialIds = this.proExecutionCostAnalParam.getMaterialIds())) {
            filters.add(new QFilter("material", "in", materialIds));
        }
        filters.add(new QFilter("entryentity.costobject", "in", this.proExecutionCostAnalParam.getCostObjectIds()));
        filters.add(new QFilter("billstatus", "=", (Object)Character.valueOf('C')));
        filters.add(new QFilter("appnum", "=", (Object)"sca"));
        OrmInput ormInputInit = new OrmInput("queryFactnedOutPutBill", "cad_factnedoutputbill", "sourcebill,entryentity.costobject costobject,entryentity.qty outputqty,entryentity.qty outputqtysum,srcauditdate", filters.toArray(new QFilter[0]));
        DataSetX factDataSetX = this.ctx.getCurrentJob().fromInput((Input)ormInputInit);
        DataSetX factSumDataSetX = factDataSetX.groupBy(new String[]{"costobject"}).sum("outputqtysum");
        factDataSetX = factDataSetX.join(factSumDataSetX).on("costobject", "costobject").select(new String[]{"costobject", "outputqty", "srcauditdate", "sourcebill"}, new String[]{"outputqtysum"});
        srcData = srcData.removeFields(new String[]{"outputqty"});
        srcData = srcData.leftJoin(factDataSetX).on("costobject", "costobject").select(srcData.getRowMeta().getFieldNames(), new String[]{"outputqty", "srcauditdate", "outputqtysum", "sourcebill"});
        this.logger.info("\u5173\u8054\u4ea7\u54c1\u5b8c\u5de5\u6570\u91cf\u7ed3\u675f");
        return srcData;
    }

    private DataSetX relationInputDataSetX(DataSetX srcData) {
        List<Long> materialIds;
        Long costCenterId;
        Date endDate;
        Date startDate;
        this.logger.info("\u5173\u8054\u4ea7\u54c1\u4e0b\u8fbe\u6570\u91cf\u5f00\u59cb");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        Long orgId = this.proExecutionCostAnalParam.getOrgId();
        filters.add(new QFilter("accountorg", "=", (Object)orgId));
        Long manuOrgId = this.proExecutionCostAnalParam.getManuOrgId();
        if (!CadEmptyUtils.isEmpty((Long)manuOrgId)) {
            filters.add(new QFilter("manuorg", "=", (Object)manuOrgId));
        }
        if ((startDate = this.proExecutionCostAnalParam.getStartDate()) != null) {
            filters.add(new QFilter("bizdate", ">=", (Object)startDate));
        }
        if ((endDate = this.proExecutionCostAnalParam.getEndDate()) != null) {
            filters.add(new QFilter("bizdate", "<=", (Object)endDate));
        }
        if (!CadEmptyUtils.isEmpty((Long)(costCenterId = this.proExecutionCostAnalParam.getCostCenterId()))) {
            filters.add(new QFilter("costcenter", "=", (Object)costCenterId));
        }
        if (!CadEmptyUtils.isEmpty(materialIds = this.proExecutionCostAnalParam.getMaterialIds())) {
            filters.add(new QFilter("material", "in", materialIds));
        }
        filters.add(new QFilter("costobject", "in", this.proExecutionCostAnalParam.getCostObjectIds()));
        filters.add(new QFilter("billstatus", "=", (Object)Character.valueOf('C')));
        filters.add(new QFilter("appnum", "=", (Object)"sca"));
        OrmInput ormInputInit = new OrmInput("queryPlannedOutPutBill", "cad_plannedoutputbill", "costobject,qty inputqty", filters.toArray(new QFilter[0]));
        DataSetX planDataSetX = this.ctx.getCurrentJob().fromInput((Input)ormInputInit);
        srcData = srcData.removeFields(new String[]{"inputqty"});
        srcData = srcData.leftJoin(planDataSetX).on("costobject", "costobject").select(srcData.getRowMeta().getFieldNames(), new String[]{"inputqty"});
        this.logger.info("\u5173\u8054\u4ea7\u54c1\u4e0b\u8fbe\u6570\u91cf\u7ed3\u675f");
        return srcData;
    }

    private DataSetX relationCostObjectDataSetX(DataSetX srcData) {
        List<Long> trackNumberIds;
        List<Long> configuredCodeIds;
        List<Long> materialIds;
        this.logger.info("\u5173\u8054\u6210\u672c\u6838\u7b97\u5bf9\u8c61id\u5f00\u59cb");
        ArrayList<QFilter> commonFilters = new ArrayList<QFilter>(10);
        commonFilters.addAll(this.proExecutionCostAnalParam.getCommonFilters());
        List<String> proBillNumbers = this.proExecutionCostAnalParam.getProBillNumbers();
        if (!CadEmptyUtils.isEmpty(proBillNumbers)) {
            commonFilters.add(new QFilter("srcbillnumber", "in", proBillNumbers));
        }
        if (!CadEmptyUtils.isEmpty(materialIds = this.proExecutionCostAnalParam.getMaterialIds())) {
            commonFilters.add(new QFilter("material", "in", materialIds));
        }
        if (!CadEmptyUtils.isEmpty(configuredCodeIds = this.proExecutionCostAnalParam.getConfiguredCodeIds())) {
            commonFilters.add(new QFilter("configuredcode", "in", configuredCodeIds));
        }
        if (!CadEmptyUtils.isEmpty(trackNumberIds = this.proExecutionCostAnalParam.getTrackNumberIds())) {
            commonFilters.add(new QFilter("tracknumber", "in", trackNumberIds));
        }
        commonFilters.add(new QFilter("producttype", "=", (Object)"C"));
        OrmInput ormInputInit = new OrmInput("queryCostObject", "cad_costobject", "id costobject,billno,probill,configuredcode,auxpty,projectnumber,lot,tracknumber,material.baseunit.precision precision,material.baseunit.precision basprecision", commonFilters.toArray(new QFilter[0]));
        DataSetX costObjectDataSetX = this.ctx.getCurrentJob().fromInput((Input)ormInputInit);
        String[] fieldNames = srcData.getRowMeta().getFieldNames();
        List<String> fieldNameList = Arrays.asList(fieldNames);
        for (String name : costObject_Query) {
            if (!fieldNameList.contains(name)) continue;
            srcData = srcData.removeFields(new String[]{name});
        }
        srcData = costObjectDataSetX.join(srcData).on("billno", "costobjectnumber").select(costObject_Query, srcData.getRowMeta().getFieldNames());
        ArrayList<Long> ids = new ArrayList<Long>(16);
        ArrayList<Long> proBillIds = new ArrayList<Long>(16);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryCostObject", (String)"cad_costobject", (String)"id,probill", (QFilter[])commonFilters.toArray(new QFilter[0]), null);
        if (dataSet != null && dataSet.hasNext()) {
            for (Row row : dataSet) {
                ids.add(row.getLong("id"));
                proBillIds.add(row.getLong("probill"));
            }
        }
        this.proExecutionCostAnalParam.setCostObjectIds(ids);
        this.proExecutionCostAnalParam.setProBillIds(proBillIds);
        this.logger.info("\u5173\u8054\u6210\u672c\u6838\u7b97\u5bf9\u8c61id\u7ed3\u675f");
        return srcData;
    }

    public static DataSetX addRowDiff(DataSetX dataSetOne, DataSetX dataSetTwo) {
        ArrayList srcFileds = Lists.newArrayList((Object[])dataSetOne.getRowMeta().getFields());
        ArrayList destFields = Lists.newArrayList((Object[])dataSetTwo.getRowMeta().getFields());
        srcFileds.removeAll(destFields);
        Object[] values = new Object[srcFileds.size()];
        for (int i = 0; i < srcFileds.size(); ++i) {
            DataType dt = ((Field)srcFileds.get(i)).getDataType();
            if (dt.equals((Object)DataType.BigDecimalType)) {
                values[i] = BigDecimal.ZERO;
                continue;
            }
            if (dt.equals((Object)DataType.BooleanType)) {
                values[i] = false;
                continue;
            }
            if (dt.equals((Object)DataType.DoubleType)) {
                values[i] = 0.0;
                continue;
            }
            if (dt.equals((Object)DataType.IntegerType)) {
                values[i] = 0;
                continue;
            }
            if (dt.equals((Object)DataType.LongType)) {
                values[i] = 0L;
                continue;
            }
            if (dt.equals((Object)DataType.StringType)) {
                values[i] = " ";
                continue;
            }
            if (!dt.equals((Object)DataType.TimestampType)) continue;
            values[i] = new Date();
        }
        if (srcFileds.size() > 0) {
            dataSetTwo = dataSetTwo.addFields(srcFileds.toArray(new Field[0]), values);
        }
        dataSetTwo = dataSetTwo.select(dataSetOne.getRowMeta().getFieldNames());
        return dataSetTwo;
    }
}

