/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.calcall.handle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetXHelper;
import kd.macc.sca.report.calcall.handle.CalcAllItemAllSumFunction;
import kd.macc.sca.report.calcall.handle.CalcAllItemCostCenterFunction;
import kd.macc.sca.report.calcall.handle.CalcAllItemGroupFunction;
import kd.macc.sca.report.calcall.handle.CalcAllItemPeriodFunction;
import kd.macc.sca.report.calcall.handle.CalcAllItemSumFunction;
import kd.macc.sca.report.calcall.model.CalcAllItemRptParam;
import org.apache.commons.lang.StringUtils;

public class CalcAllItemRptHandleGroupRow
implements IDataXTransform {
    private CalcAllItemRptParam reportParam;
    private ReportDataCtx ctx;
    public static final long BASE_MGS_ID = 730148448254487552L;
    private final String total = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"CalcAllItemRptHandleGroupRow_0", (String)"macc-sca-report", (Object[])new Object[0]);
    private String[] sumCols = new String[]{"pdstartamount1", "pdcurramount1", "pdcompanount1", "pdendamount1", "totalamount1", "stdamount1", "diffamount1", "totalupdatediff1"};

    public CalcAllItemRptHandleGroupRow(CalcAllItemRptParam reportParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.reportParam = reportParam;
    }

    public DataSetX doTransform(DataSetX dataSetBase) {
        dataSetBase = dataSetBase.filter("datatype in ('99','1','98')");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        DataSetX sumDataSetBase = this.updateSumAmount(dataSetBase);
        DataSetX dataSet = this.getDataSetByClassified(sumDataSetBase, params);
        dataSet = this.getGroupData(dataSet);
        Boolean showGroup = this.reportParam.getShowgroup();
        Boolean isshowdetail = this.reportParam.getIsshowdetail();
        dataSet = this.getSumDataSet(dataSet, showGroup);
        DataSetX dataSetTotal = this.getDataSetTotal(dataSet, isshowdetail);
        return this.getAllDataSet(dataSetTotal);
    }

    private DataSetX getDataSetTotal(DataSetX dataSet, final Boolean isshowdetail) {
        DataSetX dataSetTotal = dataSet.map(new MapFunction(){
            private static final long serialVersionUID = 1L;

            public RowX map(RowX rowX) {
                Long subelement = rowX.getLong(this.getSourceRowMeta().getFieldIndex("subelement"));
                Integer element = rowX.getInteger(this.getSourceRowMeta().getFieldIndex("element"));
                Long material = rowX.getLong(this.getSourceRowMeta().getFieldIndex("material"));
                Long unit = rowX.getLong(this.getSourceRowMeta().getFieldIndex("unit"));
                String subelementname = rowX.getString(this.getSourceRowMeta().getFieldIndex("subelementname"));
                if (isshowdetail.booleanValue()) {
                    if (CadEmptyUtils.isEmpty((Long)subelement) || material > 0L) {
                        rowX.set(this.getSourceRowMeta().getFieldIndex("unit"), (Object)unit);
                    } else {
                        rowX.set(this.getSourceRowMeta().getFieldIndex("unit"), (Object)9L);
                    }
                } else {
                    rowX.set(this.getSourceRowMeta().getFieldIndex("unit"), (Object)(CadEmptyUtils.isEmpty((Long)subelement) ? unit : 9L));
                    rowX.set(this.getSourceRowMeta().getFieldIndex("material"), (Object)0L);
                    rowX.set(this.getSourceRowMeta().getFieldIndex("matversion"), (Object)0L);
                    rowX.set(this.getSourceRowMeta().getFieldIndex("auxpty"), (Object)0L);
                    rowX.set(this.getSourceRowMeta().getFieldIndex("resource"), (Object)0L);
                }
                rowX.set(this.getSourceRowMeta().getFieldIndex("subelementname"), (Object)(CadEmptyUtils.isEmpty((Long)subelement) ? ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"CalcAllItemRptHandleGroupRow_0", (String)"macc-sca-report", (Object[])new Object[0]) : subelementname));
                rowX.set(this.getSourceRowMeta().getFieldIndex("materialgroup"), (Object)(CadEmptyUtils.isEmpty((Long)subelement) ? Long.valueOf(0L) : rowX.getLong(this.getSourceRowMeta().getFieldIndex("materialgroup"))));
                rowX.set(this.getSourceRowMeta().getFieldIndex("periodord"), (Object)"0");
                rowX.set(this.getSourceRowMeta().getFieldIndex("costcenterord"), (Object)"0");
                return rowX;
            }

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }
        });
        return dataSetTotal;
    }

    private DataSetX getAllDataSet(DataSetX dataSet) {
        DataSetX costCenterdataSet = dataSet.filter("subelementname='" + this.total + "'").groupBy(new String[]{"currency", "period", "costcenter", "costcentername"}).reduceGroup((GroupReduceFunction)new CalcAllItemCostCenterFunction());
        DataSetX periodSumData = dataSet.filter("subelementname='" + this.total + "'").groupBy(new String[]{"currency", "period"}).reduceGroup((GroupReduceFunction)new CalcAllItemPeriodFunction());
        DataSetX allSumData = dataSet.filter("subelementname='" + this.total + "'").groupBy(new String[]{"currency"}).reduceGroup((GroupReduceFunction)new CalcAllItemAllSumFunction());
        DataSetX unionData = dataSet.union(costCenterdataSet).union(periodSumData).union(allSumData).orderBy(new String[]{"periodname", "periodord", "costcentername", "costcenterord", "costobjectname", "elementnum", "subelementnum", "materialnum"});
        unionData.removeFields(this.sumCols);
        return unionData;
    }

    private DataSetX getGroupData(DataSetX dataSet) {
        if (this.reportParam.getIsshowdetail().booleanValue()) {
            return dataSet;
        }
        String fields = "costobject,unit,manuorg,costaccount,period,costcenter,costcentername,costobject,bizstatus,costobjectname,elementnum,subelementnum,element,subelement,materialgroup,material,matversion,auxpty,resource";
        DataSetX dataSetX = dataSet.groupBy(fields.split(",")).reduceGroup((GroupReduceFunction)new CalcAllItemGroupFunction());
        return dataSetX;
    }

    private DataSetX getSumDataSet(DataSetX dataSet, Boolean showGroup) {
        String fields = "";
        fields = showGroup != false ? "costobject,manuorg,costaccount,period,bizstatus,costcenter,costcentername,costobject,costobjectname,unit,element,elementnum,subelementnum,subelement,materialgroup" : "costobject,manuorg,costaccount,period,bizstatus,costcenter,costcentername,costobject,costobjectname,unit,element,elementnum,subelementnum,subelement,materialgroup,material,matversion,auxpty,resource";
        dataSet = dataSet.groupBy(fields.split(",")).reduceGroup((GroupReduceFunction)new CalcAllItemSumFunction());
        return dataSet;
    }

    private DataSetX getDataSetByClassified(DataSetX dataSet, Map<String, Object> params) {
        DynamicObject materialGrpStdDyn = (DynamicObject)params.get("materialGrpStd");
        DataSetX allDataSet = null;
        if (materialGrpStdDyn == null || materialGrpStdDyn.getLong("id") != 730148448254487552L) {
            DataSet materialDataSet = CalcAllItemRptHandleGroupRow.getClassifiedMaterialDataSet((DynamicObjectCollection)params.get("mulMaterialGroup"), false, (DynamicObject)params.get("materialGrpStd"));
            DataSetX materialDataSetX = this.ctx.getCurrentJob().fromInput((Input)new DataSetInput(materialDataSet));
            DataSetX materialgroup = dataSet.removeFields(new String[]{"materialgroup", "unit", "materialgroupnumber"});
            DataSetX matDataSet = dataSet.filter("material != 0");
            DataSetX notMatDataSet = dataSet.filter("material = 0");
            matDataSet = matDataSet.leftJoin(materialDataSetX).on("material", "material").select(materialgroup.getRowMeta().getFieldNames(), new String[]{"materialgroup", "unit", "materialgroupnumber"});
            notMatDataSet = notMatDataSet.leftJoin(materialDataSetX).on("product", "material").select(materialgroup.getRowMeta().getFieldNames(), new String[]{"materialgroup", "unit", "materialgroupnumber"});
            allDataSet = matDataSet.union(notMatDataSet);
        } else {
            ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(dataSet.getRowMeta().getFieldNames()));
            fieldNames.remove("group");
            fieldNames.remove("matgroup");
            fieldNames.add("case when material>0 then matgroup else group end materialgroup");
            allDataSet = dataSet.select(fieldNames.toArray(new String[0]));
        }
        DynamicObjectCollection mulMaterialGroup = (DynamicObjectCollection)params.get("mulMaterialGroup");
        if (mulMaterialGroup != null && mulMaterialGroup.size() > 0) {
            Set materialGroupId = (Set)params.get("materialGroupId");
            if (materialGroupId != null && materialGroupId.size() > 0) {
                DataSetX dataSetCostObject = allDataSet.filter("materialgroup in (" + StringUtils.join((Collection)materialGroupId, (String)",") + ")");
                final HashSet costObjectIds = new HashSet();
                dataSetCostObject = dataSetCostObject.map(new MapFunction(){
                    private static final long serialVersionUID = 1L;

                    public RowX map(RowX rowX) {
                        costObjectIds.add(rowX.getLong(this.getSourceRowMeta().getFieldIndex("costobject")));
                        return rowX;
                    }

                    public RowMeta getResultRowMeta() {
                        return this.sourceRowMeta;
                    }
                });
                if (costObjectIds.size() > 0) {
                    DataSetX fenDataSet = allDataSet.filter("subelement != null and materialgroup in (" + StringUtils.join((Collection)materialGroupId, (String)",") + ")");
                    DataSetX proDataSet = allDataSet.filter("subelement = null and costobject in (" + StringUtils.join(costObjectIds, (String)",") + ")");
                    allDataSet = DataSetXHelper.union((DataSetX)fenDataSet, (DataSetX)proDataSet);
                } else {
                    allDataSet = allDataSet.filter("1 = 2");
                }
            } else {
                allDataSet = allDataSet.filter("1 = 2");
            }
        }
        return allDataSet;
    }

    public static DataSet getClassifiedMaterialDataSet(DynamicObjectCollection materialgroup, boolean notShowMaterialGroup, DynamicObject materialgroupstandard) {
        if (notShowMaterialGroup) {
            return null;
        }
        Object pkValue = 730148448254487552L;
        if (materialgroupstandard != null) {
            pkValue = materialgroupstandard.getPkValue();
        }
        QFilter filter = new QFilter("standard", "=", pkValue);
        if (materialgroup != null && materialgroup.size() > 0) {
            filter.and(CalcAllItemRptHandleGroupRow.getGroupFilter(materialgroup, true, "group.longnumber"));
        }
        return QueryServiceHelper.queryDataSet((String)MaterialGroupHelper.class.getName(), (String)"bd_materialgroupdetail", (String)"group as materialgroup,group.longnumber longnumber,group.number as materialgroupnumber,group.name as materialgroupname,material,material.baseunit as unit,material.number as materialnumber,material.materialtype as materialtype", (QFilter[])filter.toArray(), (String)"group desc");
    }

    public static QFilter getGroupFilter(DynamicObjectCollection materialgroupColl, boolean isFromFilteInfo, String fieldName) {
        if (materialgroupColl != null && materialgroupColl.size() > 0) {
            DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"bd_materialgroup").getProperty("parent");
            GroupProp group = (GroupProp)property;
            String longNumberDLM = "";
            if (group instanceof ParentBasedataProp) {
                longNumberDLM = ((ParentBasedataProp)group).getLongNumberDLM();
            }
            QFilter groupFilter = QFilter.of((String)"1 != 1", (Object[])new Object[0]);
            HashSet<String> groupNumSet = new HashSet<String>(16);
            for (DynamicObject matgroup : materialgroupColl) {
                String longnumber = isFromFilteInfo ? matgroup.getString("longnumber") : (matgroup.getDataEntityType().getProperties().get((Object)"fbasedataid") == null ? matgroup.getString("longnumber") : matgroup.getDynamicObject("fbasedataid").getString("longnumber"));
                groupFilter.or(new QFilter(fieldName, "like", (Object)(longnumber + longNumberDLM + "%")));
                groupNumSet.add(longnumber);
            }
            if (!groupNumSet.isEmpty()) {
                groupFilter.or(new QFilter(fieldName, "in", groupNumSet));
            }
            return groupFilter;
        }
        return QFilter.of((String)"1=1", (Object[])new Object[0]);
    }

    private DataSetX updateSumAmount(DataSetX dataSetBase) {
        DataSetX sumDatabase = dataSetBase.filter("subelement != 0");
        sumDatabase = sumDatabase.groupBy(new String[]{"costobject", "costaccount", "period"}).sum("pdstartamount", "pdstartamount1").sum("pdcurramount", "pdcurramount1").sum("pdcompanount", "pdcompanount1").sum("pdendamount", "pdendamount1").sum("totalamount", "totalamount1").sum("stdamount", "stdamount1").sum("diffamount", "diffamount1").sum("totalupdatediff", "totalupdatediff1");
        dataSetBase = dataSetBase.removeFields(new String[]{"pdstartamount1", "pdcurramount1", "pdcompanount1", "pdendamount1", "totalamount1", "stdamount1", "diffamount1", "totalupdatediff1"});
        sumDatabase = dataSetBase.leftJoin(sumDatabase).on("costobject", "costobject").on("costaccount", "costaccount").on("period", "period").select(dataSetBase.getRowMeta().getFieldNames(), this.sumCols);
        sumDatabase = sumDatabase.map(new MapFunction(){
            private static final long serialVersionUID = 1L;

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }

            public RowX map(RowX rowX) {
                String subelement = rowX.getString(this.getSourceRowMeta().getFieldIndex("subelement"));
                rowX.set(this.getSourceRowMeta().getFieldIndex("pdstartamount"), (Object)(CadEmptyUtils.isEmpty((String)subelement) ? rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("pdstartamount1")) : rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("pdstartamount"))));
                rowX.set(this.getSourceRowMeta().getFieldIndex("pdcurramount"), (Object)(CadEmptyUtils.isEmpty((String)subelement) ? rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("pdcurramount1")) : rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("pdcurramount"))));
                rowX.set(this.getSourceRowMeta().getFieldIndex("pdcompanount"), (Object)(CadEmptyUtils.isEmpty((String)subelement) ? rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("pdcompanount1")) : rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("pdcompanount"))));
                rowX.set(this.getSourceRowMeta().getFieldIndex("pdendamount"), (Object)(CadEmptyUtils.isEmpty((String)subelement) ? rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("pdendamount1")) : rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("pdendamount"))));
                rowX.set(this.getSourceRowMeta().getFieldIndex("totalamount"), (Object)(CadEmptyUtils.isEmpty((String)subelement) ? rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("totalamount1")) : rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("totalamount"))));
                rowX.set(this.getSourceRowMeta().getFieldIndex("stdamount"), (Object)(CadEmptyUtils.isEmpty((String)subelement) ? rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("stdamount1")) : rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("stdamount"))));
                rowX.set(this.getSourceRowMeta().getFieldIndex("diffamount"), (Object)(CadEmptyUtils.isEmpty((String)subelement) ? rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("diffamount1")) : rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("diffamount"))));
                rowX.set(this.getSourceRowMeta().getFieldIndex("totalupdatediff"), (Object)(CadEmptyUtils.isEmpty((String)subelement) ? rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("totalupdatediff1")) : rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("totalupdatediff"))));
                return rowX;
            }
        });
        return sumDatabase;
    }
}

