/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.clac;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.utils.DataSetXHelper;
import kd.macc.sca.common.rpt.UnabSorbCalcParam;
import kd.macc.sca.report.clac.MatTypeSumDataDealFunction;

public class UnabSorbCalcHandleDataRow
implements IDataXTransform {
    private ReportDataCtx ctx;
    private UnabSorbCalcParam unabSorbCalcParam;

    public UnabSorbCalcHandleDataRow(UnabSorbCalcParam unabSorbCalcParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.unabSorbCalcParam = unabSorbCalcParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        Integer level = this.unabSorbCalcParam.getLevel();
        HashMap<String, String> matTypeMap = new HashMap<String, String>(16);
        DataSetX materialDataSetX = this.getMaterialDataSet(matTypeMap);
        srcData = srcData.removeFields(new String[]{"materialgroup", "materialgroupnumber"});
        srcData = level == 0 ? srcData.leftJoin(materialDataSetX).on("mfgmaterial", "material").select(srcData.getRowMeta().getFieldNames(), new String[]{"materialgroup", "materialgroupnumber", "longnumber"}) : srcData.join(materialDataSetX).on("mfgmaterial", "material").select(srcData.getRowMeta().getFieldNames(), new String[]{"materialgroup", "materialgroupnumber", "longnumber"});
        if (level > 0) {
            srcData = srcData.map((MapFunction)new MatTypeSumDataDealFunction(matTypeMap));
        }
        if (this.unabSorbCalcParam.getOnlyMaterialType().booleanValue()) {
            String sumStr = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"UnabSorbCalcHandleDataRow_0", (String)"macc-sca-report", (Object[])new Object[0]);
            DataSetX sumDataSetX = srcData.filter("mfgtype = '5'").groupBy(new String[]{"periodname", "materialgroup", "materialgroupnumber", "costcentername", "currency", "costcenternumber", "bizstatus", "productgroup", "productgroupnum", "producttype"}).sum("mfgpdstartqty").sum("mfgpdstartamt").sum("mfgpdcurrqty").sum("mfgpdcurramt").sum("mfgpdendqty").sum("mfgpdendamt").sum("mfgpddiffqty").sum("mfgpddiffamt").sum("mfgtotaldiffqty").sum("mfgtotaldiffamt").addFields(new Field[]{new Field("mfgelementname", (DataType)DataType.StringType), new Field("mfgtype", (DataType)DataType.StringType), new Field("mfgsubelementname", (DataType)DataType.StringType), new Field("mfgmodelnum", (DataType)DataType.StringType), new Field("mfgunit", (DataType)DataType.LongType), new Field("costobject", (DataType)DataType.LongType)}, new Object[]{"", "6", sumStr, "", 0L, 0L});
            DataSetX detialDataSetX = srcData.filter("mfgtype = '1'").groupBy(new String[]{"periodname", "materialgroup", "materialgroupnumber", "costcentername", "currency", "costcenternumber", "bizstatus", "productgroup", "productgroupnum", "producttype", "mfgsubelementname", "mfgelementnumber", "mfgelementname", "mfgsubelementnumber", "mfgtype", "mfgunit"}).sum("mfgpdstartqty").sum("mfgpdstartamt").sum("mfgpdcurrqty").sum("mfgpdcurramt").sum("mfgpdendqty").sum("mfgpdendamt").sum("mfgpddiffqty").sum("mfgpddiffamt").sum("mfgtotaldiffqty").sum("mfgtotaldiffamt");
            srcData = UnabSorbCalcHandleDataRow.addRowDiff(srcData, detialDataSetX);
            srcData = DataSetXHelper.unionIfRowDiff((DataSetX)srcData, (DataSetX)sumDataSetX);
        }
        String sumAllStr = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"UnabSorbCalcHandleDataRow_1", (String)"macc-sca-report", (Object[])new Object[0]);
        DataSetX costCenterdataSet = UnabSorbCalcHandleDataRow.getCostCenterDataSetX(srcData, sumAllStr);
        DataSetX periodSumData = UnabSorbCalcHandleDataRow.getPeriodSumDataSetX(srcData, sumAllStr);
        DataSetX allSumData = srcData.filter("mfgtype != '1'").groupBy(new String[]{"currency"}).sum("mfgpdstartqty").sum("mfgpdstartamt").sum("mfgpdcurrqty").sum("mfgpdcurramt").sum("mfgpdendqty").sum("mfgpdendamt").sum("mfgpddiffqty").sum("mfgpddiffamt").sum("mfgtotaldiffqty").sum("mfgtotaldiffamt").addFields(new Field[]{new Field("periodname", (DataType)DataType.StringType), new Field("mfgtype", (DataType)DataType.StringType)}, new Object[]{sumAllStr, "0"});
        srcData = DataSetXHelper.unionIfRowDiff((DataSetX)srcData, (DataSetX)periodSumData);
        srcData = DataSetXHelper.unionIfRowDiff((DataSetX)srcData, (DataSetX)costCenterdataSet);
        srcData = DataSetXHelper.unionIfRowDiff((DataSetX)srcData, (DataSetX)allSumData);
        return srcData;
    }

    private static DataSetX getPeriodSumDataSetX(DataSetX srcData, final String sumAllStr) {
        DataSetX periodSumData = srcData.filter("mfgtype != '1'").groupBy(new String[]{"period", "currency", "periodname"}).sum("mfgpdstartqty").sum("mfgpdstartamt").sum("mfgpdcurrqty").sum("mfgpdcurramt").sum("mfgpdendqty").sum("mfgpdendamt").sum("mfgpddiffqty").sum("mfgpddiffamt").sum("mfgtotaldiffqty").sum("mfgtotaldiffamt").addFields(new Field[]{new Field("mfgtype", (DataType)DataType.StringType)}, new Object[]{"0"});
        periodSumData = periodSumData.map(new MapFunction(){
            private static final long serialVersionUID = 1L;

            public RowX map(RowX rowX) {
                String period = rowX.getString(this.getSourceRowMeta().getFieldIndex("periodname"));
                rowX.set(this.getSourceRowMeta().getFieldIndex("periodname"), (Object)(period + sumAllStr));
                return rowX;
            }

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }
        });
        return periodSumData;
    }

    private static DataSetX getCostCenterDataSetX(DataSetX srcData, final String sumAllStr) {
        DataSetX costCenterdataSet = srcData.filter("mfgtype != '1'").groupBy(new String[]{"costcenter", "costcenternumber", "costcentername", "periodname", "currency", "costcenterord"}).sum("mfgpdstartqty").sum("mfgpdstartamt").sum("mfgpdcurrqty").sum("mfgpdcurramt").sum("mfgpdendqty").sum("mfgpdendamt").sum("mfgpddiffqty").sum("mfgpddiffamt").sum("mfgtotaldiffqty").sum("mfgtotaldiffamt").addFields(new Field[]{new Field("mfgtype", (DataType)DataType.StringType)}, new Object[]{"0"});
        costCenterdataSet = costCenterdataSet.map(new MapFunction(){
            private static final long serialVersionUID = 1L;

            public RowX map(RowX rowX) {
                String period = rowX.getString(this.getSourceRowMeta().getFieldIndex("costcentername"));
                rowX.set(this.getSourceRowMeta().getFieldIndex("costcentername"), (Object)(period + sumAllStr));
                rowX.set(this.getSourceRowMeta().getFieldIndex("costcenterord"), (Object)"1");
                return rowX;
            }

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }
        });
        return costCenterdataSet;
    }

    public static DataSetX addRowDiff(DataSetX dataSetOne, DataSetX dataSetTwo) {
        ArrayList srcFileds = Lists.newArrayList((Object[])dataSetOne.getRowMeta().getFields());
        ArrayList destFields = Lists.newArrayList((Object[])dataSetTwo.getRowMeta().getFields());
        srcFileds.removeAll(destFields);
        Object[] values = new Object[srcFileds.size()];
        for (int i = 0; i < srcFileds.size(); ++i) {
            DataType dt = ((Field)srcFileds.get(i)).getDataType();
            if (dt.equals((Object)DataType.BigDecimalType)) {
                values[i] = BigDecimal.ZERO;
                continue;
            }
            if (dt.equals((Object)DataType.BooleanType)) {
                values[i] = false;
                continue;
            }
            if (dt.equals((Object)DataType.DoubleType)) {
                values[i] = 0.0;
                continue;
            }
            if (dt.equals((Object)DataType.IntegerType)) {
                values[i] = 0;
                continue;
            }
            if (dt.equals((Object)DataType.LongType)) {
                values[i] = 0L;
                continue;
            }
            if (dt.equals((Object)DataType.StringType)) {
                values[i] = " ";
                continue;
            }
            if (!dt.equals((Object)DataType.TimestampType)) continue;
            values[i] = new Date();
        }
        if (srcFileds.size() > 0) {
            dataSetTwo = dataSetTwo.addFields(srcFileds.toArray(new Field[0]), values);
        }
        dataSetTwo = dataSetTwo.select(dataSetOne.getRowMeta().getFieldNames());
        return dataSetTwo;
    }

    private DataSetX getMaterialDataSet(Map<String, String> matTypeMap) {
        Integer level = this.unabSorbCalcParam.getLevel();
        Long orgId = this.unabSorbCalcParam.getOrgId();
        DynamicObject materialGrpStd = this.unabSorbCalcParam.getMaterialGrpStd();
        DynamicObjectCollection mulMaterialGroup = this.unabSorbCalcParam.getMaterialGroup();
        boolean isFromFilteInfo = false;
        if (level > 0) {
            DynamicObject materialGroup = null;
            if (mulMaterialGroup != null && mulMaterialGroup.size() > 0) {
                List materialGroupList = mulMaterialGroup.stream().map(material -> material.getDynamicObject("fbasedataid")).collect(Collectors.toList());
                materialGroup = (DynamicObject)materialGroupList.get(0);
            }
            mulMaterialGroup = this.getMaterialGroup(materialGrpStd, materialGroup, level, matTypeMap, orgId);
            isFromFilteInfo = true;
        }
        DataSet materialDataSet = MaterialGroupHelper.getClassifiedMaterialDataSet((DynamicObjectCollection)mulMaterialGroup, (boolean)false, (DynamicObject)materialGrpStd, (boolean)isFromFilteInfo);
        DataSetX materialDataSetX = this.ctx.getCurrentJob().fromInput((Input)new DataSetInput(materialDataSet));
        return materialDataSetX;
    }

    private DynamicObjectCollection getMaterialGroup(DynamicObject materialGrpStd, DynamicObject materialGroup, Integer level, Map<String, String> matTypeMap, Long orgId) {
        ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
        createOrgIds.add(orgId);
        QFilter groupFilter = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, materialGrpStd.getLong("id"), true});
        int size = level;
        String longNumberDLM = MaterialGroupHelper.getLongNumberDLM();
        if (materialGroup != null) {
            String groupLongNum = materialGroup.getString("longnumber");
            size = level + groupLongNum.split(longNumberDLM).length - 1;
            QFilter levelFilter = new QFilter("longnumber", "like", (Object)(groupLongNum + longNumberDLM + "%"));
            levelFilter.or(new QFilter("longnumber", "=", (Object)groupLongNum));
            groupFilter.and(levelFilter);
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_materialgroup", (String)"id,number,name,standard,longnumber,isleaf", (QFilter[])groupFilter.toArray(), (String)"number asc");
        HashSet<Long> ids = new HashSet<Long>(50);
        for (DynamicObject obj : dynamicObjects) {
            String longnumber = obj.getString("longnumber");
            int tempSize = longnumber.split(longNumberDLM).length;
            Boolean isLeaf = obj.getBoolean("isleaf");
            if (tempSize != size && (tempSize >= size || !isLeaf.booleanValue())) continue;
            Long id = obj.getLong("id");
            ids.add(id);
            String number = obj.getString("number");
            matTypeMap.put(longnumber, number + " / " + id);
        }
        QFilter idsFilter = new QFilter("id", "in", ids);
        return QueryServiceHelper.query((String)"bd_materialgroup", (String)"id,number,name,standard,longnumber,isleaf", (QFilter[])idsFilter.toArray(), (String)"number asc");
    }
}

