/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.clac;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.PermItemCheckHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ReportUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.sca.common.helper.MatBaseDataFilterHelper;
import kd.macc.sca.common.rpt.UnabSorbCalcParam;

public class UnabSorbCalcRptPlugin
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final Long MAT_GROUP_STD = 730148448254487552L;
    private static String[] CLEAR_STR = new String[]{"period", "manuorg", "materialgroup", "materialgroupnumber", "costcenter", "costobject", "bizstatus", "productgroup", "productgroupnum", "producttype", "mfgmaterial", "mfgmaterialnumber", "mfgmaterialname", "mfgmodelnum", "mfgversion", "mfgauxpty", "mfgunit"};
    private static String[] CLEAR_STR_ONLY = new String[]{"period", "costcenter", "bizstatus", "materialgroup", "materialgroupnumber", "productgroup", "productgroupnum", "producttype"};

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgInput = (BasedataEdit)this.getControl("org");
        orgInput.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            QFilter qfId = new QFilter("id", "in", (Object)orgIds);
            filterParameter.getQFilters().add(qfId);
        });
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"UnabSorbCalcRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            Long acctOrgId = org.getLong("id");
            qFilters.add(StartCostHelper.getEnabledCostAccountIdsFilter((Long)acctOrgId, (String)this.getView().getFormShowParameter().getAppId()));
        });
        MulBasedataEdit mulPeriod = (MulBasedataEdit)this.getControl("mulperiod");
        mulPeriod.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"UnabSorbCalcRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"UnabSorbCalcRptPlugin_1", (String)"macc-sca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)org.getLong("id"), (Long)costAccountObj.getLong("id")));
        });
        MulBasedataEdit mulManuOrg = (MulBasedataEdit)this.getControl("mulmanuorg");
        mulManuOrg.addBeforeF7SelectListener(evt -> {
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
            if (accountorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"UnabSorbCalcRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(new QFilter("id", "in", (Object)ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountorg.getLong("id"), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId())));
        });
        BasedataEdit costCenterGroup = (BasedataEdit)this.getControl("costcentergroup");
        costCenterGroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"UnabSorbCalcRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            Long acctOrgId = org.getLong("id");
            qFilters.add(new QFilter("org", "=", (Object)acctOrgId));
            DynamicObjectCollection mulmanuorg = this.getModel().getDataEntity().getDynamicObjectCollection("mulmanuorg");
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulmanuorg)) {
                List manuOrgIds = mulmanuorg.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toList());
                QFilter manuOrgFilter = new QFilter("manuorg", "in", manuOrgIds);
                qFilters.add(manuOrgFilter);
            }
            Date date = new Date();
            QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
            dateFilter.and("expdate", ">", (Object)date);
            qFilters.add(dateFilter);
        });
        MulBasedataEdit mulCostCenter = (MulBasedataEdit)this.getControl("mulcostcenter");
        mulCostCenter.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject selectedCostCenterGroup;
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"UnabSorbCalcRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter showOrgDutyFilter = new QFilter("orgduty", "=", (Object)4L);
            QFilter calorgsFilter = new QFilter("accountorg", "=", (Object)org.getLong("id"));
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(showOrgDutyFilter);
            qFilters.add(calorgsFilter);
            DynamicObjectCollection mulmanuorg = this.getModel().getDataEntity().getDynamicObjectCollection("mulmanuorg");
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulmanuorg)) {
                List manuOrgList = mulmanuorg.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toList());
                QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactoryForList((long)org.getLong("id"), manuOrgList, (String)this.getView().getFormShowParameter().getAppId(), (String)this.getBillEntityId());
                qFilters.add(costCenterIdFilter);
            }
            if ((selectedCostCenterGroup = this.getModel().getDataEntity().getDynamicObject("costcentergroup")) != null) {
                QFilter costGroupFilter = new QFilter("id", "=", (Object)selectedCostCenterGroup.getLong("id"));
                DynamicObjectCollection cosCenter = QueryServiceHelper.query((String)"cad_costcentergroup", (String)"entryentity.costcenter coscenterid", (QFilter[])new QFilter[]{costGroupFilter});
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)cosCenter)) {
                    Set cosCenterId = cosCenter.stream().map(dynamicObject -> dynamicObject.getLong("coscenterid")).collect(Collectors.toSet());
                    QFilter manuOrgFilter = new QFilter("id", "in", cosCenterId);
                    qFilters.add(manuOrgFilter);
                } else {
                    qFilters.add(QFilter.of((String)"1=0", (Object[])new Object[0]));
                }
            }
        });
        MulBasedataEdit mulcostobject = (MulBasedataEdit)this.getControl("mulcostobject");
        mulcostobject.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"UnabSorbCalcRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            QFilter calorgsFilter = new QFilter("org", "=", (Object)org.getLong("id"));
            DynamicObjectCollection costcenterDy = this.getModel().getDataEntity().getDynamicObjectCollection("mulcostcenter");
            qFilters.add(calorgsFilter);
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costcenterDy)) {
                List collect = costcenterDy.stream().map(costObject -> costObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                qFilters.add(new QFilter("costcenter", "in", collect));
            }
        });
        BasedataEdit materialGrpStd = (BasedataEdit)this.getControl("materialgrpstd");
        materialGrpStd.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"UnabSorbCalcRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(org.getLong("id"));
            Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, Boolean.TRUE});
            qFilters.add(new QFilter("id", "in", (Object)ids));
        });
        MulBasedataEdit mulMaterialGroup = (MulBasedataEdit)this.getControl("mulmaterialgroup");
        mulMaterialGroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"UnabSorbCalcRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject materialgrpstdObj = (DynamicObject)this.getModel().getValue("materialgrpstd");
            if (materialgrpstdObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"UnabSorbCalcRptPlugin_6", (String)"macc-sca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(org.getLong("id"));
            QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, materialgrpstdObj.getPkValue(), false});
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(serviceResponse);
            HashMap<String, ArrayList<Long>> params = new HashMap<String, ArrayList<Long>>(2);
            params.put("useOrgs", createOrgIds);
            listShowParameter.setCustomParams(params);
            listShowParameter.setCustomParam("groupStandard", materialgrpstdObj.getPkValue());
            listShowParameter.setF7ClickByFilter(false);
        });
        MulBasedataEdit mulMaterial = (MulBasedataEdit)this.getControl("mulmaterial");
        mulMaterial.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"UnabSorbCalcRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject materialGrpStdObj = (DynamicObject)this.getModel().getValue("materialgrpstd");
            if (materialGrpStdObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"UnabSorbCalcRptPlugin_6", (String)"macc-sca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            HashSet<Long> orgSet = new HashSet<Long>(16);
            orgSet.add(org.getLong("id"));
            DynamicObjectCollection mulmaterialgroup = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup");
            DynamicObject materialgroupstandard = (DynamicObject)this.getModel().getValue("materialgrpstd");
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(MatBaseDataFilterHelper.getBaseFilter(new ArrayList(orgSet)));
            if (!CollectionUtils.isEmpty((Collection)mulmaterialgroup) || materialgroupstandard.getLong("id") != 730148448254487552L) {
                qFilters.add(MaterialGroupHelper.getClassifiedMaterialIdFilter((DynamicObjectCollection)mulmaterialgroup, (boolean)false, (DynamicObject)materialgroupstandard));
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "org": {
                this.setOther();
                this.setCostAccount();
                this.setManuorg();
                break;
            }
            case "costaccount": {
                this.setPeriodAndCurrency();
                break;
            }
            case "materialgrpstd": {
                this.getModel().setValue("mulmaterialgroup", null);
                break;
            }
            case "mulmaterialgroup": {
                this.getModel().setValue("mulmaterial", null);
                DynamicObjectCollection mulmaterialGroup = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup");
                if (mulmaterialGroup != null && mulmaterialGroup.size() > 1) {
                    this.getModel().setValue("level", null);
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"level"});
                    break;
                }
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"level"});
                break;
            }
            case "level": {
                DynamicObjectCollection mulmaterialGroupObj = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup");
                Integer level = (Integer)this.getModel().getValue("level");
                if (mulmaterialGroupObj == null || mulmaterialGroupObj.size() <= 1 || level == 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b\u591a\u9009\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u5206\u7c7b\u7ea7\u6b21\u3002", (String)"UnabSorbCalcRptPlugin_7", (String)"macc-sca-report", (Object[])new Object[0]));
                this.getModel().setValue("level", null);
                return;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setOrg();
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.setCostAccount();
            this.setPeriodAndCurrency();
        }
        this.setManuorg();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.fillHyperLinkData() != null) {
            ReportFilter filter = (ReportFilter)this.getControl("reportfilterap");
            filter.search();
        }
    }

    private UnabSorbCalcParam fillHyperLinkData() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String openParamStr = (String)fsp.getCustomParam(UnabSorbCalcParam.class.getName());
        if (!CadEmptyUtils.isEmpty((String)openParamStr)) {
            UnabSorbCalcParam param = (UnabSorbCalcParam)SerializationUtils.fromJsonString((String)openParamStr, UnabSorbCalcParam.class);
            this.getModel().setValue("org", (Object)param.getOrgId());
            this.getModel().setValue("costaccount", (Object)param.getCostAccountId());
            this.getModel().setValue("currency", (Object)param.getCurrencyId());
            this.getModel().setValue("mulperiod", (Object)param.getPeriodIds().toArray());
            this.getModel().setValue("materialgrpstd", (Object)MAT_GROUP_STD);
            this.getModel().setValue("level", (Object)param.getLevel());
            this.getView().updateView("org");
            this.getView().updateView("costaccount");
            this.getView().updateView("currency");
            this.getView().updateView("mulperiod");
            this.getView().updateView("materialgrpstd");
            this.getView().updateView("level");
            return param;
        }
        return null;
    }

    private void setManuorg() {
        Object org = this.getModel().getValue("org");
        if (!ObjectUtils.isEmpty((Object)org)) {
            DynamicObject orgData = (DynamicObject)org;
            boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)((Long)orgData.getPkValue()));
            this.getView().setVisible(Boolean.valueOf(enableMulFactory), new String[]{"mulmanuorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mulmanuorg"});
        }
        this.getModel().setValue("mulmanuorg", null);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return;
        }
        if ("exportexcel".equals(operateKey) && !PermItemCheckHelper.isPerm((String)"sca_unabsorbrptnew", (String)"47150e89000000ac", (String)this.getView().getFormShowParameter().getAppId(), (Long)org.getLong("id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u672a\u5438\u6536\u8d39\u7528\u8ba1\u7b97\u5355\u201d\u7684\u201c\u5bfc\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UnabSorbCalcRptPlugin_9", (String)"macc-sca-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        ArrayList pros = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "currency", "mulperiod", "materialgrpstd"});
        boolean isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, (List)pros);
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"UnabSorbCalcRptPlugin_3", (String)"macc-sca-report", (Object[])new Object[0]));
            return false;
        }
        UnabSorbCalcParam pram = this.buildUnabSorbCalcParam(this.getModel().getDataEntity());
        this.getQueryParam().getCustomParam().put(UnabSorbCalcParam.class.getName(), pram);
        return true;
    }

    private UnabSorbCalcParam buildUnabSorbCalcParam(DynamicObject dataEntity) {
        String bizStatus;
        DynamicObjectCollection costobjects;
        DynamicObjectCollection costcenters;
        DynamicObject costCenterGroup;
        UnabSorbCalcParam param = new UnabSorbCalcParam();
        DynamicObject org = dataEntity.getDynamicObject("org");
        param.setOrgId(Long.valueOf(org.getLong("id")));
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        param.setCostAccountId(Long.valueOf(costAccount.getLong("id")));
        DynamicObject currency = dataEntity.getDynamicObject("currency");
        param.setCurrencyId(Long.valueOf(currency.getLong("id")));
        DynamicObjectCollection periods = (DynamicObjectCollection)this.getModel().getValue("mulperiod");
        param.setPeriodIds(periods.stream().map(period -> period.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        DynamicObjectCollection mulManuorg = (DynamicObjectCollection)this.getModel().getValue("mulmanuorg");
        if (mulManuorg != null) {
            param.setManuOrgIds(mulManuorg.stream().map(manuorg -> manuorg.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if ((costCenterGroup = dataEntity.getDynamicObject("costcentergroup")) != null) {
            param.setCostCenterGroupId(Long.valueOf(costCenterGroup.getLong("id")));
        }
        DynamicObject materialgrpstd = dataEntity.getDynamicObject("materialgrpstd");
        param.setMaterialGrpStd(materialgrpstd);
        DynamicObjectCollection mulMaterialGroup = dataEntity.getDynamicObjectCollection("mulmaterialgroup");
        if (mulMaterialGroup != null) {
            param.setMaterialGroup(mulMaterialGroup);
        }
        int level = 0;
        if (dataEntity.get("level") != null) {
            level = dataEntity.getInt("level");
        }
        param.setLevel(Integer.valueOf(level));
        DynamicObjectCollection mulMaterial = (DynamicObjectCollection)this.getModel().getValue("mulmaterial");
        if (mulMaterial != null) {
            param.setMaterialIds(mulMaterial.stream().map(material -> material.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if ((costcenters = (DynamicObjectCollection)this.getModel().getValue("mulcostcenter")) != null) {
            param.setCostCenterIds(costcenters.stream().map(costcenter -> costcenter.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if ((costobjects = (DynamicObjectCollection)this.getModel().getValue("mulcostobject")) != null) {
            param.setCostObjectIds(costobjects.stream().map(costobject -> costobject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if (!CadEmptyUtils.isEmpty((String)(bizStatus = (String)this.getModel().getValue("bizstatus"))) && !"ALL".equalsIgnoreCase(bizStatus)) {
            param.setBizStatus(bizStatus);
        }
        Boolean onlyMaterialType = (Boolean)this.getModel().getValue("onlymaterialtype");
        param.setOnlyMaterialType(onlyMaterialType);
        return param;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"UnabSorbCalcRptPlugin_4", (String)"macc-sca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"UnabSorbCalcRptPlugin_8", (String)"macc-sca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"sca_unabsorbrptnew", (IDataModel)this.getModel());
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        Boolean onlyMaterialType = (Boolean)this.getModel().getValue("onlymaterialtype");
        if (onlyMaterialType.booleanValue()) {
            ReportUtils.clearFileNameValue((String[])CLEAR_STR_ONLY, (DynamicObjectCollection)rowData, (String[])CLEAR_STR_ONLY);
        } else {
            ReportUtils.clearFileNameValue((String[])CLEAR_STR, (DynamicObjectCollection)rowData, (String[])CLEAR_STR);
        }
    }

    private void setOther() {
        this.getModel().setValue("mulcostcenter", null);
        this.getModel().setValue("costaccount", null);
        this.getModel().setValue("mulperiod", null);
        this.getModel().setValue("currency", null);
        this.getModel().setValue("mulmanuorg", null);
        this.getModel().setValue("mulcostobject", null);
        this.getModel().setValue("mulmaterial", null);
        this.getModel().setValue("level", (Object)0);
        this.getModel().setValue("mulmaterialgroup", null);
    }

    private void setOrg() {
        if (this.getModel().getValue("org") == null) {
            Long orgId = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
            if (!isAccounting) {
                return;
            }
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (orgIds.contains(orgId)) {
                this.getModel().setValue("org", (Object)orgId);
                this.getView().updateView("org");
            }
        }
    }

    private void setCostAccount() {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        Long mainBookId = CostAccountHelper.getCostAccountByAccoutOrg((Long)((DynamicObject)org).getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
        if (mainBookId != 0L) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
        } else {
            this.getModel().setValue("costaccount", null);
        }
        this.getView().updateView("costaccount");
    }

    private void setPeriodAndCurrency() {
        DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
        if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
            this.getModel().setValue("mulperiod", null);
            this.getModel().setValue("currency", null);
        } else {
            Long costAccountId = costAccountObj.getLong("id");
            DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
            if (curPeriod == null) {
                this.getModel().setValue("mulperiod", null);
                this.getModel().setValue("currency", null);
            } else {
                Long currentPeriodId = curPeriod.getLong("id");
                this.getModel().setValue("mulperiod", (Object)new Object[]{currentPeriodId});
                this.getModel().setValue("currency", (Object)CurrencyHelper.getCurrency((DynamicObject)costAccountObj));
            }
        }
    }
}

