/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.cost;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.sca.common.helper.MatBaseDataFilterHelper;
import kd.macc.sca.report.cost.CostRedLevelParam;

public class CostReductionLevelRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void registerListener(EventObject e) {
        MulBasedataEdit org = (MulBasedataEdit)this.getControl("orgf");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit costaccount = (MulBasedataEdit)this.getControl("costaccountf");
        costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit prdorg = (MulBasedataEdit)this.getControl("prdorgf");
        prdorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit storageorgunit = (MulBasedataEdit)this.getControl("storageorgunitf");
        storageorgunit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit period = (MulBasedataEdit)this.getControl("mulperiodf");
        period.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialgrpstd = (BasedataEdit)this.getControl("materialgrpstd");
        materialgrpstd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulmaterialtype = (MulBasedataEdit)this.getControl("mulmaterialtypef");
        mulmaterialtype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulmaterial = (MulBasedataEdit)this.getControl("mulmaterialf");
        mulmaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulproduct = (MulBasedataEdit)this.getControl("mulproductf");
        mulproduct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        String appId = AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView());
        filterInfo.addFilterItem("appnum", (Object)appId, "=");
        queryParam.setFilter(filterInfo);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"prdorgf", "storageorgunitf"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"viewtransincost"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"viewpurcost"});
        this.init();
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        List columns = event.getColumns();
        boolean onlymaterialtype = this.getModel().getDataEntity().getBoolean("onlymaterialtype");
        boolean viewtransincost = this.getModel().getDataEntity().getBoolean("viewtransincost");
        boolean viewpurcost = this.getModel().getDataEntity().getBoolean("viewpurcost");
        for (AbstractReportColumn col : columns) {
            ReportColumn subcolRc;
            if (col instanceof ReportColumn) {
                ReportColumn reportColumn = (ReportColumn)col;
                String key = reportColumn.getFieldKey();
                if (!"submaterial".equals(key) && !"submaterialname".equals(key) && !"subbaseunit".equals(key) && !key.contains("submaterialauxprop")) continue;
                reportColumn.setHide(onlymaterialtype);
                continue;
            }
            if (!(col instanceof ReportColumnGroup)) continue;
            ReportColumnGroup reportColumnGroup = (ReportColumnGroup)col;
            if ("entryfieldgroupaptransin".equals(reportColumnGroup.getFieldKey())) {
                for (AbstractReportColumn subcol : reportColumnGroup.getChildren()) {
                    subcolRc = (ReportColumn)subcol;
                    subcolRc.setHide(!viewtransincost);
                }
                continue;
            }
            if (!"entryfieldgroupappur".equals(reportColumnGroup.getFieldKey())) continue;
            for (AbstractReportColumn subcol : reportColumnGroup.getChildren()) {
                subcolRc = (ReportColumn)subcol;
                subcolRc.setHide(!viewpurcost);
            }
        }
        this.getView().updateView("reportlistap");
        super.afterCreateColumn(event);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        DynamicObjectCollection org = this.getModel().getDataEntity().getDynamicObjectCollection("orgf");
        Set orgSet = null;
        switch (name) {
            case "orgf": {
                break;
            }
            case "costaccountf": {
                qFilters.add(this.getCostAccountF7QFilter(AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView())));
                break;
            }
            case "prdorgf": {
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)org)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionLevelRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                orgSet = org.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                Iterator iterator = orgSet.iterator();
                HashSet prdOrgSet = new HashSet(4);
                while (iterator.hasNext()) {
                    Long orgId = (Long)iterator.next();
                    List productOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)orgId, (boolean)true);
                    prdOrgSet.addAll(productOrgs);
                }
                qFilters.add(new QFilter("id", "in", prdOrgSet));
                break;
            }
            case "storageorgunitf": {
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)org)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionLevelRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObjectCollection prdorg = this.getModel().getDataEntity().getDynamicObjectCollection("prdorgf");
                orgSet = org.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                Set pdorgSet = prdorg.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                HashSet stOrgs = new HashSet();
                if (!CadEmptyUtils.isEmpty(pdorgSet)) {
                    for (Long pdorg : pdorgSet) {
                        List stOrglist = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)pdorg, (boolean)true);
                        stOrgs.addAll(stOrglist);
                    }
                } else {
                    for (Long orgId : orgSet) {
                        List stOrglist = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)orgId, (boolean)true);
                        stOrgs.addAll(stOrglist);
                    }
                }
                qFilters.add(new QFilter("id", "in", stOrgs));
                break;
            }
            case "mulperiodf": {
                DynamicObjectCollection costaccount = this.getModel().getDataEntity().getDynamicObjectCollection("costaccountf");
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costaccount)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionLevelRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                Iterator ite = costaccount.iterator();
                TreeSet<Long> minSet = new TreeSet<Long>();
                TreeSet<Long> maxSet = new TreeSet<Long>();
                HashSet<Long> periodTypeSet = new HashSet<Long>();
                while (ite.hasNext()) {
                    DynamicObject costAccId = (DynamicObject)ite.next();
                    this.getUsePeriodFilter(costAccId.getDynamicObject("fbasedataid").getLong("id"), periodTypeSet, minSet, maxSet);
                }
                if (periodTypeSet.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u6838\u7b97\u671f\u95f4\u7c7b\u578b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionLevelRptPlugin_1", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter filters = new QFilter("periodtype", "in", periodTypeSet);
                filters.and(new QFilter("id", ">=", (Object)minSet.first()));
                filters.and(new QFilter("id", "<=", (Object)maxSet.last()));
                qFilters.add(filters);
                break;
            }
            case "materialgrpstd": {
                List createOrgIds = org.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, Boolean.TRUE});
                qFilters.add(new QFilter("id", "in", (Object)ids));
                break;
            }
            case "mulmaterialtypef": {
                DynamicObject materialgrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd");
                if (materialgrpstd == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"CostReductionLevelRptPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                List createOrgIds = org.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, materialgrpstd.getPkValue(), false});
                qFilters.add(serviceResponse);
                HashMap params = new HashMap(2);
                params.put("useOrgs", createOrgIds);
                listShowParameter.setCustomParams(params);
                listShowParameter.setCustomParam("groupStandard", materialgrpstd.getPkValue());
                listShowParameter.setF7ClickByFilter(false);
                break;
            }
            case "mulproductf": {
                List orgIds = org.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                if (orgIds.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionLevelRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter matOrgFilter = MatBaseDataFilterHelper.getBaseFilter(orgIds);
                qFilters.add(matOrgFilter);
                listShowParameter.setF7ClickByFilter(false);
                break;
            }
            case "mulmaterialf": {
                DynamicObject materialgrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd");
                if (materialgrpstd == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"CostReductionLevelRptPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                List createOrgIds = org.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                HashMap params = new HashMap(2);
                params.put("useOrgs", createOrgIds);
                listShowParameter.setCustomParams(params);
                DynamicObjectCollection mulmaterialtype = (DynamicObjectCollection)this.getModel().getValue("mulmaterialtypef");
                if (!CollectionUtils.isEmpty((Collection)mulmaterialtype) || materialgrpstd != null && materialgrpstd.getLong("id") != 730148448254487552L) {
                    qFilters.add(MaterialGroupHelper.getClassifiedMaterialIdFilter((DynamicObjectCollection)mulmaterialtype, (boolean)false, (DynamicObject)materialgrpstd));
                }
                listShowParameter.setF7ClickByFilter(false);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyname = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (propertyname) {
            case "orgf": {
                break;
            }
            case "costaccountf": {
                if (newValue == null) {
                    this.getModel().setValue("mulperiodf", null);
                }
                if (newValue instanceof DynamicObjectCollection) {
                    DynamicObjectCollection costAccountCol = (DynamicObjectCollection)newValue;
                    Set<Long> costAccIdSet = costAccountCol.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                    Set orgIdSet = costAccountCol.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("calorg.id")).collect(Collectors.toSet());
                    boolean b1 = this.validateCurrencyWhenChooseCostAcc(costAccIdSet, oldValue);
                    boolean b2 = this.validatePeriodTypeWhenChooseCostAcc(costAccIdSet, oldValue);
                    boolean b3 = this.validateCostReductCalDimension(costAccIdSet, oldValue);
                    if (!(b1 && b2 && b3)) {
                        if (oldValue instanceof DynamicObjectCollection) {
                            Set oldSet = ((DynamicObjectCollection)oldValue).stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                            oldSet.retainAll(costAccIdSet);
                            if (oldSet.size() == 0) {
                                this.getModel().setValue("mulperiodf", null);
                                this.getModel().setValue("prdorgf", null);
                                this.getModel().setValue("storageorgunitf", null);
                            }
                        }
                        this.getModel().setValue("orgf", (Object)orgIdSet.toArray());
                        this.getView().updateView("orgf");
                    }
                }
                this.setCurrency();
                this.setPeriod();
                break;
            }
            case "materialgrpstd": {
                this.getModel().setValue("mulmaterialtypef", null);
                this.getModel().setValue("mulmaterialf", null);
                break;
            }
            case "mulmaterialtypef": {
                this.getModel().setValue("mulmaterialf", null);
                break;
            }
            case "prdorgf": {
                if ("Y".equals(this.getPageCache().get("need_storg_cache"))) {
                    List stOrglist;
                    DynamicObjectCollection prdorg = this.getModel().getDataEntity().getDynamicObjectCollection("prdorgf");
                    List pdorgList = prdorg.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                    if (prdorg.size() == 1 && (stOrglist = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)((Long)pdorgList.get(0)), (boolean)true)).size() == 1) {
                        DynamicObjectCollection stCol = this.getModel().getDataEntity().getDynamicObjectCollection("storageorgunitf");
                        stCol.clear();
                        Map stOrgDynMap = BusinessDataServiceHelper.loadFromCache((Object[])stOrglist.toArray(), (String)"bos_org");
                        if (stOrgDynMap.size() > 0) {
                            DynamicObject obj = stCol.addNew();
                            obj.set("fbasedataid", stOrgDynMap.get(stOrglist.get(0)));
                            this.getView().updateView("storageorgunitf");
                            break;
                        }
                    }
                }
                this.getModel().setValue("storageorgunitf", null);
                this.getView().updateView("storageorgunitf");
                break;
            }
            case "storageorgunitf": {
                List stList;
                List pdOrglist;
                DynamicObjectCollection stCol = this.getModel().getDataEntity().getDynamicObjectCollection("storageorgunitf");
                DynamicObjectCollection prdorg = this.getModel().getDataEntity().getDynamicObjectCollection("prdorgf");
                if (stCol.size() != 1 || prdorg.size() != 0 || (pdOrglist = OrgUnitServiceHelper.getAllToOrg((String)"05", (String)"04", (Long)((Long)(stList = stCol.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList())).get(0)), (boolean)true)).size() != 1) break;
                prdorg.clear();
                Map pdOrgDynMap = BusinessDataServiceHelper.loadFromCache((Object[])pdOrglist.toArray(), (String)"bos_org");
                if (pdOrgDynMap.size() <= 0) break;
                DynamicObject obj = stCol.addNew();
                obj.set("fbasedataid", pdOrgDynMap.get(pdOrglist.get(0)));
                this.getView().updateView("prdorgf");
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        DynamicObjectCollection costAccount = filter.getDynamicObjectCollection("costaccountf");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccount)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionLevelRptPlugin_3", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObjectCollection period = filter.getDynamicObjectCollection("mulperiodf");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)period)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u671f\u95f4", (String)"CostReductionLevelRptPlugin_4", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObjectCollection mulproduct = filter.getDynamicObjectCollection("mulproductf");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)mulproduct)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ea7\u54c1", (String)"CostReductionLevelRptPlugin_5", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObject currency = filter.getDynamicObject("currency");
        if (currency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u7ef4\u62a4\u5e01\u79cd\u3002", (String)"CostReductionLevelRptPlugin_6", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObject materialgrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd");
        if (materialgrpstd == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"CostReductionLevelRptPlugin_7", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        CostRedLevelParam costRedLevelParam = this.buildCostRedLevelParam(filter);
        this.getQueryParam().getCustomParam().put(CostRedLevelParam.class.getName(), costRedLevelParam);
        return super.verifyQuery(queryParam);
    }

    private CostRedLevelParam buildCostRedLevelParam(FilterInfo filter) {
        DynamicObjectCollection mulMaterials;
        DynamicObjectCollection mulMaterialTypes;
        DynamicObject materialGrpStd;
        DynamicObjectCollection mulProducts;
        DynamicObjectCollection mulPeriods;
        DynamicObject currency;
        DynamicObjectCollection storageOrgs;
        DynamicObjectCollection prdOrgs;
        DynamicObjectCollection costAccounts;
        CostRedLevelParam costRedLevelParam = new CostRedLevelParam();
        DynamicObjectCollection orgs = filter.getDynamicObjectCollection("orgf");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)orgs)) {
            costRedLevelParam.setOrgIds(orgs.stream().map(org -> org.getLong("id")).collect(Collectors.toList()));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(costAccounts = filter.getDynamicObjectCollection("costaccountf")))) {
            costRedLevelParam.setCostAccountIds(costAccounts.stream().map(costAccount -> costAccount.getLong("id")).collect(Collectors.toList()));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(prdOrgs = filter.getDynamicObjectCollection("prdorgf")))) {
            costRedLevelParam.setManuOrgIds(prdOrgs.stream().map(prdOrg -> prdOrg.getLong("id")).collect(Collectors.toList()));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(storageOrgs = filter.getDynamicObjectCollection("storageorgunitf")))) {
            costRedLevelParam.setStorageOrgIds(storageOrgs.stream().map(storageOrg -> storageOrg.getLong("id")).collect(Collectors.toList()));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObject)(currency = filter.getDynamicObject("currency")))) {
            costRedLevelParam.setCurrencyId(currency.getLong("id"));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(mulPeriods = filter.getDynamicObjectCollection("mulperiodf")))) {
            costRedLevelParam.setPeriods(mulPeriods.stream().collect(Collectors.toList()));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(mulProducts = filter.getDynamicObjectCollection("mulproductf")))) {
            costRedLevelParam.setProductIds(mulProducts.stream().map(product -> product.getLong("id")).collect(Collectors.toList()));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObject)(materialGrpStd = filter.getDynamicObject("materialgrpstd")))) {
            costRedLevelParam.setMaterialGroupStd(materialGrpStd);
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(mulMaterialTypes = filter.getDynamicObjectCollection("mulmaterialtypef")))) {
            costRedLevelParam.setMaterialType(mulMaterialTypes);
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(mulMaterials = filter.getDynamicObjectCollection("mulmaterialf")))) {
            costRedLevelParam.setMaterialIds(mulMaterials.stream().map(material -> material.getLong("id")).collect(Collectors.toList()));
        }
        costRedLevelParam.setDisPlayLevel(filter.getString("displaylevel"));
        costRedLevelParam.setOnlySumRow(filter.getBoolean("onlysumrow"));
        costRedLevelParam.setOnlyMaterialType(filter.getBoolean("onlymaterialtype"));
        costRedLevelParam.setTopSumRow(filter.getBoolean("topsumrow"));
        costRedLevelParam.setViewTransinCost(filter.getBoolean("viewtransincost"));
        costRedLevelParam.setViewPurCost(filter.getBoolean("viewpurcost"));
        return costRedLevelParam;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"CostReductionLevelRptPlugin_8", (String)"macc-sca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c\u8fd8\u539f\uff08\u5206\u7ea7\u67e5\u8be2\uff09", (String)"CostReductionLevelRptPlugin_9", (String)"macc-sca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"sca_costredlevelrpt", (IDataModel)this.getModel());
    }

    private void init() {
        DynamicObjectCollection org = this.getModel().getDataEntity().getDynamicObjectCollection("orgf");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)org)) {
            return;
        }
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (isaccount && permAccountOrgIds.contains(currentOrgId)) {
            Object[] orgCol = new Object[]{currentOrgId};
            this.getModel().setValue("orgf", (Object)orgCol);
            this.getView().updateView("orgf");
        }
        org = this.getModel().getDataEntity().getDynamicObjectCollection("orgf");
        this.setCostAccount(org);
        this.getView().updateView("costaccountf");
    }

    private void setCostAccount(DynamicObjectCollection org) {
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)org)) {
            this.getModel().setValue("costaccountf", null);
            this.getModel().setValue("mulperiodf", null);
            this.getModel().setValue("currency", null);
            return;
        }
        Object[] costAccountCol = new Object[1];
        Long costAccount = this.getCostAccountByAccoutOrg(((DynamicObject)org.get(0)).getDynamicObject("fbasedataid").getLong("id"));
        if (costAccount != 0L) {
            costAccountCol[0] = costAccount;
            this.getModel().setValue("costaccountf", (Object)costAccountCol);
            HashSet<Long> costAccIdSet = new HashSet<Long>();
            costAccIdSet.add(Long.getLong("id"));
            this.validateCostReductCalDimension(costAccIdSet, null);
        } else {
            this.getModel().setValue("costaccountf", null);
            this.getModel().setValue("mulperiodf", null);
            this.getModel().setValue("orgf", null);
        }
        this.setCurrency();
        if (costAccount != 0L) {
            this.setPeriod();
        }
    }

    private Long getCostAccountByAccoutOrg(Long accountOrgId) {
        QFilter accountorgQF = new QFilter("org", "=", (Object)accountOrgId);
        QFilter enablestdtQF = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        enablestdtQF.and("appnum", "=", (Object)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
        QFilter isinitaccountQF = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount costaccount,entryentity.costaccount.ismainaccount ismainaccount", (QFilter[])new QFilter[]{accountorgQF, enablestdtQF, isinitaccountQF}, (String)"entryentity.costaccount.ismainaccount desc,entryentity.costaccount.id desc");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)result)) {
            return 0L;
        }
        if (((DynamicObject)result.get(0)).getBoolean("ismainaccount") || result.size() == 1) {
            return ((DynamicObject)result.get(0)).getLong("costaccount");
        }
        return 0L;
    }

    private void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection costaccount = dataEntity.getDynamicObjectCollection("costaccountf");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costaccount)) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObjectCollection calpolicyCol = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calpolicy", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)((DynamicObject)costaccount.get(0)).getDynamicObject("fbasedataid").getLong("id"))});
        Set calpolicySet = calpolicyCol.stream().map(r -> r.getLong("calpolicy")).collect(Collectors.toSet());
        if (CadEmptyUtils.isEmpty(calpolicySet)) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObjectCollection currencyCol = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "in", calpolicySet)});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)currencyCol)) {
            this.getModel().setValue("currency", null);
            return;
        }
        Set currencySet = currencyCol.stream().map(r -> r.getLong("currency")).collect(Collectors.toSet());
        if (CadEmptyUtils.isEmpty(currencySet)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u5e01\u79cd\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionLevelRptPlugin_10", (String)"macc-sca-report", (Object[])new Object[0]));
            return;
        }
        if (currencySet.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u5e01\u79cd\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionLevelRptPlugin_10", (String)"macc-sca-report", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("currency", currencySet.toArray()[0]);
    }

    private void setPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection org = dataEntity.getDynamicObjectCollection("orgf");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)org)) {
            return;
        }
        DynamicObjectCollection costAccount = dataEntity.getDynamicObjectCollection("costaccountf");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccount)) {
            this.getModel().setValue("mulperiodf", null);
            this.getView().updateView("mulperiodf");
            return;
        }
        Long orgId = ((DynamicObject)org.get(0)).getLong("fbasedataid.id");
        Long costAccountId = ((DynamicObject)costAccount.get(0)).getLong("fbasedataid.id");
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount});
        if (res != null) {
            Long currentperiod = res.getLong("currentperiod");
            Object[] objects = new Object[]{currentperiod};
            this.getModel().setValue("mulperiodf", (Object)objects);
            this.getView().updateView("mulperiodf");
        }
    }

    private QFilter getCostAccountF7QFilter(String appNum) {
        List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        QFilter orgFilter = new QFilter("org", "in", (Object)permAccountOrgIds);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter appnumFilter = new QFilter("appnum", "=", (Object)appNum);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, appnumFilter};
        DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filters);
        if (costAccountIds.size() > 0) {
            Set costAccountIdList = costAccountIds.stream().map(costAccount -> costAccount.getLong("costaccountid")).collect(Collectors.toSet());
            return new QFilter("id", "in", costAccountIdList);
        }
        return new QFilter("id", "=", (Object)0);
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    private void getUsePeriodFilter(Long costAccountId, Set<Long> periodTypeSet, TreeSet<Long> minSet, TreeSet<Long> maxSet) {
        QFilter periodfilter = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        DynamicObjectCollection cal_sysctrlentity = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"org.id orgid,entry.costaccount.id acctid,entry.calpolicy.periodtype periodtype,entry.startperiod.id startperiod,entry.currentperiod.id currentperiod", (QFilter[])periodfilter.toArray());
        if (cal_sysctrlentity.size() > 0) {
            DynamicObject periodDO = (DynamicObject)cal_sysctrlentity.get(0);
            periodTypeSet.add(periodDO.getLong("periodtype"));
            minSet.add(periodDO.getLong("startperiod"));
            maxSet.add(periodDO.getLong("currentperiod"));
        }
    }

    private boolean validateCostReductCalDimension(Set<Long> costAccIdSet, Object oldValue) {
        QFilter prdQFilter = new QFilter("costaccount", "in", costAccIdSet);
        DynamicObjectCollection resCol = QueryServiceHelper.query((String)"cad_sysparam", (String)"id,restoredimension,restorecalcrange", (QFilter[])prdQFilter.toArray());
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)resCol)) {
            Set<String> restoredimensionSet = resCol.stream().map(r -> r.getString("restoredimension")).collect(Collectors.toSet());
            Set restorecalcrangeSet = resCol.stream().map(r -> r.getString("restorecalcrange")).collect(Collectors.toSet());
            if (restoredimensionSet.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7684\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u7ef4\u5ea6\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CostReductionLevelRptPlugin_11", (String)"macc-sca-report", (Object[])new Object[0]));
                this.getModel().setValue("costaccountf", oldValue);
                this.getView().setVisible(Boolean.TRUE, new String[]{"prdorgf"});
                return true;
            }
            String[] array = restoredimensionSet.toArray(new String[0]);
            if (array.length == 1) {
                String str = array[0];
                MulBasedataEdit prdorg = (MulBasedataEdit)this.getControl("prdorgf");
                if ("B".equals(str)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"prdorgf"});
                    this.getPageCache().put("need_prdorg_cache", "Y");
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"prdorgf"});
                    this.getModel().setValue("prdorgf", null);
                    this.getPageCache().put("need_prdorg_cache", "N");
                }
            }
            boolean viewtransincost = false;
            boolean viewpurcost = false;
            for (String restorecalcrange : restorecalcrangeSet) {
                if (restorecalcrange.contains(SysParamEnum.RESTORECALCRANGE_TRANSDIRBILL.getValue())) {
                    viewtransincost = true;
                }
                if (!restorecalcrange.contains(SysParamEnum.RESTORECALCRANGE_PURINBILL.getValue())) continue;
                viewpurcost = true;
            }
            boolean allviewtransincost = true;
            for (String restorecalcrange : restorecalcrangeSet) {
                if (restorecalcrange.contains(SysParamEnum.RESTORECALCRANGE_TRANSDIRBILL.getValue())) continue;
                allviewtransincost = false;
                break;
            }
            if (allviewtransincost && "Y".equals(this.getPageCache().get("need_prdorg_cache"))) {
                this.getPageCache().put("need_storg_cache", "Y");
                this.getView().setVisible(Boolean.TRUE, new String[]{"storageorgunitf"});
            } else {
                this.getPageCache().put("need_storg_cache", "N");
                this.getView().setVisible(Boolean.FALSE, new String[]{"storageorgunitf"});
                this.getModel().setValue("storageorgunitf", null);
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"viewtransincost"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"viewpurcost"});
        }
        return false;
    }

    private boolean validateCurrencyWhenChooseCostAcc(Set<Long> costAccIdSet, Object oldValue) {
        QFilter qFilter = new QFilter("id", "in", costAccIdSet);
        DynamicObjectCollection calpolicyCol = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calpolicy", (QFilter[])new QFilter[]{qFilter});
        Set calpolicySet = calpolicyCol.stream().map(r -> r.getLong("calpolicy")).collect(Collectors.toSet());
        if (CadEmptyUtils.isEmpty(calpolicySet)) {
            return false;
        }
        DynamicObjectCollection currencyCol = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "in", calpolicySet)});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)currencyCol)) {
            return false;
        }
        Set currencySet = currencyCol.stream().map(r -> r.getLong("currency")).collect(Collectors.toSet());
        if (currencySet.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5e01\u522b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u5e01\u522b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionLevelRptPlugin_12", (String)"macc-sca-report", (Object[])new Object[0]));
            this.getModel().setValue("costaccountf", oldValue);
            return true;
        }
        return false;
    }

    private boolean validatePeriodTypeWhenChooseCostAcc(Set<Long> costAccIdSet, Object oldValue) {
        Set periodtypeSet;
        QFilter periodfilter = new QFilter("entry.costaccount", "in", costAccIdSet);
        DynamicObjectCollection cal_sysctrlentity = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"org.id orgid,entry.costaccount.id acctid,entry.calpolicy.periodtype periodtype,entry.startperiod.id startperiod,entry.currentperiod.id currentperiod", (QFilter[])periodfilter.toArray());
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)cal_sysctrlentity) && (periodtypeSet = cal_sysctrlentity.stream().map(r -> r.getLong("periodtype")).collect(Collectors.toSet())).size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u6838\u7b97\u671f\u95f4\u7c7b\u578b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionLevelRptPlugin_1", (String)"macc-sca-report", (Object[])new Object[0]));
            this.getModel().setValue("costaccountf", oldValue);
            return true;
        }
        return false;
    }
}

