/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.cost;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;

public class MaterialTypeFunction
extends ReduceGroupFunction {
    private RowMeta rowMeta;

    public MaterialTypeFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public Iterator<Object[]> reduce(Iterator<Row> iterator) {
        BigDecimal sumUnitAmt;
        BigDecimal unitAmt;
        BigDecimal sumPrice;
        ArrayList<Object[]> resultList = new ArrayList<Object[]>();
        BigDecimal headQty = BigDecimal.ZERO;
        BigDecimal perTotalQty = BigDecimal.ZERO;
        BigDecimal periodTotalQty = BigDecimal.ZERO;
        BigDecimal periodTotalAmt = BigDecimal.ZERO;
        BigDecimal yearPerQty = BigDecimal.ZERO;
        BigDecimal yearTotalQty = BigDecimal.ZERO;
        BigDecimal yearTotalAmt = BigDecimal.ZERO;
        long periodId = 0L;
        long material = 0L;
        String productName = "";
        String productModelNum = "";
        String elementName = "";
        String subElementName = "";
        long baseUnit = 0L;
        long currency = 0L;
        int level = 0;
        String materialType = "";
        boolean isFirst = true;
        while (iterator.hasNext()) {
            Row row = iterator.next();
            if (isFirst) {
                periodId = row.getLong(this.rowMeta.getFieldIndex("period"));
                material = row.getLong(this.rowMeta.getFieldIndex("material"));
                currency = row.getLong(this.rowMeta.getFieldIndex("currency"));
                productName = row.getString(this.rowMeta.getFieldIndex("productname"));
                productModelNum = row.getString(this.rowMeta.getFieldIndex("productmodelnum"));
                baseUnit = row.getLong(this.rowMeta.getFieldIndex("baseunit"));
                elementName = row.getString(this.rowMeta.getFieldIndex("elementname"));
                subElementName = row.getString(this.rowMeta.getFieldIndex("subelementname"));
                level = row.getInteger(this.rowMeta.getFieldIndex("level"));
                materialType = row.getString(this.rowMeta.getFieldIndex("entrymaterialtype"));
                headQty = row.getBigDecimal(this.rowMeta.getFieldIndex("headqty"));
                isFirst = false;
            }
            BigDecimal perQty = row.getBigDecimal(this.rowMeta.getFieldIndex("perqty"));
            perTotalQty = perTotalQty.add(perQty);
            BigDecimal qty = row.getBigDecimal(this.rowMeta.getFieldIndex("qty"));
            periodTotalQty = periodTotalQty.add(qty);
            BigDecimal amount = row.getBigDecimal(this.rowMeta.getFieldIndex("amount"));
            periodTotalAmt = periodTotalAmt.add(amount);
            BigDecimal sumPerQty = row.getBigDecimal(this.rowMeta.getFieldIndex("sumperqty"));
            yearPerQty = yearPerQty.add(sumPerQty);
            BigDecimal sumQty = row.getBigDecimal(this.rowMeta.getFieldIndex("sumqty"));
            yearTotalQty = yearTotalQty.add(sumQty);
            BigDecimal sumAmt = row.getBigDecimal(this.rowMeta.getFieldIndex("sumamt"));
            yearTotalAmt = yearTotalAmt.add(sumAmt);
        }
        BigDecimal price = this.isNullOrZero(periodTotalQty) ? BigDecimal.ZERO : periodTotalAmt.divide(periodTotalQty, 10, 4);
        BigDecimal bigDecimal = sumPrice = this.isNullOrZero(yearTotalQty) ? BigDecimal.ZERO : yearTotalAmt.divide(yearTotalQty, 10, 4);
        if (level == 0) {
            unitAmt = price;
            sumUnitAmt = sumPrice;
        } else {
            unitAmt = this.isNullOrZero(headQty) ? BigDecimal.ZERO : periodTotalAmt.divide(headQty, 10, 4);
            sumUnitAmt = this.isNullOrZero(headQty) ? BigDecimal.ZERO : yearTotalAmt.divide(headQty, 10, 4);
        }
        Object[] totalCountRowData = new Object[this.rowMeta.getFields().length];
        totalCountRowData[this.rowMeta.getFieldIndex((String)"period")] = periodId;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"material")] = material;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"currency")] = currency;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"productname")] = productName;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"productmodelnum")] = productModelNum;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"baseunit")] = baseUnit;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"elementname")] = elementName;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"subelementname")] = subElementName;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"level")] = level;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"linetype")] = "0";
        totalCountRowData[this.rowMeta.getFieldIndex((String)"isTop")] = 0;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"entrymaterialtype")] = materialType;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"perqty")] = perTotalQty;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"qty")] = periodTotalQty;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"curprice")] = price;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"curunitamt")] = unitAmt;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"amount")] = periodTotalAmt;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"sumperqty")] = yearPerQty;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"sumqty")] = yearTotalQty;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"sumprice")] = sumPrice;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"sumunitamt")] = sumUnitAmt;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"sumamt")] = yearTotalAmt;
        resultList.add(totalCountRowData);
        return resultList.iterator();
    }

    private boolean isNullOrZero(BigDecimal value) {
        return value == null || value.compareTo(BigDecimal.ZERO) == 0;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

