/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.cost;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;

public class SumRowFunction
extends GroupReduceFunction {
    private RowMeta rowMeta;

    public SumRowFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList<RowX> targetRows = new ArrayList<RowX>();
        BigDecimal periodTotalQty = BigDecimal.ZERO;
        BigDecimal periodTotalAmt = BigDecimal.ZERO;
        BigDecimal yearTotalQty = BigDecimal.ZERO;
        BigDecimal yearTotalAmt = BigDecimal.ZERO;
        Long currency = 0L;
        for (RowX rowX : iterable) {
            if (targetRows.size() < 1) {
                targetRows.add(rowX);
            }
            currency = rowX.getLong(this.getSourceRowMeta().getFieldIndex("currency"));
            BigDecimal qty = rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("qty"));
            periodTotalQty = periodTotalQty.add(qty);
            BigDecimal amount = rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("amount"));
            periodTotalAmt = periodTotalAmt.add(amount);
            BigDecimal sumQty = rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("sumqty"));
            yearTotalQty = yearTotalQty.add(sumQty);
            BigDecimal sumAmt = rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("sumamt"));
            yearTotalAmt = yearTotalAmt.add(sumAmt);
        }
        for (RowX row : targetRows) {
            row.set(this.rowMeta.getFieldIndex("level"), (Object)ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"SumRowFunction_0", (String)"macc-sca-report", (Object[])new Object[0]));
            row.set(this.rowMeta.getFieldIndex("linetype"), (Object)"1");
            row.set(this.rowMeta.getFieldIndex("currency"), (Object)currency);
            row.set(this.rowMeta.getFieldIndex("qty"), (Object)periodTotalQty);
            row.set(this.rowMeta.getFieldIndex("amount"), (Object)periodTotalAmt);
            row.set(this.rowMeta.getFieldIndex("sumqty"), (Object)yearTotalQty);
            row.set(this.rowMeta.getFieldIndex("sumamt"), (Object)yearTotalAmt);
            row.set(this.rowMeta.getFieldIndex("elementname"), (Object)"");
            row.set(this.rowMeta.getFieldIndex("subelementname"), (Object)"");
            row.set(this.rowMeta.getFieldIndex("entrymaterialtype"), (Object)"");
            row.set(this.rowMeta.getFieldIndex("material"), (Object)0L);
            row.set(this.rowMeta.getFieldIndex("productname"), (Object)"");
            row.set(this.rowMeta.getFieldIndex("productmodelnum"), (Object)"");
            row.set(this.rowMeta.getFieldIndex("materialver"), (Object)0L);
            row.set(this.rowMeta.getFieldIndex("submaterial"), (Object)0L);
            row.set(this.rowMeta.getFieldIndex("submaterialname"), (Object)"");
            row.set(this.rowMeta.getFieldIndex("subbaseunit"), (Object)0L);
            row.set(this.rowMeta.getFieldIndex("subelement"), (Object)0L);
            row.set(this.rowMeta.getFieldIndex("baseunit"), (Object)0L);
            row.set(this.rowMeta.getFieldIndex("element"), (Object)0L);
            row.set(this.rowMeta.getFieldIndex("headqty"), (Object)BigDecimal.ZERO);
            row.set(this.rowMeta.getFieldIndex("perqty"), (Object)BigDecimal.ZERO);
            row.set(this.rowMeta.getFieldIndex("curprice"), (Object)BigDecimal.ZERO);
            row.set(this.rowMeta.getFieldIndex("curunitamt"), (Object)BigDecimal.ZERO);
            row.set(this.rowMeta.getFieldIndex("transinperqty"), (Object)BigDecimal.ZERO);
            row.set(this.rowMeta.getFieldIndex("transinprice"), (Object)BigDecimal.ZERO);
            row.set(this.rowMeta.getFieldIndex("transinunitamt"), (Object)BigDecimal.ZERO);
            row.set(this.rowMeta.getFieldIndex("purperqty"), (Object)BigDecimal.ZERO);
            row.set(this.rowMeta.getFieldIndex("purprice"), (Object)BigDecimal.ZERO);
            row.set(this.rowMeta.getFieldIndex("purunitamt"), (Object)BigDecimal.ZERO);
            row.set(this.rowMeta.getFieldIndex("sumperqty"), (Object)BigDecimal.ZERO);
            row.set(this.rowMeta.getFieldIndex("sumprice"), (Object)BigDecimal.ZERO);
            row.set(this.rowMeta.getFieldIndex("sumunitamt"), (Object)BigDecimal.ZERO);
            collector.collect(row);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

