/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.costrecovry.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;

public class AddTotalRowFunction
extends ReduceGroupFunction {
    private static final long serialVersionUID = 1274486992033330176L;
    private RowMeta rowMeta;

    public AddTotalRowFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public Iterator<Object[]> reduce(Iterator<Row> iterator) {
        ArrayList<Object[]> resultList = new ArrayList<Object[]>();
        BigDecimal periodTotalQty = BigDecimal.ZERO;
        BigDecimal periodTotalAmt = BigDecimal.ZERO;
        BigDecimal yearTotalQty = BigDecimal.ZERO;
        BigDecimal yearTotalAmt = BigDecimal.ZERO;
        while (iterator.hasNext()) {
            Row row = iterator.next();
            BigDecimal qty = row.getBigDecimal(this.rowMeta.getFieldIndex("qty"));
            periodTotalQty = periodTotalQty.add(qty);
            BigDecimal amount = row.getBigDecimal(this.rowMeta.getFieldIndex("amount"));
            periodTotalAmt = periodTotalAmt.add(amount);
            BigDecimal sumQty = row.getBigDecimal(this.rowMeta.getFieldIndex("sumqty"));
            yearTotalQty = yearTotalQty.add(sumQty);
            BigDecimal sumAmt = row.getBigDecimal(this.rowMeta.getFieldIndex("sumamt"));
            yearTotalAmt = yearTotalAmt.add(sumAmt);
        }
        Object[] totalCountRowData = new Object[this.rowMeta.getFields().length];
        totalCountRowData[this.rowMeta.getFieldIndex((String)"period")] = 0L;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"elementname")] = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AddTotalRowFunction_1", (String)"macc-sca-report", (Object[])new Object[0]);
        totalCountRowData[this.rowMeta.getFieldIndex((String)"linetype")] = "2";
        totalCountRowData[this.rowMeta.getFieldIndex((String)"isTop")] = 1;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"qty")] = periodTotalQty;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"amount")] = periodTotalAmt;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"sumqty")] = yearTotalQty;
        totalCountRowData[this.rowMeta.getFieldIndex((String)"sumamt")] = yearTotalAmt;
        resultList.add(totalCountRowData);
        return resultList.iterator();
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

