/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.costrecovry.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PermissionHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.sca.common.helper.MatBaseDataFilterHelper;
import kd.macc.sca.report.costrecovry.item.CostReductionItemParam;

public class CostReductionItemFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbarap = (Toolbar)this.getControl("toolbarap");
        toolbarap.addItemClickListener((ItemClickListener)this);
        MulBasedataEdit costaccount = (MulBasedataEdit)this.getControl("mulcostaccount");
        costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit prdorg = (MulBasedataEdit)this.getControl("mulprdorg");
        prdorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit storageorgunit = (MulBasedataEdit)this.getControl("mulstorageorgunit");
        storageorgunit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit period = (MulBasedataEdit)this.getControl("mulperiod");
        period.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialgrpstd = (BasedataEdit)this.getControl("materialgrpstd");
        materialgrpstd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulmaterialtype = (MulBasedataEdit)this.getControl("mulmaterialtype");
        mulmaterialtype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulmaterial = (MulBasedataEdit)this.getControl("mulmaterial");
        mulmaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulproduct = (MulBasedataEdit)this.getControl("mulproduct");
        mulproduct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void initialize() {
        super.initialize();
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        String appId = AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView());
        filterInfo.addFilterItem("appnum", (Object)appId, "=");
        queryParam.setFilter(filterInfo);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("exportexcel".equals(itemKey)) {
            this.isHasPermission(evt, "4730fc9f000004ae");
        }
    }

    private void isHasPermission(BeforeItemClickEvent evt, String permItem) {
        List orgPermission = PermissionHelper.getUserPermOrgs((Long)RequestContext.getOrCreate().getCurrUserId(), (String)"sca_costreditemrpt", (String)permItem);
        if (orgPermission == null) {
            return;
        }
        if (orgPermission.isEmpty() || !orgPermission.contains(RequestContext.get().getOrgId())) {
            evt.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff01\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostReductionItemFormPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
        }
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        DynamicObjectCollection org = this.getModel().getDataEntity().getDynamicObjectCollection("mulorg");
        Set orgSet = null;
        switch (name) {
            case "mulorg": {
                List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                qFilters.add(new QFilter("id", "in", (Object)permAccountOrgIds));
                break;
            }
            case "mulcostaccount": {
                qFilters.add(this.getCostAccountF7QFilter(AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView())));
                break;
            }
            case "mulprdorg": {
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)org)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostReductionItemFormPlugin_1", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                orgSet = org.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                Iterator iterator = orgSet.iterator();
                HashSet prdOrgSet = new HashSet(4);
                while (iterator.hasNext()) {
                    Long orgId = (Long)iterator.next();
                    List productOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)orgId, (boolean)true);
                    prdOrgSet.addAll(productOrgs);
                }
                qFilters.add(new QFilter("id", "in", prdOrgSet));
                break;
            }
            case "mulstorageorgunit": {
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)org)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostReductionItemFormPlugin_1", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObjectCollection prdorg = this.getModel().getDataEntity().getDynamicObjectCollection("mulprdorg");
                orgSet = org.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                Set pdorgSet = prdorg.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                HashSet stOrgs = new HashSet();
                if (!CadEmptyUtils.isEmpty(pdorgSet)) {
                    for (Long pdorg : pdorgSet) {
                        List stOrglist = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)pdorg, (boolean)true);
                        stOrgs.addAll(stOrglist);
                    }
                } else {
                    for (Long orgId : orgSet) {
                        List stOrglist = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)orgId, (boolean)true);
                        stOrgs.addAll(stOrglist);
                    }
                }
                qFilters.add(new QFilter("id", "in", stOrgs));
                break;
            }
            case "mulperiod": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostReductionItemFormPlugin_1", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObjectCollection costaccount = this.getModel().getDataEntity().getDynamicObjectCollection("mulcostaccount");
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costaccount)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionItemFormPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                Iterator ite = costaccount.iterator();
                TreeSet<Long> minSet = new TreeSet<Long>();
                TreeSet<Long> maxSet = new TreeSet<Long>();
                HashSet<Long> periodTypeSet = new HashSet<Long>();
                while (ite.hasNext()) {
                    DynamicObject costAccId = (DynamicObject)ite.next();
                    this.getUsePeriodFilter(costAccId.getDynamicObject("fbasedataid").getLong("id"), periodTypeSet, minSet, maxSet);
                }
                if (periodTypeSet.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u6838\u7b97\u671f\u95f4\u7c7b\u578b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionItemFormPlugin_3", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter filters = new QFilter("periodtype", "in", periodTypeSet);
                filters.and(new QFilter("id", ">=", (Object)minSet.first()));
                filters.and(new QFilter("id", "<=", (Object)maxSet.last()));
                qFilters.add(filters);
                break;
            }
            case "mulproduct": {
                List orgIds = org.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                if (orgIds.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionItemFormPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter matOrgFilter = MatBaseDataFilterHelper.getBaseFilter(orgIds);
                qFilters.add(matOrgFilter);
                listShowParameter.setF7ClickByFilter(false);
                break;
            }
            case "materialgrpstd": {
                List createOrgIds = org.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, Boolean.TRUE});
                qFilters.add(new QFilter("id", "in", (Object)ids));
                break;
            }
            case "mulmaterialtype": {
                DynamicObject materialgrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd");
                if (materialgrpstd == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"CostReductionItemFormPlugin_4", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                List createOrgIds = org.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, materialgrpstd.getPkValue(), false});
                qFilters.add(serviceResponse);
                HashMap params = new HashMap(2);
                params.put("useOrgs", createOrgIds);
                listShowParameter.setCustomParams(params);
                listShowParameter.setCustomParam("groupStandard", materialgrpstd.getPkValue());
                listShowParameter.setF7ClickByFilter(false);
                break;
            }
            case "mulmaterial": {
                DynamicObject materialgrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd");
                if (materialgrpstd == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"CostReductionItemFormPlugin_4", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                List createOrgIds = org.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                HashMap params = new HashMap(2);
                params.put("useOrgs", createOrgIds);
                listShowParameter.setCustomParams(params);
                DynamicObjectCollection mulmaterialtype = (DynamicObjectCollection)this.getModel().getValue("mulmaterialtype");
                if (!CollectionUtils.isEmpty((Collection)mulmaterialtype) || materialgrpstd != null && materialgrpstd.getLong("id") != 730148448254487552L) {
                    qFilters.add(MaterialGroupHelper.getClassifiedMaterialIdFilter((DynamicObjectCollection)mulmaterialtype, (boolean)false, (DynamicObject)materialgrpstd));
                }
                listShowParameter.setF7ClickByFilter(false);
            }
        }
    }

    public void getUsePeriodFilter(Long costAccountId, Set<Long> periodTypeSet, TreeSet<Long> minSet, TreeSet<Long> maxSet) {
        QFilter periodfilter = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        DynamicObjectCollection cal_sysctrlentity = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"org.id orgid,entry.costaccount.id acctid,entry.calpolicy.periodtype periodtype,entry.startperiod.id startperiod,entry.currentperiod.id currentperiod", (QFilter[])periodfilter.toArray());
        if (!cal_sysctrlentity.isEmpty()) {
            DynamicObject periodDO = (DynamicObject)cal_sysctrlentity.get(0);
            periodTypeSet.add(periodDO.getLong("periodtype"));
            minSet.add(periodDO.getLong("startperiod"));
            maxSet.add(periodDO.getLong("currentperiod"));
        }
    }

    private QFilter getCostAccountF7QFilter(String appNum) {
        List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        QFilter orgFilter = new QFilter("org", "in", (Object)permAccountOrgIds);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter appnumFilter = new QFilter("appnum", "=", (Object)appNum);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, appnumFilter};
        DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filters);
        if (!costAccountIds.isEmpty()) {
            Set costAccountIdList = costAccountIds.stream().map(costAccount -> costAccount.getLong("costaccountid")).collect(Collectors.toSet());
            return new QFilter("id", "in", costAccountIdList);
        }
        return new QFilter("id", "=", (Object)0);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initData();
        this.getView().setVisible(Boolean.FALSE, new String[]{"mulstorageorgunit", "viewtransincost", "viewpurcost"});
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        DynamicObjectCollection costaccount = filter.getDynamicObjectCollection("mulcostaccount");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costaccount)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionItemFormPlugin_5", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObjectCollection org = filter.getDynamicObjectCollection("mulorg");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)org)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostReductionItemFormPlugin_6", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObject currency = filter.getDynamicObject("currency");
        if (currency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u7ef4\u62a4\u5e01\u79cd", (String)"CostReductionItemFormPlugin_19", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObjectCollection period = filter.getDynamicObjectCollection("mulperiod");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)period)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u671f\u95f4\u3002", (String)"CostReductionItemFormPlugin_8", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObjectCollection mulproduct = filter.getDynamicObjectCollection("mulproduct");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)mulproduct)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ea7\u54c1", (String)"CostReductionItemFormPlugin_9", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObject materialgrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd");
        if (materialgrpstd == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"CostReductionItemFormPlugin_10", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        CostReductionItemParam costReductionItemParam = this.buildCostReductionItemParam(this.getModel().getDataEntity(true));
        this.getQueryParam().getCustomParam().put(CostReductionItemParam.class.getName(), costReductionItemParam);
        return super.verifyQuery(queryParam);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"CostReductionItemFormPlugin_11", (String)"macc-sca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c\u8fd8\u539f\uff08\u5206\u9879\u67e5\u8be2\uff09", (String)"CostReductionItemFormPlugin_12", (String)"macc-sca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"sca_costreditemrpt", (IDataModel)this.getModel());
    }

    private void initData() {
        DynamicObjectCollection org = this.getModel().getDataEntity().getDynamicObjectCollection("mulorg");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)org)) {
            return;
        }
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (isaccount && permAccountOrgIds.contains(currentOrgId)) {
            Object[] orgCol = new Object[]{currentOrgId};
            this.getModel().setValue("mulorg", (Object)orgCol);
        }
        org = this.getModel().getDataEntity().getDynamicObjectCollection("mulorg");
        this.setCostAccount(org);
    }

    private void setCostAccount(DynamicObjectCollection org) {
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)org)) {
            this.getModel().setValue("mulcostaccount", null);
            this.getModel().setValue("mulperiod", null);
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObjectCollection costAccountCol = new DynamicObjectCollection();
        DynamicObject costAccount = this.getCostAccountByAccoutOrg(((DynamicObject)org.get(0)).getDynamicObject("fbasedataid").getLong("id"));
        if (costAccount != null) {
            costAccountCol.add((Object)costAccount);
            this.getModel().setValue("mulcostaccount", (Object)costAccountCol);
            HashSet<Long> costAccIdSet = new HashSet<Long>();
            costAccIdSet.add(costAccount.getLong("id"));
            this.validateCostReductCalDimension(costAccIdSet, null);
        } else {
            this.getModel().setValue("mulcostaccount", null);
            this.getModel().setValue("mulperiod", null);
            this.getModel().setValue("mulorg", null);
        }
        this.setCurrency();
        if (costAccount != null) {
            this.setPeriod();
        }
    }

    private DynamicObject getCostAccountByAccoutOrg(Long accountOrgId) {
        QFilter accountorgQF = new QFilter("org", "=", (Object)accountOrgId);
        QFilter enablestdtQF = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isinitaccountQF = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter appnumQF = new QFilter("appnum", "=", (Object)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
        Object[] result = BusinessDataServiceHelper.load((String)"sca_startstdcost", (String)"entryentity.costaccount,entryentity.costaccount.ismainaccount ismainaccount", (QFilter[])new QFilter[]{accountorgQF, enablestdtQF, isinitaccountQF, appnumQF}, (String)"entryentity.costaccount.ismainaccount desc,entryentity.costaccount.id desc");
        if (CadEmptyUtils.isEmpty((Object[])result)) {
            return null;
        }
        if (((DynamicObject)result[0].getDynamicObjectCollection("entryentity").get(0)).getBoolean("costaccount.ismainaccount") || result.length == 1) {
            return ((DynamicObject)result[0].getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("costaccount");
        }
        return null;
    }

    private void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection costaccount = dataEntity.getDynamicObjectCollection("mulcostaccount");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costaccount)) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObjectCollection calpolicyCol = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calpolicy", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)((DynamicObject)costaccount.get(0)).getDynamicObject("fbasedataid").getLong("id"))});
        Set calpolicySet = calpolicyCol.stream().map(r -> r.getLong("calpolicy")).collect(Collectors.toSet());
        if (CadEmptyUtils.isEmpty(calpolicySet)) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObjectCollection currencyCol = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "in", calpolicySet)});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)currencyCol)) {
            this.getModel().setValue("currency", null);
            return;
        }
        Set currencySet = currencyCol.stream().map(r -> r.getLong("currency")).collect(Collectors.toSet());
        if (CadEmptyUtils.isEmpty(currencySet)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u5e01\u522b\u7684\u6210\u672c\u8d26\u7c3f", (String)"CostReductionItemFormPlugin_20", (String)"macc-sca-report", (Object[])new Object[0]));
            return;
        }
        if (currencySet.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u5e01\u79cd\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionItemFormPlugin_13", (String)"macc-sca-report", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("currency", currencySet.toArray()[0]);
    }

    private void setPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection org = dataEntity.getDynamicObjectCollection("mulorg");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)org)) {
            return;
        }
        DynamicObjectCollection costAccount = dataEntity.getDynamicObjectCollection("mulcostaccount");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccount)) {
            this.getModel().setValue("mulperiod", null);
            this.getView().updateView("mulperiod");
            return;
        }
        Long orgId = ((DynamicObject)org.get(0)).getDynamicObject("fbasedataid").getLong("id");
        Long costAccountId = ((DynamicObject)costAccount.get(0)).getDynamicObject("fbasedataid").getLong("id");
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount});
        if (res != null) {
            Long currentperiod = res.getLong("currentperiod");
            Object[] objects = new Object[]{currentperiod};
            this.getModel().setValue("mulperiod", (Object)objects);
            this.getView().updateView("mulperiod");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyname = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (propertyname) {
            case "mulcostaccount": {
                if (newValue == null) {
                    this.getModel().setValue("mulperiod", null);
                }
                if (newValue instanceof DynamicObjectCollection) {
                    DynamicObjectCollection costAccountCol = (DynamicObjectCollection)newValue;
                    Set<Long> costAccIdSet = costAccountCol.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                    Set orgIdSet = costAccountCol.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("calorg.id")).collect(Collectors.toSet());
                    boolean b1 = this.validateCurrencyWhenChooseCostAcc(costAccIdSet, oldValue);
                    boolean b2 = this.validatePeriodTypeWhenChooseCostAcc(costAccIdSet, oldValue);
                    boolean b3 = this.validateCostReductCalDimension(costAccIdSet, oldValue);
                    if (!(b1 && b2 && b3)) {
                        if (oldValue instanceof DynamicObjectCollection) {
                            Set oldSet = ((DynamicObjectCollection)oldValue).stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                            oldSet.retainAll(costAccIdSet);
                            if (oldSet.size() == 0) {
                                this.getModel().setValue("mulperiod", null);
                                this.getModel().setValue("mulprdorg", null);
                                this.getModel().setValue("mulstorageorgunit", null);
                            }
                        }
                        this.getModel().setValue("mulorg", (Object)orgIdSet.toArray());
                        this.getView().updateView("mulorg");
                    }
                }
                this.setCurrency();
                this.setPeriod();
                break;
            }
            case "materialgrpstd": {
                this.getModel().setValue("mulmaterialtype", null);
                this.getModel().setValue("mulmaterial", null);
                break;
            }
            case "mulmaterialtype": {
                this.getModel().setValue("mulmaterial", null);
                break;
            }
            case "mulprdorg": {
                if ("Y".equals(this.getPageCache().get("need_storg_cache"))) {
                    List stOrglist;
                    DynamicObjectCollection prdorg = this.getModel().getDataEntity().getDynamicObjectCollection("mulprdorg");
                    List pdorgList = prdorg.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                    if (prdorg.size() == 1 && (stOrglist = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)((Long)pdorgList.get(0)), (boolean)true)).size() == 1) {
                        DynamicObjectCollection stCol = this.getModel().getDataEntity().getDynamicObjectCollection("mulstorageorgunit");
                        stCol.clear();
                        Map stOrgDynMap = BusinessDataServiceHelper.loadFromCache((Object[])stOrglist.toArray(), (String)"bos_org");
                        if (stOrgDynMap.size() > 0) {
                            DynamicObject obj = stCol.addNew();
                            obj.set("fbasedataid", stOrgDynMap.get(stOrglist.get(0)));
                            this.getView().updateView("mulstorageorgunit");
                            break;
                        }
                    }
                }
                this.getModel().setValue("mulstorageorgunit", null);
                this.getView().updateView("mulstorageorgunit");
                break;
            }
            case "mulstorageorgunit": {
                List stList;
                List pdOrglist;
                DynamicObjectCollection stCol = this.getModel().getDataEntity().getDynamicObjectCollection("mulstorageorgunit");
                DynamicObjectCollection prdorg = this.getModel().getDataEntity().getDynamicObjectCollection("mulprdorg");
                if (stCol.size() != 1 || prdorg.size() != 0 || (pdOrglist = OrgUnitServiceHelper.getAllToOrg((String)"05", (String)"04", (Long)((Long)(stList = stCol.stream().map(r -> r.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList())).get(0)), (boolean)true)).size() != 1) break;
                prdorg.clear();
                Map pdOrgDynMap = BusinessDataServiceHelper.loadFromCache((Object[])pdOrglist.toArray(), (String)"bos_org");
                if (pdOrgDynMap.size() <= 0) break;
                DynamicObject obj = stCol.addNew();
                obj.set("fbasedataid", pdOrgDynMap.get(pdOrglist.get(0)));
                this.getView().updateView("mulprdorg");
                break;
            }
        }
    }

    private boolean validateCostReductCalDimension(Set<Long> costAccIdSet, Object oldValue) {
        QFilter prdQFilter = new QFilter("costaccount", "in", costAccIdSet);
        DynamicObjectCollection resCol = QueryServiceHelper.query((String)"cad_sysparam", (String)"id,restoredimension,restorecalcrange", (QFilter[])prdQFilter.toArray());
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)resCol)) {
            Set<String> restoredimensionSet = resCol.stream().map(r -> r.getString("restoredimension")).collect(Collectors.toSet());
            Set restorecalcrangeSet = resCol.stream().map(r -> r.getString("restorecalcrange")).collect(Collectors.toSet());
            if (restoredimensionSet.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7684\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u7ef4\u5ea6\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CostReductionItemFormPlugin_14", (String)"macc-sca-report", (Object[])new Object[0]));
                this.getModel().setValue("mulcostaccount", oldValue);
                this.getView().setVisible(Boolean.TRUE, new String[]{"mulprdorg"});
                return true;
            }
            String[] array = restoredimensionSet.toArray(new String[0]);
            if (array.length == 1) {
                String str = array[0];
                if ("B".equals(str)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"mulprdorg"});
                    this.getPageCache().put("need_prdorg_cache", "Y");
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"mulprdorg"});
                    this.getModel().setValue("mulprdorg", null);
                    this.getPageCache().put("need_prdorg_cache", "N");
                }
            }
            boolean allviewtransincost = true;
            for (String restorecalcrange : restorecalcrangeSet) {
                if (restorecalcrange.contains(SysParamEnum.RESTORECALCRANGE_TRANSDIRBILL.getValue())) continue;
                allviewtransincost = false;
                break;
            }
            if (allviewtransincost && "Y".equals(this.getPageCache().get("need_prdorg_cache"))) {
                this.getPageCache().put("need_storg_cache", "Y");
            } else {
                this.getPageCache().put("need_storg_cache", "N");
                this.getView().setVisible(Boolean.FALSE, new String[]{"mulstorageorgunit"});
                this.getModel().setValue("mulstorageorgunit", null);
            }
        }
        return false;
    }

    private boolean validateCurrencyWhenChooseCostAcc(Set<Long> costAccIdSet, Object oldValue) {
        QFilter qFilter = new QFilter("id", "in", costAccIdSet);
        DynamicObjectCollection calpolicyCol = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calpolicy", (QFilter[])new QFilter[]{qFilter});
        Set calpolicySet = calpolicyCol.stream().map(r -> r.getLong("calpolicy")).collect(Collectors.toSet());
        if (CadEmptyUtils.isEmpty(calpolicySet)) {
            return false;
        }
        DynamicObjectCollection currencyCol = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "in", calpolicySet)});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)currencyCol)) {
            return false;
        }
        Set currencySet = currencyCol.stream().map(r -> r.getLong("currency")).collect(Collectors.toSet());
        if (currencySet != null && currencySet.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5e01\u522b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u5e01\u522b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionItemFormPlugin_15", (String)"macc-sca-report", (Object[])new Object[0]));
            this.getModel().setValue("mulcostaccount", oldValue);
            return true;
        }
        return false;
    }

    private boolean validatePeriodTypeWhenChooseCostAcc(Set<Long> costAccIdSet, Object oldValue) {
        Set periodtypeSet;
        QFilter periodfilter = new QFilter("entry.costaccount", "in", costAccIdSet);
        DynamicObjectCollection cal_sysctrlentity = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"org.id orgid,entry.costaccount.id acctid,entry.calpolicy.periodtype periodtype,entry.startperiod.id startperiod,entry.currentperiod.id currentperiod", (QFilter[])periodfilter.toArray());
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)cal_sysctrlentity) && (periodtypeSet = cal_sysctrlentity.stream().map(r -> r.getLong("periodtype")).collect(Collectors.toSet())) != null && periodtypeSet.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u6838\u7b97\u671f\u95f4\u7c7b\u578b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostReductionItemFormPlugin_3", (String)"macc-sca-report", (Object[])new Object[0]));
            this.getModel().setValue("mulcostaccount", oldValue);
            return true;
        }
        return false;
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        List columns = event.getColumns();
        boolean onlymaterialtype = this.getModel().getDataEntity().getBoolean("onlymaterialtype");
        boolean viewtransincost = this.getModel().getDataEntity().getBoolean("viewtransincost");
        boolean viewpurcost = this.getModel().getDataEntity().getBoolean("viewpurcost");
        for (AbstractReportColumn col : columns) {
            ReportColumn subcolRc;
            if (col instanceof ReportColumn) {
                ReportColumn reportColumn = (ReportColumn)col;
                String key = reportColumn.getFieldKey();
                if (!"material".equals(key) && !"materialbaseunit".equals(key) && !"materialname".equals(key) && !key.equals("submaterial") && !key.equals("submaterial_ref_name") && !key.contains("submaterial_ref_baseunit") && !key.contains("submaterialauxprop")) continue;
                reportColumn.setHide(onlymaterialtype);
                continue;
            }
            if (!(col instanceof ReportColumnGroup)) continue;
            ReportColumnGroup reportColumnGroup = (ReportColumnGroup)col;
            if ("entryfieldgroupaptransin".equals(reportColumnGroup.getFieldKey())) {
                for (AbstractReportColumn subcol : reportColumnGroup.getChildren()) {
                    subcolRc = (ReportColumn)subcol;
                    subcolRc.setHide(!viewtransincost);
                }
                continue;
            }
            if (!"entryfieldgroupappur".equals(reportColumnGroup.getFieldKey())) continue;
            for (AbstractReportColumn subcol : reportColumnGroup.getChildren()) {
                subcolRc = (ReportColumn)subcol;
                subcolRc.setHide(!viewpurcost);
            }
        }
    }

    private CostReductionItemParam buildCostReductionItemParam(DynamicObject dataEntity) {
        DynamicObjectCollection mulMaterialTypes;
        DynamicObjectCollection mulPeriod;
        CostReductionItemParam param = new CostReductionItemParam();
        this.setIds(dataEntity, param, "mulcostaccount");
        this.setIds(dataEntity, param, "mulorg");
        this.setIds(dataEntity, param, "mulprdorg");
        this.setIds(dataEntity, param, "mulstorageorgunit");
        DynamicObject currency = dataEntity.getDynamicObject("currency");
        if (currency != null) {
            param.setCurrencyId(currency.getLong("id"));
        }
        if (!(mulPeriod = dataEntity.getDynamicObjectCollection("mulperiod")).isEmpty()) {
            param.setMulPeriod(mulPeriod);
        }
        this.setIds(dataEntity, param, "mulproduct");
        DynamicObject materialGrpStd = dataEntity.getDynamicObject("materialgrpstd");
        if (materialGrpStd != null) {
            param.setMaterialGrpStd(materialGrpStd);
        }
        if (!(mulMaterialTypes = dataEntity.getDynamicObjectCollection("mulmaterialtype")).isEmpty()) {
            param.setMulMaterialTypes(mulMaterialTypes);
        }
        this.setIds(dataEntity, param, "mulmaterial");
        param.setOlnySumRow(dataEntity.getBoolean("onlysumrow"));
        param.setOnlyMaterialType(dataEntity.getBoolean("onlymaterialtype"));
        param.setTopSumRow(dataEntity.getBoolean("topsumrow"));
        param.setViewTransinCost(dataEntity.getBoolean("viewtransincost"));
        param.setViewPurCost(dataEntity.getBoolean("viewpurcost"));
        return param;
    }

    private void setIds(DynamicObject dataEntity, CostReductionItemParam param, String key) {
        DynamicObjectCollection dys = dataEntity.getDynamicObjectCollection(key);
        ArrayList<Long> ids = new ArrayList<Long>(dys.size());
        dys.forEach(p -> ids.add(p.getDynamicObject("fbasedataid").getLong("id")));
        if (ids.isEmpty()) {
            return;
        }
        switch (key) {
            case "mulcostaccount": {
                param.setCostAccountIds(ids);
                break;
            }
            case "mulorg": {
                param.setOrgIds(ids);
                break;
            }
            case "mulprdorg": {
                param.setPrdOrgIds(ids);
                break;
            }
            case "mulstorageorgunit": {
                param.setStorageOrgUnitIds(ids);
                break;
            }
            case "mulproduct": {
                param.setMulProductIds(ids);
                break;
            }
            case "mulmaterial": {
                param.setMulMaterialIds(ids);
                break;
            }
        }
    }
}

