/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.costrecovry.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.macc.sca.report.costrecovry.item.CostReductionItemParam;

public class CostReductionItemFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 2232400386910032900L;

    public CostReductionItemFunction(CostReductionItemParam args) {
    }

    public RowMeta getResultRowMeta() {
        return this.getSourceRowMeta();
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList<RowX> targetRows = new ArrayList<RowX>();
        BigDecimal headQty = BigDecimal.ZERO;
        BigDecimal headTotalAmt = BigDecimal.ZERO;
        Long material = 0L;
        boolean isZeroLevel = false;
        String materialName = ResManager.loadKDString((String)"\u7269\u6599", (String)"CostReductionItemFunction_0", (String)"macc-sca-report", (Object[])new Object[0]);
        String productName = ResManager.loadKDString((String)"\u4ea7\u54c1\u7ea7", (String)"CostReductionItemFunction_1", (String)"macc-sca-report", (Object[])new Object[0]);
        for (RowX row : iterable) {
            BigDecimal curUnitAmt;
            BigDecimal perQty;
            BigDecimal curPrice;
            Integer level = row.getInteger(this.getSourceRowMeta().getFieldIndex("level"));
            material = row.getLong(this.getSourceRowMeta().getFieldIndex("material"));
            BigDecimal curAmt = row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("amount"));
            BigDecimal curQty = row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("qty"));
            headQty = row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("headqty"));
            headTotalAmt = row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("headtotalamt"));
            boolean isCurQtyZero = this.isNullOrZero(curQty);
            boolean isHeadQtyZero = this.isNullOrZero(headQty);
            boolean isHeadTotalAmtZero = this.isNullOrZero(headTotalAmt);
            BigDecimal bigDecimal = curPrice = isCurQtyZero ? BigDecimal.ZERO : curAmt.divide(curQty, 10, 4);
            if (level == 0) {
                isZeroLevel = true;
                perQty = isHeadQtyZero && isHeadTotalAmtZero ? BigDecimal.ZERO : BigDecimal.ONE;
                curUnitAmt = curPrice;
                row.set(this.getSourceRowMeta().getFieldIndex("elementname"), (Object)materialName);
                row.set(this.getSourceRowMeta().getFieldIndex("subelementname"), (Object)productName);
            } else {
                perQty = isHeadQtyZero ? BigDecimal.ZERO : (isCurQtyZero ? BigDecimal.ZERO : curQty.divide(headQty, 10, 4));
                curUnitAmt = isHeadQtyZero ? BigDecimal.ZERO : curAmt.divide(headQty, 10, 4);
            }
            row.set(this.getSourceRowMeta().getFieldIndex("perqty"), (Object)perQty);
            row.set(this.getSourceRowMeta().getFieldIndex("curprice"), (Object)curPrice);
            row.set(this.getSourceRowMeta().getFieldIndex("curunitamt"), (Object)curUnitAmt);
            targetRows.add(row);
        }
        if (!isZeroLevel && !targetRows.isEmpty()) {
            RowX zeroRow = new RowX(this.getSourceRowMeta().getFieldCount());
            for (int i = 0; i < this.getSourceRowMeta().getFieldCount(); ++i) {
                zeroRow.set(i, ((RowX)targetRows.get(0)).get(i));
            }
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("level"), (Object)0);
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("submaterial"), (Object)material);
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("perqty"), (Object)(this.isNullOrZero(headQty) && this.isNullOrZero(headTotalAmt) ? BigDecimal.ZERO : BigDecimal.ONE));
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("qty"), (Object)headQty);
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("amount"), (Object)headTotalAmt);
            BigDecimal curPrice = this.isNullOrZero(headQty) ? BigDecimal.ZERO : headTotalAmt.divide(headQty, 10, 4);
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("curprice"), (Object)curPrice);
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("curunitamt"), (Object)curPrice);
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("elementname"), (Object)materialName);
            zeroRow.set(this.getSourceRowMeta().getFieldIndex("subelementname"), (Object)productName);
            targetRows.add(zeroRow);
        }
        for (RowX rowX : targetRows) {
            collector.collect(rowX);
        }
    }

    private boolean isNullOrZero(BigDecimal value) {
        return value == null || value.compareTo(BigDecimal.ZERO) == 0;
    }
}

