/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.costrecovry.item;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.sca.report.costrecovry.item.CostReductionItemFunction;
import kd.macc.sca.report.costrecovry.item.CostReductionItemParam;
import kd.macc.sca.report.costrecovry.item.CostReductionItemPeriodYearFunction;
import org.apache.commons.lang.StringUtils;

public class HandleFinalRow
implements IDataXTransform {
    private static final String selectFields = "period,periodyear,material,materialver,currency,level,element,subelementname,subelement,submaterial,subbaseunit,headqty,headtotalamt,perqty,qty,curprice,curunitamt,amount";
    private ReportDataCtx ctx;
    private CostReductionItemParam costReductionItemParam;

    public HandleFinalRow(CostReductionItemParam costReductionItemParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.costReductionItemParam = costReductionItemParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        List<String> selectFieldsList = Arrays.asList(selectFields.split(","));
        StringBuilder mainSelectFields = new StringBuilder();
        mainSelectFields.append(selectFields);
        Set<String> showKeyCols = this.costReductionItemParam.getShowKeyCols();
        for (String keyCol : showKeyCols) {
            if (selectFieldsList.contains(keyCol)) continue;
            mainSelectFields.append(",").append(keyCol);
        }
        DataSetX allPeriodData = null;
        String[] selectFieldsArr = mainSelectFields.toString().split(",");
        DynamicObjectCollection periods = this.costReductionItemParam.getMulPeriod();
        HashSet periodIds = new HashSet(16);
        periods.forEach(s -> periodIds.add(s.getDynamicObject("fbasedataid").getLong("id")));
        QFilter idQFilter = new QFilter("id", "in", periodIds);
        OrmInput ormInput = new OrmInput("HandleFinalRow", "bd_period", "id,periodyear", idQFilter.toArray());
        DataSetX periodYear = this.ctx.getCurrentJob().fromInput((Input)ormInput);
        srcData = srcData.leftJoin(periodYear).on("period", "id").select(srcData.getRowMeta().getFieldNames(), new String[]{"periodyear"});
        DataSetX selectPeriodData = srcData.filter("period in(" + StringUtils.join(periodIds, (String)",") + ")");
        selectPeriodData = selectPeriodData.groupBy(new String[]{"period", "material", "materialver"}).reduceGroup((GroupReduceFunction)new CostReductionItemFunction(this.costReductionItemParam));
        for (DynamicObject period : periods) {
            selectPeriodData = selectPeriodData.filter("period = " + period.getDynamicObject("fbasedataid").getLong("id"));
            DataSetX yearData = selectPeriodData.filter("periodyear = " + period.getDynamicObject("fbasedataid").getInt("periodyear")).addFields(new Field[]{new Field("currentperiod", (DataType)DataType.LongType)}, new Object[]{period.getDynamicObject("fbasedataid").getLong("id")});
            yearData = yearData.groupBy(new String[]{"material", "materialver", "currency", "level", "element", "subelement", "submaterial", "subbaseunit", "currentperiod"}).sum("headqty").sum("perqty").sum("qty").sum("amount").sum("sumperqty").sum("sumqty").sum("sumprice").sum("sumunitamt").sum("sumamt");
            yearData = yearData.map((MapFunction)new CostReductionItemPeriodYearFunction(yearData.getRowMeta(), this.costReductionItemParam));
            selectPeriodData = selectPeriodData.leftJoin(yearData).on("period", "currentperiod").on("material", "material").on("materialver", "materialver").on("currency", "currency").on("level", "level").on("element", "element").on("subelement", "subelement").on("submaterial", "submaterial").on("subbaseunit", "subbaseunit").select(selectFieldsArr, new String[]{"sumperqty", "sumqty", "sumprice", "sumunitamt", "sumamt"});
            selectPeriodData = selectPeriodData.map(new MapFunction(){

                public RowX map(RowX rowX) {
                    return rowX;
                }

                public RowMeta getResultRowMeta() {
                    return this.sourceRowMeta;
                }
            });
            if (allPeriodData == null) {
                allPeriodData = selectPeriodData;
                continue;
            }
            allPeriodData = HandleFinalRow.union(allPeriodData, selectPeriodData);
        }
        return allPeriodData;
    }

    private static DataSetX union(DataSetX dataSet1, DataSetX dataSet2) {
        dataSet2 = dataSet2.select(dataSet1.getRowMeta().getFieldNames());
        dataSet1 = dataSet1.union(dataSet2);
        return dataSet1;
    }
}

