/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class ScaRptHelper {
    public static String getManuFactureFields() {
        StringJoiner headField = new StringJoiner(",");
        headField.add("org as prodorg");
        headField.add("billno as manubill");
        headField.add("transactiontype as transactiontype");
        headField.add("billstatus as billstatus");
        StringJoiner entryField = new StringJoiner(",");
        entryField.add("treeentryentity.seq as manuentryseq");
        entryField.add("treeentryentity.material as material");
        entryField.add("treeentryentity.unit as unit");
        entryField.add("treeentryentity.qty as qty");
        entryField.add("treeentryentity.planstatus as planstatus");
        entryField.add("treeentryentity.taskstatus as entrytaskstatus");
        entryField.add("treeentryentity.bizstatus as bizstatus");
        entryField.add("treeentryentity.stockqty as inbillqty");
        entryField.add("treeentryentity.qty - treeentryentity.stockqty as surplusqty");
        entryField.add("treeentryentity.beginbookdate as transmittime");
        entryField.add("treeentryentity.startworktime as startworktime");
        entryField.add("treeentryentity.endworktime as endworktime");
        entryField.add("treeentryentity.closetime as closetime");
        entryField.add("treeentryentity.configuredcode as configuredcode");
        entryField.add("treeentryentity.tracknumber as tracknumber");
        return headField.merge(entryField).toString();
    }

    public static String getMatAllocFields() {
        StringJoiner headField = new StringJoiner(",");
        headField.add("'TL' as tradetype");
        headField.add("'' as applybillno");
        headField.add("billno as tradebillno");
        headField.add("bizdate as bookdate");
        headField.add("material as trademateriel");
        headField.add("0 as resource");
        headField.add("0 as productcost");
        headField.add("0 as updatedcost");
        headField.add("'' as difftype");
        headField.add("useqty as tradeqty");
        headField.add("baseunit as tradebaseunit");
        headField.add("manuorg");
        StringJoiner entryField = new StringJoiner(",");
        entryField.add("entryentity.costobejctentry.auxpty as auxpty");
        entryField.add("entryentity.costobejctentry.tracknumber as tracknumber");
        entryField.add("entryentity.costobejctentry.projectnumber as projectnumber");
        entryField.add("entryentity.costobejctentry.lot as lot");
        entryField.add("entryentity.costobejctentry.configuredcode as configuredcode");
        entryField.add("entryentity.costobejctentry.material as product");
        entryField.add("entryentity.costobejctentry.srcbillnumber as manubill");
        entryField.add("entryentity.costobejctentry.srcbillrow as manuentryseq");
        return headField.merge(entryField).toString();
    }

    public static String getFactnedOutPutEntryCostFields() {
        StringJoiner headField = new StringJoiner(",");
        headField.add("'WG' as tradetype");
        headField.add("billno as tradebillno");
        headField.add("bizdate as bookdate");
        headField.add("material as trademateriel");
        headField.add("completeqty as tradeqty");
        headField.add("baseunit as tradebaseunit");
        headField.add("0 as resource");
        headField.add("0 as productcost");
        headField.add("0 as updatedcost");
        headField.add("'' as difftype");
        StringJoiner entryField = new StringJoiner(",");
        entryField.add("entrycost.subelement as subelement");
        entryField.add("entrycost.stdprice as stdprice");
        return headField.merge(entryField).toString();
    }

    public static String getFactnedOutPutEntryentityFields() {
        StringJoiner headField = new StringJoiner(",");
        headField.add("billno as tradebillno");
        StringJoiner entryField = new StringJoiner(",");
        entryField.add("entryentity.qty as qty");
        entryField.add("entryentity.costobject.srcbillnumber as manubill");
        entryField.add("entryentity.costobject.srcbillrow as manuentryseq");
        return headField.merge(entryField).toString();
    }

    public static List<QFilter> getFactnedOutPutFilters(FilterInfo filterInfo) {
        DynamicObjectCollection querymaterial;
        DynamicObject org;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject period = filterInfo.getDynamicObject("period");
        if (period != null) {
            Date begindate = period.getDate("begindate");
            Date enddate = period.getDate("enddate");
            if (begindate != null) {
                filters.add(new QFilter("bizdate", ">=", (Object)begindate));
            }
            if (enddate != null) {
                filters.add(new QFilter("bizdate", "<=", (Object)enddate));
            }
        }
        if ((org = filterInfo.getDynamicObject("org")) != null) {
            filters.add(new QFilter("org", "=", org.getPkValue()));
        }
        if ((querymaterial = filterInfo.getDynamicObjectCollection("querymaterial")) != null && querymaterial.size() > 0) {
            filters.add(new QFilter("material", "in", querymaterial.stream().map(a -> a.getPkValue()).collect(Collectors.toList())));
        }
        return filters;
    }

    public static List<QFilter> getMatAllocFilters(FilterInfo filterInfo) {
        DynamicObjectCollection querymaterial;
        String pombillno;
        DynamicObject costAccount;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject period = filterInfo.getDynamicObject("period");
        if (period != null) {
            filters.add(new QFilter("period", "=", period.getPkValue()));
        }
        if ((costAccount = filterInfo.getDynamicObject("costaccount")) != null) {
            filters.add(new QFilter("costaccount", "=", costAccount.getPkValue()));
        }
        if (StringUtils.isNotEmpty((String)(pombillno = filterInfo.getString("pombillno")))) {
            filters.add(new QFilter("entryentity.costobejctentry.srcbillnumber", "in", (Object)pombillno.split(";")));
        }
        if ((querymaterial = filterInfo.getDynamicObjectCollection("querymaterial")) != null && querymaterial.size() > 0) {
            filters.add(new QFilter("entryentity.costobejctentry.material", "in", querymaterial.stream().map(a -> a.getPkValue()).collect(Collectors.toList())));
        }
        return filters;
    }

    public static QFilter[] getResAbsorbBillFilters(FilterInfo filterInfo) {
        DynamicObjectCollection querymaterial;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject org = filterInfo.getDynamicObject("org");
        filters.add(new QFilter("org", "=", org.getPkValue()));
        DynamicObject period = filterInfo.getDynamicObject("period");
        filters.add(new QFilter("period", "=", period.getPkValue()));
        DynamicObject costaccount = filterInfo.getDynamicObject("costaccount");
        filters.add(new QFilter("costaccount", "=", costaccount.getPkValue()));
        String pombillno = filterInfo.getString("pombillno");
        if (StringUtils.isNotEmpty((String)pombillno)) {
            filters.add(new QFilter("costobject.srcbillnumber", "in", (Object)pombillno.split(";")));
        }
        if ((querymaterial = filterInfo.getDynamicObjectCollection("querymaterial")) != null && querymaterial.size() > 0) {
            filters.add(new QFilter("costobject.material", "in", querymaterial.stream().map(a -> a.getPkValue()).collect(Collectors.toList())));
        }
        return filters.toArray(new QFilter[filters.size()]);
    }

    public static String getResAbsorbBillFields() {
        StringJoiner fields = new StringJoiner(",");
        fields.add("'BG' as tradetype");
        fields.add("costobject.srcbillnumber as manubill");
        fields.add("costobject.srcbillrow as manuentryseq");
        fields.add("billno as tradebillno");
        fields.add("bizdate as bookdate");
        fields.add("0 as trademateriel");
        fields.add("resource as resource");
        fields.add("entryentity.qty as tradeqty");
        fields.add("0 as tradebaseunit");
        fields.add("entryentity.subelement as subelement");
        fields.add("entryentity.amount as amount");
        fields.add("0 as productcost");
        fields.add("0 as updatedcost");
        fields.add("'' as difftype");
        fields.add("'' as applybillno");
        return fields.toString();
    }

    public static QFilter[] getCosChangeBillFilters(FilterInfo filterInfo) {
        DynamicObjectCollection querymaterial;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject org = filterInfo.getDynamicObject("org");
        filters.add(new QFilter("productentry.org", "=", org.getPkValue()));
        DynamicObject period = filterInfo.getDynamicObject("period");
        filters.add(new QFilter("productentry.period", "=", period.getPkValue()));
        DynamicObject costaccount = filterInfo.getDynamicObject("costaccount");
        filters.add(new QFilter("productentry.costaccountbook", "=", costaccount.getPkValue()));
        String pombillno = filterInfo.getString("pombillno");
        if (StringUtils.isNotEmpty((String)pombillno)) {
            filters.add(new QFilter("productentry.costobject.srcbillnumber", "in", (Object)pombillno.split(";")));
        }
        if ((querymaterial = filterInfo.getDynamicObjectCollection("querymaterial")) != null && querymaterial.size() > 0) {
            filters.add(new QFilter("productentry.costobject.material", "in", querymaterial.stream().map(a -> a.getPkValue()).collect(Collectors.toList())));
        }
        filters.add(new QFilter("productentry.updatediff", "<", (Object)0).or(new QFilter("productentry.updatediff", ">", (Object)1.0E-6)));
        return filters.toArray(new QFilter[filters.size()]);
    }

    public static String getCosChangeBillFields() {
        StringJoiner fields = new StringJoiner(",");
        fields.add("id as id");
        fields.add("'GX' as tradetype");
        fields.add("productentry.costobject.srcbillnumber as manubill");
        fields.add("productentry.costobject.srcbillrow as manuentryseq");
        fields.add("billno as tradebillno");
        fields.add("effecttime as bookdate");
        fields.add("productentry.prosubmaterial as trademateriel");
        fields.add("productentry.resource as resource");
        fields.add("0 as tradeqty");
        fields.add("0 as tradebaseunit");
        fields.add("productentry.procsubelement as subelement");
        fields.add("productentry.updatediff as amount");
        fields.add("productentry.productcost as productcost");
        fields.add("productentry.updatedcost as updatedcost");
        fields.add("'' as difftype");
        return fields.toString();
    }

    public static String getUpdateDiffCosChangeFields() {
        StringJoiner fields = new StringJoiner(",");
        fields.add("'GX' as tradetype");
        fields.add("productentry.costobject.srcbillnumber as manubill");
        fields.add("productentry.costobject.srcbillrow as manuentryseq");
        fields.add("billno as tradebillno");
        fields.add("effecttime as bookdate");
        fields.add("productentry.prosubmaterial as trademateriel");
        fields.add("productentry.resource as resource");
        fields.add("0 as tradeqty");
        fields.add("0 as tradebaseunit");
        fields.add("productentry.procsubelement as subelement");
        fields.add("productentry.updatediff as amount");
        fields.add("productentry.productcost as productcost");
        fields.add("productentry.updatedcost as updatedcost");
        fields.add("case when productentry.productcost=0 then 0 else (productentry.updatediff / productentry.productcost)*100 end as deviation");
        fields.add("productentry.costcenter as costcenter");
        fields.add("productentry.costobject as costobject");
        fields.add("id as id");
        return fields.toString();
    }

    public static QFilter[] getFinishDiffBillFilters(FilterInfo filterInfo) {
        DynamicObjectCollection querymaterial;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject org = filterInfo.getDynamicObject("org");
        filters.add(new QFilter("org", "=", org.getPkValue()));
        DynamicObject period = filterInfo.getDynamicObject("period");
        filters.add(new QFilter("period", "=", period.getPkValue()));
        DynamicObject costaccount = filterInfo.getDynamicObject("costaccount");
        filters.add(new QFilter("costaccount", "=", costaccount.getPkValue()));
        String pombillno = filterInfo.getString("pombillno");
        if (StringUtils.isNotEmpty((String)pombillno)) {
            filters.add(new QFilter("costobject.srcbillnumber", "in", (Object)pombillno.split(";")));
        }
        if ((querymaterial = filterInfo.getDynamicObjectCollection("querymaterial")) != null && querymaterial.size() > 0) {
            filters.add(new QFilter("costobject.material", "in", querymaterial.stream().map(a -> a.getPkValue()).collect(Collectors.toList())));
        }
        return filters.toArray(new QFilter[filters.size()]);
    }

    public static String getFinishDiffBillFields() {
        StringJoiner fields = new StringJoiner(",");
        fields.add("'GB' as tradetype");
        fields.add("costobject.srcbillnumber as manubill");
        fields.add("costobject.srcbillrow as manuentryseq");
        fields.add("billno as tradebillno");
        fields.add("auditdate as bookdate");
        fields.add("0 as trademateriel");
        fields.add("0 as resource");
        fields.add("0 as tradeqty");
        fields.add("0 as tradebaseunit");
        fields.add("entryentity.subelement as subelement");
        fields.add("entryentity.amount as amount");
        fields.add("0 as productcost");
        fields.add("0 as updatedcost");
        fields.add("entryentity.difftype as difftype");
        fields.add("'' as applybillno");
        return fields.toString();
    }
}

