/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.reduction;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algox.DataSetX;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.DataSetXHelper;
import kd.macc.sca.report.common.ReportRptHelper;
import kd.macc.sca.report.reduction.CostAnalyzeRptParam;
import org.apache.commons.lang.StringUtils;

public class CostAnalyzePeriodUnionHandle
implements IDataXTransform {
    private CostAnalyzeRptParam rptParam = null;
    private ReportDataCtx ctx;

    public CostAnalyzePeriodUnionHandle(CostAnalyzeRptParam reportParam, ReportDataCtx ctx) {
        this.rptParam = reportParam;
        this.ctx = ctx;
    }

    public DataSetX doTransform(DataSetX srcData) {
        if (this.rptParam.isOnlysumrow()) {
            srcData = srcData.filter("level=0");
        }
        DataSetX curPeriodDataSetX = srcData.filter("period = " + this.rptParam.getPeriodId() + "");
        HashSet groupCols = new HashSet(16);
        Set showKeyCols = this.ctx.getShowKeyCols();
        groupCols.addAll(showKeyCols);
        groupCols.remove("period");
        String[] keyCols = groupCols.toArray(new String[groupCols.size()]);
        ArrayList<String> needAddAmtFields = new ArrayList<String>(10);
        if (this.rptParam.isViewpreperiod()) {
            curPeriodDataSetX = this.getPeriodData("pre", curPeriodDataSetX, srcData, keyCols, needAddAmtFields);
        }
        if (this.rptParam.isViewpreyear()) {
            curPeriodDataSetX = this.getPeriodData("preyear", curPeriodDataSetX, srcData, keyCols, needAddAmtFields);
        }
        if (this.rptParam.isViewtotal()) {
            if (this.rptParam.isViewpreyear()) {
                curPeriodDataSetX = this.getPeriodData("preyearall", curPeriodDataSetX, srcData, keyCols, needAddAmtFields);
            }
            curPeriodDataSetX = this.getPeriodData("curyearall", curPeriodDataSetX, srcData, keyCols, needAddAmtFields);
        }
        if (!needAddAmtFields.isEmpty()) {
            curPeriodDataSetX = DataSetXHelper.addBigDecimalFields((DataSetX)curPeriodDataSetX, (String[])needAddAmtFields.toArray(new String[0]));
        }
        return ReportRptHelper.groupDeal(curPeriodDataSetX, showKeyCols.toArray(new String[0]), 1, this.ctx.getShowQtyCols().toArray(new String[0]));
    }

    private DataSetX getPeriodData(String keyPre, DataSetX curPeriodDataSetX, DataSetX srcData, String[] keyCols, List<String> needAddAmtFields) {
        String qtyFiled = keyPre + "sumqty";
        String amtFiled = keyPre + "sumamt";
        this.ctx.getShowQtyCols().add(qtyFiled);
        this.ctx.getShowQtyCols().add(amtFiled);
        List<Long> periodIds = this.rptParam.getPeriodYearMap().get(keyPre);
        if (!CadEmptyUtils.isEmpty(periodIds)) {
            DataSetX yearPeriodTempX = srcData.filter("period in (" + StringUtils.join((Object[])periodIds.toArray(), (char)',') + ")").groupBy(keyCols).sum("cursumqty", qtyFiled).sum("cursumamt", amtFiled);
            yearPeriodTempX = yearPeriodTempX.addFields(new Field[]{new Field("period", (DataType)DataType.LongType)}, new Object[]{this.rptParam.getPeriodId()});
            curPeriodDataSetX = DataSetXHelper.addBigDecimalFields((DataSetX)curPeriodDataSetX, (String[])new String[]{qtyFiled, amtFiled});
            curPeriodDataSetX = DataSetXHelper.unionIfRowDiff((DataSetX)curPeriodDataSetX, (DataSetX)yearPeriodTempX);
        } else {
            needAddAmtFields.add(qtyFiled);
            needAddAmtFields.add(amtFiled);
        }
        return curPeriodDataSetX;
    }
}

