/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.reduction;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.report.reduction.CostAnalyzeDataGroupHandle;
import kd.macc.sca.report.reduction.CostAnalyzePeriodUnionHandle;
import kd.macc.sca.report.reduction.CostAnalyzeRptParam;
import kd.macc.sca.report.reduction.CostAnalyzeStdUnionHandle;

public class CostAnalyzeRptSourceCf
implements IReportDataHandle {
    private final Log logger = LogFactory.getLog(CostAnalyzeRptSourceCf.class);
    public static final List<String> materialFields = Lists.newArrayList((Object[])new String[]{"submaterial", "submaterialnum", "treepath"});
    public static final List<String> groupFields = Lists.newArrayList((Object[])new String[]{"materialgroup", "materialgroupnum"});
    public static final List<String> elementFields = Lists.newArrayList((Object[])new String[]{"element", "elementnum"});
    public static final List<String> subelementFields = Lists.newArrayList((Object[])new String[]{"subelement", "subelementnum"});
    public static final String AUXFIELD = "auxprop";
    public static final List<String> actFields = Lists.newArrayList((Object[])new String[]{"sumqty", "sumamt"});
    public static final List<String> calcFields = Lists.newArrayList((Object[])new String[]{"qty", "price", "unitamt"});
    public static final List<String> stdFields = Lists.newArrayList((Object[])new String[]{"stdqty", "stdprice", "stdunitamt"});
    public static final String CUR_PRE = "cur";
    public static final String PREPERIOD_PRE = "pre";
    public static final String PREYEAR_PRE = "preyear";
    public static final String CURYEARALL_PRE = "curyearall";
    public static final String PREYEARALL_PRE = "preyearall";
    private CostAnalyzeRptParam rptParam = null;

    public void setupCtx(ReportDataCtx ctx) {
        super.setupCtx(ctx);
        this.logger.info("CostAnalyzeRptSourceCf-\u5f00\u59cb\u8bbe\u7f6e\u4e0a\u4e0b\u6587");
        this.rptParam = (CostAnalyzeRptParam)ctx.getParam(CostAnalyzeRptParam.class.getName());
        ctx.setShowBlockEntity(false);
        this.dealQueryPeriodRange(this.rptParam);
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getFixedFilter(this.rptParam));
        } else {
            fixedFs.addAll(this.getFixedFilter(this.rptParam));
        }
        ctx.getShowKeyCols().add("period");
        if (this.rptParam.isShowProdOrg()) {
            ctx.getShowKeyCols().add("manuorg");
        }
        this.logger.info("CostAnalyzeRptSourceCf-\u7ed3\u675f\u8bbe\u7f6e\u4e0a\u4e0b\u6587");
    }

    private void dealQueryPeriodRange(CostAnalyzeRptParam rptParam) {
        List<Long> periodIds;
        DynamicObject prePeriodDyn;
        rptParam.getPeriodYearMap().put(CUR_PRE, Collections.singletonList(rptParam.getPeriodId()));
        if (rptParam.isViewpreperiod() && (prePeriodDyn = PeriodHelper.getPreviousPeriod((Object)rptParam.getPeriodId())) != null) {
            rptParam.getPeriodYearMap().put(PREPERIOD_PRE, Collections.singletonList(prePeriodDyn.getLong("id")));
        }
        DynamicObject curPeriodDyn = null;
        if (rptParam.isViewpreyear() || rptParam.isViewtotal()) {
            String entityName = "bd_period";
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
            curPeriodDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)rptParam.getPeriodId(), (DynamicObjectType)type);
        }
        Long startPeriod = StartCostHelper.getCostaccountStartPeriod((String)rptParam.getAppnum(), (Long)rptParam.getOrgId(), (Long)rptParam.getCostaccountId());
        if (rptParam.isViewpreyear()) {
            periodIds = this.filterStartPeriodId(PeriodHelper.getPeriodIdByType((DynamicObject)curPeriodDyn, (String)"1"), startPeriod);
            rptParam.getPeriodYearMap().put(PREYEAR_PRE, periodIds);
        }
        if (rptParam.isViewtotal()) {
            periodIds = this.filterStartPeriodId(PeriodHelper.getPeriodIdByType((DynamicObject)curPeriodDyn, (String)"2"), startPeriod);
            rptParam.getPeriodYearMap().put(CURYEARALL_PRE, periodIds);
            periodIds = this.filterStartPeriodId(PeriodHelper.getPeriodIdByType((DynamicObject)curPeriodDyn, (String)"3"), startPeriod);
            rptParam.getPeriodYearMap().put(PREYEARALL_PRE, periodIds);
        }
        for (List<Long> ids : rptParam.getPeriodYearMap().values()) {
            rptParam.getQueryPeriodIds().addAll(ids);
        }
    }

    private List<Long> filterStartPeriodId(List<Long> periodIds, Long startPeriod) {
        if (CadEmptyUtils.isEmpty((Long)startPeriod)) {
            return periodIds;
        }
        ArrayList<Long> curPeriodIds = new ArrayList<Long>(periodIds);
        for (Long id : periodIds) {
            if (id >= startPeriod) continue;
            curPeriodIds.remove(id);
        }
        return curPeriodIds;
    }

    private List<QFilter> getFixedFilter(CostAnalyzeRptParam rptParam) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        qFilterList.add(new QFilter("org", "=", (Object)rptParam.getOrgId()));
        qFilterList.add(new QFilter("costaccount", "=", (Object)rptParam.getCostaccountId()));
        qFilterList.add(new QFilter("period", "in", rptParam.getQueryPeriodIds()));
        qFilterList.add(new QFilter("period", "in", rptParam.getQueryPeriodIds()));
        if (!CadEmptyUtils.isEmpty((Long)rptParam.getProdOrg())) {
            qFilterList.add(new QFilter("manuorg", "=", (Object)rptParam.getProdOrg()));
        }
        qFilterList.add(new QFilter("material", "in", rptParam.getProducts()));
        return qFilterList;
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("transFormAfterUnion\u591a\u4e2a\u6570\u636e\u5757union\u5b8c\u6210\u540e\u6267\u884c\uff0c\u53ef\u5728\u6b64\u6dfb\u52a0\u81ea\u5df1\u5b9e\u73b0\u7684IDataXTransform\u5904\u7406\u6570\u636e");
        ctx.logInfo((Object)ResManager.loadKDString((String)"\u5904\u7406\u6570\u636e\u5757\u6570\u636e", (String)"CostAnalyzeRptSourceCf_0", (String)"macc-sca-report", (Object[])new Object[0]));
        if (this.rptParam.isViewpreperiod() || this.rptParam.isViewpreyear() || this.rptParam.isViewtotal()) {
            transCollector.add(new CostAnalyzePeriodUnionHandle(this.rptParam, ctx));
        }
        transCollector.add(new CostAnalyzeStdUnionHandle(this.rptParam, ctx));
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        super.beforeGroupData(ctx);
        ctx.setGroupPlans(null);
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new CostAnalyzeDataGroupHandle(this.rptParam, ctx));
    }

    private List<String> getGroupFields(String keyPre) {
        ArrayList<String> list = new ArrayList<String>(10);
        for (String field : calcFields) {
            list.add(keyPre + field);
        }
        for (String field : actFields) {
            list.add(keyPre + field);
        }
        return list;
    }

    private void addPropFields(String field, Set<String> fields) {
        fields.add(CUR_PRE + field);
        fields.add(PREPERIOD_PRE + field);
        fields.add(PREYEAR_PRE + field);
        fields.add(CURYEARALL_PRE + field);
        fields.add(PREYEARALL_PRE + field);
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        this.logger.info("\u5c55\u793a\u5217\u8c03\u6574\u5f00\u59cb");
        ReportColumnGroup stdGroup = new ReportColumnGroup();
        stdGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c", (String)"CostAnalyzeRptSourceCf_1", (String)"macc-sca-report", (Object[])new Object[0])));
        stdGroup.setFieldKey("stdgroup");
        ReportColumnGroup curGroup = new ReportColumnGroup();
        curGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u5b9e\u9645", (String)"CostAnalyzeRptSourceCf_7", (String)"macc-sca-report", (Object[])new Object[0])));
        curGroup.setFieldKey("curgroup");
        List<String> curFields = this.getGroupFields(CUR_PRE);
        ReportColumnGroup preGroup = new ReportColumnGroup();
        preGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0a\u671f\u5b9e\u9645", (String)"CostAnalyzeRptSourceCf_8", (String)"macc-sca-report", (Object[])new Object[0])));
        preGroup.setFieldKey("pregroup");
        List<String> preFields = this.getGroupFields(PREPERIOD_PRE);
        ReportColumnGroup preyearGroup = new ReportColumnGroup();
        preyearGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0a\u5e74\u540c\u671f\u5b9e\u9645", (String)"CostAnalyzeRptSourceCf_4", (String)"macc-sca-report", (Object[])new Object[0])));
        preyearGroup.setFieldKey("preyeargroup");
        List<String> preyearFields = this.getGroupFields(PREYEAR_PRE);
        ReportColumnGroup curyearallGroup = new ReportColumnGroup();
        curyearallGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u5b9e\u9645", (String)"CostAnalyzeRptSourceCf_5", (String)"macc-sca-report", (Object[])new Object[0])));
        curyearallGroup.setFieldKey("curyearallgroup");
        List<String> curyearallFields = this.getGroupFields(CURYEARALL_PRE);
        ReportColumnGroup preyearallGroup = new ReportColumnGroup();
        preyearallGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0a\u5e74\u7d2f\u8ba1\u5b9e\u9645", (String)"CostAnalyzeRptSourceCf_6", (String)"macc-sca-report", (Object[])new Object[0])));
        preyearallGroup.setFieldKey("preyearallgroup");
        List<String> preyearallFields = this.getGroupFields(PREYEARALL_PRE);
        HashSet<String> qtyProps = new HashSet<String>(10);
        HashSet<String> amtProps = new HashSet<String>(10);
        HashSet<String> priceProps = new HashSet<String>(10);
        this.addPropFields("qty", qtyProps);
        this.addPropFields("sumqty", qtyProps);
        this.addPropFields("unitamt", priceProps);
        this.addPropFields("sumamt", amtProps);
        this.addPropFields("price", priceProps);
        priceProps.add("stdprice");
        priceProps.add("stdunitamt");
        qtyProps.add("stdqty");
        Iterator<AbstractReportColumn> iterator = cols.iterator();
        while (iterator.hasNext()) {
            ReportColumn repCol = (ReportColumn)iterator.next();
            String fieldKey = repCol.getFieldKey();
            if (qtyProps.contains(fieldKey)) {
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                repCol.setFieldType("qty");
                repCol.setMeasureUnitField("baseunit");
                repCol.setNoDisplayScaleZero(false);
            }
            if (amtProps.contains(fieldKey)) {
                repCol.setZeroShow(false);
                repCol.setFieldType("amount");
                repCol.setHideSingleColumnRow(false);
                repCol.setNoDisplayScaleZero(false);
                repCol.setCurrencyField("currency");
            }
            if (priceProps.contains(fieldKey)) {
                repCol.setZeroShow(false);
                repCol.setFieldType("price");
                repCol.setHideSingleColumnRow(false);
                repCol.setNoDisplayScaleZero(false);
                repCol.setCurrencyField("currency");
            }
            if (stdFields.contains(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                stdGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (curFields.contains(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                curGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (preFields.contains(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                preGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (preyearFields.contains(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                preyearGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (curyearallFields.contains(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                curyearallGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (preyearallFields.contains(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                preyearallGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (!"level".equals(fieldKey)) continue;
            repCol.setZeroShow(true);
        }
        if (!stdGroup.getChildren().isEmpty()) {
            cols.add((AbstractReportColumn)stdGroup);
        }
        if (!curGroup.getChildren().isEmpty()) {
            cols.add((AbstractReportColumn)curGroup);
        }
        if (!preGroup.getChildren().isEmpty()) {
            cols.add((AbstractReportColumn)preGroup);
        }
        if (!preyearGroup.getChildren().isEmpty()) {
            cols.add((AbstractReportColumn)preyearGroup);
        }
        if (!curyearallGroup.getChildren().isEmpty()) {
            cols.add((AbstractReportColumn)curyearallGroup);
        }
        if (!preyearallGroup.getChildren().isEmpty()) {
            cols.add((AbstractReportColumn)preyearallGroup);
        }
        return cols;
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        super.transformResult(transCollector, ctx);
        transCollector.add(new IDataTransform(){

            public DataSet doTransform(DataSet dataSet) {
                ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(dataSet.getRowMeta().getFieldNames()));
                fieldNames.add(CostAnalyzeRptSourceCf.this.rptParam.getCurencyId() + "L currency");
                fieldNames.remove("level");
                fieldNames.add("case when linetype='3' then '' else cast(level as String) end level");
                return dataSet.select(fieldNames.toArray(new String[0]));
            }
        });
    }
}

