/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.reduction;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algox.DataSetX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.DataSetXHelper;
import kd.macc.sca.report.common.ReportRptHelper;
import kd.macc.sca.report.reduction.CostAnalyzeRptParam;
import org.apache.commons.lang.ArrayUtils;

public class CostAnalyzeStdUnionHandle
implements IDataXTransform {
    private static final Log logger = LogFactory.getLog(CostAnalyzeStdUnionHandle.class);
    private CostAnalyzeRptParam rptParam = null;
    private ReportDataCtx ctx;
    private static String[] fields = new String[]{"level", "path", "root"};

    public CostAnalyzeStdUnionHandle(CostAnalyzeRptParam reportParam, ReportDataCtx ctx) {
        this.rptParam = reportParam;
        this.ctx = ctx;
    }

    public DataSetX doTransform(DataSetX srcData) {
        DataSet stdDs = this.getStandardCostDataRow();
        if (this.rptParam.isOnlysumrow()) {
            stdDs = stdDs.filter("level=0");
        }
        stdDs = stdDs.addField(this.rptParam.getPeriodId() + "L", "period");
        if (this.rptParam.isShowProdOrg()) {
            stdDs = stdDs.addField(this.rptParam.getProdOrg() + "L", "manuorg");
        }
        DataSet materialDs = this.queryMaterialDs();
        stdDs = stdDs.leftJoin(materialDs).on("material", "id").select(stdDs.getRowMeta().getFieldNames(), new String[]{"materialnum", "baseunit"}).finish();
        DataSet elementDs = this.queryElementDs();
        stdDs = stdDs.leftJoin(elementDs).on("element", "id").select(stdDs.getRowMeta().getFieldNames(), new String[]{"elementnum"}).finish();
        DataSet subelementDs = this.querySubElementDs();
        if ((stdDs = stdDs.leftJoin(subelementDs).on("subelement", "id").select(stdDs.getRowMeta().getFieldNames(), new String[]{"subelementnum"}).finish()).isEmpty()) {
            srcData = DataSetXHelper.addBigDecimalFields((DataSetX)srcData, (String[])new String[]{"stdprice", "stdqty", "stdunitamt"});
        } else {
            DataSetX calcResultDataSetX = this.ctx.getCurrentJob().fromInput((Input)new DataSetInput(stdDs));
            srcData = DataSetXHelper.addBigDecimalFields((DataSetX)srcData, (String[])new String[]{"stdprice", "stdqty", "stdunitamt"});
            srcData = DataSetXHelper.unionIfRowDiffStrDefaultEmpty((DataSetX)srcData, (DataSetX)calcResultDataSetX);
        }
        this.ctx.getShowQtyCols().add("stdprice");
        this.ctx.getShowQtyCols().add("stdqty");
        this.ctx.getShowQtyCols().add("stdunitamt");
        return ReportRptHelper.groupDeal(srcData, this.ctx.getShowKeyCols().toArray(new String[0]), 1, this.ctx.getShowQtyCols().toArray(new String[0]));
    }

    private DataSet queryMaterialDs() {
        QFilter filter = new QFilter("id", "in", this.rptParam.getProducts());
        return QueryServiceHelper.queryDataSet((String)"material_query", (String)"bd_material", (String)"id,number materialnum,baseunit", (QFilter[])filter.toArray(), null);
    }

    private DataSet queryElementDs() {
        return QueryServiceHelper.queryDataSet((String)"element_query", (String)"cad_element", (String)"id,number elementnum", null, null);
    }

    private DataSet querySubElementDs() {
        return QueryServiceHelper.queryDataSet((String)"subelement_query", (String)"cad_subelement", (String)"id,number subelementnum", null, null);
    }

    private Set<Long> getNodeMaterials(List<Node> list) {
        HashSet<Long> materials = new HashSet<Long>(10);
        for (Node node : list) {
            String[] ids = node.getId().split("@");
            String[] pids = node.getPid().split("@");
            if (ids.length > 2) {
                materials.add(Long.valueOf(ids[0]));
            }
            if (pids.length <= 2) continue;
            materials.add(Long.valueOf(pids[0]));
        }
        return materials;
    }

    private void setCosttype() {
        if ("sca".equals(this.rptParam.getAppnum())) {
            DynamicObject costType = null;
            if (CadEmptyUtils.isEmpty((Long)this.rptParam.getProdOrg())) {
                List productOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)this.rptParam.getOrgId(), (boolean)true);
                for (Long prdOrg : productOrgs) {
                    costType = this.getCostType(this.rptParam.getOrgId(), this.rptParam.getCostaccountId(), prdOrg);
                    if (costType == null) continue;
                    break;
                }
            } else {
                costType = this.getCostType(this.rptParam.getOrgId(), this.rptParam.getCostaccountId(), this.rptParam.getProdOrg());
            }
            if (costType == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u7ec4\u7ec7\u672a\u7ef4\u62a4\u6210\u672c\u7c7b\u578b\u4e0e\u7ec4\u7ec7\u5bf9\u5e94\u8868\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u67e5\u8be2", (String)"CostAnalyzeStdUnionHandle_0", (String)"macc-sca-report", (Object[])new Object[0]));
            }
            this.rptParam.setCosttypeId(costType.getLong("costtype.id"));
        } else if (CadEmptyUtils.isEmpty((Long)this.rptParam.getCosttypeId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u7ec4\u7ec7\u672a\u7ef4\u62a4\u6210\u672c\u7c7b\u578b\u4e0e\u7ec4\u7ec7\u5bf9\u5e94\u8868\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u67e5\u8be2", (String)"CostAnalyzeStdUnionHandle_0", (String)"macc-sca-report", (Object[])new Object[0]));
        }
    }

    private DataSet getStandardCostDataRow() {
        this.setCosttype();
        HashSet<Long> materialIds = new HashSet<Long>(this.rptParam.getProducts());
        List<Node> list = new ArrayList<Node>();
        DataSet dataSet = this.getLevelDataSet(materialIds, 0).select(new String[]{"id", "material", "matvers", "auxproperty", "material as submaterial", "matvers as submatvers", "auxproperty as subauxproperty", "bomrate", "calcqty", "level", "path"});
        RowMeta rowMeta = dataSet.getRowMeta();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String parentKey = "root";
            String key = row.getLong("material") + "@" + row.getLong("matvers") + "@" + row.getLong("auxproperty");
            Node node = new Node(key, parentKey, row.getBigDecimal("bomrate"), this.parseRow(row, rowMeta));
            if (list.contains(node)) continue;
            list.add(node);
        }
        HashSet<String> queryMaterials = new HashSet<String>(10);
        list = this.getLevelData(materialIds, 1, list, queryMaterials);
        Set<Long> materials = this.getNodeMaterials(list);
        LinkedList<Node> resultList = new LinkedList<Node>();
        this.sortList(list, "root", BigDecimal.ONE, resultList, "root");
        List dataList = resultList.stream().map(a -> a.getData()).collect(Collectors.toList());
        DataSet bomStructure = Algo.create((String)"macc.sca.rpt").createDataSet(dataList.iterator(), rowMeta);
        DataSet calResultDataSet = this.getEffectResultDataSet(materials);
        DataSet selftCalcDataSet = bomStructure.join(calResultDataSet).on("submaterial", "material").on("submatvers", "matvers").on("subauxproperty", "auxproperty").select(bomStructure.getRowMeta().getFieldNames(), new String[]{"element", "subelement", "qty", "price", "amount", "datatype", "material effmaterial", "matvers effmatvers", "auxproperty effauxproperty", "submaterial effsubmaterial", "submatvers effsubmatvers", "subauxproperty effsubauxproperty", "subelementtype"}).finish();
        DataSet zeroDataSet = selftCalcDataSet.filter("level = 1 and datatype = '1'");
        DataSet normalDataSet = selftCalcDataSet.filter("datatype != '1'");
        selftCalcDataSet = zeroDataSet.union(normalDataSet);
        Object[] objects1 = (String[])ArrayUtils.addAll((Object[])bomStructure.getRowMeta().getFieldNames(), (Object[])new String[]{"element", "subelement", "bomrate*qty as qty", "price", "qty*bomrate*price amount", "datatype", "effmaterial", "effmatvers", "effauxproperty", "effsubmaterial", "effsubmatvers", "effsubauxproperty", "subelementtype"});
        selftCalcDataSet = selftCalcDataSet.select(Arrays.toString(objects1).replace("[", "").replace("]", ""));
        DataSet calcDataSet = selftCalcDataSet.addField("0L", "root");
        DataSet resultDataSet = this.dealResourceDataSet(calcDataSet);
        String selectFields = "material,matvers as materialver,auxproperty as auxprop,element, subelement,cast(effsubmaterial as long) as submaterial,cast(effsubmatvers as long) as submaterialver,cast(effsubauxproperty as long) as submaterialauxprop,qty as stdqty,price as stdprice,amount as stdunitamt,level,root,path as treepath,case when datatype='2' then '5' else datatype end datatype";
        return resultDataSet.select(selectFields).groupBy(new String[]{"material", "materialver", "auxprop", "element", "subelement", "submaterial", "submaterialver", "submaterialauxprop", "stdprice", "level", "root", "treepath", "datatype"}).sum("stdqty").sum("stdunitamt").finish();
    }

    private List<Node> getLevelData(Set<Long> materials, int level, List<Node> list, Set<String> queryMaterials) {
        DataSet dataSet = this.getLevelDataSet(materials, level);
        Set<Long> subMaterials = this.getMaterialSet(list, dataSet, queryMaterials);
        if (!subMaterials.isEmpty()) {
            list = this.getLevelData(subMaterials, ++level, list, queryMaterials);
        }
        return list;
    }

    private Set<Long> getMaterialSet(List<Node> list, DataSet dataSet, Set<String> queryMaterials) {
        RowMeta rowMeta = dataSet.getRowMeta();
        HashSet<Long> subMaterials = new HashSet<Long>(16);
        while (dataSet.hasNext()) {
            BigDecimal bomrate;
            Node node;
            Row row = dataSet.next();
            String parentKey = row.getLong("material") + "@" + row.getLong("matvers") + "@" + row.getLong("auxproperty");
            String key = row.getLong("submaterial") + "@" + row.getLong("submatvers") + "@" + row.getLong("subauxproperty");
            queryMaterials.add(parentKey);
            if (!queryMaterials.contains(key)) {
                subMaterials.add(row.getLong("submaterial"));
            }
            if (list.contains(node = new Node(key, parentKey, bomrate = row.getBigDecimal("bomrate"), this.parseRow(row, rowMeta)))) continue;
            list.add(node);
        }
        return subMaterials;
    }

    private DataSet getEffectResultDataSet(Set<Long> allMaterials) {
        List<QFilter> stdPriceQFilters = this.getStdPriceQFilters(allMaterials, new String[]{"1", "2", "4"});
        String entityName = "cad_calceffectiveresult";
        String selfFields = "material,matvers,auxproperty,case when entryentity.submaterial=0 then material else entryentity.submaterial end submaterial,case when entryentity.submaterial=0 then matvers else entryentity.submatvers end submatvers,case when entryentity.submaterial=0 then auxproperty else entryentity.subauxproperty end subauxproperty,entryentity.element as element,entryentity.subelement as subelement,entryentity.qty qty,entryentity.price price ,entryentity.stdprice as amount,entryentity.datatype as datatype,entryentity.subelement.type subelementtype";
        if ("aca".equals(this.rptParam.getAppnum())) {
            entityName = "cad_calcsimulationresult";
            if (!CadEmptyUtils.isEmpty((String)this.rptParam.getCalRecordName())) {
                stdPriceQFilters.add(new QFilter("calcrecord.name", "=", (Object)this.rptParam.getCalRecordName()));
            } else {
                QFilter recordFilter = new QFilter("calcrecord", "is null", null).or(new QFilter("calcrecord", "<=", (Object)0L));
                stdPriceQFilters.add(recordFilter);
            }
        } else {
            selfFields = selfFields + ",effectdate";
        }
        DataSet effectResult = QueryServiceHelper.queryDataSet((String)"calcDataQuery", (String)entityName, (String)selfFields, (QFilter[])stdPriceQFilters.toArray(new QFilter[0]), null);
        if (Boolean.TRUE.equals(this.isQueryPeriod())) {
            String queryPeriodGroups = "material,matvers,auxproperty";
            String queryPeriodFields = queryPeriodGroups + ",effectdate";
            DataSet queryPeriodDataSet = effectResult.copy().select(queryPeriodFields.split(",")).groupBy(queryPeriodGroups.split(",")).max("effectdate").finish();
            effectResult = effectResult.join(queryPeriodDataSet, JoinType.INNER).on("material", "material").on("matvers", "matvers").on("auxproperty", "auxproperty").on("effectdate", "effectdate").select(effectResult.getRowMeta().getFieldNames(), null).finish();
        }
        effectResult = effectResult.groupBy(new String[]{"element", "subelement", "material", "matvers", "auxproperty", "submaterial", "submatvers", "subauxproperty", "datatype", "subelementtype"}).sum("amount").sum("qty").finish();
        return effectResult.select(new String[]{"element", "subelement", "material", "matvers", "auxproperty", "submaterial", "submatvers", "subauxproperty", "datatype", "amount", "qty", "case when qty!= 0 then amount/qty else 0 end price", "subelementtype"});
    }

    private DataSet getLevelDataSet(Set<Long> materials, int level) {
        List<QFilter> stdPriceQFilters = this.getStdPriceQFilters(materials, new String[]{"4"});
        String entityName = "cad_calceffectiveresult";
        String fields = "id,material,matvers,auxproperty,entryentity.submaterial as submaterial,entryentity.submatvers as submatvers,entryentity.subauxproperty as subauxproperty," + (level == 0 ? "entryentity.qty/entryentity.qty bomrate," : "entryentity.qty bomrate,") + (level == 0 ? "entryentity.qty/entryentity.qty calcqty," : "entryentity.qty calcqty,") + this.getLevelStr(level) + " level,'' path";
        if ("aca".equals(this.rptParam.getAppnum())) {
            entityName = "cad_calcsimulationresult";
            if (!CadEmptyUtils.isEmpty((String)this.rptParam.getCalRecordName())) {
                stdPriceQFilters.add(new QFilter("calcrecord.name", "=", (Object)this.rptParam.getCalRecordName()));
            } else {
                QFilter recordFilter = new QFilter("calcrecord", "is null", null).or(new QFilter("calcrecord", "<=", (Object)0L));
                stdPriceQFilters.add(recordFilter);
            }
        } else {
            fields = fields + ",effectdate";
        }
        DataSet calcEffectDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.report.CostAnalyzeRptQuery#getLevelDataSet", (String)entityName, (String)fields, (QFilter[])stdPriceQFilters.toArray(new QFilter[0]), null);
        if (Boolean.TRUE.equals(this.isQueryPeriod())) {
            String queryPeriodGroups = "material,matvers,auxproperty";
            String queryPeriodFields = queryPeriodGroups + ",effectdate";
            DataSet calcQueryPeriodDataSet = calcEffectDataSet.copy().select(queryPeriodFields.split(",")).groupBy(queryPeriodGroups.split(",")).max("effectdate").finish();
            calcEffectDataSet = calcEffectDataSet.join(calcQueryPeriodDataSet, JoinType.INNER).on("material", "material").on("matvers", "matvers").on("auxproperty", "auxproperty").on("effectdate", "effectdate").select(calcEffectDataSet.getRowMeta().getFieldNames(), null).finish();
        }
        if (!"aca".equals(this.rptParam.getAppnum())) {
            calcEffectDataSet = calcEffectDataSet.removeFields(new String[]{"effectdate"});
        }
        return calcEffectDataSet;
    }

    private List<QFilter> getStdPriceQFilters(Set<Long> matIds, String[] datatype) {
        List<Object> qFilterList = new ArrayList<QFilter>(10);
        qFilterList.add(new QFilter("costtype", "=", (Object)this.rptParam.getCosttypeId()));
        qFilterList.add(new QFilter("entryentity.datatype", "in", (Object)datatype));
        if (matIds != null) {
            qFilterList.add(new QFilter("material", "in", matIds));
        }
        qFilterList.add(new QFilter("ismaindata", "=", (Object)1L));
        if ("sca".equals(this.rptParam.getAppnum())) {
            Date[] periodtime;
            Date queryDate = this.rptParam.getQuerydate();
            Long queryPeriodId = this.rptParam.getQueryperiodId();
            if (queryDate != null) {
                qFilterList.add(new QFilter("effectdate", "<=", (Object)queryDate));
                qFilterList.add(new QFilter("expdate", ">", (Object)queryDate));
            } else if (!CadEmptyUtils.isEmpty((Long)queryPeriodId) && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)queryPeriodId)) != null) {
                qFilterList = CostUpdateHelper.getPeriodQFilter(qFilterList, (Date[])periodtime);
            }
        }
        return qFilterList;
    }

    private DynamicObject getCostType(Long org, Long costAccount, Long entryProdOrg) {
        boolean enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)costAccount);
        QFilter qFilter = new QFilter("costaccount", "=", (Object)costAccount);
        if (!enableMulFactory) {
            qFilter.and(new QFilter("calorg", "=", (Object)org));
        } else {
            qFilter.and(new QFilter("storageorgunit", "in", (Object)OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)entryProdOrg, (boolean)true)));
        }
        QFilter timeFilter = new QFilter("effectdate", "<=", (Object)TimeServiceHelper.now());
        timeFilter.and("invaliddate", ">", (Object)TimeServiceHelper.now());
        qFilter.and(timeFilter);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costtypeorg", (String)"costtype", (QFilter[])qFilter.toArray());
    }

    private DataSet dealResourceDataSet(DataSet dataSet) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        RowMeta rowMeta = dataSet.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        int len = dataSet.getRowMeta().getFields().length;
        while (dataSet.hasNext()) {
            int i;
            Row row = dataSet.next();
            if (row == null) continue;
            Object[] obj = new Object[len];
            String pathValue = "";
            String levelValue = "";
            boolean isProductRow = false;
            if ("1".equals(row.getString("datatype")) && "1".equals(row.getString("level"))) {
                isProductRow = true;
            }
            for (i = 0; i < len; ++i) {
                String path;
                if (!Arrays.asList(fields).contains(fieldNames[i])) {
                    obj[i] = row.get(i);
                    continue;
                }
                if ("level".equals(fieldNames[i])) {
                    String level = isProductRow ? "0" : row.get(i) + "";
                    obj[i] = level;
                    levelValue = level;
                }
                if ("path".equals(fieldNames[i])) {
                    String productArr;
                    String[] productInfo;
                    path = row.getString("path");
                    String newPath = this.changePath(path);
                    if ("001".equals(row.getString("subelementtype"))) {
                        if (!isProductRow) {
                            newPath = newPath + "@" + row.getString("effsubmaterial");
                        }
                    } else {
                        newPath = newPath + "@0";
                    }
                    obj[i] = newPath;
                    pathValue = newPath;
                    String[] pathArr = path.split("-");
                    if (pathArr != null && pathArr.length >= 2 && (productInfo = (productArr = pathArr[1]).split("@")).length >= 3) {
                        obj[dataSet.getRowMeta().getFieldIndex((String)"material")] = Long.valueOf(productInfo[0]);
                        obj[dataSet.getRowMeta().getFieldIndex((String)"matvers")] = Long.valueOf(productInfo[1]);
                        obj[dataSet.getRowMeta().getFieldIndex((String)"auxproperty")] = Long.valueOf(productInfo[2]);
                    }
                }
                if (isProductRow) {
                    obj[rowMeta.getFieldIndex((String)"element")] = 0L;
                    obj[rowMeta.getFieldIndex((String)"subelement")] = 0L;
                }
                if (!"root".equals(fieldNames[i])) continue;
                path = row.getString("path");
                String str = path.split("-")[1];
                obj[i] = Long.parseLong(str.split("@")[0]);
            }
            for (i = 0; i < len; ++i) {
                if (!"level".equals(fieldNames[i]) || "".equals(pathValue) || "0".equals(levelValue)) continue;
                int sum = pathValue.split("@").length - 1;
                obj[i] = "" + sum;
            }
            dataList.add(obj);
        }
        return Algo.create((String)"macc.sca.rpt").createDataSet(dataList.iterator(), rowMeta);
    }

    public void sortList(List<Node> list, String id, BigDecimal qty, List<Node> resultList, String parentPath) {
        for (Node node : list) {
            if (!node.getPid().equals(id)) continue;
            String path = parentPath + "-" + node.getId();
            Node clone = node.clone();
            clone.setPath(path);
            BigDecimal multiply = clone.getBomrate().multiply(qty);
            clone.setBomrate(multiply);
            boolean has = false;
            for (Node rNode : resultList) {
                if (!path.equals(rNode.getPath())) continue;
                has = true;
                break;
            }
            if (!has) {
                resultList.add(clone);
            }
            this.sortList(list, clone.getId(), multiply, resultList, path);
        }
    }

    private String changePath(String path) {
        String[] splits = path.split("-");
        StringBuilder newPath = new StringBuilder();
        for (int i = 0; i < splits.length; ++i) {
            String[] temPath;
            if ("root".equals(splits[i]) || (temPath = splits[i].split("@")).length <= 2) continue;
            if (newPath.length() > 0) {
                newPath.append("@");
            }
            newPath.append(temPath[0]);
        }
        return newPath.toString();
    }

    private String getLevelStr(int level) {
        return String.valueOf(++level);
    }

    private Boolean isQueryPeriod() {
        if (this.rptParam.getQuerydate() != null) {
            return Boolean.FALSE;
        }
        if (!CadEmptyUtils.isEmpty((Long)this.rptParam.getQueryperiodId())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Object[] parseRow(Row row, RowMeta rowMeta) {
        Field[] fields = rowMeta.getFields();
        Object[] rowData = new Object[fields.length];
        for (int j = 0; j < fields.length; ++j) {
            Object val;
            String name = fields[j].getName();
            rowData[j] = val = row.get(name);
        }
        return rowData;
    }

    public static class Node
    implements Cloneable {
        private String id;
        private String pid;
        private BigDecimal bomrate;
        private String path;
        private Object[] data;

        public Node(String id, String pid, BigDecimal bomrate, Object[] data) {
            this.id = id;
            this.pid = pid;
            this.data = data;
            this.bomrate = bomrate;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getPid() {
            return this.pid;
        }

        public void setPath(String path) {
            this.path = path;
            if (this.data != null) {
                this.data[this.data.length - 1] = path;
            }
        }

        public String getPath() {
            return this.path;
        }

        public void setPid(String pid) {
            this.pid = pid;
        }

        public Object[] getData() {
            return this.data;
        }

        public BigDecimal getBomrate() {
            return this.bomrate;
        }

        public void setBomrate(BigDecimal bomrate) {
            this.bomrate = bomrate;
            if (this.data != null) {
                this.data[this.data.length - 4] = bomrate;
            }
        }

        public String toString() {
            return "[ pid=" + this.pid + ", id= " + this.id + "]";
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return ("" + this.getPid() + this.getId()).equals("" + ((Node)obj).getPid() + ((Node)obj).getId());
        }

        public Node clone() {
            Node node = null;
            try {
                node = (Node)super.clone();
            }
            catch (CloneNotSupportedException e) {
                logger.info(e.getMessage());
            }
            if (node != null) {
                node.data = (Object[])this.data.clone();
            }
            return node;
        }
    }
}

