/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.reduction;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.Grouper;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.DataSetXHelper;
import kd.macc.sca.report.reduction.CostReductionItemDealFunction;
import kd.macc.sca.report.reduction.CostReductionRptParam;
import kd.macc.sca.report.reduction.CostRedutionCalcUnitAmtFunction;
import kd.macc.sca.report.reduction.CostRedutionDealFuncyion;
import org.apache.commons.lang.StringUtils;

public class CostReductionDataRowHandle
implements IDataXTransform {
    private final Log logger = LogFactory.getLog(CostReductionDataRowHandle.class);
    private ReportDataCtx ctx;
    private static final List<String> materialFields = Lists.newArrayList((Object[])new String[]{"submaterial", "subcalckeycol", "submaterialauxprop", "submaterialnum", "subbaseunit", "isleaf", "keytreepath"});
    private static final List<String> groupFields = Lists.newArrayList((Object[])new String[]{"group", "groupname"});
    private static final List<String> elementFields = Lists.newArrayList((Object[])new String[]{"element", "elementname"});
    private static final List<String> subelementFields = Lists.newArrayList((Object[])new String[]{"subelement", "subelementname"});
    private static final List<String> CUR_ARR = Lists.newArrayList((Object[])new String[]{"curqty", "curamt"});
    private static final List<String> SUM_ARR = Lists.newArrayList((Object[])new String[]{"sumqty", "sumamt"});
    private static final List<String> TRAN_ARR = Lists.newArrayList((Object[])new String[]{"transinqty", "transinamt"});
    private static final List<String> PUR_ARR = Lists.newArrayList((Object[])new String[]{"purqty", "puramt"});
    private CostReductionRptParam costReductionRptParam;

    public CostReductionDataRowHandle(CostReductionRptParam costReductionRptParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.costReductionRptParam = costReductionRptParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        this.logger.info("\u6210\u672c\u8fd8\u539f\u5206\u9879\u4e0e\u5206\u7ea7\u62a5\u8868\u6570\u636e\u5904\u7406\u5f00\u59cb");
        Long startTime = System.currentTimeMillis();
        if (this.costReductionRptParam.getMaterialGrpStdId() != 730148448254487552L || !CadEmptyUtils.isEmpty((DynamicObjectCollection)this.costReductionRptParam.getMaterialGroup())) {
            DataSet materialDataSet = MaterialGroupHelper.getClassifiedMaterialDataSet((DynamicObjectCollection)this.costReductionRptParam.getMaterialGroup(), (boolean)false, (DynamicObject)this.costReductionRptParam.getMaterialGrpStd(), (boolean)false).select("materialgroup group,materialgroupname groupname,material").groupBy(new String[]{"group", "groupname", "material"}).finish();
            DataSetX materialDataSetX = this.ctx.getCurrentJob().fromInput((Input)new DataSetInput(materialDataSet));
            srcData = srcData.removeFields(new String[]{"group", "groupname"});
            DataSetX levelZeroDsx = srcData.filter("level='0'");
            levelZeroDsx = levelZeroDsx.leftJoin(materialDataSetX).on("submaterial", "material").select(levelZeroDsx.getRowMeta().getFieldNames(), new String[]{"group", "groupname"});
            DataSetX levelSubDsx = srcData.filter("level<>'0'");
            levelSubDsx = levelSubDsx.join(materialDataSetX).on("submaterial", "material").select(levelSubDsx.getRowMeta().getFieldNames(), new String[]{"group", "groupname"});
            srcData = levelSubDsx.union(levelZeroDsx);
        }
        final boolean calckeycol = this.costReductionRptParam.isCalckeycol();
        this.ctx.getShowKeyCols().remove("treepath");
        DataSetX resultDataSetX = srcData = srcData.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }

            public RowX map(RowX row) {
                int keytreepathIndex = this.sourceRowMeta.getFieldIndex("keytreepath");
                int treepathIndex = this.sourceRowMeta.getFieldIndex("treepath");
                if (calckeycol) {
                    if (StringUtils.isEmpty((String)row.getString(keytreepathIndex))) {
                        row.set(keytreepathIndex, (Object)row.getString(treepathIndex));
                    }
                } else {
                    row.set(keytreepathIndex, (Object)row.getString(treepathIndex));
                }
                return row;
            }
        });
        if (this.costReductionRptParam.isViewTotal()) {
            resultDataSetX = this.dealPeriodYearSum(srcData);
        }
        if (!this.costReductionRptParam.isLevelRpt()) {
            resultDataSetX = resultDataSetX.map((MapFunction)new CostReductionItemDealFunction());
        }
        if (CadBgParamUtils.getCadParamForInt((String)"reductviewzero", (int)1) == 1) {
            resultDataSetX = this.costReductionRptParam.isViewTotal() ? resultDataSetX.filter("curqty!=0 or sumqty!=0 or curamt!=0 or sumamt!=0") : resultDataSetX.filter("curqty!=0 or curamt!=0");
        }
        Set<String> groupSumCols = this.dealSubKeyColView();
        String[] sumArr = this.ctx.getShowQtyCols().toArray(new String[0]);
        String[] groupSumArr = groupSumCols.toArray(new String[groupSumCols.size()]);
        resultDataSetX = this.groupSumAndMaxDeal(resultDataSetX, groupSumArr, sumArr, null);
        resultDataSetX = resultDataSetX.addFields(new Field[]{new Field("isproductrow", (DataType)DataType.IntegerType), new Field("isperiodrow", (DataType)DataType.IntegerType), new Field("istotalrow", (DataType)DataType.IntegerType), new Field("linetype", (DataType)DataType.StringType)}, new Object[]{0, 0, 0, "0"});
        resultDataSetX = resultDataSetX.groupBy(new String[]{"period", "periodyear", "materialnum", "material", "calckeycol", "auxprop", "modelnum", "baseunit"}).reduceGroup((GroupReduceFunction)new CostRedutionDealFuncyion(this.costReductionRptParam));
        if (this.costReductionRptParam.isLevelRpt() && groupSumCols.contains("keytreepath")) {
            resultDataSetX = resultDataSetX.groupBy(new String[]{"period", "periodyear", "materialnum", "material", "calckeycol", "auxprop", "modelnum", "baseunit"}).reduceGroup((GroupReduceFunction)new CostRedutionCalcUnitAmtFunction(this.costReductionRptParam.isViewTotal()));
        }
        resultDataSetX = this.dealSumData(resultDataSetX);
        resultDataSetX = resultDataSetX.orderBy(this.getOrderByStr(groupSumCols));
        this.logger.info("\u6210\u672c\u8fd8\u539f\u5206\u9879\u4e0e\u5206\u7ea7\u62a5\u8868\u6570\u636e\u5904\u7406\u7ed3\u675f\uff0c\u8017\u65f6\uff1a%s", (Object)(System.currentTimeMillis() - startTime));
        return resultDataSetX;
    }

    private DataSetX dealSumData(DataSetX resultDataSetX) {
        ArrayList<String> sumList = new ArrayList<String>(10);
        sumList.addAll(CUR_ARR);
        if (this.costReductionRptParam.isViewTotal()) {
            sumList.addAll(SUM_ARR);
        }
        if (this.costReductionRptParam.getViewTransinCost()) {
            sumList.addAll(TRAN_ARR);
        }
        if (this.costReductionRptParam.getViewPurCost()) {
            sumList.addAll(PUR_ARR);
        }
        DataSetX productDataSetX = resultDataSetX.filter("level='0'");
        DataSetX periodSumDataSetx = this.groupSumAndMaxDeal(productDataSetX, new String[]{"period", "periodyear", "currency"}, sumList.toArray(new String[0]), null).addFields(new Field[]{new Field("isperiodrow", (DataType)DataType.IntegerType), new Field("linetype", (DataType)DataType.StringType)}, new Object[]{1, "2"});
        sumList.removeAll(SUM_ARR);
        DataSetX periodYearDataSetx = this.groupSumAndMaxDeal(periodSumDataSetx, new String[]{"periodyear", "currency"}, sumList.toArray(new String[0]), this.costReductionRptParam.isViewTotal() ? SUM_ARR.toArray(new String[0]) : null);
        if (this.costReductionRptParam.isViewTotal()) {
            sumList.addAll(SUM_ARR);
        }
        DataSetX totalSumDataSetx = this.groupSumAndMaxDeal(periodYearDataSetx, new String[]{"currency"}, sumList.toArray(new String[0]), null).addFields(new Field[]{new Field("istotalrow", (DataType)DataType.IntegerType), new Field("linetype", (DataType)DataType.StringType)}, new Object[]{1, "6"});
        if (this.costReductionRptParam.getOlnySumRow()) {
            resultDataSetX = resultDataSetX.filter("1=2");
        }
        resultDataSetX = DataSetXHelper.unionIfRowDiff((DataSetX)resultDataSetX, (DataSetX)periodSumDataSetx);
        return DataSetXHelper.unionIfRowDiff((DataSetX)resultDataSetX, (DataSetX)totalSumDataSetx);
    }

    private Set<String> dealSubKeyColView() {
        HashSet<String> groupSumCols = new HashSet<String>(16);
        groupSumCols.addAll(this.ctx.getShowKeyCols());
        if (!this.costReductionRptParam.getSubShowKeyCols().contains("element")) {
            groupSumCols.removeAll(elementFields);
        }
        if (!this.costReductionRptParam.getSubShowKeyCols().contains("subelement")) {
            groupSumCols.removeAll(subelementFields);
        }
        if (!this.costReductionRptParam.getSubShowKeyCols().contains("group")) {
            groupSumCols.removeAll(groupFields);
        }
        if (!this.costReductionRptParam.getSubShowKeyCols().contains("submaterial")) {
            groupSumCols.removeAll(materialFields);
        }
        return groupSumCols;
    }

    private DataSetX dealPeriodYearSum(DataSetX srcData) {
        List<Long> periodIds = this.costReductionRptParam.getPeriodids();
        DataSetX curPeriodDataSetX = srcData.filter("period in (" + StringUtils.join((Object[])periodIds.toArray(), (char)',') + ")");
        HashSet groupCols = new HashSet(16);
        Set showKeyCols = this.ctx.getShowKeyCols();
        groupCols.addAll(showKeyCols);
        groupCols.remove("period");
        String[] keyCols = groupCols.toArray(new String[groupCols.size()]);
        DataSetX yearPeriodX = null;
        Map<Long, Set<Long>> periodYearMap = this.costReductionRptParam.getPeriodYearMap();
        for (Map.Entry<Long, Set<Long>> entry : periodYearMap.entrySet()) {
            Long periodId = entry.getKey();
            Set<Long> yearPeriodIds = entry.getValue();
            DataSetX yearPeriodTempX = srcData.filter("period in (" + StringUtils.join((Object[])yearPeriodIds.toArray(), (char)',') + ")").groupBy(keyCols).sum("curqty", "sumqty").sum("curamt", "sumamt");
            yearPeriodTempX = yearPeriodTempX.addFields(new Field[]{new Field("period", (DataType)DataType.LongType)}, new Object[]{periodId});
            if (yearPeriodX == null) {
                yearPeriodX = yearPeriodTempX;
                continue;
            }
            yearPeriodX = DataSetXHelper.union((DataSetX)yearPeriodX, (DataSetX)yearPeriodTempX);
        }
        DataSetX relDataSetX = DataSetXHelper.unionIfRowDiff((DataSetX)curPeriodDataSetX, yearPeriodX);
        Set showQtyCols = this.ctx.getShowQtyCols();
        String[] groupArr = showKeyCols.toArray(new String[showKeyCols.size()]);
        String[] sumArr = this.ctx.getShowQtyCols().toArray(new String[showQtyCols.size()]);
        return this.groupSumAndMaxDeal(relDataSetX, groupArr, sumArr, null);
    }

    private String[] getOrderByStr(Set<String> groupSumCols) {
        ArrayList<String> fields = new ArrayList<String>(10);
        if (this.costReductionRptParam.getTopSumRow()) {
            fields.add("istotalrow desc");
        } else {
            fields.add("istotalrow");
        }
        fields.add("period desc");
        fields.add("isperiodrow");
        fields.add("materialnum");
        fields.add("calckeycol");
        fields.add("auxprop");
        fields.add("isproductrow desc");
        if (groupSumCols.contains("keytreepath")) {
            fields.add("keytreepath");
        } else {
            fields.add("level");
        }
        if (groupSumCols.contains("element")) {
            fields.add("element desc");
        }
        if (groupSumCols.contains("subelement")) {
            fields.add("subelement desc");
        }
        return fields.toArray(new String[0]);
    }

    private DataSetX groupSumAndMaxDeal(DataSetX srcDataSetX, String[] groupArr, String[] sumArr, String[] maxArr) {
        if (groupArr.length == 0) {
            throw new KDBizException("group field is null");
        }
        DataSetX dataDsx = null;
        Grouper detailGrouper = srcDataSetX.groupBy(groupArr);
        if (sumArr != null) {
            for (String showQtyCol : sumArr) {
                dataDsx = dataDsx == null ? detailGrouper.sum(showQtyCol) : dataDsx.sum(showQtyCol);
            }
        }
        if (maxArr != null) {
            for (String showQtyCol : maxArr) {
                dataDsx = dataDsx == null ? detailGrouper.max(showQtyCol) : dataDsx.max(showQtyCol);
            }
        }
        if (dataDsx == null) {
            return srcDataSetX;
        }
        return dataDsx;
    }
}

