/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.reduction;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.macc.cad.common.helper.CalcKeycolHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.report.reduction.CostReductionDataRowHandle;
import kd.macc.sca.report.reduction.CostReductionRptParam;

public class CostReductionRptSourceCf
implements IReportDataHandle {
    private final Log logger = LogFactory.getLog(CostReductionRptSourceCf.class);
    private static final List<String> CUR_GROUP = Lists.newArrayList((Object[])new String[]{"curperqty", "curqty", "curprice", "curunitamt", "curamt"});
    public static final List<String> TRANSIN_GROUP = Lists.newArrayList((Object[])new String[]{"transinperqty", "transinqty", "transinprice", "transinunitamt", "transinamt"});
    public static final List<String> PUR_GROUP = Lists.newArrayList((Object[])new String[]{"purperqty", "purqty", "purprice", "purunitamt", "puramt"});
    public static final List<String> SUM_GROUP = Lists.newArrayList((Object[])new String[]{"sumperqty", "sumqty", "sumprice", "sumunitamt", "sumamt"});
    private static final List<String> qtyProps = Lists.newArrayList((Object[])new String[]{"curperqty", "curqty", "transinperqty", "transinqty", "purperqty", "purqty", "sumperqty", "sumqty"});
    private static final List<String> amtProps = Lists.newArrayList((Object[])new String[]{"curunitamt", "curamt", "transinunitamt", "transinamt", "purunitamt", "puramt", "sumunitamt", "sumamt"});
    private static final List<String> priceProps = Lists.newArrayList((Object[])new String[]{"curprice", "transinprice", "purprice", "sumprice"});
    private static final List<String> hideProps = Lists.newArrayList((Object[])new String[]{"currency", "treepath", "calckeycol", "keytreepath", "subcalckeycol", "isleaf", "level", "periodyear", "element", "subelement", "group"});
    private static final List<String> hideLevelProps = Lists.newArrayList((Object[])new String[]{"currency", "treepath", "calckeycol", "keytreepath", "subcalckeycol", "isleaf", "periodyear", "element", "subelement", "group"});
    private CostReductionRptParam costReductionRptParam;

    public void setupCtx(ReportDataCtx ctx) {
        super.setupCtx(ctx);
        this.logger.info("\u5f00\u59cb\u8bbe\u7f6e\u4e0a\u4e0b\u6587");
        this.costReductionRptParam = (CostReductionRptParam)ctx.getParam(CostReductionRptParam.class.getName());
        ctx.setShowBlockEntity(false);
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getFixedFilter());
        } else {
            fixedFs.addAll(this.getFixedFilter());
        }
        ctx.getShowKeyCols().add("calckeycol");
        ctx.getShowKeyCols().add("subcalckeycol");
        ctx.getShowKeyCols().add("keytreepath");
        this.costReductionRptParam.setCalckeycol(!CadEmptyUtils.isEmpty((Set)CalcKeycolHelper.getCostaccountReductKeyCols((Long)this.costReductionRptParam.getOrgIds().get(0), (Long)this.costReductionRptParam.getCostAccountIds().get(0), (String)this.costReductionRptParam.getAppnum())));
        this.logger.info("\u7ed3\u675f\u8bbe\u7f6e\u4e0a\u4e0b\u6587");
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        super.beforeGroupData(ctx);
        ctx.setGroupPlans(null);
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        super.transFormAfterGroup(transCollector, ctx);
        this.logger.info("\u5904\u7406\u6570\u636e\uff0c\u8fc7\u6ee4\u6ee1\u8db3\u6761\u4ef6\u7684\u6570\u636e\u5e76\u8ba1\u7b97\u5f53\u5e74\u7d2f\u8ba1\u6570\u636e\u5f00\u59cb");
        transCollector.add(new CostReductionDataRowHandle(this.costReductionRptParam, ctx));
        this.logger.info("\u5904\u7406\u6570\u636e\uff0c\u8fc7\u6ee4\u6ee1\u8db3\u6761\u4ef6\u7684\u6570\u636e\u5e76\u8ba1\u7b97\u5f53\u5e74\u7d2f\u8ba1\u6570\u636e\u7ed3\u675f");
    }

    private List<QFilter> getFixedFilter() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        if (!CadEmptyUtils.isEmpty(this.costReductionRptParam.getOrgIds())) {
            filters.add(new QFilter("org", "in", this.costReductionRptParam.getOrgIds()));
        }
        if (!CadEmptyUtils.isEmpty(this.costReductionRptParam.getCostAccountIds())) {
            filters.add(new QFilter("costaccount", "in", this.costReductionRptParam.getCostAccountIds()));
        }
        if (!CadEmptyUtils.isEmpty(this.costReductionRptParam.getPrdOrgIds())) {
            filters.add(new QFilter("prdorg", "in", this.costReductionRptParam.getPrdOrgIds()));
        }
        if (!CadEmptyUtils.isEmpty(this.costReductionRptParam.getStorageOrgUnitIds())) {
            filters.add(new QFilter("storageorgunit", "in", this.costReductionRptParam.getStorageOrgUnitIds()));
        }
        if (!CadEmptyUtils.isEmpty(this.costReductionRptParam.getMulProductIds())) {
            filters.add(new QFilter("material", "in", this.costReductionRptParam.getMulProductIds()));
        }
        if (!CadEmptyUtils.isEmpty(this.costReductionRptParam.getMulMaterialIds())) {
            filters.add(new QFilter("level", "=", (Object)0).or(new QFilter("submaterial", "in", this.costReductionRptParam.getMulMaterialIds())));
        }
        if (this.costReductionRptParam.isViewTotal()) {
            HashSet queryPeriodIds = new HashSet(10);
            for (Long periodId : this.costReductionRptParam.getPeriodids()) {
                Set yearPeriodIds = PeriodHelper.getCurPeriodYear((Long)periodId);
                this.costReductionRptParam.getPeriodYearMap().put(periodId, yearPeriodIds);
                queryPeriodIds.addAll(yearPeriodIds);
            }
            filters.add(new QFilter("period", "in", queryPeriodIds));
        } else {
            filters.add(new QFilter("period", "in", this.costReductionRptParam.getPeriodids()));
        }
        if (this.costReductionRptParam.isLevelRpt() && this.costReductionRptParam.getDisplayLevel() != -1) {
            filters.add(new QFilter("level", "<=", (Object)this.costReductionRptParam.getDisplayLevel()));
        }
        return filters;
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        this.logger.info("\u5c55\u793a\u5217\u8c03\u6574\u5f00\u59cb");
        Boolean isLevelRpt = this.costReductionRptParam.isLevelRpt();
        Boolean viewPurCost = this.costReductionRptParam.getViewPurCost();
        Boolean viewTransinCost = this.costReductionRptParam.getViewTransinCost();
        Boolean viewTotal = this.costReductionRptParam.isViewTotal();
        ReportColumnGroup curGroup = new ReportColumnGroup();
        curGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u5b8c\u5de5\u6210\u672c", (String)"CostReductionRptSourceCf_0", (String)"macc-sca-report", (Object[])new Object[0])));
        curGroup.setFieldKey("curgroup");
        ReportColumnGroup transinGroup = new ReportColumnGroup();
        transinGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u8c03\u5165\u6210\u672c", (String)"CostReductionRptSourceCf_1", (String)"macc-sca-report", (Object[])new Object[0])));
        transinGroup.setFieldKey("transingroup");
        ReportColumnGroup purGroup = new ReportColumnGroup();
        purGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u91c7\u8d2d\u6210\u672c", (String)"CostReductionRptSourceCf_2", (String)"macc-sca-report", (Object[])new Object[0])));
        purGroup.setFieldKey("purgroup");
        ReportColumnGroup sumGroup = new ReportColumnGroup();
        sumGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u5b8c\u5de5\u6210\u672c", (String)"CostReductionRptSourceCf_3", (String)"macc-sca-report", (Object[])new Object[0])));
        sumGroup.setFieldKey("sumgroup");
        Iterator<AbstractReportColumn> iterator = cols.iterator();
        while (iterator.hasNext()) {
            ReportColumn repCol = (ReportColumn)iterator.next();
            String fieldKey = repCol.getFieldKey();
            if (!isLevelRpt.booleanValue() && hideProps.contains(fieldKey)) {
                repCol.setHide(true);
            }
            if (isLevelRpt.booleanValue() && hideLevelProps.contains(fieldKey)) {
                repCol.setHide(true);
            }
            if (qtyProps.contains(fieldKey)) {
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                repCol.setFieldType("qty");
                repCol.setMeasureUnitField("subbaseunit");
                repCol.setNoDisplayScaleZero(false);
            }
            if (amtProps.contains(fieldKey)) {
                repCol.setZeroShow(false);
                repCol.setFieldType("amount");
                repCol.setHideSingleColumnRow(false);
                repCol.setNoDisplayScaleZero(false);
                repCol.setCurrencyField("currency");
            }
            if (priceProps.contains(fieldKey)) {
                repCol.setZeroShow(false);
                repCol.setFieldType("price");
                repCol.setHideSingleColumnRow(false);
                repCol.setNoDisplayScaleZero(false);
                repCol.setCurrencyField("currency");
            }
            if (CUR_GROUP.contains(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                curGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (TRANSIN_GROUP.contains(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                transinGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (PUR_GROUP.contains(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                purGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (SUM_GROUP.contains(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                sumGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (!"level".equals(fieldKey)) continue;
            repCol.setZeroShow(true);
        }
        cols.add((AbstractReportColumn)curGroup);
        if (viewPurCost.booleanValue()) {
            cols.add((AbstractReportColumn)curGroup);
        }
        if (viewTransinCost.booleanValue()) {
            cols.add((AbstractReportColumn)transinGroup);
        }
        if (viewTotal.booleanValue()) {
            cols.add((AbstractReportColumn)sumGroup);
        }
        return cols;
    }
}

