/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.reduction;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.report.reduction.CostReductionRptParam;

public class CostRedutionDealFuncyion
extends GroupReduceFunction {
    private static final long serialVersionUID = 1620364234833755136L;
    private CostReductionRptParam costReductionRptParam;

    public CostRedutionDealFuncyion(CostReductionRptParam costReductionRptParam) {
        this.costReductionRptParam = costReductionRptParam;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList<RowX> targetRows = new ArrayList<RowX>(10);
        int precision = this.costReductionRptParam.getAmtPrecision();
        int pricePrecision = this.costReductionRptParam.getPricePrecision();
        BigDecimal yearHeadSumQty = BigDecimal.ZERO;
        BigDecimal curHeadQty = BigDecimal.ZERO;
        BigDecimal purHeadQty = BigDecimal.ZERO;
        BigDecimal transinHeadQty = BigDecimal.ZERO;
        for (RowX row : iterable) {
            int level = row.getInteger(this.getSourceRowMeta().getFieldIndex("level"));
            if (level == 0) {
                if (this.costReductionRptParam.isViewTotal()) {
                    yearHeadSumQty = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("sumqty")));
                }
                curHeadQty = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("curqty")));
                if (this.costReductionRptParam.getViewTransinCost()) {
                    transinHeadQty = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("transinqty")));
                }
                if (this.costReductionRptParam.getViewPurCost()) {
                    purHeadQty = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(this.getSourceRowMeta().getFieldIndex("purqty")));
                }
            }
            targetRows.add(row);
        }
        for (RowX row : targetRows) {
            Long level = row.getLong(this.getSourceRowMeta().getFieldIndex("level"));
            if (level == 0L) {
                int elementIndex = this.getSourceRowMeta().getFieldIndex("elementname", false);
                int subelementIndex = this.getSourceRowMeta().getFieldIndex("subelementname", false);
                String elementStr = ResManager.loadKDString((String)"\u7269\u6599", (String)"CostRedutionDealFuncyion_0", (String)"macc-sca-report", (Object[])new Object[0]);
                String subelementStr = ResManager.loadKDString((String)"\u4ea7\u54c1\u7ea7", (String)"CostRedutionDealFuncyion_1", (String)"macc-sca-report", (Object[])new Object[0]);
                if (elementIndex >= 0) {
                    row.set(elementIndex, (Object)elementStr);
                }
                if (subelementIndex >= 0) {
                    row.set(subelementIndex, (Object)subelementStr);
                }
                row.set(this.getSourceRowMeta().getFieldIndex("isproductrow"), (Object)1);
                row.set(this.getSourceRowMeta().getFieldIndex("linetype"), (Object)"1");
            }
            int curQtyIndex = this.getSourceRowMeta().getFieldIndex("curqty");
            BigDecimal curQty = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(curQtyIndex));
            int curAmtIndex = this.getSourceRowMeta().getFieldIndex("curamt");
            BigDecimal curAmt = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(curAmtIndex));
            int curPerQtyIndex = this.getSourceRowMeta().getFieldIndex("curperqty");
            row.set(curPerQtyIndex, (Object)CostRedutionDealFuncyion.getDevideCal(curQty, curHeadQty, 10));
            int curPriceIndex = this.getSourceRowMeta().getFieldIndex("curprice");
            row.set(curPriceIndex, (Object)CostRedutionDealFuncyion.getDevideCal(curAmt, curQty, pricePrecision));
            int curUnitAmtIndex = this.getSourceRowMeta().getFieldIndex("curunitamt");
            row.set(curUnitAmtIndex, (Object)CostRedutionDealFuncyion.getDevideCal(curAmt, curHeadQty, precision));
            if (this.costReductionRptParam.isViewTotal()) {
                int sumQtyIndex = this.getSourceRowMeta().getFieldIndex("sumqty");
                BigDecimal sumQty = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(sumQtyIndex));
                int sumAmtIndex = this.getSourceRowMeta().getFieldIndex("sumamt");
                BigDecimal sumAmt = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(sumAmtIndex));
                int sumPerQtyIndex = this.getSourceRowMeta().getFieldIndex("sumperqty");
                row.set(sumPerQtyIndex, (Object)CostRedutionDealFuncyion.getDevideCal(sumQty, yearHeadSumQty, 10));
                int sumPriceIndex = this.getSourceRowMeta().getFieldIndex("sumprice");
                row.set(sumPriceIndex, (Object)CostRedutionDealFuncyion.getDevideCal(sumAmt, sumQty, pricePrecision));
                int sumUnitAmtIndex = this.getSourceRowMeta().getFieldIndex("sumunitamt");
                row.set(sumUnitAmtIndex, (Object)CostRedutionDealFuncyion.getDevideCal(sumAmt, yearHeadSumQty, precision));
            }
            if (this.costReductionRptParam.getViewTransinCost()) {
                int transinQtyIndex = this.getSourceRowMeta().getFieldIndex("transinqty");
                BigDecimal transinQty = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(transinQtyIndex));
                int transinAmtIndex = this.getSourceRowMeta().getFieldIndex("transinamt");
                BigDecimal transinAmt = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(transinAmtIndex));
                int transinPerQtyIndex = this.getSourceRowMeta().getFieldIndex("transinperqty");
                row.set(transinPerQtyIndex, (Object)CostRedutionDealFuncyion.getDevideCal(transinQty, transinHeadQty, 10));
                int transinPriceIndex = this.getSourceRowMeta().getFieldIndex("transinprice");
                row.set(transinPriceIndex, (Object)CostRedutionDealFuncyion.getDevideCal(transinAmt, transinQty, pricePrecision));
                int transinUnitAmtIndex = this.getSourceRowMeta().getFieldIndex("transinunitamt");
                row.set(transinUnitAmtIndex, (Object)CostRedutionDealFuncyion.getDevideCal(transinAmt, transinHeadQty, precision));
            }
            if (this.costReductionRptParam.getViewPurCost()) {
                int purQtyIndex = this.getSourceRowMeta().getFieldIndex("purqty");
                BigDecimal purQty = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(purQtyIndex));
                int purAmtIndex = this.getSourceRowMeta().getFieldIndex("puramt");
                BigDecimal purAmt = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(purAmtIndex));
                int purPerQtyIndex = this.getSourceRowMeta().getFieldIndex("purperqty");
                row.set(purPerQtyIndex, (Object)CostRedutionDealFuncyion.getDevideCal(purQty, purHeadQty, 10));
                int purPriceIndex = this.getSourceRowMeta().getFieldIndex("purprice");
                row.set(purPriceIndex, (Object)CostRedutionDealFuncyion.getDevideCal(purAmt, purQty, pricePrecision));
                int purUnitAmtIndex = this.getSourceRowMeta().getFieldIndex("purunitamt");
                row.set(purUnitAmtIndex, (Object)CostRedutionDealFuncyion.getDevideCal(purAmt, purHeadQty, precision));
            }
            collector.collect(row);
        }
    }

    private static BigDecimal getDevideCal(BigDecimal divider, BigDecimal dividend, int precision) {
        if (dividend.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return divider.divide(dividend, precision, 4);
    }
}

