/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.restore.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.utils.BigDecimalUtils;

public class DiffResultCompRptCalcSubTotalFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private int priceprecision = 4;
    private Set<String> qtyCols = new HashSet<String>();
    private static final String[] qtyArray = new String[]{"startqty", "currqty", "compqty", "endqty", "totalqty"};

    public DiffResultCompRptCalcSubTotalFunction(int priceprecision, Set<String> qtyCols) {
        this.priceprecision = priceprecision;
        this.qtyCols = qtyCols;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList listRows = Lists.newArrayList();
        for (RowX rowX : iterable) {
            listRows.add(rowX);
        }
        RowX compRow = null;
        for (RowX row : listRows) {
            if (!"1".equals(row.getString(this.sourceRowMeta.getFieldIndex("datatype")))) continue;
            compRow = row;
        }
        if (compRow == null) {
            compRow = ((RowX)listRows.get(0)).copy();
            for (String col : this.qtyCols) {
                compRow.set(this.sourceRowMeta.getFieldIndex(col), (Object)BigDecimal.ZERO);
            }
        }
        HashSet<String> hashSet = new HashSet<String>(this.qtyCols);
        hashSet.removeAll(Arrays.asList(qtyArray));
        for (RowX row : listRows) {
            if ("1".equals(row.getString(this.sourceRowMeta.getFieldIndex("datatype")))) continue;
            for (String col : hashSet) {
                int index = this.sourceRowMeta.getFieldIndex(col);
                BigDecimal amt = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)compRow.getBigDecimal(index));
                compRow.set(index, (Object)amt.add(BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal(index))));
            }
        }
        this.setUnitPrice("start", compRow, compRow);
        this.setUnitPrice("curr", compRow, compRow);
        this.setUnitPrice("comp", compRow, compRow);
        this.setUnitPrice("end", compRow, compRow);
        this.setUnitPrice("total", compRow, compRow);
        for (RowX row : listRows) {
            if ("1".equals(row.getString(this.sourceRowMeta.getFieldIndex("datatype")))) continue;
            this.setUnitPrice("start", compRow, row);
            this.setUnitPrice("curr", compRow, row);
            this.setUnitPrice("comp", compRow, row);
            this.setUnitPrice("end", compRow, row);
            this.setUnitPrice("total", compRow, row);
        }
        for (RowX row : listRows) {
            if ("1".equals(row.getString(this.sourceRowMeta.getFieldIndex("datatype")))) continue;
            collector.collect(row);
        }
        collector.collect(compRow);
    }

    private void setUnitPrice(String startPre, RowX compRowX, RowX detailRowX) {
        BigDecimal qty = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)compRowX.getBigDecimal(this.sourceRowMeta.getFieldIndex(String.format("%sqty", startPre))));
        if (BigDecimal.ZERO.compareTo(qty) != 0) {
            BigDecimal amt = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)detailRowX.getBigDecimal(this.sourceRowMeta.getFieldIndex(String.format("%samt", startPre))));
            BigDecimal actcostupamt = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)detailRowX.getBigDecimal(this.sourceRowMeta.getFieldIndex(String.format("%sactcostupamt", startPre))));
            BigDecimal price = amt.divide(qty, this.priceprecision, 4);
            detailRowX.set(this.sourceRowMeta.getFieldIndex(startPre + "price"), (Object)price);
            BigDecimal actprice = actcostupamt.divide(qty, this.priceprecision, 4);
            detailRowX.set(this.sourceRowMeta.getFieldIndex(startPre + "actprice"), (Object)actprice);
        }
    }
}

