/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.restore.function;

import java.math.BigDecimal;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import org.apache.commons.lang3.StringUtils;

public class DiffResultCompRptCalcUnitFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private String keyPre = "";
    private int priceprecision = 4;

    public DiffResultCompRptCalcUnitFunction(int priceprecision) {
        this.priceprecision = priceprecision;
    }

    public DiffResultCompRptCalcUnitFunction(int priceprecision, String keyPre) {
        this.priceprecision = priceprecision;
        if (StringUtils.isNotEmpty((CharSequence)keyPre)) {
            this.keyPre = keyPre;
        }
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public RowX map(RowX paramRowX) {
        this.setUnitPrice("start", paramRowX);
        this.setUnitPrice("curr", paramRowX);
        this.setUnitPrice("comp", paramRowX);
        this.setUnitPrice("end", paramRowX);
        this.setUnitPrice("total", paramRowX);
        return paramRowX;
    }

    private void setUnitPrice(String startPre, RowX paramRowX) {
        BigDecimal qty = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)paramRowX.getBigDecimal(this.sourceRowMeta.getFieldIndex(String.format("%s%sqty", this.keyPre, startPre))));
        if (BigDecimal.ZERO.compareTo(qty) != 0) {
            BigDecimal amt = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)paramRowX.getBigDecimal(this.sourceRowMeta.getFieldIndex(String.format("%samt", startPre))));
            BigDecimal actcostupamt = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)paramRowX.getBigDecimal(this.sourceRowMeta.getFieldIndex(String.format("%sactcostupamt", startPre))));
            BigDecimal price = amt.divide(qty, this.priceprecision, 4);
            paramRowX.set(this.sourceRowMeta.getFieldIndex(startPre + "price"), (Object)price);
            BigDecimal actprice = actcostupamt.divide(qty, this.priceprecision, 4);
            paramRowX.set(this.sourceRowMeta.getFieldIndex(startPre + "actprice"), (Object)actprice);
        }
    }
}

