/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.restore.handle;

import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.report.restore.model.DiffResultCompParam;

public class DiffResultCompRptHandleFinalRow
implements IDataXTransform {
    private ReportDataCtx ctx;
    private DiffResultCompParam reportParam;

    public DiffResultCompRptHandleFinalRow(DiffResultCompParam reportParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.reportParam = reportParam;
    }

    public DataSetX doTransform(DataSetX srcDataDsx) {
        if (this.reportParam.isShowDetail() && this.ctx.getShowKeyCols().contains("materialgroup")) {
            DataSet materialDs = MaterialGroupHelper.getClassifiedMaterialDataSet((long)this.reportParam.getMaterialgrpstd(), this.reportParam.getMatGroupIds());
            materialDs = materialDs.select("material,materialgroup,materialgroupnumber as materialgroupnum");
            DataSetX materialDsX = this.ctx.getCurrentJob().fromInput((Input)new DataSetInput(materialDs));
            srcDataDsx = srcDataDsx.removeFields(new String[]{"materialgroup", "materialgroupnum"});
            DataSetX materialNullDsx = srcDataDsx.filter("material=0").addFields(new Field[]{new Field("isresource", (DataType)DataType.StringType)}, new Object[]{"1"});
            DataSetX materialNotNullDsx = srcDataDsx.filter("material>0").addFields(new Field[]{new Field("isresource", (DataType)DataType.StringType)}, new Object[]{"0"});
            final int materialNumIndex = materialNullDsx.getRowMeta().getFieldIndex("materialnum", false);
            int productIndex = materialNullDsx.getRowMeta().getFieldIndex("product", false);
            final int productNumIndex = materialNullDsx.getRowMeta().getFieldIndex("productnum", false);
            if (productIndex >= 0) {
                materialNullDsx = materialNullDsx.map(new MapFunction(){
                    private static final long serialVersionUID = 1L;

                    public RowMeta getResultRowMeta() {
                        return this.sourceRowMeta;
                    }

                    public RowX map(RowX row) {
                        Long materialId = row.getLong(this.getSourceRowMeta().getFieldIndex("material"));
                        if (CadEmptyUtils.isEmpty((Long)materialId)) {
                            row.set(this.getSourceRowMeta().getFieldIndex("material"), row.get(this.getSourceRowMeta().getFieldIndex("product")));
                            if (materialNumIndex >= 0 && productNumIndex >= 0) {
                                row.set(this.getSourceRowMeta().getFieldIndex("materialnum"), row.get(this.getSourceRowMeta().getFieldIndex("productnum")));
                            }
                        }
                        return row;
                    }
                });
            }
            srcDataDsx = materialNullDsx.union(materialNotNullDsx);
            srcDataDsx = srcDataDsx.join(materialDsX).on("material", "material").select(srcDataDsx.getRowMeta().getFieldNames(), new String[]{"materialgroup", "materialgroupnum"});
            srcDataDsx = srcDataDsx.map(new MapFunction(){
                private static final long serialVersionUID = 1L;

                public RowX map(RowX row) {
                    int isresourceIndex = this.getSourceRowMeta().getFieldIndex("isresource", false);
                    int materialIndex = this.getSourceRowMeta().getFieldIndex("material", false);
                    int materialNumIndex = this.getSourceRowMeta().getFieldIndex("materialnum", false);
                    if (isresourceIndex < 0 || materialIndex < 0 || materialNumIndex < 0) {
                        return row;
                    }
                    Boolean isResource = row.getBoolean(isresourceIndex);
                    if (isResource.booleanValue()) {
                        row.set(this.getSourceRowMeta().getFieldIndex("material"), (Object)0L);
                        row.set(this.getSourceRowMeta().getFieldIndex("materialnum"), (Object)" ");
                    }
                    return row;
                }

                public RowMeta getResultRowMeta() {
                    return this.sourceRowMeta;
                }
            });
        }
        srcDataDsx.removeFields(new String[]{"isresource"});
        return srcDataDsx;
    }
}

