/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.restore.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IFilter;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.report.restore.handle.PurDiffAllocRptHandleFinalRow;
import kd.macc.sca.report.restore.handle.PurDiffAllocRptHandleGroupRow;
import kd.macc.sca.report.restore.handle.PurDiffAllocRptHandleSumRow;
import kd.macc.sca.report.restore.model.PurDiffAllocParam;
import kd.macc.sca.report.restore.model.PurDiffAllocRptConstant;

public class PurDiffAllocSourceCf
implements IReportDataHandle {
    private final Log logger = LogFactory.getLog(PurDiffAllocSourceCf.class);
    public static final List<String> ADD_NUM_FIELDS = Arrays.asList("costcenter", "costobject", "product", "element", "subelement", "material", "materialgroup");
    private PurDiffAllocParam reportParam;

    public void setupCtx(ReportDataCtx ctx) {
        this.logger.info("\u5f00\u59cb\u8bbe\u7f6e\u4e0a\u4e0b\u6587");
        this.reportParam = (PurDiffAllocParam)ctx.getParam(PurDiffAllocParam.class.getName());
        ctx.setShowBlockEntity(false);
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getFixedFilter());
        } else {
            fixedFs.addAll(this.getFixedFilter());
        }
        this.dealDimension(ctx, this.reportParam);
    }

    private void dealDimension(ReportDataCtx ctx, PurDiffAllocParam reportParam) {
        List<String> allkeyCols = PurDiffAllocSourceCf.filterBigtableCols(ctx.getReportConf(), null);
        reportParam.setAllKeyCols(allkeyCols);
        ctx.getShowKeyCols().add("currency");
        ctx.getShowKeyCols().add("datalinetype");
        reportParam.getNeedClearFields().add("datalinetype");
        for (String field : ADD_NUM_FIELDS) {
            if (!ctx.getShowKeyCols().contains(field)) continue;
            ctx.getShowKeyCols().add(field + "num");
        }
        if (ctx.getShowKeyCols().contains("material")) {
            ctx.getShowKeyCols().add("unit");
        }
        if (ctx.getShowKeyCols().contains("materialgroup") && ctx.getShowKeyCols().add("material")) {
            reportParam.getNeedClearFields().add("material");
        }
    }

    public static List<String> filterBigtableCols(ReportConf conf, IFilter<BigTableColConf> filter) {
        List bigTableColConf = conf.getBigTableColConf();
        ArrayList<String> fsCol = new ArrayList<String>(10);
        for (BigTableColConf colConf : bigTableColConf) {
            if (filter == null) {
                fsCol.add(colConf.getCol());
                continue;
            }
            if (!filter.filter((Object)colConf)) continue;
            fsCol.add(colConf.getCol());
        }
        return fsCol;
    }

    private List<QFilter> getFixedFilter() {
        ArrayList<QFilter> commonFilters = new ArrayList<QFilter>(10);
        commonFilters.add(new QFilter("org", "in", this.reportParam.getOrgIds()));
        commonFilters.add(new QFilter("costaccount", "in", this.reportParam.getCostaccountIds()));
        if (this.reportParam.getStartperiod().equals(this.reportParam.getEndperiod())) {
            commonFilters.add(new QFilter("period", "=", (Object)this.reportParam.getStartperiod()));
        } else {
            commonFilters.add(new QFilter("period", ">=", (Object)this.reportParam.getStartperiod()));
            commonFilters.add(new QFilter("period", "<=", (Object)this.reportParam.getEndperiod()));
        }
        if (!CadEmptyUtils.isEmpty(this.reportParam.getCostobjectIds())) {
            Set<Long> objectIds = PurDiffAllocSourceCf.getDiffCalcResultMainCostObjectId(commonFilters, this.reportParam.getCostobjectIds());
            commonFilters.add(new QFilter("maincostobject", "in", objectIds));
        }
        if (!CadEmptyUtils.isEmpty(this.reportParam.getCostcenterIds())) {
            commonFilters.add(new QFilter("costcenter", "in", this.reportParam.getCostcenterIds()));
        }
        if ("A".equals(this.reportParam.getBizstatus()) || "B".equals(this.reportParam.getBizstatus())) {
            commonFilters.add(new QFilter("bizstatus", "=", (Object)this.reportParam.getBizstatus()));
        }
        if (!CadEmptyUtils.isEmpty(this.reportParam.getProductIds())) {
            commonFilters.add(new QFilter("product", "in", this.reportParam.getProductIds()));
        }
        if (!CadEmptyUtils.isEmpty(this.reportParam.getMaterials())) {
            commonFilters.add(new QFilter("material", "in", this.reportParam.getMaterials()));
        }
        if (this.reportParam.getMaterialgrpstd() == 730148448254487552L) {
            if (!CadEmptyUtils.isEmpty(this.reportParam.getMatGroupIds())) {
                commonFilters.add(new QFilter("materialgroup", "in", this.reportParam.getMatGroupIds()));
            } else {
                commonFilters.add(new QFilter("material", ">", (Object)0L));
            }
        }
        return commonFilters;
    }

    private static Set<Long> getDiffCalcResultMainCostObjectId(List<QFilter> filters, Object costobjectVal) {
        ArrayList<QFilter> csfilters = new ArrayList<QFilter>(filters);
        csfilters.add(new QFilter("entryentity2.relacostobject2", "in", costobjectVal));
        DataSet ds = QueryServiceHelper.queryDataSet((String)"diffcalcresult", (String)"sca_diffcalcresult", (String)"costobject", (QFilter[])csfilters.toArray(new QFilter[0]), null);
        ds = ds.groupBy(new String[]{"costobject"}).finish();
        HashSet<Long> objectIds = new HashSet<Long>(16);
        for (Row row : ds) {
            objectIds.add(row.getLong("costobject"));
        }
        return objectIds;
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        super.transFormAfterGroup(transCollector, ctx);
        ctx.logInfo((Object)ResManager.loadKDString((String)"\u5904\u7406\u6570\u636e\u5757\u6570\u636e", (String)"PurDiffAllocSourceCf_0", (String)"macc-sca-report", (Object[])new Object[0]));
        transCollector.add(new PurDiffAllocRptHandleFinalRow(this.reportParam, ctx));
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        super.beforeGroupData(ctx);
        ctx.setGroupPlans(null);
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        super.transFormAfterGroup(transCollector, ctx);
        transCollector.add(new PurDiffAllocRptHandleGroupRow(this.reportParam, ctx));
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new PurDiffAllocRptHandleSumRow(this.reportParam, ctx));
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        this.logger.info("\u914d\u7f6e\u5217\u662f\u5426\u663e\u793a ");
        ReportColumnGroup startdiff = new ReportColumnGroup();
        startdiff.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0b\u9636\u5dee\u5f02-\u671f\u521d\u5728\u4ea7\u54c1", (String)"PurDiffAllocSourceCf_6", (String)"macc-sca-report", (Object[])new Object[0])));
        startdiff.setFieldKey("startdiff");
        ReportColumnGroup currdiff = new ReportColumnGroup();
        currdiff.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0b\u9636\u5dee\u5f02-\u672c\u671f\u6295\u5165", (String)"PurDiffAllocSourceCf_7", (String)"macc-sca-report", (Object[])new Object[0])));
        currdiff.setFieldKey("currdiff");
        ReportColumnGroup compdiff = new ReportColumnGroup();
        compdiff.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0b\u9636\u5dee\u5f02-\u672c\u671f\u5dee\u5f02\u8f6c\u51fa", (String)"PurDiffAllocSourceCf_8", (String)"macc-sca-report", (Object[])new Object[0])));
        compdiff.setFieldKey("compdiff");
        ReportColumnGroup enddiff = new ReportColumnGroup();
        enddiff.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0b\u9636\u5dee\u5f02-\u671f\u672b\u5728\u4ea7\u54c1", (String)"PurDiffAllocSourceCf_9", (String)"macc-sca-report", (Object[])new Object[0])));
        enddiff.setFieldKey("enddiff");
        ReportColumnGroup totaldiff = new ReportColumnGroup();
        totaldiff.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0b\u9636\u5dee\u5f02-\u7d2f\u8ba1\u5dee\u5f02\u8f6c\u51fa", (String)"PurDiffAllocSourceCf_10", (String)"macc-sca-report", (Object[])new Object[0])));
        totaldiff.setFieldKey("totaldiff");
        Iterator<AbstractReportColumn> iterator = cols.iterator();
        while (iterator.hasNext()) {
            ReportColumn repCol = (ReportColumn)iterator.next();
            String fieldKey = repCol.getFieldKey();
            if (!this.reportParam.getDiffTypes().contains("P") && PurDiffAllocRptConstant.diffTypes_P_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("Q") && PurDiffAllocRptConstant.diffTypes_Q_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("S") && PurDiffAllocRptConstant.diffTypes_S_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("R") && PurDiffAllocRptConstant.diffTypes_R_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("M") && PurDiffAllocRptConstant.diffTypes_M_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("G") && PurDiffAllocRptConstant.diffTypes_G_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("H") && PurDiffAllocRptConstant.diffTypes_H_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("K") && PurDiffAllocRptConstant.diffTypes_K_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("C") && PurDiffAllocRptConstant.diffTypes_C_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("T") && PurDiffAllocRptConstant.diffTypes_T_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("X") && PurDiffAllocRptConstant.diffTypes_X_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("W") && PurDiffAllocRptConstant.diffTypes_W_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if (!this.reportParam.getDiffTypes().contains("Y") && PurDiffAllocRptConstant.diffTypes_Y_Hide.contains(fieldKey)) {
                iterator.remove();
                continue;
            }
            if ("currency".equals(fieldKey)) {
                repCol.setHide(true);
                continue;
            }
            if (PurDiffAllocRptConstant.qtyField.contains(fieldKey) && ctx.getShowKeyCols().contains("unit")) {
                repCol.setMeasureUnitField("unit");
            }
            if ("amount".equals(repCol.getFieldType()) && ctx.getShowKeyCols().contains("currency")) {
                repCol.setCurrencyField("currency");
            }
            if (fieldKey.startsWith("start")) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                startdiff.getChildren().add(repCol);
                iterator.remove();
            }
            if (fieldKey.startsWith("curr")) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                currdiff.getChildren().add(repCol);
                iterator.remove();
            }
            if (fieldKey.startsWith("comp")) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                compdiff.getChildren().add(repCol);
                iterator.remove();
            }
            if (fieldKey.startsWith("end")) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                enddiff.getChildren().add(repCol);
                iterator.remove();
            }
            if (!fieldKey.startsWith("total")) continue;
            repCol.setNoDisplayScaleZero(false);
            repCol.setZeroShow(false);
            repCol.setHideSingleColumnRow(false);
            totaldiff.getChildren().add(repCol);
            iterator.remove();
        }
        cols.add((AbstractReportColumn)startdiff);
        cols.add((AbstractReportColumn)currdiff);
        cols.add((AbstractReportColumn)compdiff);
        cols.add((AbstractReportColumn)enddiff);
        cols.add((AbstractReportColumn)totaldiff);
        return cols;
    }
}

