/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.common.costcalc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.sca.common.costcalc.CalcResultEntryRow;
import kd.macc.sca.common.costcalc.CalcResultMfgEntryRow;

@DataEntityTypeAttribute(tableName="t_sca_calcresult", dbRouteKey="cal")
public class CalcResultHeader {
    private long id;
    private String billNo;
    private String billStatus;
    private String bizStatus;
    private long creator;
    private long modifier;
    private long auditor;
    private Date createTime;
    private Date modifyTime;
    private Date auditDate;
    private long org;
    private long costAccount;
    private long costCenter;
    private long costObject;
    private long currency;
    private long period;
    private Date bizDate;
    private long srcbill;
    private List<CalcResultEntryRow> entryRows = new ArrayList<CalcResultEntryRow>();
    private List<CalcResultMfgEntryRow> mfgEntryRows = new ArrayList<CalcResultMfgEntryRow>();
    private CalcResultEntryRow totalRow;
    private static final IDataEntityType dataEntityType = OrmUtils.getDataEntityType(CalcResultHeader.class);

    public static IDataEntityType getDataEntityType() {
        return dataEntityType;
    }

    public CalcResultHeader() {
        String userId = RequestContext.get().getUserId();
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            this.creator = Long.parseLong(userId);
        }
        this.createTime = TimeServiceHelper.now();
    }

    @SimplePropertyAttribute(isPrimaryKey=true, alias="fid", dbType=-5)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @SimplePropertyAttribute(alias="fbillno", dbType=12)
    public String getBillNo() {
        return this.billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    @SimplePropertyAttribute(alias="fbillstatus", dbType=1)
    public String getBillStatus() {
        return this.billStatus;
    }

    public void setBillStatus(String billStatus) {
        this.billStatus = billStatus;
    }

    @SimplePropertyAttribute(alias="fbizstatus", dbType=1)
    public String getBizStatus() {
        return this.bizStatus;
    }

    public void setBizStatus(String bizStatus) {
        this.bizStatus = bizStatus;
    }

    @SimplePropertyAttribute(alias="fcreatorid", dbType=-5)
    public long getCreator() {
        return this.creator;
    }

    public void setCreator(long creator) {
        this.creator = creator;
    }

    @SimplePropertyAttribute(alias="fcreatetime", dbType=91)
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @SimplePropertyAttribute(alias="fmodifierid", dbType=-5)
    public long getModifier() {
        return this.modifier;
    }

    public void setModifier(long modifier) {
        this.modifier = modifier;
    }

    @SimplePropertyAttribute(alias="fmodifytime", dbType=91)
    public Date getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    @SimplePropertyAttribute(alias="fauditorid", dbType=-5)
    public long getAuditor() {
        return this.auditor;
    }

    public void setAuditor(long auditor) {
        this.auditor = auditor;
    }

    @SimplePropertyAttribute(alias="fauditdate", dbType=91)
    public Date getAuditDate() {
        return this.auditDate;
    }

    public void setAuditDate(Date auditDate) {
        this.auditDate = auditDate;
    }

    @SimplePropertyAttribute(alias="forgid", dbType=-5)
    public long getOrg() {
        return this.org;
    }

    public void setOrg(long org) {
        this.org = org;
    }

    @SimplePropertyAttribute(alias="fcostaccountid", dbType=-5)
    public long getCostAccount() {
        return this.costAccount;
    }

    public void setCostAccount(long costAccount) {
        this.costAccount = costAccount;
    }

    @SimplePropertyAttribute(alias="fcostcenterid", dbType=-5)
    public long getCostCenter() {
        return this.costCenter;
    }

    public void setCostCenter(long costCenter) {
        this.costCenter = costCenter;
    }

    @SimplePropertyAttribute(alias="fcostobjectid", dbType=-5)
    public long getCostObject() {
        return this.costObject;
    }

    public void setCostObject(long costObject) {
        this.costObject = costObject;
    }

    @SimplePropertyAttribute(alias="fcurrencyid", dbType=-5)
    public long getCurrency() {
        return this.currency;
    }

    public void setCurrency(long currency) {
        this.currency = currency;
    }

    @SimplePropertyAttribute(alias="fperiodid", dbType=-5)
    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    @SimplePropertyAttribute(alias="fbizdate", dbType=91)
    public Date getBizDate() {
        return this.bizDate;
    }

    public void setBizDate(Date bizDate) {
        this.bizDate = bizDate;
    }

    @SimplePropertyAttribute(alias="fsrcbillid", dbType=-5)
    public long getSrcbill() {
        return this.srcbill;
    }

    public void setSrcbill(long srcbill) {
        this.srcbill = srcbill;
    }

    public List<CalcResultEntryRow> getEntryRows() {
        return this.entryRows;
    }

    public List<CalcResultMfgEntryRow> getMfgEntryRows() {
        return this.mfgEntryRows;
    }

    public CalcResultEntryRow addNew() {
        CalcResultEntryRow entryRow = new CalcResultEntryRow();
        entryRow.setEntryId(DBServiceHelper.genGlobalLongId());
        entryRow.setId(this.getId());
        entryRow.setSeq(this.entryRows.size() + 1);
        this.entryRows.add(entryRow);
        return entryRow;
    }

    public CalcResultMfgEntryRow addMfgFeeEntry(String mfgType) {
        CalcResultMfgEntryRow entryRow = new CalcResultMfgEntryRow();
        entryRow.setEntryId(DBServiceHelper.genGlobalLongId());
        entryRow.setType(mfgType);
        entryRow.setId(this.getId());
        entryRow.setSeq(this.mfgEntryRows.size() + 1);
        this.mfgEntryRows.add(entryRow);
        return entryRow;
    }

    public CalcResultEntryRow getTotalRow() {
        if (this.totalRow == null) {
            for (CalcResultEntryRow row : this.entryRows) {
                if (!StringUtils.equals((CharSequence)"5", (CharSequence)row.getCalType())) continue;
                this.totalRow = row;
                break;
            }
        }
        return this.totalRow;
    }

    public BigDecimal getTotalRowTotalAmt() {
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (CalcResultEntryRow row : this.entryRows) {
            if (!StringUtils.equals((CharSequence)"5", (CharSequence)row.getCalType()) || row.getTotalAmount() == null) continue;
            totalAmt = totalAmt.add(row.getTotalAmount());
        }
        return totalAmt;
    }

    public BigDecimal getTotalRowStdTotalAmt() {
        BigDecimal stdTotalAmt = BigDecimal.ZERO;
        for (CalcResultEntryRow row : this.entryRows) {
            if (!StringUtils.equals((CharSequence)"5", (CharSequence)row.getCalType()) || row.getStdAmount() == null) continue;
            stdTotalAmt = stdTotalAmt.add(row.getStdAmount());
        }
        return stdTotalAmt;
    }

    public void setTotalRow(CalcResultEntryRow totalRow) {
        this.totalRow = totalRow;
    }

    public List<CalcResultEntryRow> clearSpecialEntry(String delCalType, String delDataType) {
        ArrayList<CalcResultEntryRow> delRows = new ArrayList<CalcResultEntryRow>();
        for (int i = this.entryRows.size() - 1; i >= 0; --i) {
            CalcResultEntryRow entryRow = this.entryRows.get(i);
            boolean isDel = false;
            if (StringUtils.isEmpty((CharSequence)delCalType)) {
                isDel = StringUtils.equals((CharSequence)delDataType, (CharSequence)entryRow.getDataType()) && !"3".equals(entryRow.getDiffType());
            } else {
                boolean bl = isDel = StringUtils.equals((CharSequence)delCalType, (CharSequence)entryRow.getCalType()) && !"3".equals(entryRow.getDiffType());
                if (isDel && !StringUtils.isEmpty((CharSequence)delDataType)) {
                    boolean bl2 = isDel = isDel && StringUtils.equals((CharSequence)delDataType, (CharSequence)entryRow.getDataType()) && !"3".equals(entryRow.getDiffType());
                }
            }
            if (!isDel) continue;
            delRows.add(entryRow);
            this.entryRows.remove(i);
        }
        return delRows;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("org").append("=").append(this.org).append(",");
        sb.append("costAccount").append("=").append(this.costAccount).append(",");
        sb.append("costCenter").append("=").append(this.costCenter).append(",");
        sb.append("costObject").append("=").append(this.costObject).append(",");
        sb.append("period").append("=").append(this.period).append(",");
        sb.append("currency").append("=").append(this.currency);
        sb.append("}");
        return sb.toString();
    }
}

