/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.common.costcalc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;

@DataEntityTypeAttribute(tableName="T_SCA_UNABSORBENTRY", dbRouteKey="cal")
public class CalcResultMfgEntryRow {
    private long entryId;
    private long id;
    private int seq;
    private String type;
    private long costObjectId;
    private String productType;
    private long mfgElement;
    private long mfgSubElement;
    private BigDecimal mfgPdStartQty = BigDecimal.ZERO;
    private BigDecimal mfgPdStartAmt = BigDecimal.ZERO;
    private BigDecimal mfgPdCurrQty = BigDecimal.ZERO;
    private BigDecimal mfgPdCurrAmt = BigDecimal.ZERO;
    private BigDecimal mfgPdEndQty = BigDecimal.ZERO;
    private BigDecimal mfgPdEndAmt = BigDecimal.ZERO;
    private BigDecimal mfgPdDiffQty = BigDecimal.ZERO;
    private BigDecimal mfgPdDiffAmt = BigDecimal.ZERO;
    private BigDecimal mfgTotalDiffQty = BigDecimal.ZERO;
    private BigDecimal mfgTotalDiffAmt = BigDecimal.ZERO;
    private BigDecimal mfgPreTotalDiffQty = BigDecimal.ZERO;
    private BigDecimal mfgPreTotalDiffAmt = BigDecimal.ZERO;
    private String mfgSourceInfo;
    private List<TakeValInfo> takeValInfos = new ArrayList<TakeValInfo>();
    private static final IDataEntityType dataEntityType = OrmUtils.getDataEntityType(CalcResultMfgEntryRow.class);

    @SimplePropertyAttribute(isPrimaryKey=true, alias="fentryid", dbType=-5)
    public long getEntryId() {
        return this.entryId;
    }

    public void setEntryId(long entryId) {
        this.entryId = entryId;
    }

    @SimplePropertyAttribute(alias="fid", dbType=-5)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @SimplePropertyAttribute(alias="fseq", dbType=4)
    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    @SimplePropertyAttribute(alias="ftype", dbType=1)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @SimplePropertyAttribute(alias="felementid", dbType=-5)
    public long getMfgElement() {
        return this.mfgElement;
    }

    public void setMfgElement(long mfgElement) {
        this.mfgElement = mfgElement;
    }

    @SimplePropertyAttribute(alias="fsubelementid", dbType=-5)
    public long getMfgSubElement() {
        return this.mfgSubElement;
    }

    public void setMfgSubElement(long mfgSubElement) {
        this.mfgSubElement = mfgSubElement;
    }

    @SimplePropertyAttribute(alias="fpdstartqty", dbType=3)
    public BigDecimal getMfgPdStartQty() {
        return this.mfgPdStartQty;
    }

    public void setMfgPdStartQty(BigDecimal mfgPdStartQty) {
        if (mfgPdStartQty != null) {
            this.mfgPdStartQty = mfgPdStartQty;
        }
    }

    @SimplePropertyAttribute(alias="fpdstartamt", dbType=3)
    public BigDecimal getMfgPdStartAmt() {
        return this.mfgPdStartAmt;
    }

    public void setMfgPdStartAmt(BigDecimal mfgPdStartAmt) {
        if (mfgPdStartAmt != null) {
            this.mfgPdStartAmt = mfgPdStartAmt;
        }
    }

    public void addMfgPdStartAmt(BigDecimal mfgPdStartAmt) {
        if (mfgPdStartAmt != null) {
            this.mfgPdStartAmt = this.addBigDecimal(this.mfgPdStartAmt, mfgPdStartAmt);
        }
    }

    @SimplePropertyAttribute(alias="fpdcurrqty", dbType=3)
    public BigDecimal getMfgPdCurrQty() {
        return this.mfgPdCurrQty;
    }

    public void addMfgPdCurrQty(BigDecimal mfgPdCurrQty) {
        if (mfgPdCurrQty != null) {
            this.mfgPdCurrQty = this.addBigDecimal(this.mfgPdCurrQty, mfgPdCurrQty);
        }
    }

    public void setMfgPdCurrQty(BigDecimal mfgPdCurrQty) {
        if (mfgPdCurrQty != null) {
            this.mfgPdCurrQty = mfgPdCurrQty;
        }
    }

    @SimplePropertyAttribute(alias="fpdcurramt", dbType=3)
    public BigDecimal getMfgPdCurrAmt() {
        return this.mfgPdCurrAmt;
    }

    public void addMfgPdCurrAmt(BigDecimal mfgPdCurrAmt) {
        if (mfgPdCurrAmt != null) {
            this.mfgPdCurrAmt = this.addBigDecimal(this.mfgPdCurrAmt, mfgPdCurrAmt);
        }
    }

    public void setMfgPdCurrAmt(BigDecimal mfgPdCurrAmt) {
        if (mfgPdCurrAmt != null) {
            this.mfgPdCurrAmt = mfgPdCurrAmt;
        }
    }

    @SimplePropertyAttribute(alias="fpdendqty", dbType=3)
    public BigDecimal getMfgPdEndQty() {
        return this.mfgPdEndQty;
    }

    public void addMfgPdEndQty(BigDecimal mfgPdEndQty) {
        if (mfgPdEndQty != null) {
            this.mfgPdEndQty = this.addBigDecimal(this.mfgPdEndQty, mfgPdEndQty);
        }
    }

    public void setMfgPdEndQty(BigDecimal mfgPdEndQty) {
        if (mfgPdEndQty != null) {
            this.mfgPdEndQty = mfgPdEndQty;
        }
    }

    @SimplePropertyAttribute(alias="fpdendamt", dbType=3)
    public BigDecimal getMfgPdEndAmt() {
        return this.mfgPdEndAmt;
    }

    public void addMfgPdEndAmt(BigDecimal mfgPdEndAmt) {
        if (mfgPdEndAmt != null) {
            this.mfgPdEndAmt = this.addBigDecimal(this.mfgPdEndAmt, mfgPdEndAmt);
        }
    }

    public void setMfgPdEndAmt(BigDecimal mfgPdEndAmt) {
        if (mfgPdEndAmt != null) {
            this.mfgPdEndAmt = mfgPdEndAmt;
        }
    }

    @SimplePropertyAttribute(alias="fpddiffqty", dbType=3)
    public BigDecimal getMfgPdDiffQty() {
        return this.mfgPdDiffQty;
    }

    public void addMfgPdDiffQty(BigDecimal mfgPdDiffQty) {
        if (mfgPdDiffQty != null) {
            this.mfgPdDiffQty = this.addBigDecimal(this.mfgPdDiffQty, mfgPdDiffQty);
        }
    }

    public void setMfgPdDiffQty(BigDecimal mfgPdDiffQty) {
        if (mfgPdDiffQty != null) {
            this.mfgPdDiffQty = mfgPdDiffQty;
        }
    }

    @SimplePropertyAttribute(alias="fpddiffamt", dbType=3)
    public BigDecimal getMfgPdDiffAmt() {
        return this.mfgPdDiffAmt;
    }

    public void addMfgPdDiffAmt(BigDecimal mfgPdDiffAmt) {
        if (mfgPdDiffAmt != null) {
            this.mfgPdDiffAmt = this.addBigDecimal(this.mfgPdDiffAmt, mfgPdDiffAmt);
        }
    }

    public void setMfgPdDiffAmt(BigDecimal mfgPdDiffAmt) {
        if (mfgPdDiffAmt != null) {
            this.mfgPdDiffAmt = mfgPdDiffAmt;
        }
    }

    @SimplePropertyAttribute(alias="ftotaldiffqty", dbType=3)
    public BigDecimal getMfgTotalDiffQty() {
        return this.mfgTotalDiffQty;
    }

    public void addMfgTotalDiffQty(BigDecimal mfgTotalDiffQty) {
        if (mfgTotalDiffQty != null) {
            this.mfgTotalDiffQty = this.addBigDecimal(this.mfgTotalDiffQty, mfgTotalDiffQty);
        }
    }

    public void setMfgTotalDiffQty(BigDecimal mfgTotalDiffQty) {
        if (mfgTotalDiffQty != null) {
            this.mfgTotalDiffQty = this.addBigDecimal(this.mfgTotalDiffQty, mfgTotalDiffQty);
        }
    }

    @SimplePropertyAttribute(alias="ftotaldiffamt", dbType=3)
    public BigDecimal getMfgTotalDiffAmt() {
        return this.mfgTotalDiffAmt;
    }

    public void addMfgTotalDiffAmt(BigDecimal mfgTotalDiffAmt) {
        if (mfgTotalDiffAmt != null) {
            this.mfgTotalDiffAmt = this.addBigDecimal(this.mfgTotalDiffAmt, mfgTotalDiffAmt);
        }
    }

    public void setMfgTotalDiffAmt(BigDecimal mfgTotalDiffAmt) {
        if (mfgTotalDiffAmt != null) {
            this.mfgTotalDiffAmt = mfgTotalDiffAmt;
        }
    }

    @SimplePropertyAttribute(alias="fsourceinfo", dbType=12)
    public String getMfgSourceInfo() {
        this.rebuildSourceInfo();
        if (this.mfgSourceInfo == null) {
            this.mfgSourceInfo = "";
        }
        if (this.mfgSourceInfo.length() >= 2000) {
            return this.mfgSourceInfo.substring(0, 2000);
        }
        return this.mfgSourceInfo;
    }

    @SimplePropertyAttribute(alias="fmfgobjid", dbType=-5)
    public long getCostObjectId() {
        return this.costObjectId;
    }

    public void setCostObjectId(long costObjectId) {
        this.costObjectId = costObjectId;
    }

    @SimplePropertyAttribute(alias="fmfgprotype", dbType=1)
    public String getProductType() {
        return this.productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public void setMfgSourceInfo(String mfgSourceInfo) {
        this.mfgSourceInfo = mfgSourceInfo;
    }

    public BigDecimal getMfgPreTotalDiffQty() {
        return this.mfgPreTotalDiffQty;
    }

    public void setMfgPreTotalDiffQty(BigDecimal mfgPreTotalDiffQty) {
        if (mfgPreTotalDiffQty != null) {
            this.mfgPreTotalDiffQty = mfgPreTotalDiffQty;
        }
    }

    public BigDecimal getMfgPreTotalDiffAmt() {
        return this.mfgPreTotalDiffAmt;
    }

    public void setMfgPreTotalDiffAmt(BigDecimal mfgPreTotalDiffAmt) {
        if (mfgPreTotalDiffAmt != null) {
            this.mfgPreTotalDiffAmt = mfgPreTotalDiffAmt;
        }
    }

    public static IDataEntityType getDataEntityType() {
        return dataEntityType;
    }

    public void addTaskValInfo(String srcBill, String srcBillId, String srcField, String targetField, BigDecimal value) {
        if (value != null && value.compareTo(BigDecimal.ZERO) != 0) {
            TakeValInfo info = TakeValInfo.create(srcBill, srcBillId, srcField, targetField, value);
            this.takeValInfos.add(info);
        }
    }

    public void addAllTaskValInfos(CalcResultMfgEntryRow srcRow, String targetField) {
        if (srcRow.takeValInfos.isEmpty()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)targetField)) {
            this.takeValInfos.addAll(srcRow.takeValInfos);
        } else {
            for (TakeValInfo info : srcRow.takeValInfos) {
                if (!StringUtils.equals((CharSequence)targetField, (CharSequence)info.getTargetField())) continue;
                this.takeValInfos.add(info);
            }
        }
    }

    public void addAllTaskValInfos(CalcResultMfgEntryRow srcRow, String srcField, String targetField) {
        if (srcRow.takeValInfos.isEmpty()) {
            return;
        }
        for (TakeValInfo info : srcRow.takeValInfos) {
            if (!StringUtils.equals((CharSequence)srcField, (CharSequence)info.getTargetField())) continue;
            TakeValInfo info2 = new TakeValInfo();
            info2.setSrcBill(info.srcBill);
            info2.setSrcBillId(info.srcBillId);
            info2.setSrcField(info.srcField);
            info2.setTargetField(targetField);
            info2.setValue(info.value);
            this.takeValInfos.add(info2);
        }
    }

    public void clearTaskValInfos() {
        this.takeValInfos.clear();
    }

    public void clearTaskValInfos(String targetField) {
        if (StringUtils.isBlank((CharSequence)targetField)) {
            return;
        }
        int count = this.takeValInfos.size();
        for (int i = count - 1; i >= 0; --i) {
            TakeValInfo info = this.takeValInfos.get(i);
            if (!StringUtils.equals((CharSequence)targetField, (CharSequence)info.getTargetField())) continue;
            this.takeValInfos.remove(i);
        }
    }

    private void rebuildSourceInfo() {
        if (this.takeValInfos.isEmpty()) {
            this.mfgSourceInfo = "";
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (TakeValInfo info : this.takeValInfos) {
            sb.append(info.toString()).append("\r\n");
        }
        this.mfgSourceInfo = sb.toString();
    }

    private BigDecimal addBigDecimal(BigDecimal d1, BigDecimal d2) {
        if (d1 == null && d2 == null) {
            return BigDecimal.ZERO;
        }
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        return d1.add(d2);
    }

    public String toString() {
        return "CalcResultMfgEntryRow{entryId=" + this.entryId + ", id=" + this.id + ", seq=" + this.seq + ", type='" + this.type + '\'' + ", mfgElement=" + this.mfgElement + ", mfgSubElement=" + this.mfgSubElement + ", mfgPdStartQty=" + this.mfgPdStartQty + ", mfgPdStartAmt=" + this.mfgPdStartAmt + ", mfgPdCurrQty=" + this.mfgPdCurrQty + ", mfgPdCurrAmt=" + this.mfgPdCurrAmt + ", mfgPdEndQty=" + this.mfgPdEndQty + ", mfgPdEndAmt=" + this.mfgPdEndAmt + ", mfgPdDiffQty=" + this.mfgPdDiffQty + ", mfgPdDiffAmt=" + this.mfgPdDiffAmt + ", mfgTotalDiffQty=" + this.mfgTotalDiffQty + ", mfgTotalDiffAmt=" + this.mfgTotalDiffAmt + ", mfgSourceInfo='" + this.mfgSourceInfo + '\'' + ", takeValInfos=" + this.takeValInfos + '}';
    }

    static class TakeValInfo {
        private String srcBill;
        private String srcBillId;
        private String srcField;
        private String targetField;
        private BigDecimal value;

        TakeValInfo() {
        }

        public static TakeValInfo create(String srcBill, String srcBillId, String srcField, String targetField, BigDecimal value) {
            TakeValInfo info = new TakeValInfo();
            info.setSrcBill(srcBill);
            info.setSrcBillId(srcBillId);
            info.setSrcField(srcField);
            info.setTargetField(targetField);
            info.setValue(value);
            return info;
        }

        public String getSrcBill() {
            return this.srcBill;
        }

        public void setSrcBill(String srcBill) {
            this.srcBill = srcBill;
        }

        public String getSrcBillId() {
            return this.srcBillId;
        }

        public void setSrcBillId(String srcBillId) {
            this.srcBillId = srcBillId;
        }

        public String getSrcField() {
            return this.srcField;
        }

        public void setSrcField(String srcField) {
            this.srcField = srcField;
        }

        public String getTargetField() {
            return this.targetField;
        }

        public void setTargetField(String targetField) {
            this.targetField = targetField;
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public void setValue(BigDecimal value) {
            this.value = value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getTargetField()).append(" += ");
            sb.append(this.getSrcBill()).append(".").append(this.getSrcBillId()).append(".");
            sb.append(this.getSrcField()).append(",");
            sb.append(this.getValue().toPlainString());
            return sb.toString();
        }
    }
}

