/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.common.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ImportServiceHelper {
    private static final Log logger = LogFactory.getLog(ImportServiceHelper.class);

    public static List<Long> getUserHasPermProOrgsByAccOrg(Long accOrg) {
        return ImportServiceHelper.getUserHasPermOrgs(accOrg, "04");
    }

    public static List<Long> getUserHasPermOrgsByAccOrg(Long accOrg) {
        List<Long> invOrgs = ImportServiceHelper.getUserHasPermOrgs(accOrg, "05");
        List<Long> proOrgs = ImportServiceHelper.getUserHasPermOrgs(accOrg, "04");
        invOrgs.removeAll(proOrgs);
        invOrgs.addAll(proOrgs);
        return invOrgs;
    }

    public static List<Long> getUserHasPermOrgs(Long accOrg, String type) {
        List productOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)type, (Long)accOrg, (boolean)true);
        if (CadEmptyUtils.isEmpty((List)productOrgs)) {
            return productOrgs;
        }
        List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId())).getHasPermOrgs();
        List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)type);
        if (CadEmptyUtils.isEmpty((List)permOrgIds) && CadEmptyUtils.isEmpty((List)orgIds)) {
            orgIds = OrgUnitServiceHelper.getAllOrg((String)type);
        }
        productOrgs.retainAll(orgIds);
        return productOrgs;
    }

    public static List<ComboItem> getPermProOrgsByAccOrg(Long accOrg) {
        ArrayList<ComboItem> orgItems = new ArrayList<ComboItem>();
        List<Long> userHasPermProOrgsByAccOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg(accOrg);
        QFilter qfId = new QFilter("id", "in", userHasPermProOrgsByAccOrg);
        DynamicObjectCollection org = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{qfId});
        for (DynamicObject acctOrg : org) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(acctOrg.getString("name")));
            item.setValue(acctOrg.getString("id"));
            if (orgItems.contains(item)) continue;
            orgItems.add(item);
        }
        return orgItems;
    }

    public static List<Long> getHasPermOrgIdsByOrgViewType(String orgViewTyp) {
        List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId())).getHasPermOrgs();
        List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)orgViewTyp);
        if (CadEmptyUtils.isEmpty((List)permOrgIds) && CadEmptyUtils.isEmpty((List)orgIds)) {
            orgIds = OrgUnitServiceHelper.getAllOrg((String)orgViewTyp);
        }
        return orgIds;
    }

    public static List<Long> getCostCenterByDataRule(Long userId, List<Long> accountOrgs, List<Long> costCenters, String entity, String appNum) {
        ArrayList<Long> enableCostCenters = new ArrayList<Long>(10);
        Set<Long> dyDataRuleCostCenterIds = ImportServiceHelper.getDyDataRuleCostCenter(userId, appNum, entity, "4730fc9f000003ae", accountOrgs);
        if (!CadEmptyUtils.isEmpty(dyDataRuleCostCenterIds)) {
            costCenters.forEach(p -> {
                if (dyDataRuleCostCenterIds.contains(p)) {
                    enableCostCenters.add((Long)p);
                }
            });
        } else {
            enableCostCenters.addAll(costCenters);
        }
        return enableCostCenters;
    }

    public static Set<Long> getDyDataRuleCostCenter(Long userId, String appNum, String entityName, String permItemId, List<Long> orgIds) {
        HashSet<Long> dyDataRuleCostCenterIds = new HashSet<Long>(10);
        try {
            QFilter dataRuleFilter = ImportServiceHelper.getDataRuleFiltersByImport(userId, appNum, entityName, permItemId, orgIds);
            if (dataRuleFilter == null) {
                return dyDataRuleCostCenterIds;
            }
            DynamicObjectCollection dyDataRuleCostCenters = QueryServiceHelper.query((String)"bos_costcentersourcemap", (String)"costcenter.id costcenterid", (QFilter[])new QFilter[]{dataRuleFilter});
            dyDataRuleCostCenters.forEach(p -> dyDataRuleCostCenterIds.add(p.getLong("costcenterid")));
            return dyDataRuleCostCenterIds;
        }
        catch (NumberFormatException e) {
            logger.info("\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e\u89c4\u5219\u4e2d\u7684\u6210\u672c\u4e2d\u5fc3" + e.getMessage());
            return dyDataRuleCostCenterIds;
        }
    }

    public static QFilter getDataRuleFiltersByImport(Long userId, String appId, String entityNum, String permItemId, List<Long> orgIds) {
        boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)userId, (String)appId, (String)entityNum, (String)permItemId);
        if (!hasPerm) {
            return null;
        }
        return ImportServiceHelper.getDataRuleFilters(userId, appId, entityNum, permItemId, orgIds);
    }

    public static QFilter getDataRuleFilters(Long userId, String appId, String entityNum, String permItemId, List<Long> orgIds) {
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        return permissionService.getDataRuleWithoutDim(userId.longValue(), appId, entityNum, permItemId, orgIds);
    }

    public static Boolean isStartMatAllocSubEntry() {
        QFilter filter = new QFilter("key", "=", (Object)"isStartMatAllocSubEntry");
        DynamicObject param = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_bgparam", (String)"value", (QFilter[])new QFilter[]{filter});
        if (param == null) {
            return Boolean.FALSE;
        }
        return param.getBoolean("value");
    }
}

