/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MaterialRangeCalcHelper {
    private static final Log LOG = LogFactory.getLog(MaterialRangeCalcHelper.class);
    private static final long ZERO = 0L;

    public static Long getMockCostTypeByProduceOrgId(Long produceOrgId) {
        ArrayList<Long> proOrgIdList = new ArrayList<Long>();
        proOrgIdList.add(produceOrgId);
        List<Long> inventoryOrgIdList = MaterialRangeCalcHelper.getDelegatedOrgIdListByOrgId(proOrgIdList, "04", "05");
        if (CadEmptyUtils.isEmpty(inventoryOrgIdList)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("getMockCostTypeByProduceOrgId produceOrgId={},inventoryOrgIdList is empty", (Object)produceOrgId);
            }
            return 0L;
        }
        Long inventoryOrgId = inventoryOrgIdList.contains(produceOrgId) ? produceOrgId : inventoryOrgIdList.get(0);
        Long costTypeId = MaterialRangeCalcHelper.getCostTypeByOrgId(inventoryOrgId);
        if (CadEmptyUtils.isEmpty((Long)costTypeId)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("getMockCostTypeByProduceOrgId inventoryOrgId={}, costTypeId is empty", (Object)inventoryOrgId);
            }
            return 0L;
        }
        List mockCostType = CostTypeHelper.getMnCostByHs((Long)costTypeId);
        if (CadEmptyUtils.isEmpty((List)mockCostType)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("getMockCostTypeByProduceOrgId costTypeId={}, mockCostType is empty", (Object)costTypeId);
            }
            return 0L;
        }
        return (Long)mockCostType.get(0);
    }

    public static List<Long> getDelegatedOrgIdListByOrgId(List<Long> fromOrgIdList, String fromOrgViewType, String toOrgViewType) {
        if (CadEmptyUtils.isEmpty(fromOrgIdList)) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> toOrgIdList = new ArrayList<Long>();
        for (Long fromOrgId : fromOrgIdList) {
            OrgRelationParam param = new OrgRelationParam();
            param.setOrgId(fromOrgId.longValue());
            param.setFromViewType(fromOrgViewType);
            param.setToViewType(toOrgViewType);
            param.setDirectViewType("toorg");
            param.setIncludeSelf(true);
            List orgIds = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
            if (CadEmptyUtils.isEmpty((List)orgIds)) continue;
            toOrgIdList.addAll(orgIds);
        }
        return toOrgIdList;
    }

    public static Long getRulePlanIdByCostType(Long costTypeId) {
        if (CadEmptyUtils.isEmpty((Long)costTypeId)) {
            return 0L;
        }
        QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
        filter.and("enable", "=", (Object)true);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_calcruleplan", (String)"id,default", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)dynamicObjects)) {
            return 0L;
        }
        Long rulePlanId = ((DynamicObject)dynamicObjects.get(0)).getLong("id");
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!dynamicObject.getBoolean("default")) continue;
            rulePlanId = dynamicObject.getLong("id");
            break;
        }
        return rulePlanId;
    }

    private static Long getCostTypeByOrgId(Long orgId) {
        QFilter qFilter = new QFilter("bizstatus", "=", (Object)"1");
        qFilter.and(new QFilter("storageorgunit", "=", (Object)orgId));
        qFilter.and("effectdate", "<=", (Object)new Date());
        qFilter.and("invaliddate", ">", (Object)new Date());
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cal_bd_costtypeorg", (String)"storageorgunit, costtype", (QFilter[])qFilter.toArray());
        if (dynamicObject == null) {
            return 0L;
        }
        return dynamicObject.getLong("costtype");
    }

    public static Long getBoomRuleIdByCostType(Long costTypeId) {
        if (CadEmptyUtils.isEmpty((Long)costTypeId)) {
            return 0L;
        }
        QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
        filter.and("enable", "=", (Object)true);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_bomrulesetting", (String)"id,default", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)dynamicObjects)) {
            return 0L;
        }
        Long bomRuleId = ((DynamicObject)dynamicObjects.get(0)).getLong("id");
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!dynamicObject.getBoolean("default")) continue;
            bomRuleId = dynamicObject.getLong("id");
        }
        return bomRuleId;
    }

    public static Long getRouteRuleSettingIdByCostType(Long costTypeId) {
        if (CadEmptyUtils.isEmpty((Long)costTypeId)) {
            return 0L;
        }
        QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
        filter.and("enable", "=", (Object)true);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_routerulesetting", (String)"id,default", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)dynamicObjects)) {
            return 0L;
        }
        Long routeRuleSetId = ((DynamicObject)dynamicObjects.get(0)).getLong("id");
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!dynamicObject.getBoolean("default")) continue;
            routeRuleSetId = dynamicObject.getLong("id");
        }
        return routeRuleSetId;
    }
}

