/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class StandCostCalcHelper {
    private static final Log logger = LogFactory.getLog(StandCostCalcHelper.class);

    public static void addSalOrderStdCalcLog(List<Long> salOrderIds, Map<String, Long> matStockProduceOrgMap) {
        if (CadEmptyUtils.isEmpty(salOrderIds)) {
            return;
        }
        DynamicObjectCollection dynamicObjects = StandCostCalcHelper.getSalOrders(salOrderIds, null);
        logger.info("\u9500\u552e\u8ba2\u5355\uff0c\u83b7\u53d6\u9500\u552e\u8ba2\u5355\u4e2a\u6570\uff1a{}", (Object)dynamicObjects.size());
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)dynamicObjects)) {
            return;
        }
        if (CadEmptyUtils.isEmpty(matStockProduceOrgMap)) {
            matStockProduceOrgMap = StandCostCalcHelper.getBillEntryIdProduceOrgMap(dynamicObjects);
        }
        Map<Long, List<ThreeTuple>> costTypeAndOrgMap = StandCostCalcHelper.getCostTypeAndOrg(dynamicObjects, matStockProduceOrgMap);
        logger.info("\u9500\u552e\u8ba2\u5355\uff0c\u83b7\u53d6\u751f\u4ea7\u7ec4\u7ec7\u548c\u6210\u672c\u7c7b\u578b\u5173\u7cfbMap\u4e2a\u6570\uff1a{}", (Object)costTypeAndOrgMap.size());
        if (CadEmptyUtils.isEmpty(costTypeAndOrgMap)) {
            return;
        }
        ArrayList<Long> costTypeIds = new ArrayList<Long>(10);
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        for (Map.Entry<Long, List<ThreeTuple>> costTypeOrg : costTypeAndOrgMap.entrySet()) {
            List<ThreeTuple> values = costTypeOrg.getValue();
            for (ThreeTuple value : values) {
                long org = Long.parseLong(String.valueOf(value.item1));
                long costType = Long.parseLong(String.valueOf(value.item3));
                if (!costTypeIds.contains(costType)) {
                    costTypeIds.add(costType);
                }
                if (orgIds.contains(org)) continue;
                orgIds.add(org);
            }
        }
        Set trackNumberIds = DynamicObjectHelper.getIdSet((DynamicObjectCollection)dynamicObjects, (String)"tracknumber");
        List ids = DynamicObjectHelper.getIdList((DynamicObjectCollection)dynamicObjects, (String)"id");
        Map<Long, List<Long>> orgSalOrderIdMap = StandCostCalcHelper.getOrgSalOrderScopeIdMap(orgIds, ids);
        logger.info("\u9500\u552e\u8ba2\u5355\uff0c\u7ec4\u7ec7\u548c\u8ba2\u5355id\u5173\u7cfbMap\u4e2a\u6570\uff1a{}\uff0c\u7ec4\u7ec7\uff1a{}", (Object)orgSalOrderIdMap.size(), orgSalOrderIdMap.keySet());
        if (CadEmptyUtils.isEmpty(orgSalOrderIdMap)) {
            logger.info("\u6ca1\u6709\u83b7\u53d6\u5230\u7b26\u5408\u8ddf\u8e2a\u53f7\u914d\u7f6e\u89c4\u5219\u7684\u9500\u552e\u8ba2\u5355\uff0c\u8ddf\u8e2a\u53f7\u65e5\u5fd7\u540c\u6b65\u7ed3\u675f");
            return;
        }
        Map<Long, Map<String, DynamicObject>> orgSalOrderLogMap = StandCostCalcHelper.getExistSalOrderLogMap(costTypeIds, new ArrayList<Long>(trackNumberIds));
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> updateLogs = new ArrayList<DynamicObject>(10);
        HashMap<Long, List> costTypeExistMatTrackMap = new HashMap<Long, List>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long manuOrg;
            List<ThreeTuple> tuples;
            Long entryid = dynamicObject.getLong("entryid");
            Long material = dynamicObject.getLong("material");
            Long estockOrg = dynamicObject.getLong("estockorg");
            String key = material + "@" + estockOrg;
            if (matStockProduceOrgMap.containsKey(String.valueOf(entryid))) {
                key = String.valueOf(entryid);
            }
            if ((tuples = costTypeAndOrgMap.get(manuOrg = matStockProduceOrgMap.get(key) == null ? estockOrg : matStockProduceOrgMap.get(key))) == null) continue;
            for (ThreeTuple tuple : tuples) {
                if (!orgSalOrderIdMap.containsKey(tuple.item1) || !orgSalOrderIdMap.get(tuple.item1).contains(dynamicObject.getLong("id"))) {
                    logger.info("\u9500\u552e\u8ba2\u5355\uff1amanuOrg:{},tuple.item1:{},\u8ba2\u5355id:{}\u3002containsKey\u6bd4\u8f83\u7ed3\u679c\uff1a{}\uff0ccontains\u6bd4\u8f83\u7ed3\u679c\uff1a{}", new Object[]{manuOrg, tuple.item1, dynamicObject.getLong("id"), !orgSalOrderIdMap.containsKey(tuple.item1), !orgSalOrderIdMap.get(tuple.item1).contains(dynamicObject.getLong("id"))});
                    continue;
                }
                Map<String, DynamicObject> logMap = orgSalOrderLogMap.get(Long.parseLong(String.valueOf(tuple.item3)));
                long auxpty = dynamicObject.getLong("auxpty");
                long configuredCode = dynamicObject.getLong("configuredcode");
                long trackNumber = dynamicObject.getLong("tracknumber");
                String matKey = material + "@" + auxpty + "@" + configuredCode + "@" + trackNumber;
                if (logMap != null && logMap.containsKey(matKey)) {
                    DynamicObject object = logMap.get(matKey);
                    if (object != null) {
                        object.set("syncdate", (Object)new Date());
                        object.set("salorderno", (Object)dynamicObject.getString("billno"));
                        object.set("salorderentryid", (Object)dynamicObject.getLong("entryid"));
                        object.set("salorderaudittime", (Object)dynamicObject.getDate("auditdate"));
                        updateLogs.add(object);
                        logger.info("\u9500\u552e\u8ba2\u5355id\uff1a{}\uff0c\u5206\u5f55id\uff1a{}\uff0c\u7269\u6599\u914d\u7f6e\u53f7\u8ddf\u8e2a\u53f7\u76f8\u540c\u7ef4\u5ea6\u5728\u65e5\u5fd7\u8868\u4e2d\u5df2\u5b58\u5728\uff0c\u5c06\u8fdb\u884c\u66f4\u65b0\u3002", (Object)dynamicObject.getLong("id"), (Object)dynamicObject.getLong("entryid"));
                        continue;
                    }
                    logger.info("\u9500\u552e\u8ba2\u5355id\uff1a{}\uff0c\u5206\u5f55id\uff1a{}\uff0c\u7269\u6599\u914d\u7f6e\u53f7\u8ddf\u8e2a\u53f7\u76f8\u540c\u7ef4\u5ea6\u5728\u65e5\u5fd7\u8868\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u518d\u5199\u5165\u3002", (Object)dynamicObject.getLong("id"), (Object)dynamicObject.getLong("entryid"));
                    continue;
                }
                List existMatTracks = (List)costTypeExistMatTrackMap.get(Long.parseLong(String.valueOf(tuple.item3)));
                if (existMatTracks != null && existMatTracks.contains(matKey)) {
                    logger.info("\u9500\u552e\u8ba2\u5355id\uff1a{}\uff0c\u5206\u5f55id\uff1a{}\uff0c\u5df2\u5b58\u5728\u5176\u4ed6\u7269\u6599\u914d\u7f6e\u53f7\u8ddf\u8e2a\u53f7\u76f8\u540c\u7ef4\u5ea6\u5199\u5165\u65e5\u5fd7\u8868\uff0c\u4e0d\u518d\u5199\u5165\u3002", (Object)dynamicObject.getLong("id"), (Object)dynamicObject.getLong("entryid"));
                    continue;
                }
                DynamicObject stdCalcObj = BusinessDataServiceHelper.newDynamicObject((String)"sca_salorderstdcalclog");
                stdCalcObj.set("org", tuple.item1);
                stdCalcObj.set("targetcosttype", tuple.item2);
                stdCalcObj.set("costtype", tuple.item3);
                stdCalcObj.set("manuorg", (Object)manuOrg);
                stdCalcObj.set("syncdate", (Object)new Date());
                stdCalcObj.set("salorderno", (Object)dynamicObject.getString("billno"));
                stdCalcObj.set("salorderseq", (Object)dynamicObject.getInt("seq"));
                stdCalcObj.set("salorderentryid", (Object)dynamicObject.getLong("entryid"));
                stdCalcObj.set("material", (Object)dynamicObject.getLong("material"));
                stdCalcObj.set("auxpty", (Object)auxpty);
                stdCalcObj.set("configuredcode", (Object)configuredCode);
                stdCalcObj.set("tracknumber", (Object)trackNumber);
                stdCalcObj.set("salorderaudittime", (Object)dynamicObject.getDate("auditdate"));
                stdCalcObj.set("status", (Object)"00");
                stdCalcObj.set("lastexecdate", null);
                stdCalcObj.set("trytimes", (Object)0);
                stdCalcObj.set("billtype", (Object)dynamicObject.getLong("billtype"));
                stdCalcObj.set("srcbill", (Object)dynamicObject.getString("billformid"));
                logs.add(stdCalcObj);
                costTypeExistMatTrackMap.computeIfAbsent(Long.parseLong(String.valueOf(tuple.item3)), p -> new ArrayList()).add(matKey);
            }
        }
        costTypeExistMatTrackMap.clear();
        orgSalOrderLogMap.clear();
        logger.info("\u9500\u552e\u8ba2\u5355\uff0c\u751f\u6210\u9500\u552e\u8ba2\u5355\u65e5\u5fd7\u4e2a\u6570\uff1a" + logs.size());
        logger.info("\u9500\u552e\u8ba2\u5355\uff0c\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u65e5\u5fd7\u4e2a\u6570\uff1a" + updateLogs.size());
        if (!CadEmptyUtils.isEmpty(logs)) {
            SaveServiceHelper.save((DynamicObject[])logs.toArray(new DynamicObject[0]));
        }
        if (!CadEmptyUtils.isEmpty(updateLogs)) {
            SaveServiceHelper.update((DynamicObject[])updateLogs.toArray(new DynamicObject[0]));
        }
    }

    private static DynamicObjectCollection getSalOrders(List<Long> salOrderIds, QFilter qFilter) {
        QFilter filter = new QFilter("id", "in", salOrderIds);
        filter.and(new QFilter("billentry.configuredcode", ">", (Object)0L));
        filter.and(new QFilter("billentry.tracknumber", ">", (Object)0L));
        if (qFilter != null) {
            filter.and(qFilter);
        }
        String fields = "id,org,billno,biztype,billentry.seq as seq,billentry.id as entryid,billentry.material.masterid as material,billentry.e_stockorg as estockorg,billentry.proorg as proorg,billentry.auxpty as auxpty,billentry.configuredcode as configuredcode,billentry.tracknumber as tracknumber,auditdate,billtype,billtype.billformid billformid";
        return QueryServiceHelper.query((String)"sm_salorder", (String)fields, (QFilter[])new QFilter[]{filter});
    }

    private static Map<String, Long> getMatStockProduceOrgMap(DynamicObjectCollection salOrders) {
        HashMap<String, Long> matStockProduceOrgMap = new HashMap<String, Long>(16);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)salOrders)) {
            return matStockProduceOrgMap;
        }
        HashSet<Long> stockOrgIds = new HashSet<Long>(10);
        HashSet<Long> materialIds = new HashSet<Long>(10);
        for (DynamicObject salOrder : salOrders) {
            long estockorg = salOrder.getLong("estockorg");
            long material = salOrder.getLong("material");
            if (CadEmptyUtils.isEmpty((Long)estockorg)) continue;
            stockOrgIds.add(estockorg);
            materialIds.add(material);
        }
        for (Long stockOrgId : stockOrgIds) {
            Map<String, Long> map = StandCostCalcHelper.getMatStockProduceOrgMap(stockOrgId, materialIds);
            if (CadEmptyUtils.isEmpty(map)) continue;
            matStockProduceOrgMap.putAll(map);
        }
        return matStockProduceOrgMap;
    }

    private static Map<String, Long> getBillEntryIdProduceOrgMap(DynamicObjectCollection salOrders) {
        HashMap<String, Long> matStockProduceOrgMap = new HashMap<String, Long>(16);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)salOrders)) {
            return matStockProduceOrgMap;
        }
        for (DynamicObject salOrder : salOrders) {
            long entryid = salOrder.getLong("entryid");
            long proOrg = salOrder.getLong("proorg");
            if (CadEmptyUtils.isEmpty((Long)proOrg)) continue;
            matStockProduceOrgMap.put(String.valueOf(entryid), proOrg);
        }
        return matStockProduceOrgMap;
    }

    private static Map<String, Long> getMatStockProduceOrgMap(Long stockOrgId, Set<Long> materialIds) {
        HashMap<String, Long> stockProduceOrgMap = new HashMap<String, Long>(16);
        if (CadEmptyUtils.isEmpty((Long)stockOrgId) || CadEmptyUtils.isEmpty(materialIds)) {
            return stockProduceOrgMap;
        }
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_materialplan", (Long)stockOrgId);
        orgFilter.and(new QFilter("masterid", "in", materialIds));
        DynamicObjectCollection planInfos = QueryServiceHelper.query((String)"mpdm_materialplan", (String)"masterid,is_inter_assist,inter_assist_type.product_org product_org", (QFilter[])new QFilter[]{orgFilter});
        HashSet<Long> planMaterials = new HashSet<Long>(10);
        for (DynamicObject planInfo : planInfos) {
            long masterid = planInfo.getLong("masterid");
            planMaterials.add(masterid);
            long product_org = planInfo.getLong("product_org");
            boolean is_inter_assist = planInfo.getBoolean("is_inter_assist");
            String key = masterid + "@" + stockOrgId;
            if (stockProduceOrgMap.containsKey(key)) continue;
            if (is_inter_assist && !CadEmptyUtils.isEmpty((Long)product_org)) {
                stockProduceOrgMap.put(key, product_org);
                continue;
            }
            stockProduceOrgMap.put(key, stockOrgId);
        }
        HashSet<Long> noPlanMaterials = new HashSet<Long>(materialIds);
        noPlanMaterials.removeAll(planMaterials);
        for (Long noPlanMaterial : noPlanMaterials) {
            String key = noPlanMaterial + "@" + stockOrgId;
            if (stockProduceOrgMap.containsKey(key)) continue;
            stockProduceOrgMap.put(key, stockOrgId);
        }
        return stockProduceOrgMap;
    }

    private static Map<Long, List<ThreeTuple>> getCostTypeAndOrg(DynamicObjectCollection businessBills, Map<String, Long> matStockProduceOrgMap) {
        Long manuOrg;
        HashMap<Long, List<ThreeTuple>> manuOrgCostTypeMap = new HashMap<Long, List<ThreeTuple>>(16);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)businessBills)) {
            return manuOrgCostTypeMap;
        }
        HashMap manuAccountOrgMap = new HashMap(16);
        for (Map.Entry<String, Long> entry : matStockProduceOrgMap.entrySet()) {
            manuOrg = entry.getValue();
            if (manuAccountOrgMap.containsKey(manuOrg)) continue;
            OrgRelationParam param = new OrgRelationParam();
            param.setFromViewType("10");
            param.setToViewType("04");
            param.setOrgId(manuOrg.longValue());
            param.setIncludeSelf(true);
            List fromOrgs = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
            if (CadEmptyUtils.isEmpty((List)fromOrgs)) continue;
            manuAccountOrgMap.put(manuOrg, fromOrgs.get(0));
        }
        logger.info("\u9500\u552e\u8ba2\u5355\uff0c\u751f\u4ea7\u7ec4\u7ec7\u548c\u6838\u7b97\u7ec4\u7ec7\u5173\u7cfbMap\u4e2a\u6570\uff1a" + manuAccountOrgMap.size());
        for (Map.Entry<String, Long> entry : manuAccountOrgMap.entrySet()) {
            manuOrg = (Long)((Object)entry.getKey());
            Long org = entry.getValue();
            boolean enableFactory = OrgHelper.isOrgEnableMultiFactory((Long)org);
            QFilter filter = new QFilter("costtype.type", "=", (Object)"0");
            filter.and("bizstatus", "=", (Object)"1");
            filter.and("effectdate", "<=", (Object)new Date());
            filter.and("invaliddate", ">", (Object)new Date());
            if (enableFactory) {
                OrgRelationParam param = new OrgRelationParam();
                param.setFromViewType("04");
                param.setToViewType("05");
                param.setOrgId(manuOrg.longValue());
                param.setIncludeSelf(true);
                param.setDirectViewType("toorg");
                List allToOrg = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
                if (!CadEmptyUtils.isEmpty((List)allToOrg) && allToOrg.contains(manuOrg)) {
                    filter.and("storageorgunit", "=", (Object)manuOrg);
                } else {
                    filter.and("storageorgunit", "=", (Object)(CadEmptyUtils.isEmpty((List)allToOrg) ? Long.valueOf(0L) : (Long)allToOrg.get(0)));
                }
            } else {
                filter.and("calorg", "=", (Object)org);
            }
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"costtype.id as costType", (QFilter[])new QFilter[]{filter});
            HashSet<Long> costTypes = new HashSet<Long>(5);
            for (DynamicObject obj : dynamicObjects) {
                long costType = obj.getLong("costType");
                if (CadEmptyUtils.isEmpty((Long)costType)) continue;
                costTypes.add(costType);
            }
            QFilter costTypeFilter = new QFilter("id", "in", costTypes);
            costTypeFilter.and("enable", "=", (Object)"1");
            costTypeFilter.and("costtypeentry.costtypeattr", "=", (Object)"1");
            DynamicObjectCollection costTypeObjs = QueryServiceHelper.query((String)"cad_costtype", (String)"id,costtypeentry.costtype.id as costtype", (QFilter[])new QFilter[]{costTypeFilter});
            for (DynamicObject costTypeObj : costTypeObjs) {
                Long costType = costTypeObj.getLong("costtype");
                if (CadEmptyUtils.isEmpty((Long)costType)) continue;
                ThreeTuple threeTuple = new ThreeTuple((Object)org, (Object)costTypeObj.getLong("id"), (Object)costType);
                manuOrgCostTypeMap.computeIfAbsent(manuOrg, p -> new ArrayList()).add(threeTuple);
            }
        }
        return manuOrgCostTypeMap;
    }

    private static Map<Long, List<Long>> getOrgSalOrderScopeIdMap(List<Long> orgIds, List<Long> salOrderIds) {
        HashMap<Long, List<Long>> orgSalOrderIdMap = new HashMap<Long, List<Long>>(16);
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        orgFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        orgFilter.and(new QFilter("istrack", "=", (Object)Boolean.TRUE));
        DynamicObjectCollection trackSettings = QueryServiceHelper.query((String)"cad_tracknumber_setting", (String)"org,istrack,filter_tag", (QFilter[])new QFilter[]{orgFilter});
        for (DynamicObject trackSetting : trackSettings) {
            boolean istrack = trackSetting.getBoolean("istrack");
            if (!istrack) continue;
            long org = trackSetting.getLong("org");
            String filterStr = trackSetting.getString("filter_tag");
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
            if (filterCondition == null || filterCondition.getFilterRow().size() <= 0) continue;
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"sm_salorder");
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            filterBuilder.buildFilter();
            QFilter qFilter = filterBuilder.getQFilter();
            DynamicObjectCollection salOrders = StandCostCalcHelper.getSalOrders(salOrderIds, qFilter);
            List ids = DynamicObjectHelper.getIdList((DynamicObjectCollection)salOrders, (String)"id");
            orgSalOrderIdMap.put(org, ids);
        }
        return orgSalOrderIdMap;
    }

    private static Map<Long, Map<String, DynamicObject>> getExistSalOrderLogMap(List<Long> costTypeIds, List<Long> trackNumberIds) {
        HashMap<Long, Map<String, DynamicObject>> orgSalOrderLogMap = new HashMap<Long, Map<String, DynamicObject>>(16);
        QFilter orgFilter = new QFilter("costtype", "in", costTypeIds);
        orgFilter.and(new QFilter("tracknumber", "in", trackNumberIds));
        Object[] logs = BusinessDataServiceHelper.load((String)"sca_salorderstdcalclog", (String)"costtype,material,auxpty,configuredcode,tracknumber,salorderaudittime,salorderentryid,syncdate,salorderno,status", (QFilter[])new QFilter[]{orgFilter});
        if (CadEmptyUtils.isEmpty((Object[])logs)) {
            return orgSalOrderLogMap;
        }
        for (Object log : logs) {
            long costType = log.getLong("costtype.id");
            long material = log.getLong("material.id");
            long auxpty = log.getLong("auxpty.id");
            long configuredCode = log.getLong("configuredcode.id");
            long trackNumber = log.getLong("tracknumber.id");
            String key = material + "@" + auxpty + "@" + configuredCode + "@" + trackNumber;
            Map orgSalOrderLog = orgSalOrderLogMap.computeIfAbsent(costType, p -> new HashMap());
            if (orgSalOrderLog.containsKey(key)) continue;
            String status = log.getString("status");
            if (!"01".equals(status) && !"02".equals(status)) {
                orgSalOrderLog.put(key, log);
                continue;
            }
            orgSalOrderLog.put(key, null);
        }
        return orgSalOrderLogMap;
    }
}

