/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.checkdata;

import com.alibaba.fastjson.JSON;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.sca.opplugin.checkdata.CheckDataTaskHelper;
import org.apache.commons.lang.time.DateUtils;

public class CheckDataTaskSavePlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CheckDataTaskSavePlugin.class);
    private static final String SCHEDULE_TASK_DEFINEID_SCA = "0XEI354RX9JS";
    private static final String SCHEDULE_TASK_DEFINEID_ACA = "0Z7UEFC=CX+/";
    private static final String SCHEDULE_TASK_CLASSNAME = "kd.macc.sca.business.checkdata.CheckDataDispatchTask";

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                DynamicObject data = null;
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObjectCollection entry;
                    data = dataEntity.getDataEntity();
                    if (StringUtils.isEmpty((String)data.getString("number"))) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7f16\u53f7\u201d", (String)"CheckDataTaskSavePlugin_3", (String)"macc-sca-opplugin", (Object[])new Object[0]));
                    }
                    if ((entry = data.getDynamicObjectCollection("entryentity")).size() != 0) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u68c0\u67e5\u9879\u201d\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckDataTaskSavePlugin_1", (String)"macc-sca-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject plan = e.getDataEntities()[0];
        try (TXHandle handler = TX.beginNew();){
            this.deleteJobAndPlan(plan);
            Map<String, String> taskGroup = this.getCurTaskGroup(plan);
            DynamicObject[] shceduleJob = this.createNewScheduleJob(plan, taskGroup);
            this.doSaveOp(shceduleJob, "sch_job");
            DynamicObject[] schedulePlan = this.scheduleDynamicObject(plan, taskGroup);
            this.doSaveOp(schedulePlan, "sch_schedule");
        }
        catch (ParseException e1) {
            logger.error("\u6570\u636e\u68c0\u67e5\u6267\u884c\u5931\u8d25\uff1a" + e1.getMessage());
        }
    }

    private DynamicObject[] scheduleDynamicObject(DynamicObject plan, Map<String, String> taskGroup) throws ParseException {
        Map<String, String> jobInfo = this.getJobInfo(plan.getString("number"), taskGroup.keySet());
        ArrayList<DynamicObject> schedule = new ArrayList<DynamicObject>(16);
        for (Map.Entry<String, String> entry : taskGroup.entrySet()) {
            DynamicObject schedulePlan = BusinessDataServiceHelper.newDynamicObject((String)"sch_schedule");
            schedulePlan.set("txtdesc", (Object)(plan.get("description") + "@" + entry.getKey()));
            schedulePlan.set("repeatmode", (Object)this.getCycle(entry.getKey()));
            schedulePlan.set("cyclenum", (Object)("A".equals(entry.getKey()) ? 12 : 1));
            schedulePlan.set("number", (Object)(plan.get("number") + "@" + plan.getString("appnum") + "@" + entry.getKey()));
            schedulePlan.set("name", (Object)(plan.get("name") + "@" + entry.getKey()));
            schedulePlan.set("job", (Object)jobInfo.get(plan.get("number") + "@" + entry.getKey()));
            Calendar cal = Calendar.getInstance();
            schedulePlan.set("starttime", (Object)this.parseDate(cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5)));
            schedulePlan.set("endtime", (Object)this.parseDate("2099-12-31"));
            schedulePlan.set("plan", (Object)this.getPlan(entry.getKey()));
            schedulePlan.set("status", (Object)(plan.getBoolean("status") ? "1" : "0"));
            schedule.add(schedulePlan);
        }
        return schedule.toArray(new DynamicObject[0]);
    }

    private String getCycle(String cycle) {
        switch (cycle) {
            case "A": {
                return "h";
            }
            case "B": {
                return "d";
            }
            case "C": {
                return "w";
            }
            case "D": {
                return "m";
            }
            case "E": {
                return "n";
            }
        }
        return "w";
    }

    private String getPlan(String cycle) {
        switch (cycle) {
            case "A": {
                return "0 0 0/12 * * ?";
            }
            case "B": {
                return "0 0 0 * * ?";
            }
            case "C": {
                return "0 0 0 * * ?";
            }
            case "D": {
                return "0 0 0 * * ?";
            }
            case "E": {
                Calendar cal = Calendar.getInstance();
                return String.format("0 0 0 %s %s ? %s", cal.get(5), cal.get(2) + 1, cal.get(1));
            }
        }
        return "0 0 0 * * ?";
    }

    private Map<String, String> getCurTaskGroup(DynamicObject task) {
        HashMap<String, String> result = new HashMap<String, String>();
        DynamicObjectCollection entrys = task.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entrys) {
            String cycle;
            String val = (String)result.get(cycle = entry.getString("opcycle"));
            result.put(cycle, val != null ? val + "@" + entry.getString("checkitem.id") : entry.getString("checkitem.id"));
        }
        return result;
    }

    private DynamicObject[] createNewScheduleJob(DynamicObject plan, Map<String, String> taskGroup) {
        ArrayList<DynamicObject> job = new ArrayList<DynamicObject>(16);
        String appNum = plan.getString("appnum");
        for (Map.Entry<String, String> entry : taskGroup.entrySet()) {
            DynamicObject shceduleJob = BusinessDataServiceHelper.newDynamicObject((String)"sch_job");
            shceduleJob.set("number", (Object)(plan.get("number") + "@" + appNum + "@" + entry.getKey()));
            shceduleJob.set("name", (Object)(plan.get("name") + "@" + entry.getKey()));
            shceduleJob.set("jobtype", (Object)JobType.BIZ);
            shceduleJob.set("taskclassname", (Object)("sca".equals(appNum) ? SCHEDULE_TASK_DEFINEID_SCA : SCHEDULE_TASK_DEFINEID_ACA));
            shceduleJob.set("classname", (Object)SCHEDULE_TASK_CLASSNAME);
            shceduleJob.set("runbyuser", (Object)plan.getLong("operator.id"));
            shceduleJob.set("status", (Object)(plan.getBoolean("status") ? "1" : "0"));
            shceduleJob.set("runconcurrent", (Object)Boolean.TRUE);
            DynamicObject paramEntry = shceduleJob.getDynamicObjectCollection("entryentity").addNew();
            paramEntry.set("paramname", (Object)"number");
            paramEntry.set("paramvalue", (Object)plan.getString("number"));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("number", plan.getString("number"));
            params.put("checkitem", entry.getValue());
            String paramStr = JSON.toJSONString(params);
            shceduleJob.set("params", (Object)paramStr);
            job.add(shceduleJob);
        }
        return job.toArray(new DynamicObject[0]);
    }

    private void doSaveOp(DynamicObject[] obj, String objType) {
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)objType, (DynamicObject[])obj, null);
        if (!saveResult.isSuccess()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u68c0\u67e5\u4efb\u52a1\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"CheckDataTaskSavePlugin_2", (String)"macc-sca-opplugin", (Object[])new Object[0]), ((IOperateInfo)saveResult.getAllErrorOrValidateInfo().get(0)).getMessage()));
        }
    }

    private Map<String, String> getJobInfo(String billNo, Set<String> group) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashSet<String> billNos = new HashSet<String>(group.size());
        for (String gp : group) {
            billNos.add(billNo + "@" + gp);
        }
        QFilter qfNumber = new QFilter("number", "in", billNos);
        QFilter qfJobType = new QFilter("jobtype", "=", (Object)JobType.BIZ);
        DynamicObjectCollection job = QueryServiceHelper.query((String)"sch_job", (String)"number,id", (QFilter[])new QFilter[]{qfNumber, qfJobType});
        for (DynamicObject jo : job) {
            result.put(jo.getString("number"), jo.getString("id"));
        }
        return result;
    }

    private Date parseDate(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        return DateUtils.parseDate((String)string, (String[])new String[]{"yyyy-MM-dd"});
    }

    private void deleteJobAndPlan(DynamicObject plan) {
        String appNum = plan.getString("appnum");
        HashSet<String> planNumbers = new HashSet<String>(1);
        planNumbers.add(plan.getString("number"));
        Set<String> numbers = CheckDataTaskHelper.getTaskNumbers(planNumbers, appNum);
        QFilter qfNubmer = new QFilter("number", "in", numbers);
        DeleteServiceHelper.delete((String)"sch_schedule", (QFilter[])new QFilter[]{qfNubmer});
        QFilter qfJobType = new QFilter("jobtype", "=", (Object)JobType.BIZ);
        QFilter qfTaskClassName = new QFilter("taskclassname", "=", (Object)("sca".equals(appNum) ? SCHEDULE_TASK_DEFINEID_SCA : SCHEDULE_TASK_DEFINEID_ACA));
        QFilter qfClassName = new QFilter("classname", "=", (Object)SCHEDULE_TASK_CLASSNAME);
        DeleteServiceHelper.delete((String)"sch_job", (QFilter[])new QFilter[]{qfNubmer, qfJobType, qfTaskClassName, qfClassName});
    }
}

