/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.costreduction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class HalfPrdStructureAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List list = e.getFieldKeys();
        list.add("isimport");
        list.add("billno");
        list.add("entryentity");
        list.add("org");
        list.add("costaccount");
        list.add("period");
        list.add("calckeycol");
        list.add("material");
        list.add("prdorg");
        list.add("materialversion");
        list.add("auxprop");
        list.add("storageorgunit");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                HashMap<String, List> costaccountParamMap = new HashMap<String, List>(10);
                for (ExtendedDataEntity ede : dataEntities) {
                    DynamicObject data = ede.getDataEntity();
                    Long orgId = data.getLong("org.id");
                    Long costaccountId = data.getLong("costaccount.id");
                    Long periodId = data.getLong("period.id");
                    String key = String.format("%s@%s@%s", orgId, costaccountId, periodId);
                    if (!"B".equals(data.getString("billstatus"))) continue;
                    costaccountParamMap.computeIfAbsent(key, t -> new ArrayList()).add(ede);
                }
                for (Map.Entry entry : costaccountParamMap.entrySet()) {
                    ArrayList<Long> materialIds = new ArrayList<Long>(10);
                    for (ExtendedDataEntity ede : (List)entry.getValue()) {
                        materialIds.add(ede.getDataEntity().getLong("material.id"));
                    }
                    String[] keys = ((String)entry.getKey()).split("@");
                    Long orgId = Long.parseLong(keys[0]);
                    Long costaccountId = Long.parseLong(keys[1]);
                    Long periodId = Long.parseLong(keys[2]);
                    QFilter finalFilter = new QFilter("org", "=", (Object)orgId);
                    finalFilter.and("costaccount", "=", (Object)costaccountId);
                    finalFilter.and("period", "=", (Object)periodId);
                    finalFilter.and("material", "in", materialIds);
                    finalFilter.and("billstatus", "=", (Object)"C");
                    DataSet hdDs = QueryServiceHelper.queryDataSet((String)"halfprdstructure", (String)"sca_halfprdstructure", (String)"id,billno,materialversion,material,auxprop,prdorg,calckeycol,storageorgunit", (QFilter[])finalFilter.toArray(), null);
                    HashMap<String, List> keyMap = new HashMap<String, List>(10);
                    for (Row row : hdDs) {
                        String key = String.format("%s@%s@%s@%s", row.getLong("material"), row.getLong("auxprop"), row.getLong("materialversion"), row.getLong("calckeycol"));
                        keyMap.computeIfAbsent(key, t -> new ArrayList(10)).add(new ThreeTuple((Object)row.getString("billno"), (Object)row.getLong("prdorg"), (Object)row.getLong("storageorgunit")));
                    }
                    for (ExtendedDataEntity ede : (List)entry.getValue()) {
                        DynamicObject data = ede.getDataEntity();
                        Long materialId = data.getLong("material.id");
                        String srcbillno = data.getString("billno");
                        Long auxpropId = data.getLong("auxprop.id");
                        Long materialversionId = data.getLong("materialversion.id");
                        Long calckeycolId = data.getLong("calckeycol.id");
                        String key = String.format("%s@%s@%s@%s", materialId, auxpropId, materialversionId, calckeycolId);
                        long prdorgId = data.getLong("prdorg.id");
                        long storageorgunitId = data.getLong("storageorgunit.id");
                        if (keyMap.containsKey(key)) {
                            List stList;
                            boolean exists = false;
                            String billno = "";
                            if (CadEmptyUtils.isEmpty((Long)prdorgId) && CadEmptyUtils.isEmpty((Long)storageorgunitId)) {
                                billno = (String)((ThreeTuple)((List)keyMap.get((Object)key)).get((int)0)).item1;
                                exists = true;
                            } else if (!CadEmptyUtils.isEmpty((Long)storageorgunitId) && CadEmptyUtils.isEmpty((Long)prdorgId)) {
                                stList = (List)keyMap.get(key);
                                for (ThreeTuple turple : stList) {
                                    if ((Long)turple.item3 != storageorgunitId) continue;
                                    exists = true;
                                    billno = (String)turple.item1;
                                    break;
                                }
                            } else if (!CadEmptyUtils.isEmpty((Long)prdorgId)) {
                                stList = (List)keyMap.get(key);
                                for (ThreeTuple turple : stList) {
                                    if (CadEmptyUtils.isEmpty((Long)((Long)turple.item3)) || CadEmptyUtils.isEmpty((Long)storageorgunitId)) {
                                        exists = true;
                                        billno = (String)turple.item1;
                                    } else {
                                        if ((Long)turple.item3 != storageorgunitId) continue;
                                        billno = (String)turple.item1;
                                        exists = true;
                                    }
                                    break;
                                }
                            }
                            if (exists) {
                                this.addErrorMessage(ede, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u4e0d\u7b26\u5408\u4ea7\u54c1\u552f\u4e00\u6027\u5224\u65ad\uff0c\u5bf9\u5e94\u5355\u53f7\uff1a%s\u3002", (String)"HalfPrdStructureAuditOp_0", (String)"macc-sca-opplugin", (Object[])new Object[0]), billno));
                                continue;
                            }
                            keyMap.computeIfAbsent(key, t -> new ArrayList(10)).add(new ThreeTuple((Object)srcbillno, (Object)prdorgId, (Object)storageorgunitId));
                            continue;
                        }
                        keyMap.computeIfAbsent(key, t -> new ArrayList(10)).add(new ThreeTuple((Object)srcbillno, (Object)prdorgId, (Object)storageorgunitId));
                    }
                }
            }
        });
    }
}

