/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc;

import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.sca.algox.utils.ElementHelper;
import kd.macc.sca.algox.utils.FinishCalcHelper;
import kd.macc.sca.algox.utils.PeriodHelper;
import kd.macc.sca.algox.wip.input.CalcDataArgs;
import kd.macc.sca.common.costcalc.CostCalcArgs;
import kd.macc.sca.mservice.costcalc.CalcTaskType;
import kd.macc.sca.mservice.costcalc.CostCalcFilterBuilder;
import kd.macc.sca.mservice.costcalc.groupkey.MatStdCostItem;
import kd.macc.sca.mservice.costcalc.groupkey.MatStdCostKey;
import kd.macc.sca.mservice.costcalc.groupkey.MaterialKey;
import kd.macc.sca.mservice.costcalc.groupkey.OutSourcePrice;
import kd.macc.sca.mservice.costcalc.groupkey.ResourceRate;

public class CostCalcContext {
    private static final int DEFAULT_AMT_PRECISION = 23;
    private static final int DEFAULT_AMT_SCALE = 10;
    private CostCalcArgs inputArgs;
    private CalcTaskType taskType = CalcTaskType.FinishCalc;
    private Long taskConfigId;
    private DynamicObject taskConfig;
    private String reportType;
    private Map<Long, Date[]> periodDates = new HashMap<Long, Date[]>();
    private Set<Long> matSubElement;
    private Map<Long, Set<ResourceRate>> allResMap;
    private Map<Long, Set<OutSourcePrice>> allOutSourceMap;
    private Map<MaterialKey, Map<MatStdCostKey, List<MatStdCostItem>>> matStdCosts = new HashMap<MaterialKey, Map<MatStdCostKey, List<MatStdCostItem>>>();
    private DynamicObject currencyObj;
    private MathContext amountMathContext;
    private CostCalcFilterBuilder filterBuilder = new CostCalcFilterBuilder();
    private Long cusmTimeForCheck;
    private Integer checkNoPassCount = 0;
    private Integer checkRemaindCount = 0;
    private Integer calcCheckRemaindCount = 0;
    private String logUniqueKey;
    private Boolean isConcurrency = false;
    private int totalBatch = 1;
    private int currentBatch = 0;
    private Set<Long> unAbsorbFactCostobjectIds = null;
    private Set<Long> unAbsorbManuorgs = null;

    public CostCalcArgs getInputArgs() {
        return this.inputArgs;
    }

    public void setInputArgs(CostCalcArgs inputArgs) {
        this.inputArgs = inputArgs;
    }

    public CalcTaskType getTaskType() {
        return this.taskType;
    }

    public void setTaskType(CalcTaskType taskType) {
        this.taskType = taskType;
    }

    public boolean isFinishCalc() {
        return this.taskType == CalcTaskType.FinishCalc || this.taskType == CalcTaskType.FinishCalcCheck || this.taskType == CalcTaskType.RealtimeFinishCalc;
    }

    public Long getTaskConfigId() {
        return this.taskConfigId;
    }

    public void setTaskConfigId(Long taskConfigId) {
        this.taskConfigId = taskConfigId;
    }

    public DynamicObject getTaskConfig() {
        if (this.taskConfigId == null) {
            return null;
        }
        if (this.taskConfig == null) {
            this.taskConfig = BusinessDataServiceHelper.loadSingle((Object)this.taskConfigId, (String)"sca_taskconfig");
        }
        return this.taskConfig;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public Date[] getCurrPeriodDate(Long periodId) {
        if (!this.periodDates.containsKey(periodId)) {
            Date[] periodDate = PeriodHelper.getPeriodStartAndEndTime((Long)periodId);
            this.periodDates.put(periodId, periodDate);
        }
        return this.periodDates.get(periodId);
    }

    public Long getCusmTimeForCheck() {
        return this.cusmTimeForCheck;
    }

    public void setCusmTimeForCheck(Long cusmTimeForCheck) {
        this.cusmTimeForCheck = cusmTimeForCheck;
    }

    public Integer getCheckNoPassCount() {
        return this.checkNoPassCount;
    }

    public void setCheckNoPassCount(Integer checkNoPassCount) {
        this.checkNoPassCount = checkNoPassCount;
    }

    public Integer getCheckRemaindCount() {
        return this.checkRemaindCount;
    }

    public void setCheckRemaindCount(Integer checkRemaindCount) {
        this.checkRemaindCount = checkRemaindCount;
    }

    public Integer getCalcCheckRemaindCount() {
        return this.calcCheckRemaindCount;
    }

    public void setCalcCheckRemaindCount(Integer calcCheckRemaindCount) {
        this.calcCheckRemaindCount = calcCheckRemaindCount;
    }

    public void setCalcCheckRemaindCountAdd() {
        this.calcCheckRemaindCount = this.calcCheckRemaindCount + 1;
    }

    public Set<Long> getMatSubElement() {
        if (this.matSubElement == null) {
            this.matSubElement = ElementHelper.getMatSubEle();
        }
        return this.matSubElement;
    }

    public Map<Long, Set<ResourceRate>> getAllResMap() {
        return this.allResMap;
    }

    public void setAllResMap(Map<Long, Set<ResourceRate>> allResMap) {
        this.allResMap = allResMap;
    }

    public Map<Long, Set<OutSourcePrice>> getAllOutSourceMap() {
        return this.allOutSourceMap;
    }

    public void setAllOutSourceMap(Map<Long, Set<OutSourcePrice>> allOutSourceMap) {
        this.allOutSourceMap = allOutSourceMap;
    }

    public Map<MaterialKey, Map<MatStdCostKey, List<MatStdCostItem>>> getMatStdCosts() {
        return this.matStdCosts;
    }

    public void setMatStdCosts(Map<MaterialKey, Map<MatStdCostKey, List<MatStdCostItem>>> matStdCosts) {
        this.matStdCosts = matStdCosts;
    }

    public DynamicObject getCurrencyObj() {
        if (this.currencyObj == null) {
            Map currMap = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{this.getInputArgs().getCurrencyId()}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_currency"));
            this.currencyObj = (DynamicObject)currMap.get(Long.parseLong(this.getInputArgs().getCurrencyId().toString()));
        }
        return this.currencyObj;
    }

    public MathContext getAmountMathContext() {
        if (this.amountMathContext == null) {
            this.amountMathContext = new MathContext(23, RoundingMode.HALF_UP);
        }
        return this.amountMathContext;
    }

    public int getCurrencyAmtScale() {
        DynamicObject currency = this.getCurrencyObj();
        if (currency != null) {
            int amtPrecision = currency.getInt("amtprecision");
            return amtPrecision;
        }
        return 10;
    }

    public CostCalcFilterBuilder getFilterBuilder() {
        return this.filterBuilder;
    }

    public CalcDataArgs getOldVerInputArgs() {
        String paramStr = CostCalcArgs.toJSONString((CostCalcArgs)this.inputArgs);
        return FinishCalcHelper.getCalcDataArgs((String)paramStr);
    }

    public Boolean getIsConcurrency() {
        return this.isConcurrency;
    }

    public void setIsConcurrency(Boolean isConcurrency) {
        this.isConcurrency = isConcurrency;
    }

    public String getLogUniqueKey() {
        return this.logUniqueKey;
    }

    public void setLogUniqueKey(String logUniqueKey) {
        this.logUniqueKey = logUniqueKey;
    }

    public int getTotalBatch() {
        return this.totalBatch;
    }

    public void setTotalBatch(int totalBatch) {
        this.totalBatch = totalBatch;
    }

    public int getCurrentBatch() {
        return this.currentBatch;
    }

    public void setCurrentBatch(int currentBatch) {
        this.currentBatch = currentBatch;
    }

    public Set<Long> getUnAbsorbFactCostobjectIds() {
        return this.unAbsorbFactCostobjectIds;
    }

    public void setUnAbsorbFactCostobjectIds(Set<Long> unAbsorbFactCostobjectIds) {
        this.unAbsorbFactCostobjectIds = unAbsorbFactCostobjectIds;
    }

    public Set<Long> getUnAbsorbManuorgs() {
        return this.unAbsorbManuorgs;
    }

    public void setUnAbsorbManuorgs(Set<Long> unAbsorbManuorgs) {
        this.unAbsorbManuorgs = unAbsorbManuorgs;
    }
}

