/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.constants.FinshCalcCheck;
import kd.macc.sca.algox.utils.CalcReportHelper;
import kd.macc.sca.algox.utils.TaskHelper;
import kd.macc.sca.algox.utils.TimeUtils;
import kd.macc.sca.algox.wip.CalcMutexHelper;
import kd.macc.sca.common.costcalc.CostCalcArgs;
import kd.macc.sca.common.costcalc.CostCalcResult;
import kd.macc.sca.common.enums.AutoCalcStatusEnum;
import kd.macc.sca.mservice.costcalc.CalcTaskType;
import kd.macc.sca.mservice.costcalc.CostCalcContext;
import kd.macc.sca.mservice.costcalc.CostCalcResultManager;
import kd.macc.sca.mservice.costcalc.CostRealtimeCalcBuilder;
import kd.macc.sca.mservice.costcalc.action.AfterCalcAction;
import kd.macc.sca.mservice.costcalc.action.ICalcAction;

public class CostCalcEngine {
    private static final Log logger = LogFactory.getLog(CostCalcEngine.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CostCalcResult finishCalc(CostCalcArgs costCalcArgs) {
        logger.info(this.buildLogMessage("finishCalc", costCalcArgs));
        costCalcArgs.setCheckWay(1);
        costCalcArgs.setCalc(Boolean.valueOf(true));
        CostCalcContext context = new CostCalcContext();
        context.setInputArgs(costCalcArgs);
        context.setTaskType(CalcTaskType.FinishCalc);
        context.setTaskConfigId(FinshCalcCheck.CALCTASKID);
        context.setReportType("2");
        CostCalcResultManager resultManager = new CostCalcResultManager();
        CostCalcResult result = new CostCalcResult();
        CostRealtimeCalcBuilder calcBuilder = new CostRealtimeCalcBuilder();
        try {
            Object needUpdateLogIds;
            result = this.doCalculate(context, resultManager);
            if (result.isAllSuccess() && !CadEmptyUtils.isEmpty((List)(needUpdateLogIds = this.getNeedUpdateIds(costCalcArgs)))) {
                if ("5".equals(result.getStatus())) {
                    calcBuilder.updateAutoCalcLog((List<Long>)needUpdateLogIds, AutoCalcStatusEnum.WARN.getValue(), ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a\u72b6\u6001\u4e3a\uff1a\u8b66\u544a\uff0c\u8bf7\u8054\u67e5\u7ed3\u7b97\u65e5\u5fd7\u3002", (String)"CostCalcEngine_19", (String)"macc-sca-mservice", (Object[])new Object[0]), context.getInputArgs().getCalcReportId());
                } else if ("4".equals(result.getStatus())) {
                    calcBuilder.updateAutoCalcLog((List<Long>)needUpdateLogIds, AutoCalcStatusEnum.SUCCESS.getValue(), ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a\u72b6\u6001\u4e3a\uff1a\u6210\u529f\u3002", (String)"CostCalcEngine_20", (String)"macc-sca-mservice", (Object[])new Object[0]), context.getInputArgs().getCalcReportId());
                }
            }
            needUpdateLogIds = result;
            return needUpdateLogIds;
        }
        catch (Throwable e) {
            logger.error("\u6210\u672c\u8ba1\u7b97\u9519\u8bef\uff0c", e);
            this.writeErroToTaskRecord(costCalcArgs.getTaskRecordId(), e);
            CostCalcResult costCalcResult = resultManager.buildResult(false);
            return costCalcResult;
        }
        finally {
            CalcMutexHelper.releaseXMutex((String)"finish", (Object)costCalcArgs.getCostAccountId());
            Set manuOrgIds = costCalcArgs.getManuOrgIds();
            boolean enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)costCalcArgs.getCostAccountId());
            CalcMutexHelper.releaseMuteFromSet((String)"finish", (boolean)enableMulFactory, (Long)costCalcArgs.getCostAccountId(), (Set)manuOrgIds);
            CalcReportHelper.updateReport((Long)costCalcArgs.getTaskRecordId(), (Long)costCalcArgs.getCalcReportId(), (Long)costCalcArgs.getCheckReportId(), (Long)((Object)context.getCheckNoPassCount()), (Long)((Object)context.getCheckRemaindCount()), (Long)((Object)context.getCalcCheckRemaindCount()), (Long)context.getCusmTimeForCheck());
        }
    }

    private List<Long> getNeedUpdateIds(CostCalcArgs costCalcArgs) {
        Set<Long> entryIds = this.getEntryId(costCalcArgs);
        if (CadEmptyUtils.isEmpty(entryIds)) {
            return null;
        }
        return this.getExistLogBill(costCalcArgs, entryIds);
    }

    private Set<Long> getEntryId(CostCalcArgs costCalcArgs) {
        if (!costCalcArgs.getCostObjectIds().isEmpty()) {
            HashSet entryIds = Sets.newHashSetWithExpectedSize((int)10);
            QFilter filter = new QFilter("id", "in", (Object)costCalcArgs.getCostObjectIds());
            DataSet costObjects = QueryServiceHelper.queryDataSet((String)"cadcostobject", (String)"cad_costobject", (String)"probill,id", (QFilter[])filter.toArray(), null);
            for (Row costObject : costObjects) {
                Long proBill = costObject.getLong("probill");
                if (CadEmptyUtils.isEmpty((Long)proBill)) continue;
                entryIds.add(proBill);
            }
            return entryIds;
        }
        return null;
    }

    private List<Long> getExistLogBill(CostCalcArgs costCalcArgs, Collection<Long> mftorderentryids) {
        QFilter filter = new QFilter("orderentryid", "in", mftorderentryids);
        filter.and("org", "=", (Object)costCalcArgs.getOrgId());
        filter.and("costaccount", "=", (Object)costCalcArgs.getCostAccountId());
        filter.and("status", "in", (Object)new String[]{AutoCalcStatusEnum.BUSINESS_FAIL.getValue(), AutoCalcStatusEnum.NOT_EXECUTE.getValue()});
        DataSet ds = QueryServiceHelper.queryDataSet((String)"autocalclog", (String)"sca_autocalclog", (String)"id", (QFilter[])filter.toArray(), null);
        ArrayList<Long> billIds = new ArrayList<Long>(10);
        for (Row row : ds) {
            billIds.add(row.getLong("id"));
        }
        return billIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String autoFinishCalc(Long orgId, List<Long> accountIds, String operType) {
        logger.info("\u8ba1\u7b97\u65b9\u6cd5ensureFinishCalc\u4f20\u5165\u6838\u7b97\u7ec4\u7ec7ID\uff1a{}\uff0c\u6210\u672c\u8d26\u7c3fid\uff1a", (Object)orgId, (Object)StringUtils.join(accountIds, (String)","));
        CostCalcResult result = new CostCalcResult();
        CostRealtimeCalcBuilder calcBuilder = new CostRealtimeCalcBuilder();
        HashMap accountOrderEntryIdMap = Maps.newHashMapWithExpectedSize((int)2);
        List<CostCalcArgs> costCalcArgsList = calcBuilder.getFinishCalcList(orgId, accountIds, operType, accountOrderEntryIdMap);
        HashMap costaccountExecuteMap = Maps.newHashMapWithExpectedSize((int)10);
        if (costCalcArgsList != null && !costCalcArgsList.isEmpty()) {
            for (CostCalcArgs costCalcArgs : costCalcArgsList) {
                List<Long> needUpdateLogIds;
                logger.info(this.buildLogMessage("realtimeFinishCalc", costCalcArgs));
                costCalcArgs.setCheckWay(1);
                costCalcArgs.setCalc(Boolean.valueOf(true));
                CostCalcContext context = new CostCalcContext();
                context.setInputArgs(costCalcArgs);
                context.setTaskType(CalcTaskType.RealtimeFinishCalc);
                context.setTaskConfigId(FinshCalcCheck.CALCTASKID);
                context.setReportType("3");
                Long coustAccountId = costCalcArgs.getCostAccountId();
                CostCalcResultManager resultManager = new CostCalcResultManager();
                String lockErr = CalcMutexHelper.checkAndRequireXMutex((String)"finish", (Object)coustAccountId);
                if (kd.bos.util.StringUtils.isNotEmpty((String)lockErr)) {
                    logger.info("\u5b8c\u5de5\u7ed3\u7b97(costAccountId={})\u4ecd\u7136\u5728\u9501\u72b6\u6001\u4e2d\uff0c\u8bf7\u7ee7\u7eed\u7b49\u5f85....", (Object)coustAccountId);
                    needUpdateLogIds = calcBuilder.getNeedUpdateIds((Map)accountOrderEntryIdMap.get(costCalcArgs.getCostAccountId()));
                    calcBuilder.updateAutoCalcLog(needUpdateLogIds, AutoCalcStatusEnum.FAIL.getValue(), ResManager.loadKDString((String)"\u83b7\u53d6\u5b8c\u5de5\u7ed3\u7b97\u9501\u5931\u8d25\uff0c\u9700\u8981\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CostCalcEngine_16", (String)"macc-sca-mservice", (Object[])new Object[0]));
                    continue;
                }
                try {
                    result = this.doCalculate(context, resultManager);
                    costaccountExecuteMap.put(costCalcArgs.getCostAccountId(), costCalcArgs.getCostObjectIds().size());
                    logger.info("\u5de5\u5355\u5173\u95ed\u81ea\u52a8\u7ed3\u7b97\u7ed3\u679c\uff1a{}", (Object)SerializationUtils.toJsonString((Object)result));
                    if (result.isAllSuccess() && !result.getCalcResultIds().isEmpty()) {
                        needUpdateLogIds = calcBuilder.getNeedUpdateIds((Map)accountOrderEntryIdMap.get(costCalcArgs.getCostAccountId()));
                        if ("5".equals(result.getStatus())) {
                            calcBuilder.updateAutoCalcLog(needUpdateLogIds, AutoCalcStatusEnum.WARN.getValue(), ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a\u72b6\u6001\u4e3a\uff1a\u8b66\u544a\uff0c\u8bf7\u8054\u67e5\u7ed3\u7b97\u65e5\u5fd7\u3002", (String)"CostCalcEngine_19", (String)"macc-sca-mservice", (Object[])new Object[0]), context.getInputArgs().getCalcReportId());
                            continue;
                        }
                        if ("4".equals(result.getStatus())) {
                            calcBuilder.updateAutoCalcLog(needUpdateLogIds, AutoCalcStatusEnum.SUCCESS.getValue(), ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a\u72b6\u6001\u4e3a\uff1a\u6210\u529f\u3002", (String)"CostCalcEngine_20", (String)"macc-sca-mservice", (Object[])new Object[0]), context.getInputArgs().getCalcReportId());
                            continue;
                        }
                        calcBuilder.updateAutoCalcLog(needUpdateLogIds, AutoCalcStatusEnum.BUSINESS_FAIL.getValue(), ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a\u72b6\u6001\u4e3a\uff1a\u9519\u8bef\uff0c\u8bf7\u8054\u67e5\u7ed3\u7b97\u65e5\u5fd7\u3002", (String)"CostCalcEngine_21", (String)"macc-sca-mservice", (Object[])new Object[0]), costCalcArgs.getCalcReportId());
                        continue;
                    }
                    needUpdateLogIds = calcBuilder.getNeedUpdateIds((Map)accountOrderEntryIdMap.get(costCalcArgs.getCostAccountId()));
                    calcBuilder.updateAutoCalcLog(needUpdateLogIds, AutoCalcStatusEnum.BUSINESS_FAIL.getValue(), ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a\u72b6\u6001\u4e3a\uff1a\u9519\u8bef\uff0c\u8bf7\u8054\u67e5\u7ed3\u7b97\u65e5\u5fd7\u3002", (String)"CostCalcEngine_21", (String)"macc-sca-mservice", (Object[])new Object[0]), costCalcArgs.getCalcReportId());
                }
                catch (Exception e) {
                    this.writeErroToTaskRecord(costCalcArgs.getTaskRecordId(), e);
                    costaccountExecuteMap.put(costCalcArgs.getCostAccountId(), 0);
                    logger.error("\u81ea\u52a8\u5b8c\u5de5\u8ba1\u7b97\u8c03\u7528\u51fa\u73b0\u9519\u8bef\uff1a", (Throwable)e);
                    List<Long> needUpdateLogIds2 = calcBuilder.getNeedUpdateIds((Map)accountOrderEntryIdMap.get(costCalcArgs.getCostAccountId()));
                    calcBuilder.updateAutoCalcLog(needUpdateLogIds2, AutoCalcStatusEnum.FAIL.getValue(), String.format(ResManager.loadKDString((String)"\u5b8c\u5de5\u7ed3\u7b97\u51fa\u73b0\u9519\u8bef\uff1a", (String)"CostCalcEngine_18", (String)"macc-sca-mservice", (Object[])new Object[0]), e.getMessage()), costCalcArgs.getCalcReportId());
                }
                finally {
                    CalcMutexHelper.releaseXMutex((String)"finish", (Object)coustAccountId);
                    CalcReportHelper.updateReport((Long)costCalcArgs.getTaskRecordId(), (Long)costCalcArgs.getCalcReportId(), (Long)costCalcArgs.getCheckReportId(), (Long)((Object)context.getCheckNoPassCount()), (Long)((Object)context.getCheckRemaindCount()), (Long)((Object)context.getCalcCheckRemaindCount()), (Long)context.getCusmTimeForCheck());
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("calcExec", (Object)costaccountExecuteMap);
        if (costCalcArgsList == null) {
            json.put("error", (Object)"mutex");
        }
        return json.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CostCalcResult periodEndCalc(CostCalcArgs costCalcArgs) {
        logger.info(this.buildLogMessage("periodEndCalc", costCalcArgs));
        CostCalcContext context = new CostCalcContext();
        context.setInputArgs(costCalcArgs);
        context.setTaskType(CalcTaskType.PeriodEndCalc);
        context.setTaskConfigId(TaskHelper.PDEND_TASKID);
        context.setReportType("1");
        CostCalcResultManager resultManager = new CostCalcResultManager();
        try {
            CostCalcResult costCalcResult = this.doCalculate(context, resultManager);
            return costCalcResult;
        }
        catch (Throwable e) {
            logger.error(e);
            this.writeErroToTaskRecord(costCalcArgs.getTaskRecordId(), e);
            CostCalcResult costCalcResult = resultManager.buildResult(false);
            return costCalcResult;
        }
        finally {
            Set manuOrgIds = costCalcArgs.getManuOrgIds();
            boolean enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)Long.valueOf(String.valueOf(costCalcArgs.getCostAccountId())));
            CalcMutexHelper.releaseMuteFromSet((String)"pdend", (boolean)enableMulFactory, (Long)costCalcArgs.getCostAccountId(), (Set)manuOrgIds);
            CalcReportHelper.updateReport((Long)costCalcArgs.getTaskRecordId(), (Long)costCalcArgs.getCalcReportId(), (Long)costCalcArgs.getCheckReportId(), (Long)((Object)context.getCheckNoPassCount()), (Long)((Object)context.getCheckRemaindCount()), (Long)((Object)context.getCalcCheckRemaindCount()), (Long)context.getCusmTimeForCheck());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CostCalcResult finishCalcCheck(CostCalcArgs costCalcArgs) {
        logger.info(this.buildLogMessage("finishCalcCheck", costCalcArgs));
        costCalcArgs.setCheckWay(0);
        costCalcArgs.setCalc(Boolean.valueOf(false));
        costCalcArgs.setStartTime(new Date());
        CostCalcContext context = new CostCalcContext();
        context.setInputArgs(costCalcArgs);
        context.setTaskType(CalcTaskType.FinishCalcCheck);
        context.setReportType("2");
        CostCalcResultManager resultManager = new CostCalcResultManager();
        try {
            CostCalcResult costCalcResult = this.doCalculate(context, resultManager);
            return costCalcResult;
        }
        catch (Throwable e) {
            logger.error(e);
            this.writeErroToTaskRecord(costCalcArgs.getTaskRecordId(), e);
            CostCalcResult costCalcResult = resultManager.buildResult(false);
            return costCalcResult;
        }
        finally {
            CalcReportHelper.updateReport((Long)costCalcArgs.getTaskRecordId(), (Long)costCalcArgs.getCalcReportId(), (Long)costCalcArgs.getCheckReportId(), (Long)((Object)context.getCheckNoPassCount()), (Long)((Object)context.getCheckRemaindCount()), (Long)((Object)context.getCalcCheckRemaindCount()), (Long)context.getCusmTimeForCheck());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CostCalcResult periodEndCalcCheck(CostCalcArgs costCalcArgs) {
        logger.info(this.buildLogMessage("periodEndCalcCheck", costCalcArgs));
        costCalcArgs.setCheckWay(0);
        costCalcArgs.setCalc(Boolean.valueOf(false));
        CostCalcContext context = new CostCalcContext();
        context.setInputArgs(costCalcArgs);
        context.setTaskType(CalcTaskType.PeriodEndCalcCheck);
        context.setTaskConfigId(TaskHelper.PDEND_TASKID);
        context.setReportType("1");
        CostCalcResultManager resultManager = new CostCalcResultManager();
        try {
            CostCalcResult costCalcResult = this.doCalculate(context, resultManager);
            return costCalcResult;
        }
        catch (Throwable e) {
            logger.error(e);
            this.writeErroToTaskRecord(costCalcArgs.getTaskRecordId(), e);
            CostCalcResult costCalcResult = resultManager.buildResult(false);
            return costCalcResult;
        }
        finally {
            CalcReportHelper.updateReport((Long)costCalcArgs.getTaskRecordId(), (Long)costCalcArgs.getCalcReportId(), (Long)costCalcArgs.getCheckReportId(), (Long)((Object)context.getCheckNoPassCount()), (Long)((Object)context.getCheckRemaindCount()), (Long)((Object)context.getCalcCheckRemaindCount()), (Long)context.getCusmTimeForCheck());
        }
    }

    private String buildLogMessage(String mothedName, CostCalcArgs costCalcArgs) {
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u6210\u672c\u8ba1\u7b97-", (String)"CostCalcEngine_12", (String)"macc-sca-mservice", (Object[])new Object[0])).append(mothedName).append(": ");
        sb.append("isCalc=").append(costCalcArgs.isCalc()).append(", ");
        sb.append("checkResult=").append(costCalcArgs.getCheckResultId()).append(", ");
        sb.append("matCal='").append(costCalcArgs.getMatCalType()).append("', ");
        sb.append("mfgCal='").append(costCalcArgs.getMfgCalType()).append("', ");
        sb.append("org=").append(costCalcArgs.getOrgId()).append(", ");
        sb.append("costAcct=").append(costCalcArgs.getCostAccountId()).append(", ");
        sb.append("costtype=").append(costCalcArgs.getCostTypeId()).append(", ");
        sb.append("period=").append(costCalcArgs.getPeriodId()).append(", ");
        sb.append("manuOrgId=").append(costCalcArgs.getManuOrgId()).append(", ");
        if (costCalcArgs.getCostCenterIds() == null || costCalcArgs.getCostCenterIds().isEmpty()) {
            sb.append("costCenters=null, ");
        } else if (costCalcArgs.getCostCenterIds().size() <= 10) {
            sb.append("costCenters=[").append(StringUtils.join((Object[])costCalcArgs.getCostCenterIds().toArray(), (String)",")).append("], ");
        } else {
            sb.append("costCenters.size=").append(costCalcArgs.getCostCenterIds().size()).append(", ");
        }
        if (costCalcArgs.getCostObjectIds() == null || costCalcArgs.getCostObjectIds().isEmpty()) {
            sb.append("costObjects=null, ");
        } else if (costCalcArgs.getCostObjectIds().size() <= 50) {
            sb.append("costObjects=[").append(StringUtils.join((Object[])costCalcArgs.getCostObjectIds().toArray(), (String)",")).append("]");
        } else {
            sb.append("costObjects.size=").append(costCalcArgs.getCostObjectIds().size());
        }
        return sb.toString();
    }

    private CostCalcResult doCalculate(CostCalcContext context, CostCalcResultManager resultManager) {
        CostCalcResult result = new CostCalcResult();
        resultManager.setResult(result);
        boolean isSuccess = true;
        List<ICalcAction> actions = ICalcAction.create(context.getTaskType());
        try {
            for (ICalcAction action : actions) {
                action.setContext(context);
                action.setResultManager(resultManager);
                action.execute();
                if (!resultManager.isSkipNextAction()) continue;
                break;
            }
        }
        catch (Exception ex) {
            logger.error("\u6210\u672c\u8ba1\u7b97\u51fa\u73b0\u9519\u8bef\uff1a{}", (Object)ex.getMessage());
            isSuccess = false;
            String errMsg = this.getExceptionErrorInfo(ex);
            if (ex instanceof KDBizException && !StringUtils.isEmpty((CharSequence)ex.getMessage())) {
                errMsg = ex.getMessage();
            }
            long currentDetailId = resultManager.getTaskRecorder().getCurrentTaskRecordDetail();
            resultManager.getTaskRecorder().insertCalcErrorInfo(currentDetailId, 0L, errMsg);
            throw ex;
        }
        finally {
            AfterCalcAction action = new AfterCalcAction();
            action.setContext(context);
            action.setResultManager(resultManager);
            action.execute();
        }
        return resultManager.buildResult(isSuccess);
    }

    private void writeErroToTaskRecord(Long taskRecordId, Throwable ex) {
        if (taskRecordId == null) {
            return;
        }
        if (ex == null) {
            return;
        }
        String errormsg = null;
        String errInfo = this.getExceptionErrorInfo(ex);
        if (ex instanceof KDBizException && !StringUtils.isEmpty((CharSequence)ex.getMessage())) {
            errormsg = ex.getMessage();
            errInfo = ex.getMessage();
        } else {
            errormsg = errInfo;
        }
        this.writeErroToTaskRecord(taskRecordId, ex, errInfo, errormsg);
    }

    private void writeErroToTaskRecord(Long taskRecordId, Throwable ex, String errInfo, String errMsg) {
        QFilter filter = new QFilter("id", "=", (Object)taskRecordId);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id,progress,time,starttime,status,entryentity.subname,entryentity.detailconfig,entryentity.substatus,entryentity.substarttime,entryentity.subtime,entryentity.detail,entryentity.subparam,entryentity.subparam_tag", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        if (records == null || records.length == 0) {
            return;
        }
        DynamicObject record = records[0];
        record.set("progress", (Object)100);
        record.set("time", (Object)TimeUtils.getSecond((Date)record.getDate("starttime"), (Date)new Date()));
        record.set("status", (Object)"3");
        DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
        DynamicObject doingEntry = null;
        for (DynamicObject entry : entrys) {
            if ("2".equals(entry.getString("substatus"))) {
                doingEntry = entry;
                break;
            }
            if (doingEntry != null || !"1".equals(entry.getString("substatus"))) continue;
            doingEntry = entry;
        }
        if (doingEntry == null) {
            if (!entrys.isEmpty()) {
                doingEntry = (DynamicObject)entrys.get(entrys.size() - 1);
            } else {
                doingEntry = entrys.addNew();
                doingEntry.set("subname", (Object)ResManager.loadKDString((String)"\u8ba1\u7b97\u8fc7\u7a0b\u8c03\u5ea6", (String)"CostCalcEngine_13", (String)"macc-sca-mservice", (Object[])new Object[0]));
            }
        }
        if (doingEntry != null) {
            if (doingEntry.getInt("subtime") == 0) {
                doingEntry.set("substarttime", (Object)new Date());
                doingEntry.set("subtime", (Object)"1");
            }
            doingEntry.set("substatus", (Object)"3");
            doingEntry.set("detail", (Object)(errInfo.length() > 255 ? errInfo.substring(0, 255) : errInfo));
            doingEntry.set("subparam_tag", (Object)errMsg);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
    }

    private String getExceptionErrorInfo(Throwable ex) {
        StringBuilder erroStr = new StringBuilder();
        String errormsg = ex.getCause() == null ? (ex.getLocalizedMessage() == null ? "" : ex.getLocalizedMessage()) : ex.getCause().getMessage();
        erroStr.append(errormsg).append("\n");
        erroStr.append(this.toStackTrace(ex));
        return erroStr.toString();
    }

    private String toStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            return sw.toString();
        }
        catch (Exception e1) {
            logger.error("\u5931\u8d25", (Throwable)e1);
            return "";
        }
    }
}

