/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.sca.algox.constants.FinshCalcCheck;
import kd.macc.sca.algox.utils.FinishCalcHelper;
import kd.macc.sca.algox.wip.input.CalcDataArgs;
import kd.macc.sca.common.costcalc.CostCalcArgs;
import kd.macc.sca.common.enums.AutoCalcStatusEnum;
import kd.macc.sca.mservice.costcalc.MatAllocImportHelper;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang.StringUtils;

public class CostRealtimeCalcBuilder {
    private static final Log logger = LogFactory.getLog(CostRealtimeCalcBuilder.class);
    private Map<Long, DynamicObject> mapAccountPeriod = new HashMap<Long, DynamicObject>(16);
    private Map<Long, Long> mapCalpolicyCurrency = new HashMap<Long, Long>(16);
    private Map<String, Set<Long>> mapAccountCostObjRange = new HashMap<String, Set<Long>>(16);
    private Map<Long, DynamicObjectCollection> mapOrgCostaccount = new HashMap<Long, DynamicObjectCollection>(16);
    private Map<Long, Boolean> mapEnableFactory = new HashMap<Long, Boolean>();
    private static final String UPDATE_AUTOCALC_ERR_LOG = "update t_sca_autocalclog set fstatus=?,flastexecdate=?,ftrytimes=ftrytimes+1,fexeclog=?,fcalcreportid=? where fid in(%s)";
    private static final String UPDATE_AUTOCALC_RUN_LOG = "update t_sca_autocalclog set fstatus=?,flastexecdate=?,fexeclog=? where fid in(%s)";
    private static final int MAX_EXECUTE_SIZE = 50000;
    private static final int MIN_EXECUTE_SIZE = 10;
    private static final int DEFAULT_EXECUTE_SIZE = 20000;
    private static final String CODE_EXECSIZE = "scaautofinexecsize";
    private static final String CODE_APPID = "macc";
    private static final int[] EXECUTE_INTERVAL_MIN = new int[]{10, 30, 60, 120, 240, 480, 960, 1920, 3840, 7680, 10560, 15360};

    public List<CostCalcArgs> getFinishCalcList(Long orgId, List<Long> costaccountIds, String operType, Map<Long, Map<Long, List<Long>>> accountOrderEntryIdMap) {
        ArrayList<CostCalcArgs> costCalcArgs = new ArrayList<CostCalcArgs>();
        try (DLock lock = null;){
            String lockId = "CostRealtimeCalcBuilder-calc" + orgId;
            lock = DLock.create((String)lockId, (String)ResManager.loadKDString((String)"\u81ea\u52a8\u5b8c\u5de5\u7ed3\u7b97", (String)"CostRealtimeCalcBuilder_22", (String)"macc-sca-mservice", (Object[])new Object[0]));
            boolean isLocked = lock.tryLock();
            if (!isLocked) {
                List<CostCalcArgs> list = null;
                return list;
            }
            Map<Long, Map<Long, List<Long>>> accountEntryIdMap = this.getNeedFinishCalcEntryList(orgId, costaccountIds, operType);
            if (accountEntryIdMap.isEmpty()) {
                ArrayList<CostCalcArgs> arrayList = costCalcArgs;
                return arrayList;
            }
            accountOrderEntryIdMap.putAll(accountEntryIdMap);
            boolean needCheckRange = true;
            if ("FINISH_CALC".equals(operType)) {
                needCheckRange = false;
            }
            costCalcArgs.addAll(this.getFinishCalcList(orgId, accountOrderEntryIdMap, needCheckRange));
        }
        return costCalcArgs;
    }

    private Map<Long, Map<Long, List<Long>>> getNeedFinishCalcEntryList(Long orgId, List<Long> costaccountIds, String operType) {
        HashMap accountOrderEntryIdMap = Maps.newHashMapWithExpectedSize((int)2);
        if ("FINISH_CALC".equals(operType)) {
            DynamicObjectCollection orgCostaccounts = this.getOrgCostaccount(orgId);
            DynamicObjectCollection calcOrgCostaccounts = null;
            if (costaccountIds != null && !costaccountIds.contains(0L)) {
                calcOrgCostaccounts = new DynamicObjectCollection();
                for (DynamicObject orgCostaccount : orgCostaccounts) {
                    if (!costaccountIds.contains(orgCostaccount.getLong("id"))) continue;
                    calcOrgCostaccounts.add((Object)orgCostaccount);
                }
            } else {
                calcOrgCostaccounts = orgCostaccounts;
            }
            for (DynamicObject orgCostaccount : calcOrgCostaccounts) {
                Set<Long> costobjects;
                Long id = orgCostaccount.getLong("id");
                DynamicObject currentPeriod = this.getCurrentPeriod(id);
                if (currentPeriod == null || (costobjects = this.getAllCostObjectRange(orgId, id, null, currentPeriod.getLong("id"))).isEmpty()) continue;
                List<Long> mftOrderEntryIds = this.getCostObjectProbillIds(costobjects);
                for (Long orderentryId : mftOrderEntryIds) {
                    accountOrderEntryIdMap.computeIfAbsent(id, t -> Maps.newHashMapWithExpectedSize((int)16)).put(orderentryId, null);
                }
            }
            return accountOrderEntryIdMap;
        }
        int top = this.getDefaultExeSize();
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountFilter = new QFilter("costaccount", "in", costaccountIds);
        Date startDay = DateUtils.getThisMonthFirstDay();
        Date endDay = DateUtils.getThisMonthEndDay();
        QFilter timeFilter = new QFilter("syncdate", ">=", (Object)startDay);
        timeFilter.and("syncdate", "<=", (Object)endDay);
        QFilter sourceType = null;
        if ("PAGEAUTOCALC".equals(operType)) {
            sourceType = new QFilter("status", "in", (Object)new String[]{AutoCalcStatusEnum.NOT_EXECUTE.getValue()});
            top = 200;
        } else {
            sourceType = new QFilter("status", "in", (Object)new String[]{AutoCalcStatusEnum.NOT_EXECUTE.getValue(), AutoCalcStatusEnum.FAIL.getValue(), AutoCalcStatusEnum.BUSINESS_FAIL.getValue()});
        }
        DataSet autoCalcLogDs = QueryServiceHelper.queryDataSet((String)"orderclose", (String)"sca_autocalclog", (String)"id,org,costaccount,orderentryid,status,lastexecdate,trytimes", (QFilter[])new QFilter[]{orgFilter, costaccountFilter, timeFilter, sourceType}, null);
        ArrayList allBillIds = Lists.newArrayListWithExpectedSize((int)16);
        int i = 0;
        Date curDate = new Date();
        for (Row row : autoCalcLogDs) {
            int minute;
            Date exeDate;
            Long accountId = row.getLong("costaccount");
            Long orderentryId = row.getLong("orderentryid");
            Long id = row.getLong("id");
            String status = row.getString("status");
            Date lastexecdate = row.getDate("lastexecdate");
            int trytimes = row.getInteger("trytimes");
            if ((AutoCalcStatusEnum.FAIL.getValue().equals(status) || AutoCalcStatusEnum.BUSINESS_FAIL.getValue().equals(status) && lastexecdate != null) && (trytimes > EXECUTE_INTERVAL_MIN.length - 1 || (exeDate = org.apache.commons.lang3.time.DateUtils.addMinutes((Date)lastexecdate, (int)(minute = EXECUTE_INTERVAL_MIN[trytimes]))).after(curDate))) continue;
            allBillIds.add(id);
            accountOrderEntryIdMap.computeIfAbsent(accountId, t -> Maps.newHashMapWithExpectedSize((int)16)).computeIfAbsent(orderentryId, t -> new ArrayList(1)).add(id);
            if (++i < top) continue;
            break;
        }
        if (accountOrderEntryIdMap.isEmpty()) {
            return accountOrderEntryIdMap;
        }
        DynamicObjectCollection costAccounts = this.getOrgCostaccount(orgId);
        ArrayList accountIds = Lists.newArrayList();
        costAccounts.forEach(t -> accountIds.add(t.getLong("id")));
        this.updateAutoCalcLog(allBillIds, AutoCalcStatusEnum.RUNNING.getValue(), " ");
        HashMap accountOrderEntryIdNewMap = Maps.newHashMapWithExpectedSize((int)2);
        for (Map.Entry entry : accountOrderEntryIdMap.entrySet()) {
            if (accountIds.contains(entry.getKey())) {
                accountOrderEntryIdNewMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            List<Long> needUpdateLogIds = this.getNeedUpdateIds((Map)entry.getValue());
            this.updateAutoCalcLog(new ArrayList<Long>(needUpdateLogIds), AutoCalcStatusEnum.BUSINESS_FAIL.getValue(), ResManager.loadKDString((String)"\u672a\u5339\u914d\u8d26\u8584\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"CostRealtimeCalcBuilder_14", (String)"macc-sca-mservice", (Object[])new Object[0]));
        }
        return accountOrderEntryIdNewMap;
    }

    private int getDefaultExeSize() {
        int batchSize = 20000;
        Integer cacheBatchSize = (Integer)AppCache.get((String)CODE_APPID).get(CODE_EXECSIZE, Integer.class);
        if (cacheBatchSize == null) {
            batchSize = CadBgParamUtils.getScmParamForInt((String)CODE_EXECSIZE, (int)20000);
            if (batchSize > 50000) {
                batchSize = 50000;
            } else if (batchSize < 10) {
                batchSize = 10;
            }
            AppCache.get((String)CODE_APPID).put(CODE_EXECSIZE, (Object)batchSize);
        } else {
            batchSize = cacheBatchSize;
        }
        return batchSize;
    }

    public List<CostCalcArgs> getFinishCalcList(Long orgId, Map<Long, Map<Long, List<Long>>> accountOrderEntryIdMap, boolean needCheckRange) {
        DynamicObjectCollection costobjects = null;
        String errorMsg = ResManager.loadKDString((String)"\u672a\u6b63\u786e\u5f52\u96c6\u5230\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"CostRealtimeCalcBuilder_23", (String)"macc-sca-mservice", (Object[])new Object[0]);
        try {
            long time = System.currentTimeMillis();
            costobjects = this.checkAndImport(orgId, accountOrderEntryIdMap);
            logger.info("\u81ea\u52a8\u5b8c\u5de5\u7ed3\u7b97-\u5f52\u96c6{}\u6761\u6570\u636e\u8017\u8d39\u65f6\u95f4{}\u79d2", (Object)accountOrderEntryIdMap.size(), (Object)((double)(System.currentTimeMillis() - time) / 1000.0));
        }
        catch (KDBizException ex) {
            logger.error("\u81ea\u52a8\u5b8c\u5de5\u7ed3\u7b97-\u81ea\u52a8\u5f52\u96c6\u5931\u8d25\uff1a{}", (Object)ex.getMessage());
            errorMsg = ex.getMessage();
        }
        catch (Exception ex) {
            logger.error("\u81ea\u52a8\u5b8c\u5de5\u7ed3\u7b97-\u81ea\u52a8\u5f52\u96c6\u5931\u8d25\uff1a{}", (Object)ex.getMessage());
            logger.error((Throwable)ex);
        }
        if (costobjects == null) {
            costobjects = new DynamicObjectCollection();
        }
        HashSet costobjectProbillIds = Sets.newHashSetWithExpectedSize((int)costobjects.size());
        costobjects.forEach(t -> costobjectProbillIds.add(t.getLong("probill")));
        HashSet needUpdateLogIds = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : accountOrderEntryIdMap.entrySet()) {
            Map<Long, List<Long>> orderEntryIdToLogMap = entry.getValue();
            HashSet<Long> accountKeySet = new HashSet<Long>(orderEntryIdToLogMap.keySet());
            accountKeySet.removeAll(costobjectProbillIds);
            for (Long proId : accountKeySet) {
                List<Long> billIds = orderEntryIdToLogMap.remove(proId);
                if (CadEmptyUtils.isEmpty(billIds)) continue;
                needUpdateLogIds.addAll(billIds);
            }
        }
        if (!needUpdateLogIds.isEmpty()) {
            this.updateAutoCalcLog(new ArrayList<Long>(needUpdateLogIds), AutoCalcStatusEnum.FAIL.getValue(), errorMsg);
        }
        if (costobjects.isEmpty()) {
            return Lists.newArrayList();
        }
        return this.getFinishCalcArgs(orgId, (List<DynamicObject>)costobjects, accountOrderEntryIdMap, needCheckRange);
    }

    private List<CostCalcArgs> getFinishCalcArgs(Long accountOrgId, List<DynamicObject> costobjects, Map<Long, Map<Long, List<Long>>> accountOrderEntryIdMap, boolean needCheckRange) {
        ArrayList<CostCalcArgs> costCalcArgs = new ArrayList<CostCalcArgs>();
        HashMap accountObjects = Maps.newHashMapWithExpectedSize((int)8);
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : accountOrderEntryIdMap.entrySet()) {
            Map<Long, List<Long>> entryValue = entry.getValue();
            for (DynamicObject obj : costobjects) {
                if (!entryValue.containsKey(obj.getLong("probill"))) continue;
                accountObjects.computeIfAbsent(entry.getKey(), t -> Lists.newArrayList()).add(obj);
            }
        }
        DynamicObjectCollection costaccountDyns = this.getOrgCostaccount(accountOrgId);
        for (Map.Entry accountCostOjbectEntry : accountObjects.entrySet()) {
            Map<Long, List<Long>> orderEntryMap = accountOrderEntryIdMap.get(accountCostOjbectEntry.getKey());
            DynamicObject costAccount = null;
            for (DynamicObject costaccountDyn : costaccountDyns) {
                if (!((Long)accountCostOjbectEntry.getKey()).equals(costaccountDyn.getLong("id"))) continue;
                costAccount = costaccountDyn;
                break;
            }
            if (costAccount == null) {
                List<Long> needUpdateLogIds = this.getNeedUpdateIds(orderEntryMap);
                this.updateAutoCalcLog(needUpdateLogIds, AutoCalcStatusEnum.BUSINESS_FAIL.getValue(), ResManager.loadKDString((String)"\u672a\u5339\u914d\u8d26\u8584\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"CostRealtimeCalcBuilder_14", (String)"macc-sca-mservice", (Object[])new Object[0]));
                continue;
            }
            String errorMsg = ResManager.loadKDString((String)"\u672a\u6b63\u786e\u83b7\u53d6\u5230\u7ed3\u7b97\u53c2\u6570\u3002", (String)"CostRealtimeCalcBuilder_24", (String)"macc-sca-mservice", (Object[])new Object[0]);
            try {
                CostCalcArgs costCalcArg = this.getCostAccount(accountOrgId, costAccount, (List)accountCostOjbectEntry.getValue(), orderEntryMap, needCheckRange);
                if (costCalcArg != null) {
                    costCalcArgs.add(costCalcArg);
                    continue;
                }
                accountOrderEntryIdMap.remove(accountCostOjbectEntry.getKey());
            }
            catch (Exception ex) {
                if (ex instanceof KDBizException) {
                    errorMsg = ex.getMessage();
                }
                List<Long> needUpdateLogIds = this.getNeedUpdateIds(orderEntryMap);
                this.updateAutoCalcLog(needUpdateLogIds, AutoCalcStatusEnum.FAIL.getValue(), errorMsg);
            }
        }
        return costCalcArgs;
    }

    public List<Long> getNeedUpdateIds(Map<Long, List<Long>> entryValue) {
        if (entryValue == null) {
            return null;
        }
        HashSet needUpdateLogIds = Sets.newHashSetWithExpectedSize((int)16);
        for (List<Long> value : entryValue.values()) {
            if (value == null) continue;
            needUpdateLogIds.addAll(value);
        }
        return new ArrayList<Long>(needUpdateLogIds);
    }

    private CostCalcArgs getCostAccount(Long accountOrgId, DynamicObject costAccount, List<DynamicObject> costobjects, Map<Long, List<Long>> orderEntryMap, boolean needCheckRange) {
        CostCalcArgs costCalcArg = new CostCalcArgs();
        costCalcArg.setOrgId(accountOrgId);
        costCalcArg.setCostAccountId(Long.valueOf(costAccount.getLong("id")));
        HashSet costObjectIds = new HashSet(10);
        HashSet costcenterIds = new HashSet(10);
        costobjects.forEach(t -> {
            Long id = t.getLong("id");
            Long costcenter = t.getLong("costcenter");
            costObjectIds.add(id);
            costcenterIds.add(costcenter);
        });
        costCalcArg.setCostObjectIds(costObjectIds);
        DynamicObject currentPeriod = this.getCurrentPeriod(costCalcArg.getCostAccountId());
        if (currentPeriod == null) {
            logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u6210\u672c\u8d26\u7c3f(costAccountId={})\u7684\u6838\u7b97\u671f\u95f4\u4e0d\u5b58\u5728", (Object)costCalcArg.getCostAccountId());
            List<Long> needUpdateLogIds = this.getNeedUpdateIds(orderEntryMap);
            this.updateAutoCalcLog(needUpdateLogIds, AutoCalcStatusEnum.BUSINESS_FAIL.getValue(), ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u6ca1\u6709\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CostRealtimeCalcBuilder_25", (String)"macc-sca-mservice", (Object[])new Object[0]));
            return null;
        }
        costCalcArg.setPeriodId(Long.valueOf(currentPeriod.getLong("id")));
        costCalcArg.setStartDate(currentPeriod.getDate("begindate"));
        costCalcArg.setEndDate(currentPeriod.getDate("enddate"));
        Long currency = this.getCalpolicyCurrency(costAccount.getLong("calpolicy"));
        if (currency == null) {
            logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u6210\u672c\u8d26\u7c3f(costAccountId=" + costCalcArg.getCostAccountId() + ")\u7684\u6838\u7b97\u653f\u7b56\u7684\u5e01\u522b\u4e0d\u5b58\u5728");
            List<Long> needUpdateLogIds = this.getNeedUpdateIds(orderEntryMap);
            this.updateAutoCalcLog(needUpdateLogIds, AutoCalcStatusEnum.BUSINESS_FAIL.getValue(), ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6210\u672c\u8d26\u7c3f\u5bf9\u5e94\u7684\u5e01\u522b\u3002", (String)"CostRealtimeCalcBuilder_26", (String)"macc-sca-mservice", (Object[])new Object[0]));
            return null;
        }
        costCalcArg.setCurrencyId(currency);
        if (needCheckRange) {
            Set<Long> costObjectRange = this.getAllCostObjectRange(costCalcArg.getOrgId(), costCalcArg.getCostAccountId(), costCalcArg.getCostCenterIds(), costCalcArg.getPeriodId());
            HashSet errorCostobjectRange = Sets.newHashSet();
            errorCostobjectRange.addAll(costCalcArg.getCostObjectIds());
            errorCostobjectRange.removeAll(costObjectRange);
            if (!errorCostobjectRange.isEmpty()) {
                Map<Long, DynamicObject> costobjectPlanDynMap = this.getCostobjectPlanDyns(errorCostobjectRange, costCalcArg);
                ArrayList closeStatusLogIds = Lists.newArrayList();
                ArrayList timeLogIds = Lists.newArrayList();
                ArrayList otherLogIds = Lists.newArrayList();
                for (DynamicObject costobject : costobjects) {
                    Long probillId;
                    List<Long> orderEntryIds;
                    if (!errorCostobjectRange.contains(costobject.getLong("id")) || (orderEntryIds = orderEntryMap.remove(probillId = Long.valueOf(costobject.getLong("probill")))) == null) continue;
                    DynamicObject planObj = (DynamicObject)costobjectPlanDynMap.get(costobject.getLong("id"));
                    if (planObj != null) {
                        boolean closestatu = planObj.getBoolean("closestatu");
                        Date closedatetime = planObj.getDate("closedatetime");
                        if (!closestatu) {
                            closeStatusLogIds.addAll(orderEntryIds);
                            continue;
                        }
                        if (closedatetime != null && (closedatetime.before(costCalcArg.getStartDate()) || closedatetime.after(costCalcArg.getEndDate()))) {
                            timeLogIds.addAll(orderEntryIds);
                            continue;
                        }
                    }
                    otherLogIds.addAll(orderEntryIds);
                }
                this.updateAutoCalcLog(closeStatusLogIds, AutoCalcStatusEnum.BUSINESS_FAIL.getValue(), ResManager.loadKDString((String)"\u8bc6\u522b\u5230\u5de5\u5355\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u201c\u5173\u95ed\u201d\u3002", (String)"CostRealtimeCalcBuilder_27", (String)"macc-sca-mservice", (Object[])new Object[0]));
                this.updateAutoCalcLog(timeLogIds, AutoCalcStatusEnum.BUSINESS_FAIL.getValue(), ResManager.loadKDString((String)"\u5de5\u5355\u884c\u7684\u5173\u95ed\u8bb0\u8d26\u65e5\u671f\u4e0d\u5728\u5f53\u524d\u671f\u95f4\u3002", (String)"CostRealtimeCalcBuilder_28", (String)"macc-sca-mservice", (Object[])new Object[0]));
                this.updateAutoCalcLog(otherLogIds, AutoCalcStatusEnum.BUSINESS_FAIL.getValue(), ResManager.loadKDString((String)"\u6210\u672c\u5bf9\u8c61\u4e0d\u5728\u672c\u671f\u7684\u8ba1\u7b97\u8303\u56f4\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u7ed3\u7b97\u3002", (String)"CostRealtimeCalcBuilder_19", (String)"macc-sca-mservice", (Object[])new Object[0]));
            }
            costCalcArg.getCostObjectIds().retainAll(costObjectRange);
            if (CollectionUtils.isEmpty((Collection)costCalcArg.getCostObjectIds())) {
                logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u6210\u672c\u8d26\u7c3f(costAccountId={})\u7684\u6838\u7b97\u671f\u95f4(periodId={})\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61", (Object)costCalcArg.getCostAccountId(), (Object)costCalcArg.getPeriodId());
                return null;
            }
        }
        costCalcArg.setCostTypeId(Long.valueOf(costAccount.getLong("costtype")));
        this.putCostCalcArgsOtherInfo(costCalcArg);
        if (costCalcArg.getCostObjectIds().isEmpty()) {
            return null;
        }
        HashSet manuorgSet = Sets.newHashSetWithExpectedSize((int)6);
        HashMap<Long, Integer> mapCostCenterObjSize = new HashMap<Long, Integer>(16);
        for (DynamicObject dyobj : costobjects) {
            Integer len;
            Long id = dyobj.getLong("id");
            Long costcenter = dyobj.getLong("costcenter");
            if (!costCalcArg.getCostObjectIds().contains(id)) continue;
            Long manuorg = dyobj.getLong("manuorg");
            if (!CadEmptyUtils.isEmpty((Long)manuorg)) {
                manuorgSet.add(manuorg);
            }
            len = (len = (Integer)mapCostCenterObjSize.get(costcenter)) == null ? Integer.valueOf(1) : Integer.valueOf(len + 1);
            mapCostCenterObjSize.put(costcenter, len);
            break;
        }
        boolean isOrgEnableMultiFactory = this.getEnableFactory(accountOrgId);
        costCalcArg.setEnableMulFactory(isOrgEnableMultiFactory);
        if (!isOrgEnableMultiFactory) {
            manuorgSet.clear();
        }
        costCalcArg.setManuOrgIds((Set)manuorgSet);
        costCalcArg.setCcAndCoInfos(mapCostCenterObjSize);
        costCalcArg.setAppNum("sca");
        return costCalcArg;
    }

    private Map<Long, DynamicObject> getCostobjectPlanDyns(Set<Long> costobjectIds, CostCalcArgs costCalcArg) {
        QFilter filter = new QFilter("costobject", "in", costobjectIds);
        filter.and("accountorg", "=", (Object)costCalcArg.getOrgId());
        filter.and("srcbilltype", "not in", (Object)new String[]{"pom_xmftorderlog", "om_xmftorderlog", "pom_mftorder_splitlog", "om_mftorder_splitog"});
        HashMap dynplanMap = Maps.newHashMapWithExpectedSize((int)10);
        DynamicObjectCollection dynPlans = QueryServiceHelper.query((String)"cad_plannedoutputbill", (String)"id,costobject,closestatu,closedatetime", (QFilter[])filter.toArray());
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)dynPlans)) {
            return dynplanMap;
        }
        for (DynamicObject dyn : dynPlans) {
            dynplanMap.put(dyn.getLong("costobject"), dyn);
        }
        return dynplanMap;
    }

    private DynamicObjectCollection getCostObject(Collection<Long> calcList, Map<Long, DynamicObject> mfbillentryCostobjectMap) {
        DynamicObjectCollection costObjects = new DynamicObjectCollection();
        for (Long id : calcList) {
            DynamicObject costObj = mfbillentryCostobjectMap.get(id);
            if (costObj == null) continue;
            costObjects.add((Object)costObj);
        }
        return costObjects;
    }

    private List<Long> getProbills(DynamicObjectCollection costobjects) {
        ArrayList<Long> probills = new ArrayList<Long>();
        for (DynamicObject costObject : costobjects) {
            probills.add(costObject.getLong("probill"));
        }
        return probills;
    }

    private Set<Long> checkMatAlloc(Long accountId, DynamicObjectCollection costobjects) {
        HashMap mfpMap = new HashMap();
        HashMap matMap = new HashMap();
        List<Long> mftorderentryids = this.getProbills(costobjects);
        QFilter sourceFilter = new QFilter("billentry.manuentryid", "in", mftorderentryids);
        sourceFilter.and("billstatus", "=", (Object)"C");
        DataSet mdcProOrderDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_mdc_mftproorder", (String)"id,billentry.manuentryid entryid", (QFilter[])sourceFilter.toArray(), null);
        DataSet omProOrderDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_mdc_omoutbill", (String)"id,billentry.manuentryid entryid", (QFilter[])sourceFilter.toArray(), null);
        mdcProOrderDs = mdcProOrderDs.union(omProOrderDs);
        if (!mdcProOrderDs.isEmpty()) {
            mdcProOrderDs = mdcProOrderDs.groupBy(new String[]{"entryid"}).count("totalcount").finish();
            mdcProOrderDs.forEach(t -> mfpMap.put(t.getLong("entryid"), t.getInteger("totalcount")));
            mdcProOrderDs.close();
        }
        if (mfpMap.isEmpty()) {
            return null;
        }
        HashMap costobjectEntryIdMap = new HashMap(16);
        HashMap mfbillentryCostobjectMap = new HashMap(16);
        HashSet costOjectIds = new HashSet();
        costobjects.forEach(t -> {
            Long costObjectId = t.getLong("id");
            costobjectEntryIdMap.put(costObjectId, t.getLong("probill"));
            costOjectIds.add(costObjectId);
            mfbillentryCostobjectMap.put(t.getLong("probill"), costObjectId);
        });
        QFilter targetFilter = new QFilter("entryentity.costobejctentry", "in", costOjectIds);
        targetFilter.and("costaccount", "=", (Object)accountId);
        targetFilter.and("allocstatus", "=", (Object)"2");
        DataSet matAllocDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sca_matalloc", (String)"id,costaccount,entryentity.costobejctentry entryid", (QFilter[])targetFilter.toArray(), null);
        if (!matAllocDs.isEmpty()) {
            matAllocDs = matAllocDs.groupBy(new String[]{"entryid"}).count("totalcount").finish();
            matAllocDs.forEach(t -> {
                Long entryid = (Long)costobjectEntryIdMap.get(t.getLong("entryid"));
                matMap.put(entryid, t.getInteger("totalcount"));
            });
            matAllocDs.close();
        }
        ArrayList<Long> noCalcList = new ArrayList<Long>();
        for (Map.Entry mfpEntry : mfpMap.entrySet()) {
            Long entryid = (Long)mfpEntry.getKey();
            if (matMap.containsKey(entryid)) {
                int count = (Integer)mfpEntry.getValue();
                if ((Integer)matMap.get(entryid) == count) continue;
                noCalcList.add(entryid);
                continue;
            }
            noCalcList.add(entryid);
        }
        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u6570\u636e\u4e0d\u5b8c\u6574\u7684\u5de5\u5355\u5206\u5f55\u5217\u8868:{}", (Object)StringUtils.join(noCalcList, (String)","));
        if (noCalcList.isEmpty()) {
            return null;
        }
        HashSet<Long> noAllocObjects = new HashSet<Long>(16);
        for (Long noCalcOrder : noCalcList) {
            noAllocObjects.add((Long)mfbillentryCostobjectMap.get(noCalcOrder));
        }
        return noAllocObjects;
    }

    private Set<Long> getAllCostObjectRange(Long orgId, Long costaccountId, List<Long> costcenters, Long periodId) {
        String key = String.format("%1$s@%2$s@%3$s", orgId, costaccountId, periodId);
        if (this.mapAccountCostObjRange.containsKey(key)) {
            return this.mapAccountCostObjRange.get(key);
        }
        CalcDataArgs args = new CalcDataArgs();
        args.setOrgId((Object)orgId);
        args.setCostAcctId((Object)costaccountId);
        args.setPeriodId((Object)periodId);
        Set costobjectRange = FinishCalcHelper.getFinishedCostObject((CalcDataArgs)args);
        this.mapAccountCostObjRange.put(key, costobjectRange);
        return costobjectRange;
    }

    private void putCostCalcArgsOtherInfo(CostCalcArgs costCalcArgs) {
        String[] rates;
        String finishRate;
        costCalcArgs.setCheckWay(1);
        costCalcArgs.setMatCalType("3");
        costCalcArgs.setMfgCalType("4");
        costCalcArgs.setMinDiffRate(new BigDecimal("-0.1"));
        costCalcArgs.setMaxDiffRate(new BigDecimal("0.1"));
        QFilter[] filters = new QFilter[]{new QFilter("user", "=", (Object)RequestContext.getOrCreate().getCurrUserId())};
        DynamicObject userDataRecord = QueryServiceHelper.queryOne((String)"cad_userdatarecord", (String)"finishcalwizardsrate", (QFilter[])filters);
        if (userDataRecord != null && StringUtils.isNotBlank((String)(finishRate = userDataRecord.getString("finishcalwizardsrate"))) && (rates = finishRate.split(",")).length == 2) {
            costCalcArgs.setMinDiffRate(new BigDecimal(rates[0]));
            costCalcArgs.setMaxDiffRate(new BigDecimal(rates[1]));
        }
        costCalcArgs.setCheckConfigId(FinshCalcCheck.CALCCHECKCONFIGID);
    }

    private Long getCalpolicyCurrency(Long calpolicy) {
        if (this.mapCalpolicyCurrency.containsKey(calpolicy)) {
            return this.mapCalpolicyCurrency.get(calpolicy);
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy)});
        if (result == null) {
            this.mapCalpolicyCurrency.put(calpolicy, null);
        }
        if (result != null) {
            Long currency = result.getLong("currency");
            this.mapCalpolicyCurrency.put(calpolicy, currency);
            return currency;
        }
        return null;
    }

    private DynamicObjectCollection getOrgCostaccount(Long accountOrgId) {
        if (this.mapOrgCostaccount.containsKey(accountOrgId)) {
            return this.mapOrgCostaccount.get(accountOrgId);
        }
        DynamicObjectCollection costaccounts = this.getOrgCostaccountFromDb(accountOrgId);
        this.mapOrgCostaccount.put(accountOrgId, costaccounts);
        return costaccounts;
    }

    private List<Long> getCostaccount(Long accountOrgId, String appnum) {
        QFilter filter = new QFilter("org", "=", (Object)accountOrgId);
        filter.and("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        filter.and("entryentity.isinit", "=", (Object)Boolean.TRUE);
        filter.and("appnum", "=", (Object)appnum);
        DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filter.toArray());
        if (!CollectionUtils.isEmpty((Collection)costAccountIds)) {
            return costAccountIds.stream().map(costAccount -> costAccount.getLong("costaccountid")).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    private DynamicObjectCollection getOrgCostaccountFromDb(Long accountOrgId) {
        List<Long> costaccountIds = this.getCostaccount(accountOrgId, "sca");
        String selectFields = "id, name,costtype,calpolicy,ismainaccount";
        QFilter filter = new QFilter("calorg", "=", (Object)accountOrgId);
        filter.and("enable", "=", (Object)true);
        filter.and("id", "in", costaccountIds);
        String orderby = "ismainaccount DESC, number ASC";
        return QueryServiceHelper.query((String)"cal_bd_costaccount", (String)selectFields, (QFilter[])filter.toArray(), (String)orderby);
    }

    private DynamicObject getCurrentPeriod(Long costAccountID) {
        if (this.mapAccountPeriod.containsKey(costAccountID)) {
            return this.mapAccountPeriod.get(costAccountID);
        }
        DynamicObject period = this.getCurrentPeriodFromDb(costAccountID);
        if (period != null) {
            this.mapAccountPeriod.put(costAccountID, period);
        }
        return period;
    }

    private DynamicObject getCurrentPeriodFromDb(Long costAccountID) {
        DynamicObject retValue = null;
        QFilter filter = new QFilter("entry.costaccount.id", "=", (Object)costAccountID);
        String fields = "org,entry.currentperiod,entry.startperiod,entry.costaccount,entry.currentperiod.begindate,entry.currentperiod.enddate,entry.startperiod.begindate,entry.startperiod.enddate,entry.calpolicy,entry.calpolicy.periodtype,entry.isenabled";
        DynamicObject sysPeriod = BusinessDataServiceHelper.loadSingle((String)"cal_sysctrlentity", (String)fields, (QFilter[])new QFilter[]{filter});
        if (sysPeriod == null) {
            return null;
        }
        DynamicObjectCollection entrys = sysPeriod.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            long recordCostAccountID = entry.getLong("costaccount.id");
            if (costAccountID != recordCostAccountID) continue;
            retValue = entry.getDynamicObject("currentperiod");
            break;
        }
        return retValue;
    }

    private DynamicObjectCollection checkAndImport(Long orgId, Map<Long, Map<Long, List<Long>>> accountOrderEntryIdMap) {
        DynamicObjectCollection costobjects = null;
        String lockId = "CostRealtimeCalcBuilder" + orgId;
        try (DLock lock = null;){
            lock = DLock.create((String)lockId, (String)ResManager.loadKDString((String)"\u5b8c\u5de5\u7ed3\u7b97-\u6570\u636e\u81ea\u52a8\u5f52\u96c6", (String)"CostRealtimeCalcBuilder_13", (String)"macc-sca-mservice", (Object[])new Object[0]));
            boolean isLocked = lock.tryLock();
            if (!isLocked) {
                DynamicObjectCollection dynamicObjectCollection = null;
                return dynamicObjectCollection;
            }
            HashSet mftorderentryids = Sets.newHashSetWithExpectedSize((int)10);
            for (Map.Entry<Long, Map<Long, List<Long>>> entry : accountOrderEntryIdMap.entrySet()) {
                mftorderentryids.addAll(entry.getValue().keySet());
            }
            DynamicObjectCollection dynamicObjectCollection = costobjects = this.orderEntryImport(new ArrayList<Long>(mftorderentryids), orgId, null, accountOrderEntryIdMap.keySet());
            return dynamicObjectCollection;
        }
    }

    private DynamicObjectCollection orderEntryImport(List<Long> mftorderentryids, Long orgId, Set<Long> costcenters, Set<Long> accounts) {
        DynamicObjectCollection costobjects;
        ArrayList<Long> orgCostcenters = this.getOrgCostcenter(orgId);
        boolean isOrgEnableMultiFactory = this.getEnableFactory(orgId);
        ArrayList<Long> manuOrgs = new ArrayList<Long>(10);
        if (isOrgEnableMultiFactory) {
            manuOrgs.addAll(OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)orgId, (boolean)true));
        }
        if ((costobjects = this.checkCostObject(mftorderentryids, orgId, (List<Long>)(costcenters != null ? new ArrayList<Long>(costcenters) : orgCostcenters), manuOrgs)) == null || costobjects.isEmpty()) {
            return null;
        }
        ArrayList costobjectProbillIds = Lists.newArrayList();
        costobjects.forEach(t -> costobjectProbillIds.add(t.getLong("probill")));
        this.plannAndImport(costobjectProbillIds, orgId, orgCostcenters, manuOrgs);
        this.factnAndImport(costobjectProbillIds, orgId, orgCostcenters, manuOrgs);
        this.resourceAndImport(costobjectProbillIds, orgId, orgCostcenters, manuOrgs);
        this.matUseAndImport(costobjectProbillIds, orgId, orgCostcenters, manuOrgs);
        this.matAllocAuto(costobjectProbillIds, accounts);
        return costobjects;
    }

    private List<Long> getOrgCostcenter(Long orgId) {
        ArrayList costcenterIds = Lists.newArrayList();
        QFilter filter = new QFilter("accountorg", "=", (Object)orgId);
        filter.and("orgduty", "=", (Object)4L);
        DataSet costCenterDs = QueryServiceHelper.queryDataSet((String)"costcenter", (String)"bos_costcenter", (String)"id", (QFilter[])filter.toArray(), null);
        for (Row row : costCenterDs) {
            costcenterIds.add(row.getLong("id"));
        }
        return costcenterIds;
    }

    private DynamicObjectCollection checkCostObject(List<Long> mftorderentryids, Long orgId, List<Long> costcenterIds, List<Long> manuOrgs) {
        DynamicObjectCollection costobjects = this.getCostObject(mftorderentryids);
        int planSize = mftorderentryids.size();
        if (planSize != costobjects.size()) {
            HashSet<Long> needInvokeObjIds = new HashSet<Long>(16);
            HashMap mfbillentryCostobjectMap = new HashMap(16);
            costobjects.forEach(t -> mfbillentryCostobjectMap.put(t.getLong("probill"), t.getLong("id")));
            for (Long id : mftorderentryids) {
                if (mfbillentryCostobjectMap.containsKey(id)) continue;
                needInvokeObjIds.add(id);
            }
            logger.info("\u6210\u672c\u5bf9\u8c61\u9700\u8981\u5f52\u96c6\u7684\u6570\u636e:" + needInvokeObjIds);
            Object result = DispatchServiceHelper.invokeBizService((String)CODE_APPID, (String)"cad", (String)"costObjectService", (String)"importCostObject", (Object[])new Object[]{null, new ArrayList(needInvokeObjIds), orgId, costcenterIds, manuOrgs, "sca", null});
            logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u6821\u9a8c\u5e76\u505a\u5f52\u96c6\u5904\u7406\u7ed3\u679c:" + result);
            costobjects = this.getCostObject(mftorderentryids);
        }
        return costobjects;
    }

    private DynamicObjectCollection getCostObject(List<Long> mftorderentryids) {
        QFilter filter = new QFilter("probill", "in", mftorderentryids);
        filter.and("sotype", "=", (Object)"PB");
        filter.and("billstatus", "=", (Object)"C");
        return QueryServiceHelper.query((String)"cad_costobject", (String)"id,org,costcenter,sotype,bizstatus,probill,srcbillnumber,srcbillrow,manuorg", (QFilter[])filter.toArray());
    }

    private List<Long> getCostObjectProbillIds(Set<Long> costobjectIds) {
        QFilter filter = new QFilter("id", "in", costobjectIds);
        filter.and("sotype", "=", (Object)"PB");
        filter.and("billstatus", "=", (Object)"C");
        DynamicObjectCollection costobjects = QueryServiceHelper.query((String)"cad_costobject", (String)"probill", (QFilter[])filter.toArray());
        HashSet<Long> probillids = new HashSet<Long>(16);
        for (DynamicObject costobject : costobjects) {
            probillids.add(costobject.getLong("probill"));
        }
        return new ArrayList<Long>(probillids);
    }

    private void plannAndImport(List<Long> mftorderentryids, Long orgId, List<Long> costcenterIds, List<Long> manuOrgs) {
        Object result = DispatchServiceHelper.invokeBizService((String)CODE_APPID, (String)"cad", (String)"plannedOutputService", (String)"importPlannedOut", (Object[])new Object[]{null, orgId, costcenterIds, new ArrayList<Long>(mftorderentryids), manuOrgs, "sca", null});
        Map map = (Map)result;
        if ("mutex".equals(map.get("type"))) {
            throw new KDBizException((String)map.get("msg"));
        }
        logger.info("\u8ba1\u5212\u751f\u4ea7\u6570\u91cf\u6821\u9a8c\u5e76\u505a\u5f52\u96c6\u5904\u7406\u7ed3\u679c:" + result);
    }

    private void factnAndImport(List<Long> mftorderentryids, Long orgId, List<Long> costcenterIds, List<Long> manuOrgs) {
        Object result = DispatchServiceHelper.invokeBizService((String)CODE_APPID, (String)"cad", (String)"factnedOutPutService", (String)"importCompletion", (Object[])new Object[]{null, mftorderentryids, orgId, costcenterIds, manuOrgs, "sca", null});
        Map map = (Map)result;
        if ("mutex".equals(map.get("type"))) {
            throw new KDBizException((String)map.get("msg"));
        }
        logger.info("\u5b8c\u5de5\u5165\u5e93\u6570\u91cf\u6821\u9a8c\u5e76\u505a\u5f52\u96c6\u5904\u7406\u7ed3\u679c:" + result);
    }

    private void resourceAndImport(List<Long> mftorderentryids, Long orgId, List<Long> costcenterIds, List<Long> manuOrgs) {
        Object result = DispatchServiceHelper.invokeBizService((String)CODE_APPID, (String)"cad", (String)"resourceUseService", (String)"importResourceUse", (Object[])new Object[]{null, mftorderentryids, orgId, costcenterIds, manuOrgs, "sca", null});
        Map map = (Map)result;
        if ("mutex".equals(map.get("type"))) {
            throw new KDBizException((String)map.get("msg"));
        }
        logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u6821\u9a8c\u5e76\u505a\u5f52\u96c6\u5904\u7406\u7ed3\u679c:" + result);
    }

    private void matUseAndImport(List<Long> mftorderentryids, Long orgId, List<Long> costcenterIds, List<Long> manuOrgs) {
        Object result = DispatchServiceHelper.invokeBizService((String)CODE_APPID, (String)"cad", (String)"matUseService", (String)"importMatUse", (Object[])new Object[]{null, mftorderentryids, orgId, costcenterIds, manuOrgs, "sca", "sca_matusecollect", null});
        Map map = (Map)result;
        if ("mutex".equals(map.get("type"))) {
            throw new KDBizException((String)map.get("msg"));
        }
        logger.info("\u6750\u6599\u8017\u7528\u6821\u9a8c\u5e76\u505a\u5f52\u96c6\u5904\u7406\u7ed3\u679c:" + result);
    }

    private void matAllocAuto(List<Long> mftorderentryids, Set<Long> accounts) {
        OperateOption op = OperateOption.create();
        op.setVariableValue("accounts", JSONSerializer.toJSON(accounts).toString());
        Map<String, String> result = MatAllocImportHelper.importByWIP(mftorderentryids, op);
        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u7684\u81ea\u52a8\u5f15\u5165\u5904\u7406\u7ed3\u679c:" + result);
    }

    private Boolean getEnableFactory(Long orgId) {
        if (this.mapEnableFactory.containsKey(orgId)) {
            return this.mapEnableFactory.get(orgId);
        }
        boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
        this.mapEnableFactory.put(orgId, isOrgEnableMultiFactory);
        return this.mapEnableFactory.get(orgId);
    }

    public void updateAutoCalcLog(List<Long> billIds, String status, String log) {
        this.updateAutoCalcLog(billIds, status, log, 0L);
    }

    public void updateAutoCalcLog(List<Long> billIds, String status, String log, Long reportId) {
        if (CadEmptyUtils.isEmpty(billIds)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        int size = 0;
        if (log == null) {
            log = "";
        }
        if (log.length() > 2000) {
            log = log.substring(0, 1999);
        }
        String sqlFormat = UPDATE_AUTOCALC_ERR_LOG;
        Object[] paramArray = new Object[]{status, new Date(), log, reportId};
        if (AutoCalcStatusEnum.RUNNING.getValue().equals(status)) {
            sqlFormat = UPDATE_AUTOCALC_RUN_LOG;
            paramArray = new Object[]{status, new Date(), log};
        }
        for (Long billId : billIds) {
            sb.append(billId).append(",");
            if (++size <= 50) continue;
            String sql = String.format(sqlFormat, sb.toString().substring(0, sb.length() - 1));
            this.doSqlExecute(DBRoute.of((String)"cal"), sql, paramArray);
            sb.delete(0, sb.length());
            size = 0;
        }
        if (sb.length() > 0) {
            String sql = String.format(sqlFormat, sb.toString().substring(0, sb.length() - 1));
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)sql, (Object[])paramArray);
        }
    }

    private void doSqlExecute(DBRoute cal, String sql, Object[] paramArray) {
        DB.execute((DBRoute)cal, (String)sql, (Object[])paramArray);
    }
}

