/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.output.AllocResult;
import kd.macc.sca.algox.alloc.ScaMatAllocHelper;

public class MatAllocImportHelper {
    private static final Log log = LogFactory.getLog(MatAllocImportHelper.class);

    public static Map<String, String> importByWIP(List<Long> mftorderentryids, OperateOption option) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("successQty", "0");
        String appNum = option.getVariableValue("appNum", "sca");
        String accountJson = option.getVariableValue("accounts", null);
        List accounts = null;
        if (!StringUtils.isEmpty((CharSequence)accountJson)) {
            accounts = JSONObject.parseArray((String)accountJson, Long.class);
        }
        QFilter filter = new QFilter("probill", "in", mftorderentryids);
        filter.and("sotype", "=", (Object)"PB");
        filter.and("billstatus", "=", (Object)"C");
        DynamicObjectCollection costobjects = QueryServiceHelper.query((String)"cad_costobject", (String)"id,org,costcenter,sotype,bizstatus,probill", (QFilter[])filter.toArray());
        HashMap accountOrgIds = new HashMap();
        costobjects.forEach(t -> accountOrgIds.computeIfAbsent(t.getLong("org"), s -> new HashSet()).add(t.getLong("id")));
        HashMap<Long, List> orgCostAccountMap = new HashMap<Long, List>(16);
        DynamicObjectCollection costaccounts = MatAllocImportHelper.getCostaccount(accountOrgIds.keySet(), appNum, accounts);
        for (DynamicObject temp : costaccounts) {
            Long orgAccountId = temp.getLong("org");
            orgCostAccountMap.computeIfAbsent(orgAccountId, s -> new ArrayList()).add(temp);
        }
        int successQty = 0;
        if (!orgCostAccountMap.isEmpty()) {
            for (Map.Entry temp : orgCostAccountMap.entrySet()) {
                Long accountOrgId = (Long)temp.getKey();
                List costAccounts = (List)temp.getValue();
                int succNum = MatAllocImportHelper.matAllocImport(accountOrgId, costAccounts, appNum, (Set)accountOrgIds.get(accountOrgId));
                successQty += succNum;
            }
        }
        result.put("successQty", String.valueOf(successQty));
        return result;
    }

    private static int matAllocImport(Long orgId, List<DynamicObject> costAccounts, String appNum, Set<Long> costobjectIds) {
        ArrayList<Object> costAccountList = new ArrayList<Object>(10);
        HashSet<Long> costAccountSet = new HashSet<Long>(16);
        for (DynamicObject data : costAccounts) {
            Long costAccountId = data.getLong("id");
            Long currentperiod = MatAllocImportHelper.getPeriod(orgId, costAccountId);
            if (currentperiod == null) {
                log.info("\u6ca1\u6709\u5f53\u524d\u671f\u95f4(orgId=" + orgId + ";costAccountId=" + costAccountId + ";mftorderentryids=" + StringUtils.join(costobjectIds, (String)",") + ")");
                continue;
            }
            Set<Long> sourcebillid = MatAllocImportHelper.getSourceBillid(currentperiod, costobjectIds, orgId, appNum);
            if (sourcebillid == null || sourcebillid.isEmpty()) {
                log.info(ResManager.loadKDString((String)"\u8d26\u7c3f\u4e0d\u7b26\u5408\u6761\u4ef6(orgId=", (String)"MatAllocImportServiceImpl_1", (String)"macc-cad-mservice", (Object[])new Object[0]) + orgId + ";costAccountId=" + costAccountId + ";mftorderentryids=" + StringUtils.join(costobjectIds, (String)",") + ")");
                continue;
            }
            HashMap<String, String> costaccountMap = new HashMap<String, String>();
            costaccountMap.put("autoFinishCalc", "autoFinishCalc");
            costaccountMap.put("matUseBillIds", (String)((Object)sourcebillid));
            costaccountMap.put("org", (String)((Object)orgId));
            costaccountMap.put("costaccountnum", data.getString("number"));
            costaccountMap.put("costaccountId", (String)((Object)costAccountId));
            DynamicObject calpolicy = MatAllocImportHelper.getCurrency(data.getLong("calpolicy"));
            costaccountMap.put("currencyId", (String)((Object)Long.valueOf(calpolicy == null ? 0L : calpolicy.getLong("currency"))));
            costaccountMap.put("amtprecision", (String)((Object)Integer.valueOf(calpolicy == null ? 10 : calpolicy.getInt("amtprecision"))));
            Long costtypeId = data.getLong("costtype");
            boolean useMatVer = CostTypeHelper.isUseMatVersion((Long)costtypeId);
            costaccountMap.put("costtypeId", (String)((Object)costtypeId));
            costaccountMap.put("useMatVer", (String)((Object)Boolean.valueOf(useMatVer)));
            costaccountMap.put("currentperiodId", (String)((Object)currentperiod));
            costaccountMap.put("appnum", appNum);
            costAccountList.add(costaccountMap);
            costAccountSet.add(costAccountId);
        }
        if (!costAccountList.isEmpty()) {
            boolean isGetLock = true;
            boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
            HashSet<Long> manuOrgs = new HashSet<Long>();
            if (enableMulFactory) {
                List manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)"sca_matalloc", (String)"sca");
                manuOrgs.addAll(manuorgList);
            }
            try {
                String lockErr = MatAllocImportHelper.matAllocImportMutex(costAccountSet, manuOrgs, enableMulFactory);
                if (StringUtils.isNotEmpty((CharSequence)lockErr)) {
                    isGetLock = false;
                    int sourcebillid = 0;
                    return sourcebillid;
                }
                AllocResult allocRes = ScaMatAllocHelper.toAlloc(costAccountList, (String)appNum);
                allocRes.setOrgId(orgId);
                log.info("\u6750\u6599\u8017\u7528\u5206\u914d\u8f93\u51fa\u7ed3\u679c:" + SerializationUtils.toJsonString((Object)allocRes));
                String qty = (String)allocRes.getReasonMap().get("successQty");
                if (qty != null) {
                    int n = Integer.parseInt(qty);
                    return n;
                }
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, new ErrorCode("500", e.getMessage()), new Object[0]);
            }
            finally {
                if (isGetLock) {
                    for (Long costAccountId : costAccountSet) {
                        SimpleMutexHelper.releaseMuteFromSet((String)"importcollc", (boolean)enableMulFactory, (Long)costAccountId, manuOrgs);
                    }
                }
            }
        }
        return 0;
    }

    private static synchronized String matAllocImportMutex(Set<Long> costAccountSet, Set<Long> manuOrgIds, boolean enableMulFactory) {
        ArrayList<Long> cancelCostAccountIds = new ArrayList<Long>();
        String lockErr = null;
        boolean cancelFlag = false;
        for (Long costaccountId : costAccountSet) {
            lockErr = SimpleMutexHelper.checkMutexAndLock((String)"importcollc", (boolean)enableMulFactory, (Long)costaccountId, manuOrgIds);
            if (StringUtils.isNotEmpty((CharSequence)lockErr)) {
                cancelFlag = true;
                break;
            }
            cancelCostAccountIds.add(costaccountId);
        }
        if (StringUtils.isNotEmpty(lockErr) && cancelFlag && cancelCostAccountIds.size() > 0) {
            for (Long id : cancelCostAccountIds) {
                SimpleMutexHelper.releaseMuteFromSet((String)"importcollc", (boolean)enableMulFactory, (Long)id, manuOrgIds);
            }
        }
        return lockErr;
    }

    private static Set<Long> getSourceBillid(Long currentperiod, Set<Long> costobjectIds, Long orgId, String appnum) {
        QFilter filter0 = new QFilter("id", "=", (Object)currentperiod);
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"id,begindate,enddate", (QFilter[])filter0.toArray());
        if (period == null) {
            log.info("\u6ca1\u6709\u7b26\u5408\u671f\u95f4\u6761\u4ef6\u7684\u751f\u4ea7\u9886\u6599\u5355\u6570\u636e(orgId=" + orgId + ";mftorderentryids=" + StringUtils.join(costobjectIds, (String)",") + ")");
            return null;
        }
        QFilter filter = new QFilter("appnum", "=", (Object)appnum);
        filter.and("bookdate", ">=", (Object)period.getDate("begindate"));
        filter.and("bookdate", "<=", (Object)period.getDate("enddate"));
        filter.and("org", "=", (Object)orgId);
        filter.and("entryentity.costobject", "in", costobjectIds);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"matusecollect", (String)"sca_matusecollect", (String)"entryentity.id entryId", (QFilter[])filter.toArray(), null);
        HashSet<Long> sourcebillid = new HashSet<Long>();
        if (!ds.isEmpty()) {
            for (Row row : ds) {
                sourcebillid.add(row.getLong("entryId"));
            }
        } else {
            return null;
        }
        return sourcebillid;
    }

    private static DynamicObjectCollection getCostaccount(Set<Long> orgIdList, String appnum, List<Long> accounts) {
        String selectFields = "id,number, calorg As org,name,costtype,calpolicy,ismainaccount";
        String orderby = "enablestandardcost DESC, number ASC";
        QFilter filter = new QFilter("calorg", "in", orgIdList);
        if (accounts != null) {
            filter.and("id", "in", accounts);
        }
        filter.and(StartCostHelper.getEnabledCostAccountIdsFilter(new ArrayList<Long>(orgIdList), (String)"sca"));
        QFilter isEnabledFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.query((String)"cal_bd_costaccount", (String)selectFields, (QFilter[])new QFilter[]{filter, isEnabledFilter}, (String)orderby);
    }

    private static Long getPeriod(Long orgId, Long costaccountId) {
        if (orgId == null || costaccountId == null) {
            return null;
        }
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQF = new QFilter("entry.costaccount", "=", (Object)costaccountId);
        DynamicObjectCollection res = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id, entry.currentperiod AS currentperiod", (QFilter[])new QFilter[]{orgQF, costaccountQF});
        if (res == null || res.size() == 0) {
            return null;
        }
        return ((DynamicObject)res.get(0)).getLong("currentperiod");
    }

    private static DynamicObject getCurrency(Long calpolicyId) {
        if (calpolicyId == null) {
            return null;
        }
        return QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency, currency.amtprecision AS amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicyId)});
    }
}

