/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.sca.common.costcalc.CalcResultObjectInfo;

public class ProAllocHelper {
    private static final Log logger = LogFactory.getLog(ProAllocHelper.class);

    public static BigDecimal getMainAndJoinEndQty(Map<Long, CalcResultObjectInfo> objectInfoMap) {
        BigDecimal proEndQty = BigDecimal.ZERO;
        for (Map.Entry<Long, CalcResultObjectInfo> objectInfoEntry : objectInfoMap.entrySet()) {
            CalcResultObjectInfo info = objectInfoEntry.getValue();
            BigDecimal endQty = info.getStartQty().add(info.getPlanQty()).subtract(info.getFinishQty());
            proEndQty = proEndQty.add(endQty);
        }
        return proEndQty;
    }

    public static BigDecimal getMainAndJoinFinQty(Map<Long, CalcResultObjectInfo> objectInfoMap) {
        BigDecimal proFinQty = BigDecimal.ZERO;
        for (Map.Entry<Long, CalcResultObjectInfo> objectInfoEntry : objectInfoMap.entrySet()) {
            CalcResultObjectInfo value = objectInfoEntry.getValue();
            if ("B".equals(value.getProductType())) continue;
            BigDecimal finishQty = value.getFinishQty();
            proFinQty = proFinQty.add(finishQty);
        }
        return proFinQty;
    }
}

