/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.algox.utils.CostAbsorbAdjustHelper;
import kd.macc.sca.algox.utils.TimeUtils;
import kd.macc.sca.common.costcalc.CalcResultEntryRow;
import kd.macc.sca.common.costcalc.CalcResultHeader;
import kd.macc.sca.common.costcalc.CostCalcArgs;
import kd.macc.sca.mservice.costcalc.action.AbstractSingleBatchAction;
import kd.macc.sca.mservice.costcalc.groupkey.AbsorbAdjustGroupKey;
import kd.macc.sca.mservice.costcalc.groupkey.CostObjectKey;

public class AbsorbAjustCalcAction
extends AbstractSingleBatchAction {
    private static final Log logger = LogFactory.getLog(AbsorbAjustCalcAction.class);
    private static String[] dataTypes = new String[]{"1", "2", "3"};
    CostCalcArgs args;

    @Override
    protected void doExecute() {
        this.args = this.getContext().getInputArgs();
        logger.info(String.format("\u5438\u6536\u6210\u672c\u8c03\u6574\u5904\u7406\uff1a\u5f00\u59cb\uff0c\u7b2c %s / %s\u6279\uff0c\u5171 %s \u5f20", this.getSingleBatchContext().getCurrBatchSeq(), this.getSingleBatchContext().getBatchCount(), this.getSingleBatchContext().getCostObjectIds().size()));
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        this.getContext().getFilterBuilder().warpQFilter4Period(filters, "org", true, this.args);
        this.getContext().getFilterBuilder().wrapQFilter4CostObjects(filters, "costobject", this.getSingleBatchContext().getCostObjectIds());
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        Map<CostObjectKey, Map<AbsorbAdjustGroupKey, CalcResultEntryRow>> absorbAdjustRows = this.getAbsorbAdjustRows(filters);
        this.handleAbsorbAdjust(absorbAdjustRows);
        logger.info("\u5438\u6536\u6210\u672c\u8c03\u6574\u8ba1\u7b97\u7ed3\u675f");
    }

    private void handleAbsorbAdjust(Map<CostObjectKey, Map<AbsorbAdjustGroupKey, CalcResultEntryRow>> absorbAdjustRows) {
        for (Map.Entry<CostObjectKey, Map<AbsorbAdjustGroupKey, CalcResultEntryRow>> entry : absorbAdjustRows.entrySet()) {
            Long costObjectId = entry.getKey().getCostObjectId();
            CalcResultHeader calcResultHeader = this.getSingleBatchResultManager().getCalcResults().get(costObjectId);
            if (calcResultHeader == null) {
                calcResultHeader = this.addNewCalcResultHeader(costObjectId, entry.getKey().getCostCenterId());
            }
            for (Map.Entry<AbsorbAdjustGroupKey, CalcResultEntryRow> absorbAdjustItem : entry.getValue().entrySet()) {
                AbsorbAdjustGroupKey absorbAdjustGroupKey = absorbAdjustItem.getKey();
                CalcResultEntryRow absorbEntryRow = absorbAdjustItem.getValue();
                CalcResultEntryRow newEntry = calcResultHeader.addNew();
                newEntry.setCostObject(absorbAdjustGroupKey.getCostObjectId().longValue());
                newEntry.setProductType("C");
                newEntry.setElement(absorbAdjustGroupKey.getElementId().longValue());
                newEntry.setSubElement(absorbAdjustGroupKey.getSubElementId().longValue());
                newEntry.setResource(absorbAdjustGroupKey.getResourceId().longValue());
                newEntry.setCostLevel("2");
                newEntry.setCalcbasis("001");
                newEntry.setCalType(this.args.getMfgCalType());
                newEntry.setDataType(absorbAdjustGroupKey.getDataType());
                newEntry.setPdCurrAmount(absorbEntryRow.getPdCurrAmount().setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP));
                newEntry.setDiffType("2");
                newEntry.addAllTaskValInfos(absorbEntryRow, "PdCurrAmount");
            }
        }
    }

    private CalcResultHeader addNewCalcResultHeader(Long costObjectId, Long costCenterId) {
        CalcResultHeader calcResultHeader = new CalcResultHeader();
        this.getSingleBatchResultManager().getCalcResults().put(costObjectId, calcResultHeader);
        calcResultHeader.setId(DBServiceHelper.genGlobalLongId());
        calcResultHeader.setBillNo("NO." + System.currentTimeMillis());
        calcResultHeader.setOrg(this.args.getOrgId().longValue());
        calcResultHeader.setCostAccount(this.args.getCostAccountId().longValue());
        calcResultHeader.setCostCenter(costCenterId.longValue());
        calcResultHeader.setCurrency(this.args.getCurrencyId().longValue());
        calcResultHeader.setPeriod(this.args.getPeriodId().longValue());
        calcResultHeader.setCostObject(costObjectId.longValue());
        Object bizDate = TimeUtils.compareToEndDate((Date)this.getContext().getInputArgs().getEndDate());
        if (bizDate != null) {
            if (bizDate instanceof Date) {
                calcResultHeader.setBizDate((Date)bizDate);
            } else if (bizDate instanceof Calendar) {
                calcResultHeader.setBizDate(((Calendar)bizDate).getTime());
            }
        }
        calcResultHeader.setBillStatus("A");
        calcResultHeader.setBizStatus("A");
        return calcResultHeader;
    }

    private Map<CostObjectKey, Map<AbsorbAdjustGroupKey, CalcResultEntryRow>> getAbsorbAdjustRows(List<QFilter> filters) {
        HashMap<CostObjectKey, Map<AbsorbAdjustGroupKey, CalcResultEntryRow>> resultMap = new HashMap<CostObjectKey, Map<AbsorbAdjustGroupKey, CalcResultEntryRow>>(16);
        String selectFields = "id,costobject,resource,entryentity.element as element,entryentity.subelement as subelement,entryentity.amount as amount,costcenter,costaccount,org";
        int rowCount = 0;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)CostAbsorbAdjustHelper.class.getName(), (String)"sca_absorbadjust", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                ++rowCount;
                BigDecimal amount = row.getBigDecimal("amount");
                CostObjectKey costObjectKey = new CostObjectKey(row.getLong("org"), row.getLong("costaccount"), row.getLong("costcenter"), row.getLong("costobject"));
                Map absorbMap = resultMap.computeIfAbsent(costObjectKey, s -> new HashMap());
                for (String dataType : dataTypes) {
                    AbsorbAdjustGroupKey key = this.buildGroupKey(row, dataType);
                    CalcResultEntryRow entryRow = absorbMap.computeIfAbsent(key, s -> new CalcResultEntryRow());
                    entryRow.addPdCurrAmount(amount);
                    entryRow.addTaskValInfo("sca_absorbadjust", row.getLong("id").toString(), "amount", "PdCurrAmount", amount);
                }
            }
        }
        logger.info(String.format("\u8bfb\u53d6\u5438\u6536\u8c03\u6574\u5355\uff0c\u5171\u53d6\u51fa\u6570\u636e%s\u884c\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", rowCount, this.getContext().getFilterBuilder().buildQFilterLogString(filters)));
        return resultMap;
    }

    private AbsorbAdjustGroupKey buildGroupKey(Row row, String dataType) {
        return new AbsorbAdjustGroupKey(row.getLong("costaccount"), row.getLong("costcenter"), row.getLong("costobject"), row.getLong("resource"), row.getLong("element"), row.getLong("subelement"), dataType);
    }
}

