/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.check.AbstractCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckHelper;
import kd.macc.sca.common.costcalc.CostCalcArgs;
import kd.macc.sca.mservice.costcalc.CalcTaskType;
import kd.macc.sca.mservice.costcalc.CostCalcContext;
import kd.macc.sca.mservice.costcalc.CostCalcResultManager;
import kd.macc.sca.mservice.costcalc.action.ICalcAction;
import net.sf.json.JSONObject;

abstract class AbstractCalcAction
implements ICalcAction {
    private static final Log logger = LogFactory.getLog(AbstractCalcAction.class);
    private CostCalcContext context;
    private CostCalcResultManager resultManager;

    AbstractCalcAction() {
    }

    public CostCalcContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(CostCalcContext context) {
        this.context = context;
    }

    public CostCalcResultManager getResultManager() {
        return this.resultManager;
    }

    @Override
    public void setResultManager(CostCalcResultManager resultManager) {
        this.resultManager = resultManager;
    }

    public Long getDetailTaskConfigId() {
        return 0L;
    }

    @Override
    public final void execute() {
        this.doExecute();
    }

    protected abstract void doExecute();

    protected BigDecimal getBigDecimal(Object data) {
        return data == null ? BigDecimal.ZERO : (BigDecimal)data;
    }

    protected String getAlgoKey(String methodName) {
        return this.getClass().getName() + methodName;
    }

    protected List<AbstractCalcCheckAction> createCheckActions(CalcTaskType taskType, Long checkResultId) {
        String checkparamstr = CostCalcArgs.toJSONString((CostCalcArgs)this.getContext().getInputArgs());
        JSONObject checkparam = JSONObject.fromObject((Object)checkparamstr);
        checkparam.accumulate("checkResultId", (Object)checkResultId);
        String calType = this.getCheckMode(taskType);
        CalcCheckContext calcCheckContext = new CalcCheckContext();
        calcCheckContext.setCheckParamJs(checkparam);
        calcCheckContext.setCheckResultId(Long.valueOf(checkparam.getLong("checkResultId")));
        calcCheckContext.setTaskId(this.getContext().getInputArgs().getTaskRecordId());
        calcCheckContext.setTaskType(calType);
        calcCheckContext.setOrgId(this.getContext().getInputArgs().getOrgId());
        calcCheckContext.setCostAccountId(this.getContext().getInputArgs().getCostAccountId());
        calcCheckContext.setPeriodId(this.getContext().getInputArgs().getPeriodId());
        calcCheckContext.setCostCenterIds(this.getContext().getInputArgs().getCostCenterIds());
        if (this.getContext().getInputArgs().getManuOrgIds() != null) {
            calcCheckContext.setManuOrgIds(this.getContext().getInputArgs().getManuOrgIds());
        }
        calcCheckContext.setAppNum(this.getContext().getInputArgs().getAppNum());
        calcCheckContext.setPeriodStartDate(this.getContext().getInputArgs().getStartDate());
        calcCheckContext.setPeriodEndDate(this.getContext().getInputArgs().getEndDate());
        if (this.getContext().getTaskType() == CalcTaskType.FinishCalc || this.getContext().getTaskType() == CalcTaskType.RealtimeFinishCalc || this.getContext().getTaskType() == CalcTaskType.FinishCalcCheck) {
            calcCheckContext.getParams().put("checkCostobjectIds", this.getContext().getInputArgs().getCostObjectIds());
        }
        List checkItemList = this.getContext().getInputArgs().getCheckItemList();
        return CalcCheckHelper.getCheckActionList((CalcCheckContext)calcCheckContext, (List)checkItemList, (String)calType, (String)this.getContext().getInputArgs().getAppNum());
    }

    private String getCheckMode(CalcTaskType taskType) {
        String calType = null;
        switch (taskType) {
            case FinishCalc: 
            case FinishCalcCheck: {
                calType = "sca_finishcalwizards";
                break;
            }
            case RealtimeFinishCalc: {
                calType = "sca_realtimefinishcal";
                break;
            }
            case PeriodEndCalc: 
            case PeriodEndCalcCheck: {
                calType = "sca_wipcalwizards";
                break;
            }
        }
        return calType;
    }

    private String getCheckItemsField() {
        return "id,entryentity.checkitem.id as checkitemid,entryentity.checkitem.name as checkitem,entryentity.checkitem.plugin as plugin,entryentity.level as level,entryentity.checkitem.opsuggestion as opsuggestion,entryentity.checkitem.errorlog as errorlog,entryentity.checkitem.description as description,entryentity.checkitem.bizobject as bizobject,entryentity.checkitem.customfilter as customfilter";
    }
}

