/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.TimeUtils;
import kd.macc.sca.algox.constants.FinshCalcCheck;
import kd.macc.sca.algox.wip.input.CalcDataArgs;
import kd.macc.sca.common.costcalc.TaskRecordEntryRow;
import kd.macc.sca.common.costcalc.TaskRecordHeader;
import kd.macc.sca.mservice.costcalc.CalcTaskType;
import kd.macc.sca.mservice.costcalc.TaskRecorder;
import kd.macc.sca.mservice.costcalc.action.AbstractCalcAction;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class AfterCalcAction
extends AbstractCalcAction {
    private static final Log logger = LogFactory.getLog(AfterCalcAction.class);
    private TaskRecorder taskRecorder;

    @Override
    protected void doExecute() {
        logger.info("AfterCalcAction.doExecute() begin");
        this.taskRecorder = this.getResultManager().getTaskRecorder();
        this.taskRecorder.upateTaskRecordDetail(FinshCalcCheck.CALCTASKDEALCALCRESULT, "2");
        if (this.getContext().getTaskType() == CalcTaskType.FinishCalcCheck || this.getContext().getTaskType() == CalcTaskType.PeriodEndCalcCheck) {
            this.afterCheckOnly();
            this.taskRecorder.upateTaskRecordDetail(FinshCalcCheck.CALCTASKDEALCALCRESULT, "4");
        } else {
            this.afterCalc();
            this.taskRecorder.upateTaskRecordDetail(FinshCalcCheck.CALCTASKDEALCALCRESULT, "4");
        }
        int checkWay = this.getContext().getInputArgs().getCheckWay();
        this.taskRecorder.updateAndSaveCalcReport(checkWay);
        this.updateCheckReportCalc();
    }

    private void updateCheckReportCalc() {
        long reportId = this.getContext().getInputArgs().getCheckReportId();
        DynamicObject reportDyn = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"sca_calcreport", (String)"id,nextpagepara_tag");
        if (reportDyn != null) {
            String nextpageparaTag = reportDyn.getString("nextpagepara_tag");
            if (StringUtils.isEmpty((CharSequence)nextpageparaTag)) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((Object)"costobjectIds", (Object)this.getContext().getInputArgs().getCostObjectIds());
                nextpageparaTag = jsonObject.toString();
            } else {
                try {
                    JSONObject jsonObject = JSONObject.fromObject((Object)nextpageparaTag);
                    jsonObject.put((Object)"costobjectIds", (Object)this.getContext().getInputArgs().getCostObjectIds());
                    nextpageparaTag = jsonObject.toString();
                }
                catch (Exception ex) {
                    logger.error("\u8f6c\u6362\u7c7b\u578b\u51fa\u9519", (Throwable)ex);
                }
            }
            reportDyn.set("nextpagepara_tag", (Object)nextpageparaTag);
            SaveServiceHelper.update((DynamicObject)reportDyn);
        }
    }

    private void afterCheckOnly() {
        CalcDataArgs args = new CalcDataArgs();
        if (this.getContext().getTaskType() == CalcTaskType.PeriodEndCalc || this.getContext().getTaskType() == CalcTaskType.PeriodEndCalcCheck) {
            args.setFinishPageTitle(ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"AfterCalcAction_2", (String)"macc-sca-mservice", (Object[])new Object[0]));
        } else {
            args.setFinishPageTitle(ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"AfterCalcAction_3", (String)"macc-sca-mservice", (Object[])new Object[0]));
        }
        TaskRecordHeader taskRecord = this.getResultManager().getTaskRecorder().getTaskRecord();
        if (taskRecord != null) {
            if ("2".equals(taskRecord.getStatus())) {
                taskRecord.setStatus("4");
                taskRecord.setDirtyFlag("Status");
            }
            args.setCheckResultId(this.getResultManager().getCheckResultId());
            args.setCusmTime(this.getContext().getCusmTimeForCheck());
            args.setCheckNoPassCount(Long.valueOf(this.getContext().getCheckNoPassCount().intValue()));
            args.setCheckRemaindCount(Long.valueOf(this.getContext().getCheckRemaindCount().intValue()));
            String params = SerializationUtils.toJsonString((Object)args);
            taskRecord.setNextPagePara(params);
            taskRecord.setDirtyFlag("NextPagePara");
            this.getResultManager().getTaskRecorder().saveHeader();
        }
    }

    private void afterCalc() {
        this.updateTaskRecord();
        final long periodId = this.getContext().getInputArgs().getPeriodId();
        ThreadPools.executeOnce((String)"DeleteExpiredCalcResultAction.deleteCalcResult", (Runnable)new Runnable(){

            @Override
            public void run() {
                AfterCalcAction.this.deleteCalcResult(periodId);
            }
        });
    }

    private void deleteCalcResult(long periodId) {
        QFilter filter = new QFilter("org", "=", (Object)999999L);
        filter.and("period", "=", (Object)periodId);
        ArrayList idList = Lists.newArrayListWithCapacity((int)1000);
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("deleteCalcResult"), (String)"sca_calcresult", (String)"id", (QFilter[])filter.toArray(), null);
        for (Row row : ds) {
            idList.add(row.getLong("id"));
        }
        int count = 0;
        int size = CadBgParamUtils.getCadParamForInt((String)"stdCalcClearResult", (int)200);
        List spList = Lists.partition((List)idList, (int)size);
        for (List listTmp : spList) {
            filter = new QFilter("id", "in", (Object)listTmp);
            int x = DeleteServiceHelper.delete((String)"sca_calcresult", (QFilter[])filter.toArray());
            count += x;
        }
        logger.info("\u3010\u6807\u51c6\u6210\u672c\u8ba1\u7b97\u3011\u5df2\u5220\u9664 {} \u6761\u6807\u8bc6\u7684\u8bb0\u5f55", (Object)count);
    }

    private void updateTaskRecord() {
        CalcDataArgs args = this.buildNextPageParam();
        if (this.getContext().getTaskType() == CalcTaskType.PeriodEndCalc) {
            args.setFinishPageTitle(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97\u7ed3\u679c", (String)"AfterCalcAction_0", (String)"macc-sca-mservice", (Object[])new Object[0]), (String)"CalcHelper_0"));
        } else {
            args.setFinishPageTitle(ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97\u7ed3\u679c", (String)"AfterCalcAction_1", (String)"macc-sca-mservice", (Object[])new Object[0]));
        }
        args.setCusmTime(this.getContext().getCusmTimeForCheck());
        args.setCheckNoPassCount(Long.valueOf(this.getContext().getCheckNoPassCount().intValue()));
        args.setCheckRemaindCount(Long.valueOf(this.getContext().getCheckRemaindCount().intValue()));
        boolean isCreateCheckHead = this.taskRecorder.createCheckDetailHead(this.getContext().getInputArgs());
        if (!isCreateCheckHead) {
            TaskRecordHeader taskRecord = this.taskRecorder.getTaskRecord();
            for (TaskRecordEntryRow entryRow : taskRecord.getEntryRows().values()) {
                if (!"6".equals(entryRow.getSubStatus()) && !"3".equals(entryRow.getSubStatus())) continue;
                isCreateCheckHead = true;
                break;
            }
        }
        args.setCalcError(isCreateCheckHead);
        String calcParam = SerializationUtils.toJsonString((Object)args);
        TaskRecordHeader taskRecord = this.taskRecorder.getTaskRecord();
        taskRecord.setNextPagePara(calcParam);
        taskRecord.setProgress(100);
        if (isCreateCheckHead || args.getCheckNoPassCount() > 0L) {
            taskRecord.setStatus("3");
        } else if ("2".equals(taskRecord.getStatus())) {
            if (args.getCheckRemaindCount() > 0L) {
                taskRecord.setStatus("5");
            } else {
                taskRecord.setStatus("4");
            }
        }
        taskRecord.setDirtyFlag("Time");
        taskRecord.setDirtyFlag("NextPagePara");
        taskRecord.setDirtyFlag("Progress");
        taskRecord.setDirtyFlag("Status");
        this.taskRecorder.saveHeader();
    }

    private CalcDataArgs buildNextPageParam() {
        CalcDataArgs args = this.getContext().getOldVerInputArgs();
        Long time = TimeUtils.getSecondTime((Date)this.taskRecorder.getTaskRecord().getStartTime(), (Date)new Date());
        if (Long.compare(0L, time) == 0) {
            time = 1L;
        }
        this.taskRecorder.getTaskRecord().setTime(time.longValue());
        args.setTime(time.longValue());
        args.clearNotRequestData();
        this.analysisCoscenter(args, this.getResultManager().getSuccessCoCounts());
        int failCount = this.getContext().getCheckNoPassCount() + this.getContext().getCheckRemaindCount();
        args.setCheckfailCount(failCount);
        args.setCheckResultId(this.getResultManager().getCheckResultId());
        if (!CollectionUtils.isEmpty((Collection)this.getContext().getInputArgs().getCostCenterIds())) {
            args.setCostCenterIds(this.getContext().getInputArgs().getCostCenterIds());
        }
        if (this.getContext().getTaskType() == CalcTaskType.PeriodEndCalc) {
            args.setCalcType(2);
            args.setUnAbsorbCcCount(this.getResultManager().getUnAbsorbCoCounts().size());
            int unAbsorbCount = 0;
            for (Map.Entry<Long, Integer> entry : this.getResultManager().getUnAbsorbCoCounts().entrySet()) {
                unAbsorbCount += entry.getValue().intValue();
            }
            args.setUnAbsorbCoCount(Long.valueOf(unAbsorbCount));
        }
        return args;
    }

    private void analysisCoscenter(CalcDataArgs args, Map<Long, Integer> successCoCounts) {
        Map ccAndCoInfos = this.getContext().getInputArgs().getCcAndCoInfos();
        if (ccAndCoInfos == null || ccAndCoInfos.isEmpty()) {
            return;
        }
        int costcenterFail = 0;
        long costobjectSuccess = 0L;
        for (Map.Entry entry : ccAndCoInfos.entrySet()) {
            Long costCenterId = (Long)entry.getKey();
            Integer successCount = successCoCounts.get(costCenterId);
            if (successCount == null) {
                ++costcenterFail;
                continue;
            }
            costobjectSuccess += (long)successCount.intValue();
            if (successCount.intValue() == ((Integer)entry.getValue()).intValue()) continue;
            ++costcenterFail;
        }
        args.setSuccessCcCount(successCoCounts.size());
        args.setFailCcCount(costcenterFail);
        args.setSuccessCoCount(Long.valueOf(costobjectSuccess));
    }
}

