/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.CadListUtils;
import kd.macc.sca.algox.utils.LogUtils;
import kd.macc.sca.common.costcalc.CostCalcArgs;
import kd.macc.sca.mservice.costcalc.CalcTaskType;
import kd.macc.sca.mservice.costcalc.CostCalcContext;
import kd.macc.sca.mservice.costcalc.CostCalcResultManager;
import kd.macc.sca.mservice.costcalc.action.AbstractCalcAction;
import kd.macc.sca.mservice.costcalc.action.CalcExcuteAction;
import kd.macc.sca.mservice.costcalc.action.task.CalcPartitionTaskAction;

class CalcAction
extends AbstractCalcAction {
    private static final Log logger = LogFactory.getLog(CalcAction.class);
    private static final int DEFAULT_BATCH_SIZE = 200;
    private static final int BATCH_MAX_SIZE = 1000;
    private static final int BATCH_MIN_SIZE = 20;

    CalcAction() {
    }

    @Override
    protected void doExecute() {
        if (!this.getContext().getInputArgs().isCalc().booleanValue()) {
            logger.info("\u5206\u6279\u8ba1\u7b97\uff1a\u9000\u51fa\uff0cisCalc = false");
            return;
        }
        boolean isConcurrency = false;
        if (CalcTaskType.FinishCalc == this.getContext().getTaskType()) {
            isConcurrency = CadBgParamUtils.getCadParamForInt((String)"scaFinishParallel", (int)0) == 1;
        } else if (CalcTaskType.PeriodEndCalc == this.getContext().getTaskType()) {
            isConcurrency = CadBgParamUtils.getCadParamForInt((String)"scaPeriodEndParallel", (int)0) == 1;
        }
        this.getContext().setIsConcurrency(isConcurrency);
        int costObjectBatchSize = this.getCostObjectBatchSize();
        Set manuOrgs = this.getContext().getInputArgs().getManuOrgIds();
        Set costObjects = this.getContext().getInputArgs().getCostObjectIds();
        CalcExcuteAction calcExcuteAction = new CalcExcuteAction();
        long startTime = System.currentTimeMillis();
        if (isConcurrency) {
            startTime = System.currentTimeMillis();
            LogUtils.logInfo((Object)this.getContext().getLogUniqueKey(), (Log)logger, (String)String.format(ResManager.loadKDString((String)"\u5206\u6279\u8ba1\u7b97\uff1a\u5e76\u884c\u6a21\u5f0f\uff0c\u5f00\u59cb\uff0c\u5171%1$s\u5f20\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff0c\u6bcf\u6279%2$s\u5f20", (String)"CalcAction_8", (String)"macc-sca-mservice", (Object[])new Object[0]), costObjects.size(), costObjectBatchSize));
            this.executeBatchByTask(this.getContext(), costObjectBatchSize, this.getResultManager());
            LogUtils.logInfo((Object)this.getContext().getLogUniqueKey(), (Log)logger, (String)String.format(ResManager.loadKDString((String)"\u5206\u6279\u8ba1\u7b97\uff1a\u5e76\u884c\u6a21\u5f0f\uff0c\u7ed3\u675f\uff0c\u8017\u65f6%s", (String)"CalcAction_1", (String)"macc-sca-mservice", (Object[])new Object[0]), System.currentTimeMillis() - startTime));
            startTime = System.currentTimeMillis();
            LogUtils.logInfo((Object)this.getContext().getLogUniqueKey(), (Log)logger, (String)String.format(ResManager.loadKDString((String)"\u5e76\u884c\u6a21\u5f0f\uff1a\u53d6\u8ba1\u7b97\u6210\u529f\u7684\u5bf9\u8c61\u6570\u91cf%s", (String)"CalcAction_2", (String)"macc-sca-mservice", (Object[])new Object[0]), costObjects.size()));
            this.reCalSuccessCostObjectForConcurrency();
            LogUtils.logInfo((Object)this.getContext().getLogUniqueKey(), (Log)logger, (String)String.format(ResManager.loadKDString((String)"\u5e76\u884c\u6a21\u5f0f\uff1a\u53d6\u8ba1\u7b97\u6210\u529f\u7684\u5bf9\u8c61\u6570\u91cf\uff0c\u7ed3\u675f\uff0c\u8017\u65f6%s", (String)"CalcAction_3", (String)"macc-sca-mservice", (Object[])new Object[0]), System.currentTimeMillis() - startTime));
        } else {
            float totalbatch = 0.0f;
            HashMap<Long, List> manuOrgCostObjectsMap = new HashMap<Long, List>(16);
            HashMap manuOrgBatchMap = new HashMap(16);
            if (CadEmptyUtils.isEmpty((Set)manuOrgs)) {
                manuOrgCostObjectsMap.put(0L, new ArrayList(costObjects));
            } else {
                QFilter filter = new QFilter("id", "in", (Object)costObjects);
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)"CalcAction-costobject", (String)"cad_costobject", (String)"id,manuorg", (QFilter[])filter.toArray(), null);
                for (Row row : dataSet) {
                    manuOrgCostObjectsMap.computeIfAbsent(row.getLong("manuorg"), t -> new ArrayList()).add(row.getLong("id"));
                }
                HashSet<Long> unAbsorbmManuOrgs = new HashSet<Long>(manuOrgs);
                unAbsorbmManuOrgs.removeAll(manuOrgCostObjectsMap.keySet());
                if (!unAbsorbmManuOrgs.isEmpty()) {
                    this.getContext().setUnAbsorbManuorgs(unAbsorbmManuOrgs);
                }
            }
            for (Map.Entry entry : manuOrgCostObjectsMap.entrySet()) {
                List splitLists = CadListUtils.splitLists(new ArrayList((Collection)entry.getValue()), (int)costObjectBatchSize);
                totalbatch += (float)splitLists.size();
                manuOrgBatchMap.put(entry.getKey(), splitLists);
            }
            if (totalbatch == 0.0f) {
                totalbatch = 1.0f;
            }
            float batchunit = 89.0f / totalbatch;
            Float[] floatArray = new Float[]{Float.valueOf(0.0f), Float.valueOf(batchunit)};
            this.getContext().setTotalBatch((int)totalbatch);
            for (Map.Entry entry : manuOrgBatchMap.entrySet()) {
                logger.info(String.format("\u5206\u6279\u8ba1\u7b97\uff1a\u5f00\u59cb\uff0c\u751f\u4ea7\u7ec4\u7ec7-%1$s\uff0c\u5171%2$s\u5f20\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff0c\u5206\u6210%3$s\u6279\uff0c\u6bcf\u6279%4$s\u5f20", entry.getKey(), ((List)manuOrgCostObjectsMap.get(entry.getKey())).size(), ((List)entry.getValue()).size(), costObjectBatchSize));
                LogUtils.logInfo((Object)this.getContext().getLogUniqueKey(), (Log)logger, (String)String.format(ResManager.loadKDString((String)"\u5206\u6279\u8ba1\u7b97\uff1a\u5f00\u59cb\uff0c\u751f\u4ea7\u7ec4\u7ec7-%1$s\uff0c\u5171%2$s\u5f20\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff0c\u5206\u6210%3$s\u6279\uff0c\u6bcf\u6279%4$s\u5f20", (String)"CalcAction_10", (String)"macc-sca-mservice", (Object[])new Object[0]), entry.getKey(), ((List)manuOrgCostObjectsMap.get(entry.getKey())).size(), ((List)entry.getValue()).size(), costObjectBatchSize));
                startTime = System.currentTimeMillis();
                if (this.getContext().getAllResMap() != null) {
                    this.getContext().setAllResMap(null);
                }
                if (this.getContext().getMatStdCosts() != null) {
                    this.getContext().getMatStdCosts().clear();
                }
                calcExcuteAction.executeBatch((List)entry.getValue(), (Long)entry.getKey(), ((List)entry.getValue()).size(), costObjectBatchSize, this.getContext(), this.getResultManager(), floatArray);
                LogUtils.logInfo((Object)this.getContext().getLogUniqueKey(), (Log)logger, (String)String.format(ResManager.loadKDString((String)"\u5206\u6279\u8ba1\u7b97\uff1a\u7ed3\u675f\uff0c\u751f\u4ea7\u7ec4\u7ec7-%1$s\uff0c\u8017\u65f6%2$s", (String)"CalcAction_11", (String)"macc-sca-mservice", (Object[])new Object[0]), entry.getKey(), System.currentTimeMillis() - startTime));
            }
        }
    }

    private void executeBatchByTask(CostCalcContext costCalcContext, int costObjectSize, CostCalcResultManager costCalcResultManager) {
        CalcPartitionTaskAction batchAction = new CalcPartitionTaskAction();
        batchAction.partitionTask(costCalcContext, costObjectSize, costCalcResultManager);
    }

    private void reCalSuccessCostObjectForConcurrency() {
        HashMap<Long, Integer> successCoCounts = new HashMap<Long, Integer>();
        CostCalcArgs args = this.getContext().getInputArgs();
        QFilter orgFilter = new QFilter("org", "=", (Object)args.getOrgId());
        orgFilter.and(new QFilter("costaccount", "=", (Object)args.getCostAccountId()));
        orgFilter.and(new QFilter("period", "=", (Object)args.getPeriodId()));
        orgFilter.and(new QFilter("costobject", "in", (Object)args.getCostObjectIds()));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadSuccessCostObjectForConcurrency"), (String)"sca_calcresult", (String)"costcenter, costobject", (QFilter[])new QFilter[]{orgFilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long costCenterId = row.getLong("costcenter");
                if (!successCoCounts.containsKey(costCenterId)) {
                    successCoCounts.put(costCenterId, 1);
                    continue;
                }
                Integer currSuccess = (Integer)successCoCounts.get(costCenterId);
                currSuccess = currSuccess + 1;
                successCoCounts.put(costCenterId, currSuccess);
            }
        }
        for (Map.Entry entry : successCoCounts.entrySet()) {
            Long costCenterId = (Long)entry.getKey();
            Integer count = this.getResultManager().getSuccessCoCounts().computeIfAbsent(costCenterId, s -> 0);
            count = count + (Integer)entry.getValue();
            this.getResultManager().getSuccessCoCounts().put(costCenterId, count);
        }
    }

    private int getCostObjectBatchSize() {
        int batchSize = 0;
        if (CalcTaskType.FinishCalc == this.getContext().getTaskType()) {
            batchSize = CadBgParamUtils.getCadParamForInt((String)"costobjsizeFinish", (int)200);
        } else if (CalcTaskType.PeriodEndCalc == this.getContext().getTaskType()) {
            batchSize = CadBgParamUtils.getCadParamForInt((String)"costobjsizePeriodEnd", (int)200);
        }
        if (batchSize > 1000) {
            batchSize = 1000;
        } else if (batchSize < 20) {
            batchSize = 20;
        }
        return batchSize;
    }
}

