/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.thread.TaskType;
import kd.macc.cad.common.thread.ThreadHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.ScaCalcHelper;
import kd.macc.sca.mservice.costcalc.CalcTaskType;
import kd.macc.sca.mservice.costcalc.action.AbstractCalcAction;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class CalcDataCheckAction
extends AbstractCalcAction {
    private static final Log logger = LogFactory.getLog(CalcDataCheckAction.class);
    private static final int MAX_ERROR_SIZE = 2000;
    private static final String CALC_DATA_CHECK_KEY = "ScaCalcDataCheck";
    private static final String CALC_DATA_CHECK_SUBCOM_KEY = "ScaCalcSubComCheck";
    private static final String CALC_DATA_ACTION_CONCURRENCY_SWITCH = "calcDataCheckSwitch";

    @Override
    protected void doExecute() {
        if (!this.getContext().getInputArgs().isCalc().booleanValue()) {
            logger.info("\u5206\u6279\u8ba1\u7b97\uff1a\u9000\u51fa\uff0cisCalc = false");
            return;
        }
        if ("0".equals(CadBgParamUtils.getCadBgParamForString((String)CALC_DATA_CHECK_KEY, (String)"1"))) {
            logger.info("\u6210\u672c\u8ba1\u7b97\u540e\u68c0\u67e5\uff0c\u4e0d\u68c0\u67e5\u6570\u636e");
            return;
        }
        String curItem = ResManager.loadKDString((String)"\u8ba1\u7b97\u540e\u6570\u636e\u68c0\u67e5", (String)"CalcDataCheckAction_23", (String)"macc-sca-mservice", (Object[])new Object[0]);
        long itemId = this.getResultManager().getTaskRecorder().createTaskRecordDetail(curItem, null);
        Set calcMainJoinSideCostObjectSet = ScaCalcHelper.getMainJoinSideCostObjectIds((Long)this.getContext().getInputArgs().getOrgId(), (Set)this.getContext().getInputArgs().getCostObjectIds());
        int warnSize = 0;
        try {
            boolean isConcurrency;
            boolean bl = isConcurrency = CadBgParamUtils.getCadParamForInt((String)CALC_DATA_ACTION_CONCURRENCY_SWITCH, (int)1) == 1;
            if (isConcurrency) {
                warnSize = this.doCalcDataCheckWithConcurrency(calcMainJoinSideCostObjectSet, this.getContext().getTaskType().getValue());
            } else {
                long start = System.currentTimeMillis();
                warnSize = this.matCalcDataCheck();
                logger.info("\u68c0\u67e5\u672c\u671f\u6295\u5165\u9886\u6599\u7684\u5438\u6536\u6210\u672c\u4e0e\u6750\u6599\u8017\u7528\u5206\u914d\u662f\u5426\u4e00\u81f4-\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                start = System.currentTimeMillis();
                warnSize += this.mfgfeeCalcDataCheck();
                logger.info("\u68c0\u67e5\u672c\u671f\u6295\u5165\u8d44\u6e90\u7684\u5438\u6536\u6210\u672c\u4e0e\u8d44\u6e90\u8d39\u7528\u5438\u6536\u6210\u672c\u5355\u3001\u5438\u6536\u6210\u672c\u8c03\u6574\u5355\u662f\u5426\u4e00\u81f4-\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                start = System.currentTimeMillis();
                warnSize += this.factCalcDataCheck(calcMainJoinSideCostObjectSet);
                logger.info("\u68c0\u67e5\u672c\u671f\u5b8c\u5de5\u7684\u6807\u51c6\u6210\u672c\u4e0e\u5b8c\u5de5\u5165\u5e93\u6570\u91cf\u5f52\u96c6\u5355\u662f\u5426\u4e00\u81f4-\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                start = System.currentTimeMillis();
                warnSize += this.prePeriodComCurPeriodCheck();
                logger.info("\u68c0\u67e5\u671f\u521d\u5728\u4ea7\u54c1\u6210\u672c\u4e0e\u4e0a\u671f\u671f\u672b\u5728\u4ea7\u54c1\u6210\u672c\u662f\u5426\u4e00\u81f4-\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                start = System.currentTimeMillis();
                if ("1".equals(CadBgParamUtils.getCadBgParamForString((String)CALC_DATA_CHECK_SUBCOM_KEY, (String)"1"))) {
                    warnSize += this.subAndCompCheck();
                }
                logger.info("\u68c0\u67e5\u5206\u9879\u548c\u7efc\u5408\u6210\u672c\u662f\u5426\u4e00\u81f4-\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                start = System.currentTimeMillis();
                warnSize += this.finshDiffDataCheck();
                logger.info("\u68c0\u67e5\u201c\u672c\u671f\u6295\u5165\u91d1\u989d-\u672c\u671f\u5b8c\u5de5\u91d1\u989d=\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u91d1\u989d\u201d-\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                start = System.currentTimeMillis();
                warnSize += this.finshDiffCheck(calcMainJoinSideCostObjectSet);
                logger.info("\u68c0\u67e5\u751f\u6210\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355\u91d1\u989d\u6b63\u786e-\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                if (this.getContext().getTaskType().getValue() == CalcTaskType.PeriodEndCalc.getValue()) {
                    start = System.currentTimeMillis();
                    warnSize += this.unAbsorbCalcCheck();
                    logger.info("\u68c0\u67e5\u201c\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u8d39\u7528-\u5438\u6536\u8d39\u7528=\u672a\u5438\u6536\u8d39\u7528\u201d-\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                    start = System.currentTimeMillis();
                    warnSize += this.unAbsorbCalcDataCheck();
                    logger.info("\u68c0\u67e5\u201c\u671f\u521d+\u672c\u671f\u672a\u5438\u6536=\u671f\u672b\u5728\u4ea7+\u672c\u671f\u5dee\u5f02\u8f6c\u51fa\u201d-\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                    start = System.currentTimeMillis();
                    warnSize += this.unAbsorbPrePeriodComCurPeriodCheck();
                    logger.info("\u68c0\u67e5\u671f\u521d\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u4e0e\u4e0a\u671f\u671f\u672b\u5728\u4ea7\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u5b58\u5728\u5dee\u5f02-\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                    start = System.currentTimeMillis();
                    warnSize += this.unAbsorbBillCheck();
                    logger.info("\u68c0\u67e5\u751f\u6210\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u5355\u91d1\u989d\u6b63\u786e-\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                }
            }
        }
        catch (Exception ex) {
            logger.info("\u6210\u672c\u8ba1\u7b97-\u8ba1\u7b97\u7ed3\u679c\u68c0\u67e5\u51fa\u73b0\u9519\u8bef:" + ex.getMessage(), (Object)ex);
            String errorInfo = this.wrapExceptionErrorInfo(ex);
            this.getResultManager().getTaskRecorder().upateTaskRecordDetail((Long)itemId, "3", ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u5b58\u5728\u5f02\u5e38\u4efb\u52a1\u3002", (String)"CalcDataCheckAction_24", (String)"macc-sca-mservice", (Object[])new Object[0]), errorInfo);
            return;
        }
        this.getResultManager().getTaskRecorder().upateTaskRecordDetail(itemId, warnSize > 0 ? "3" : "4");
    }

    private List<String> getProcessMethodNameList(int taskType) {
        ArrayList<String> methodNameList = new ArrayList<String>(7);
        methodNameList.add("matCalcDataCheck");
        methodNameList.add("mfgfeeCalcDataCheck");
        methodNameList.add("factCalcDataCheck");
        methodNameList.add("prePeriodComCurPeriodCheck");
        if ("1".equals(CadBgParamUtils.getCadBgParamForString((String)CALC_DATA_CHECK_SUBCOM_KEY, (String)"1"))) {
            methodNameList.add("subAndCompCheck");
        }
        methodNameList.add("finshDiffDataCheck");
        methodNameList.add("finshDiffCheck");
        if (taskType != CalcTaskType.PeriodEndCalc.getValue()) {
            return methodNameList;
        }
        methodNameList.add("unAbsorbCalcCheck");
        methodNameList.add("unAbsorbCalcDataCheck");
        methodNameList.add("unAbsorbPrePeriodComCurPeriodCheck");
        methodNameList.add("unAbsorbBillCheck");
        return methodNameList;
    }

    private List<String> getProcessArgsMethodList() {
        ArrayList<String> hasArgsMethodList = new ArrayList<String>(2);
        hasArgsMethodList.add("factCalcDataCheck");
        hasArgsMethodList.add("finshDiffCheck");
        return hasArgsMethodList;
    }

    private int doCalcDataCheckWithConcurrency(final Set<Long> calcMainJoinSideCostObjectSet, int taskType) {
        logger.info("doCalcDataCheckWithConcurrency start");
        long startConcurrencyMills = System.currentTimeMillis();
        final AtomicInteger warnSize = new AtomicInteger(0);
        final AtomicInteger exceptionCount = new AtomicInteger(0);
        try {
            List<String> methodNameList = this.getProcessMethodNameList(taskType);
            final CountDownLatch countDownLatch = new CountDownLatch(methodNameList.size());
            final Class<?> clazz = Class.forName("kd.macc.sca.mservice.costcalc.action.CalcDataCheckAction");
            final CalcDataCheckAction calcDataCheckAction = (CalcDataCheckAction)clazz.newInstance();
            calcDataCheckAction.setContext(this.getContext());
            calcDataCheckAction.setResultManager(this.getResultManager());
            logger.info("doCalcDataCheckWithConcurrency execute methodNameList size={},methodNameList={}", (Object)methodNameList.size(), methodNameList);
            for (final String methodName : methodNameList) {
                final long startMills = System.currentTimeMillis();
                ThreadHelper.execute((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            logger.info("doCalcDataCheckWithConcurrency cycle start methodName={}", (Object)methodName);
                            Method method = null;
                            Object result = null;
                            List hasArgsMethodList = CalcDataCheckAction.this.getProcessArgsMethodList();
                            if (hasArgsMethodList.contains(methodName)) {
                                method = clazz.getMethod(methodName, Set.class);
                                if (method == null) {
                                    return;
                                }
                                result = method.invoke((Object)calcDataCheckAction, calcMainJoinSideCostObjectSet);
                            } else {
                                method = clazz.getMethod(methodName, new Class[0]);
                                if (method == null) {
                                    return;
                                }
                                result = method.invoke((Object)calcDataCheckAction, new Object[0]);
                            }
                            if (result != null) {
                                warnSize.addAndGet((Integer)result);
                            }
                            logger.info("doCalcDataCheckWithConcurrency cycle methodName={}, result={}", (Object)methodName, result);
                        }
                        catch (Exception e) {
                            logger.error("doCalcDataCheckWithConcurrency cycle invoke error,methodName={},Exception=", (Object)methodName, (Object)e);
                            exceptionCount.incrementAndGet();
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                        logger.info("doCalcDataCheckWithConcurrency cycle end methodName={}, costTime={}", (Object)methodName, (Object)(System.currentTimeMillis() - startMills));
                    }
                }, (TaskType)TaskType.SCA_CALCHECK);
            }
            countDownLatch.await();
            if (exceptionCount.intValue() > 0) {
                throw new KDBizException("doCalcDataCheckWithConcurrency error, exceptionCount > 0");
            }
            logger.info("doCalcDataCheckWithConcurrency end. warnSize={}, costTime={}", (Object)warnSize.intValue(), (Object)(System.currentTimeMillis() - startConcurrencyMills));
            return warnSize.intValue();
        }
        catch (Exception e) {
            logger.error("doCalcDataCheckWithConcurrency exception={}", (Object)e.getMessage());
            throw new KDBizException("doCalcDataCheckWithConcurrency error, Exception=" + e);
        }
    }

    public int matCalcDataCheck() {
        ArrayList costobjectInIds = new ArrayList(this.getContext().getInputArgs().getCostObjectIds());
        String selectFields = "entryentity.costobejctentry costobject,entryentity.amount matAmount,0.0 calcAmount";
        QFilter filter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        filter.and(new QFilter("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId()));
        filter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        filter.and(new QFilter("allocstatus", "=", (Object)"2"));
        filter.and(new QFilter("appnum", "=", (Object)"sca"));
        DataSet matDs = InFilterHelper.queryDataSetIn((String)"sca_matalloc", (String)selectFields, (QFilter)filter, (String)"entryentity.costobejctentry", costobjectInIds);
        String reaultSelectFields = "entryentity.obj costobject,0.0 matAmount,entryentity.pdcurramount calcAmount";
        QFilter resultFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        resultFilter.and(new QFilter("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId()));
        resultFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        resultFilter.and("entryentity.datatype", "=", (Object)"1");
        resultFilter.and("entryentity.caltype", "in", (Object)new String[]{"1", "3"});
        resultFilter.and("entryentity.difftype", "=", (Object)"1");
        resultFilter.and("entryentity.pdcurramount", "!=", (Object)BigDecimal.ZERO);
        DataSet calcResultDs = InFilterHelper.queryDataSetIn((String)"sca_calcresult", (String)reaultSelectFields, (QFilter)resultFilter, (String)"costobject", costobjectInIds);
        DataSet resultDs = matDs.union(calcResultDs);
        DataSet compareDs = resultDs.groupBy(new String[]{"costobject"}).sum("matAmount").sum("calcAmount").finish();
        compareDs = compareDs.select("costobject,case when matAmount is null then 0.0 else matAmount end matAmount,case when calcAmount is null then 0.0 else calcAmount end calcAmount");
        compareDs = compareDs.filter("matAmount-calcAmount!=0");
        if (compareDs.isEmpty()) {
            logger.info("matCalcDataCheck-nodiff");
            return 0;
        }
        logger.info("matCalcDataCheck-hasdiff");
        Set costobjectIds = ScaCalcHelper.getLongIdSetFromDs((DataSet)compareDs, (String)"costobject", (boolean)false);
        selectFields = "entryentity.costobejctentry.costcenter costcenter,entryentity.costobejctentry costobject,entryentity.subelemententry subelement,entryentity.amount matAmount,0.0 calcAmount";
        filter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        filter.and(new QFilter("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId()));
        filter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        filter.and("entryentity.costobejctentry", "in", (Object)costobjectIds);
        filter.and(new QFilter("allocstatus", "=", (Object)"2"));
        filter.and(new QFilter("appnum", "=", (Object)"sca"));
        matDs = QueryServiceHelper.queryDataSet((String)"queryMatAllocDataSet", (String)"sca_matalloc", (String)selectFields, (QFilter[])filter.toArray(), (String)"");
        reaultSelectFields = "entryentity.obj.costcenter costcenter,entryentity.obj costobject,entryentity.subelement subelement,0.0 matAmount,entryentity.pdcurramount calcAmount";
        resultFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        resultFilter.and(new QFilter("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId()));
        resultFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        resultFilter.and("costobject", "in", (Object)costobjectIds);
        resultFilter.and("entryentity.datatype", "=", (Object)"1");
        resultFilter.and("entryentity.caltype", "in", (Object)new String[]{"1", "3"});
        resultFilter.and("entryentity.difftype", "=", (Object)"1");
        resultFilter.and("entryentity.pdcurramount", "!=", (Object)BigDecimal.ZERO);
        calcResultDs = QueryServiceHelper.queryDataSet((String)"queryCalResult", (String)"sca_calcresult", (String)reaultSelectFields, (QFilter[])resultFilter.toArray(), (String)"");
        resultDs = matDs.union(calcResultDs);
        compareDs = resultDs.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("matAmount").sum("calcAmount").finish();
        compareDs = compareDs.select("costcenter,costobject,subelement,case when matAmount is null then 0.0 else matAmount end matAmount,case when calcAmount is null then 0.0 else calcAmount end calcAmount");
        compareDs = compareDs.filter("matAmount-calcAmount!=0");
        if (compareDs.isEmpty()) {
            return 0;
        }
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u672c\u671f\u6295\u5165\u9886\u6599\u7684\u5438\u6536\u6210\u672c\u4e0e\u6750\u6599\u8017\u7528\u5206\u914d\u662f\u5426\u4e00\u81f4\u3002", (String)"CalcDataCheckAction_0", (String)"macc-sca-mservice", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u672c\u671f\u6295\u5165\u6750\u6599\u7684\u5438\u6536\u6210\u672c\u4e0e\u6750\u6599\u8017\u7528\u5206\u914d\u5b58\u5728\u5dee\u5f02\u3002", (String)"CalcDataCheckAction_25", (String)"macc-sca-mservice", (Object[])new Object[0]);
        long itemId = this.getItemId(curItem, detail);
        compareDs = this.relaSubElementData(compareDs);
        compareDs = compareDs.orderBy(new String[]{"costcenter", "costobject", "subelementNo"});
        DynamicObject checkDetail = this.createCheckDetailDyn(itemId, curItem);
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("costobject", (Object)row.getLong("costobject"));
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u3010%1$s/%2$s\u3011\u672c\u671f\u6295\u9886\u6599\u7684\u5438\u6536\u6210\u672c\u4e3a\u3010%3$s\u3011\uff0c\u6750\u6599\u8017\u7528\u5206\u914d\u91d1\u989d\u4e3a\u3010%4$s\u3011\uff0c\u5b58\u5728\u5dee\u5f02\u3002", (String)"CalcDataCheckAction_26", (String)"macc-sca-mservice", (Object[])new Object[0]), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("matAmount")), this.getBigDecimalStr(row.getBigDecimal("calcAmount")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        return 1;
    }

    public int factCalcDataCheck(Set<Long> calcMainJoinSideCostObjectSet) {
        ArrayList<Long> costobjectInIds = new ArrayList<Long>(calcMainJoinSideCostObjectSet);
        String selectFields = "entryentity.costobject costobject,entrycost.amount factAmount,0.0 calcAmount";
        QFilter filter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        filter.and("entrycost.costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId());
        filter.and("bookdate", ">=", (Object)this.getContext().getInputArgs().getStartDate());
        filter.and("bookdate", "<=", (Object)this.getContext().getInputArgs().getEndDate());
        filter.and("billstatus", "=", (Object)"C");
        filter.and("appnum", "=", (Object)"sca");
        DataSet factDs = InFilterHelper.queryDataSetIn((String)"cad_factnedoutputbill", (String)selectFields, (QFilter)filter, (String)"entryentity.costobject", costobjectInIds);
        String reaultSelectFields = "entryentity.obj costobject,0.0 factAmount,entryentity.pdcompanount calcAmount";
        QFilter resultFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        resultFilter.and(new QFilter("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId()));
        resultFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        resultFilter.and("entryentity.datatype", "in", (Object)new String[]{"99", "98"});
        resultFilter.and("entryentity.pdcompanount", "!=", (Object)BigDecimal.ZERO);
        DataSet calcResultDs = InFilterHelper.queryDataSetIn((String)"sca_calcresult", (String)reaultSelectFields, (QFilter)resultFilter, (String)"costobject", costobjectInIds);
        DataSet resultDs = factDs.union(calcResultDs);
        DataSet compareDs = resultDs.groupBy(new String[]{"costobject"}).sum("factAmount").sum("calcAmount").finish();
        compareDs = compareDs.select("costobject,case when factAmount is null then 0.0 else factAmount end factAmount,case when calcAmount is null then 0.0 else calcAmount end calcAmount");
        compareDs = compareDs.filter("factAmount-calcAmount!=0");
        if (compareDs.isEmpty()) {
            logger.info("factCalcDataCheck-nodiff");
            return 0;
        }
        logger.info("factCalcDataCheck-hasdiff");
        Set costobjectIds = ScaCalcHelper.getLongIdSetFromDs((DataSet)compareDs, (String)"costobject", (boolean)false);
        selectFields = "entryentity.costobject.costcenter costcenter,entryentity.costobject costobject,entrycost.subelement subelement,entrycost.amount factAmount,0.0 calcAmount";
        filter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        filter.and("entrycost.costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId());
        filter.and("bookdate", ">=", (Object)this.getContext().getInputArgs().getStartDate());
        filter.and("bookdate", "<=", (Object)this.getContext().getInputArgs().getEndDate());
        filter.and("entryentity.costobject", "in", (Object)costobjectIds);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("appnum", "=", (Object)"sca");
        factDs = QueryServiceHelper.queryDataSet((String)"queryFactDataSet", (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])filter.toArray(), (String)"");
        reaultSelectFields = "entryentity.obj.costcenter costcenter,entryentity.obj costobject,entryentity.subelement subelement,0.0 factAmount,entryentity.pdcompanount calcAmount";
        resultFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        resultFilter.and(new QFilter("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId()));
        resultFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        resultFilter.and("entryentity.obj", "in", (Object)costobjectIds);
        resultFilter.and("entryentity.datatype", "=", (Object)"2");
        resultFilter.and("entryentity.caltype", "!=", (Object)"5");
        resultFilter.and("entryentity.pdcompanount", "!=", (Object)BigDecimal.ZERO);
        calcResultDs = QueryServiceHelper.queryDataSet((String)"queryCalResult", (String)"sca_calcresult", (String)reaultSelectFields, (QFilter[])resultFilter.toArray(), (String)"");
        resultDs = factDs.union(calcResultDs);
        compareDs = resultDs.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("factAmount").sum("calcAmount").finish();
        compareDs = compareDs.select("costcenter,costobject,subelement,case when factAmount is null then 0.0 else factAmount end factAmount,case when calcAmount is null then 0.0 else calcAmount end calcAmount");
        compareDs = compareDs.filter("factAmount-calcAmount!=0");
        if (compareDs.isEmpty()) {
            return 0;
        }
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u672c\u671f\u5b8c\u5de5\u7684\u6807\u51c6\u6210\u672c\u4e0e\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u662f\u5426\u4e00\u81f4\u3002", (String)"CalcDataCheckAction_27", (String)"macc-sca-mservice", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u672c\u671f\u5b8c\u5de5\u7684\u6807\u51c6\u6210\u672c\u4e0e\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u6807\u51c6\u6210\u672c\u5b58\u5728\u5dee\u5f02\u3002", (String)"CalcDataCheckAction_28", (String)"macc-sca-mservice", (Object[])new Object[0]);
        long itemId = this.getItemId(curItem, detail);
        compareDs = this.relaSubElementData(compareDs);
        compareDs = compareDs.orderBy(new String[]{"costcenter", "costobject", "subelementNo"});
        DynamicObject checkDetail = this.createCheckDetailDyn(itemId, curItem);
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("costobject", (Object)row.getLong("costobject"));
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u3010%1$s/%2$s\u3011 \u672c\u671f\u5b8c\u5de5\u7684\u6807\u51c6\u6210\u672c\u4e3a\u3010%3$s\u3011\uff0c\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u6807\u51c6\u6210\u672c\u4e3a\u3010%4$s\u3011\uff0c\u5b58\u5728\u5dee\u5f02\u3002", (String)"CalcDataCheckAction_29", (String)"macc-sca-mservice", (Object[])new Object[0]), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("calcAmount")), this.getBigDecimalStr(row.getBigDecimal("factAmount")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        return 1;
    }

    private QFilter getQFilterToArr(QFilter[] arr) {
        QFilter filter = null;
        for (QFilter f : arr) {
            if (filter == null) {
                filter = f;
                continue;
            }
            if (f == null) continue;
            filter.and(f);
        }
        return filter;
    }

    public int prePeriodComCurPeriodCheck() {
        ArrayList costobjectInIds = new ArrayList(this.getContext().getInputArgs().getCostObjectIds());
        String reaultSelectFields = "entryentity.obj costobject,entryentity.pdendamount endAmount,0.0 startAmount";
        QFilter resultFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        resultFilter.and(new QFilter("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId()));
        resultFilter.and("entryentity.datatype", "in", (Object)new String[]{"99", "98"});
        DataSet preResultDs = InFilterHelper.queryDataSetIn((String)"sca_calcresult", (String)reaultSelectFields, (QFilter)this.getQFilterToArr(new QFilter[]{resultFilter, new QFilter("period", "=", (Object)this.getContext().getInputArgs().getPrePeriodId()), new QFilter("entryentity.pdendamount", "!=", (Object)BigDecimal.ZERO)}), (String)"costobject", costobjectInIds);
        reaultSelectFields = "entryentity.obj costobject,0.0 endAmount,entryentity.pdstartamount startAmount";
        DataSet currResultDs = InFilterHelper.queryDataSetIn((String)"sca_calcresult", (String)reaultSelectFields, (QFilter)this.getQFilterToArr(new QFilter[]{resultFilter, new QFilter("period", "=", (Object)this.getContext().getInputArgs().getPeriodId()), new QFilter("entryentity.pdstartamount", "!=", (Object)BigDecimal.ZERO)}), (String)"costobject", costobjectInIds);
        DataSet resultDs = preResultDs.union(currResultDs);
        DataSet compareDs = resultDs.groupBy(new String[]{"costobject"}).sum("endAmount").sum("startAmount").finish();
        compareDs = compareDs.select("costobject,case when endAmount is null then 0.0 else endAmount end endAmount,case when startAmount is null then 0.0 else startAmount end startAmount");
        compareDs = compareDs.filter("startAmount-endAmount!=0");
        if (compareDs.isEmpty()) {
            logger.info("prePeriodComCurPeriodCheck-nodiff");
            return 0;
        }
        logger.info("prePeriodComCurPeriodCheck-hasdiff");
        Set costobjectIds = ScaCalcHelper.getLongIdSetFromDs((DataSet)compareDs, (String)"costobject", (boolean)false);
        reaultSelectFields = "entryentity.obj.costcenter costcenter,entryentity.obj costobject,entryentity.subelement subelement,entryentity.pdendamount endAmount,0.0 startAmount";
        resultFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        resultFilter.and(new QFilter("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId()));
        resultFilter.and("costobject", "in", (Object)costobjectIds);
        resultFilter.and("entryentity.datatype", "=", (Object)"2");
        preResultDs = QueryServiceHelper.queryDataSet((String)"queryCalResult", (String)"sca_calcresult", (String)reaultSelectFields, (QFilter[])new QFilter[]{resultFilter, new QFilter("period", "=", (Object)this.getContext().getInputArgs().getPrePeriodId()), new QFilter("entryentity.pdendamount", "!=", (Object)BigDecimal.ZERO)}, (String)"");
        reaultSelectFields = "entryentity.obj.costcenter costcenter,entryentity.obj costobject,entryentity.subelement subelement,0.0 endAmount,entryentity.pdstartamount startAmount";
        currResultDs = QueryServiceHelper.queryDataSet((String)"queryCalResult", (String)"sca_calcresult", (String)reaultSelectFields, (QFilter[])new QFilter[]{resultFilter, new QFilter("period", "=", (Object)this.getContext().getInputArgs().getPeriodId()), new QFilter("entryentity.pdstartamount", "!=", (Object)BigDecimal.ZERO)}, (String)"");
        resultDs = preResultDs.union(currResultDs);
        compareDs = resultDs.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("endAmount").sum("startAmount").finish();
        compareDs = compareDs.select("costcenter,costobject,subelement,case when endAmount is null then 0.0 else endAmount end endAmount,case when startAmount is null then 0.0 else startAmount end startAmount");
        compareDs = compareDs.filter("startAmount-endAmount!=0");
        if (compareDs.isEmpty()) {
            return 0;
        }
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u671f\u521d\u5728\u4ea7\u54c1\u6210\u672c\u4e0e\u4e0a\u671f\u671f\u672b\u5728\u4ea7\u54c1\u6210\u672c\u662f\u5426\u4e00\u81f4\u3002", (String)"CalcDataCheckAction_30", (String)"macc-sca-mservice", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u671f\u521d\u5728\u4ea7\u54c1\u6210\u672c\u4e0e\u4e0a\u671f\u671f\u672b\u5728\u4ea7\u54c1\u6210\u672c\u5b58\u5728\u5dee\u5f02\u3002", (String)"CalcDataCheckAction_31", (String)"macc-sca-mservice", (Object[])new Object[0]);
        long itemId = this.getItemId(curItem, detail);
        compareDs = this.relaSubElementData(compareDs);
        compareDs = compareDs.orderBy(new String[]{"costcenter", "costobject", "subelementNo"});
        DynamicObject checkDetail = this.createCheckDetailDyn(itemId, curItem);
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("costobject", (Object)row.getLong("costobject"));
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u3010%1$s/%2$s\u3011\u671f\u521d\u5728\u4ea7\u54c1\u6210\u672c\u4e3a\u3010%3$s\u3011\uff0c\u4e0a\u671f\u671f\u672b\u5728\u4ea7\u54c1\u6210\u672c\u4e3a\u3010%4$s\u3011\uff0c\u5b58\u5728\u5dee\u5f02\u3002", (String)"CalcDataCheckAction_32", (String)"macc-sca-mservice", (Object[])new Object[0]), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("startAmount")), this.getBigDecimalStr(row.getBigDecimal("endAmount")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        return 1;
    }

    public int mfgfeeCalcDataCheck() {
        ArrayList costobjectInIds = new ArrayList(this.getContext().getInputArgs().getCostObjectIds());
        String selectFields = "costobject,entryentity.amount as adjuestAmount,0.0 absobAmount,0.0 calcAmount";
        ArrayList<Object> filters = new ArrayList<QFilter>();
        this.getContext().getFilterBuilder().warpQFilter4Period(filters, "org", true, this.getContext().getInputArgs());
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        DataSet absorbCostDs = InFilterHelper.queryDataSetIn((String)"sca_absorbadjust", (String)selectFields, (QFilter)this.getQFilterToArr(filters.toArray(new QFilter[0])), (String)"costobject", costobjectInIds);
        String absorbSelectFields = "costobject,0.0 adjuestAmount,entryentity.amount absobAmount,0 calcAmount";
        ArrayList<Object> resAbsoubFilters = new ArrayList<QFilter>();
        this.getContext().getFilterBuilder().warpQFilter4Period(resAbsoubFilters, "org", true, this.getContext().getInputArgs());
        DataSet resAbsorbDs = InFilterHelper.queryDataSetIn((String)"sca_resourceabsorb", (String)absorbSelectFields, (QFilter)this.getQFilterToArr(resAbsoubFilters.toArray(new QFilter[0])), (String)"costobject", costobjectInIds);
        String reaultSelectFields = "entryentity.obj as costobject,0.0 adjuestAmount,0.0 absobAmount,entryentity.pdcurramount calcAmount";
        QFilter resultFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        resultFilter.and(new QFilter("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId()));
        resultFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        resultFilter.and("entryentity.datatype", "=", (Object)"3");
        resultFilter.and("entryentity.difftype", "=", (Object)"2");
        resultFilter.and("entryentity.pdcurramount", "!=", (Object)BigDecimal.ZERO);
        DataSet calcResultDs = InFilterHelper.queryDataSetIn((String)"sca_calcresult", (String)reaultSelectFields, (QFilter)resultFilter, (String)"costobject", costobjectInIds);
        DataSet resultDs = absorbCostDs.union(new DataSet[]{resAbsorbDs, calcResultDs});
        DataSet compareDs = resultDs.groupBy(new String[]{"costobject"}).sum("adjuestAmount").sum("absobAmount").sum("calcAmount").finish();
        compareDs = compareDs.select("costobject,case when adjuestAmount is null then 0.0 else adjuestAmount end adjuestAmount,case when absobAmount is null then 0.0 else absobAmount end absobAmount,case when calcAmount is null then 0.0 else calcAmount end calcAmount");
        compareDs = compareDs.filter("adjuestAmount+absobAmount-calcAmount!=0");
        if (compareDs.isEmpty()) {
            logger.info("mfgfeeCalcDataCheck-nodiff");
            return 0;
        }
        logger.info("mfgfeeCalcDataCheck-hasdiff");
        Set costobjectIds = ScaCalcHelper.getLongIdSetFromDs((DataSet)compareDs, (String)"costobject", (boolean)false);
        selectFields = "costobject.costcenter costcenter,costobject,entryentity.subelement as subelement,entryentity.amount as adjuestAmount,0.0 absobAmount,0.0 calcAmount";
        filters = new ArrayList();
        this.getContext().getFilterBuilder().warpQFilter4Period(filters, "org", true, this.getContext().getInputArgs());
        filters.add(new QFilter("costobject", "in", (Object)costobjectIds));
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        absorbCostDs = QueryServiceHelper.queryDataSet((String)"CostAbsorbAdjustHelper", (String)"sca_absorbadjust", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        absorbSelectFields = "costobject.costcenter costcenter,costobject,entryentity.subelement subelement,0.0 adjuestAmount,entryentity.amount absobAmount,0 calcAmount";
        resAbsoubFilters = new ArrayList();
        this.getContext().getFilterBuilder().warpQFilter4Period(resAbsoubFilters, "org", true, this.getContext().getInputArgs());
        resAbsoubFilters.add(new QFilter("costobject", "in", (Object)costobjectIds));
        resAbsorbDs = QueryServiceHelper.queryDataSet((String)"CostAbsorbAdjustHelper", (String)"sca_resourceabsorb", (String)absorbSelectFields, (QFilter[])resAbsoubFilters.toArray(new QFilter[0]), null);
        reaultSelectFields = "entryentity.obj.costcenter costcenter,entryentity.obj as costobject,entryentity.subelement subelement,0.0 adjuestAmount,0.0 absobAmount,entryentity.pdcurramount calcAmount";
        resultFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        resultFilter.and(new QFilter("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId()));
        resultFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        resultFilter.and("costobject", "in", (Object)costobjectIds);
        resultFilter.and("entryentity.datatype", "=", (Object)"3");
        resultFilter.and("entryentity.difftype", "=", (Object)"2");
        resultFilter.and("entryentity.pdcurramount", "!=", (Object)BigDecimal.ZERO);
        calcResultDs = QueryServiceHelper.queryDataSet((String)"queryCalResult", (String)"sca_calcresult", (String)reaultSelectFields, (QFilter[])resultFilter.toArray(), (String)"");
        resultDs = absorbCostDs.union(new DataSet[]{resAbsorbDs, calcResultDs});
        compareDs = resultDs.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("adjuestAmount").sum("absobAmount").sum("calcAmount").finish();
        compareDs = compareDs.select("costcenter,costobject,subelement,case when adjuestAmount is null then 0.0 else adjuestAmount end adjuestAmount,case when absobAmount is null then 0.0 else absobAmount end absobAmount,case when calcAmount is null then 0.0 else calcAmount end calcAmount");
        compareDs = compareDs.filter("adjuestAmount+absobAmount-calcAmount!=0");
        if (compareDs.isEmpty()) {
            return 0;
        }
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u672c\u671f\u6295\u5165\u8d44\u6e90\u7684\u5438\u6536\u6210\u672c\u4e0e\u8d44\u6e90\u8d39\u7528\u5438\u6536\u6210\u672c\u5355\u3001\u5438\u6536\u6210\u672c\u8c03\u6574\u5355\u662f\u5426\u4e00\u81f4\u3002", (String)"CalcDataCheckAction_3", (String)"macc-sca-mservice", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u672c\u671f\u6295\u5165\u8d44\u6e90\u7684\u5438\u6536\u6210\u672c\u4e0e\u8d44\u6e90\u8d39\u7528\u5438\u6536\u6210\u672c\u5355\u3001\u5438\u6536\u6210\u672c\u8c03\u6574\u5355\u5b58\u5728\u5dee\u5f02\u3002", (String)"CalcDataCheckAction_33", (String)"macc-sca-mservice", (Object[])new Object[0]);
        long itemId = this.getItemId(curItem, detail);
        compareDs = this.relaSubElementData(compareDs);
        compareDs = compareDs.orderBy(new String[]{"costcenter", "costobject", "subelementNo"});
        DynamicObject checkDetail = this.createCheckDetailDyn(itemId, curItem);
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("costobject", (Object)row.getLong("costobject"));
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u3010%1$s/%2$s\u3011\u672c\u671f\u6295\u5165\u8d44\u6e90\u7684\u5438\u6536\u6210\u672c\u4e3a\u3010%3$s\u3011\uff0c\u8d44\u6e90\u8d39\u7528\u5438\u6536\u6210\u672c\u5355\u4e3a\u3010%4$s\u3011\u3001\u5438\u6536\u6210\u672c\u8c03\u6574\u5355\u4e3a\u3010%5$s\u3011\uff0c\u5b58\u5728\u5dee\u5f02\u3002", (String)"CalcDataCheckAction_34", (String)"macc-sca-mservice", (Object[])new Object[0]), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("calcAmount")), this.getBigDecimalStr(row.getBigDecimal("absobAmount")), this.getBigDecimalStr(row.getBigDecimal("adjuestAmount")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        return 1;
    }

    public int unAbsorbCalcCheck() {
        String totalSelect = "entryentity.costobject as costobject,entryentity.allocamt as totalAmount,0.0 absoubAmount,0.0 unAbsoubAmount";
        QFilter totalFeeFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        totalFeeFilter.and("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId());
        totalFeeFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        if (!CadEmptyUtils.isEmpty((Set)this.getContext().getInputArgs().getManuOrgIds())) {
            totalFeeFilter.and("entryentity.costobject.manuorg", "in", (Object)this.getContext().getInputArgs().getManuOrgIds());
        }
        if (!CadEmptyUtils.isEmpty((List)this.getContext().getInputArgs().getCostCenterIds())) {
            totalFeeFilter.and("entryentity.costobject.costcenter", "in", (Object)this.getContext().getInputArgs().getCostCenterIds());
        }
        totalFeeFilter.and("allocstatus", "=", (Object)"2");
        totalFeeFilter.and("entryentity.costobject.isactfeenocal", "=", (Object)"0");
        DataSet totalDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadTotalMfgFeeal"), (String)"cad_mfgfeeallocco", (String)totalSelect, (QFilter[])totalFeeFilter.toArray(), null);
        String absorbSelect = "entryentity.obj as costobject,0.0 totalAmount,entryentity.pdcurramount as absoubAmount,0.0 unAbsoubAmount";
        QFilter absobFeeFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        absobFeeFilter.and("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId());
        absobFeeFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        if (!CadEmptyUtils.isEmpty((Set)this.getContext().getInputArgs().getManuOrgIds())) {
            absobFeeFilter.and("entryentity.obj.manuorg", "in", (Object)this.getContext().getInputArgs().getManuOrgIds());
        }
        if (!CadEmptyUtils.isEmpty((List)this.getContext().getInputArgs().getCostCenterIds())) {
            absobFeeFilter.and("entryentity.obj.costcenter", "in", (Object)this.getContext().getInputArgs().getCostCenterIds());
        }
        absobFeeFilter.and("entryentity.caltype", "in", (Object)new String[]{"2", "4"});
        absobFeeFilter.and("entryentity.datatype", "in", (Object)"3");
        absobFeeFilter.and("entryentity.pdcurramount", "!=", (Object)BigDecimal.ZERO);
        DataSet absorbDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadSubElementMfgFeeal"), (String)"sca_calcresult", (String)absorbSelect, (QFilter[])absobFeeFilter.toArray(), null);
        String unAbsorbSelect = "unabsorbentry.mfgobj as costobject,0.0 totalAmount,0.0 absoubAmount,unabsorbentry.mfgpdcurramt as unAbsoubAmount";
        QFilter unAbsoubFeeFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        unAbsoubFeeFilter.and("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId());
        unAbsoubFeeFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        if (!CadEmptyUtils.isEmpty((Set)this.getContext().getInputArgs().getManuOrgIds())) {
            unAbsoubFeeFilter.and("unabsorbentry.mfgobj.manuorg", "in", (Object)this.getContext().getInputArgs().getManuOrgIds());
        }
        if (!CadEmptyUtils.isEmpty((List)this.getContext().getInputArgs().getCostCenterIds())) {
            unAbsoubFeeFilter.and("unabsorbentry.mfgobj.costcenter", "in", (Object)this.getContext().getInputArgs().getCostCenterIds());
        }
        unAbsoubFeeFilter.and("unabsorbentry.mfgtype", "=", (Object)"5");
        unAbsoubFeeFilter.and("unabsorbentry.mfgpdcurramt", "!=", (Object)BigDecimal.ZERO);
        DataSet unAbsorbDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadSubElementUnAbsorb"), (String)"sca_calcresult", (String)unAbsorbSelect, (QFilter[])unAbsoubFeeFilter.toArray(), null);
        DataSet resultDs = totalDataSet.union(new DataSet[]{absorbDataSet, unAbsorbDataSet});
        DataSet compareDs = resultDs.groupBy(new String[]{"costobject"}).sum("totalAmount").sum("absoubAmount").sum("unAbsoubAmount").finish();
        compareDs = compareDs.select("costobject,case when totalAmount is null then 0.0 else totalAmount end totalAmount,case when absoubAmount is null then 0.0 else absoubAmount end absoubAmount,case when unAbsoubAmount is null then 0.0 else unAbsoubAmount end unAbsoubAmount");
        compareDs = compareDs.filter("totalAmount-absoubAmount-unAbsoubAmount!=0");
        if (compareDs.isEmpty()) {
            logger.info("unAbsorbCalcCheck-nodiff");
            return 0;
        }
        logger.info("unAbsorbCalcCheck-hasdiff");
        Set costobjectIds = ScaCalcHelper.getLongIdSetFromDs((DataSet)compareDs, (String)"costobject", (boolean)false);
        totalSelect = "entryentity.costobject.costcenter costcenter,entryentity.costobject as costobject,subelement,entryentity.allocamt as totalAmount,0.0 absoubAmount,0.0 unAbsoubAmount";
        totalFeeFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        totalFeeFilter.and("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId());
        totalFeeFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        totalFeeFilter.and("entryentity.costobject", "in", (Object)costobjectIds);
        totalFeeFilter.and("allocstatus", "=", (Object)"2");
        totalFeeFilter.and("entryentity.costobject.isactfeenocal", "=", (Object)"0");
        totalDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadTotalMfgFeeal"), (String)"cad_mfgfeeallocco", (String)totalSelect, (QFilter[])totalFeeFilter.toArray(), null);
        absorbSelect = "entryentity.obj.costcenter costcenter,entryentity.obj as costobject,entryentity.subelement as subelement,0.0 totalAmount,entryentity.pdcurramount as absoubAmount,0.0 unAbsoubAmount";
        absobFeeFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        absobFeeFilter.and("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId());
        absobFeeFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        absobFeeFilter.and("costobject", "in", (Object)costobjectIds);
        absobFeeFilter.and("entryentity.caltype", "in", (Object)new String[]{"2", "4"});
        absobFeeFilter.and("entryentity.datatype", "in", (Object)"3");
        absobFeeFilter.and("entryentity.pdcurramount", "!=", (Object)BigDecimal.ZERO);
        absorbDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadSubElementMfgFeeal"), (String)"sca_calcresult", (String)absorbSelect, (QFilter[])absobFeeFilter.toArray(), null);
        unAbsorbSelect = "unabsorbentry.mfgobj.costcenter costcenter,unabsorbentry.mfgobj as costobject,unabsorbentry.mfgsubelement as subelement,0.0 totalAmount,0.0 absoubAmount,unabsorbentry.mfgpdcurramt as unAbsoubAmount";
        unAbsoubFeeFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        unAbsoubFeeFilter.and("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId());
        unAbsoubFeeFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        unAbsoubFeeFilter.and("costobject", "in", (Object)costobjectIds);
        unAbsoubFeeFilter.and("unabsorbentry.mfgtype", "=", (Object)"1");
        unAbsoubFeeFilter.and("unabsorbentry.mfgpdcurramt", "!=", (Object)BigDecimal.ZERO);
        unAbsorbDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadSubElementUnAbsorb"), (String)"sca_calcresult", (String)unAbsorbSelect, (QFilter[])unAbsoubFeeFilter.toArray(), null);
        resultDs = totalDataSet.union(new DataSet[]{absorbDataSet, unAbsorbDataSet});
        compareDs = resultDs.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("totalAmount").sum("absoubAmount").sum("unAbsoubAmount").finish();
        compareDs = compareDs.select("costcenter,costobject,subelement,case when totalAmount is null then 0.0 else totalAmount end totalAmount,case when absoubAmount is null then 0.0 else absoubAmount end absoubAmount,case when unAbsoubAmount is null then 0.0 else unAbsoubAmount end unAbsoubAmount");
        compareDs = compareDs.filter("totalAmount-absoubAmount-unAbsoubAmount!=0");
        if (compareDs.isEmpty()) {
            return 0;
        }
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u201c\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u8d39\u7528-\u5438\u6536\u8d39\u7528=\u672a\u5438\u6536\u8d39\u7528\u201d", (String)"CalcDataCheckAction_35", (String)"macc-sca-mservice", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u201c\u672c\u671f\u5b9e\u9645\u5236\u9020\u8d39\u7528-\u5438\u6536\u8d39\u7528=\u672c\u671f\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u201d\u5b58\u5728\u5dee\u5f02\u3002", (String)"CalcDataCheckAction_36", (String)"macc-sca-mservice", (Object[])new Object[0]);
        long itemId = this.getItemId(curItem, detail);
        compareDs = this.relaSubElementData(compareDs);
        compareDs = compareDs.orderBy(new String[]{"costcenter", "costobject", "subelementNo"});
        DynamicObject checkDetail = this.createCheckDetailDyn(itemId, curItem);
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("costobject", (Object)row.getLong("costobject"));
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u3010%1$s/%2$s\u3011\u4e0d\u6ee1\u8db3\u201c\u672c\u671f\u5b9e\u9645\u5236\u9020\u8d39\u7528\u3010%3$s\u3011-\u5438\u6536\u8d39\u7528\u3010%4$s\u3011=\u672c\u671f\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u3010%5$s\u3011\u201d\u3002", (String)"CalcDataCheckAction_37", (String)"macc-sca-mservice", (Object[])new Object[0]), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("totalAmount")), this.getBigDecimalStr(row.getBigDecimal("absoubAmount")), this.getBigDecimalStr(row.getBigDecimal("unAbsoubAmount")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        return 1;
    }

    public int unAbsorbPrePeriodComCurPeriodCheck() {
        String unAbsorbSelect = "unabsorbentry.mfgobj costobject,0.0 as endamt,unabsorbentry.mfgpdstartamt startamt";
        QFilter qFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        qFilter.and("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId());
        if (!CadEmptyUtils.isEmpty((Set)this.getContext().getInputArgs().getManuOrgIds())) {
            qFilter.and("unabsorbentry.mfgobj.manuorg", "in", (Object)this.getContext().getInputArgs().getManuOrgIds());
        }
        if (!CadEmptyUtils.isEmpty((List)this.getContext().getInputArgs().getCostCenterIds())) {
            qFilter.and("unabsorbentry.mfgobj.costcenter", "in", (Object)this.getContext().getInputArgs().getCostCenterIds());
        }
        qFilter.and("unabsorbentry.mfgtype", "=", (Object)"5");
        DataSet unAbsorbDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadSubElementMfgFeeal"), (String)"sca_calcresult", (String)unAbsorbSelect, (QFilter[])new QFilter[]{qFilter, new QFilter("period", "=", (Object)this.getContext().getInputArgs().getPeriodId()), new QFilter("unabsorbentry.mfgpdstartamt", "!=", (Object)BigDecimal.ZERO)}, null);
        unAbsorbSelect = "unabsorbentry.mfgobj costobject,unabsorbentry.mfgpdendamt as endamt,0.0 startamt";
        DataSet unEndAbsorbDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadSubElementMfgFeeal"), (String)"sca_calcresult", (String)unAbsorbSelect, (QFilter[])new QFilter[]{qFilter, new QFilter("period", "=", (Object)this.getContext().getInputArgs().getPrePeriodId()), new QFilter("unabsorbentry.mfgpdendamt", "!=", (Object)BigDecimal.ZERO)}, null);
        DataSet resultDs = unAbsorbDataSet.union(unEndAbsorbDataSet);
        DataSet compareDs = resultDs.groupBy(new String[]{"costobject"}).sum("endamt").sum("startamt").finish();
        compareDs = compareDs.select("costobject,case when endamt is null then 0.0 else endamt end endamt,case when startamt is null then 0.0 else startamt end startamt");
        compareDs = compareDs.filter("startamt-endamt!=0");
        if (compareDs.isEmpty()) {
            logger.info("unAbsorbPrePeriodComCurPeriodCheck-nodiff");
            return 0;
        }
        logger.info("unAbsorbPrePeriodComCurPeriodCheck-hasdiff");
        Set costobjectIds = ScaCalcHelper.getLongIdSetFromDs((DataSet)compareDs, (String)"costobject", (boolean)false);
        unAbsorbSelect = "unabsorbentry.mfgobj.costcenter costcenter,unabsorbentry.mfgobj costobject,unabsorbentry.mfgsubelement as subelement,0.0 as endamt,unabsorbentry.mfgpdstartamt startamt";
        qFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        qFilter.and("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId());
        qFilter.and("costobject", "in", (Object)costobjectIds);
        qFilter.and("unabsorbentry.mfgtype", "=", (Object)"1");
        unAbsorbDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadSubElementMfgFeeal"), (String)"sca_calcresult", (String)unAbsorbSelect, (QFilter[])new QFilter[]{qFilter, new QFilter("period", "=", (Object)this.getContext().getInputArgs().getPeriodId()), new QFilter("unabsorbentry.mfgpdstartamt", "!=", (Object)BigDecimal.ZERO)}, null);
        unAbsorbSelect = "unabsorbentry.mfgobj.costcenter costcenter,unabsorbentry.mfgobj costobject,unabsorbentry.mfgsubelement as subelement,unabsorbentry.mfgpdendamt as endamt,0.0 startamt";
        unEndAbsorbDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadSubElementMfgFeeal"), (String)"sca_calcresult", (String)unAbsorbSelect, (QFilter[])new QFilter[]{qFilter, new QFilter("period", "=", (Object)this.getContext().getInputArgs().getPrePeriodId()), new QFilter("unabsorbentry.mfgpdendamt", "!=", (Object)BigDecimal.ZERO)}, null);
        resultDs = unAbsorbDataSet.union(unEndAbsorbDataSet);
        compareDs = resultDs.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("endamt").sum("startamt").finish();
        compareDs = compareDs.select("costcenter,costobject,subelement,case when endamt is null then 0.0 else endamt end endamt,case when startamt is null then 0.0 else startamt end startamt");
        compareDs = compareDs.filter("startamt-endamt!=0");
        if (compareDs.isEmpty()) {
            return 0;
        }
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u671f\u521d\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u4e0e\u4e0a\u671f\u671f\u672b\u5728\u4ea7\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u662f\u5426\u4e00\u81f4\u3002", (String)"CalcDataCheckAction_38", (String)"macc-sca-mservice", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u671f\u521d\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u4e0e\u4e0a\u671f\u671f\u672b\u5728\u4ea7\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u5b58\u5728\u5dee\u5f02\u3002", (String)"CalcDataCheckAction_39", (String)"macc-sca-mservice", (Object[])new Object[0]);
        long itemId = this.getItemId(curItem, detail);
        compareDs = this.relaSubElementData(compareDs);
        compareDs = compareDs.orderBy(new String[]{"costcenter", "costobject", "subelementNo"});
        DynamicObject checkDetail = this.createCheckDetailDyn(itemId, curItem);
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("costobject", (Object)row.getLong("costobject"));
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u3010%1$s/%2$s\u3011\u671f\u521d\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u4e3a\u3010%3$s\u3011\uff0c\u4e0a\u671f\u671f\u672b\u5728\u4ea7\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u4e3a\u3010%4$s\u3011\u5b58\u5728\u5dee\u5f02\u3002", (String)"CalcDataCheckAction_40", (String)"macc-sca-mservice", (Object[])new Object[0]), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("startamt")), this.getBigDecimalStr(row.getBigDecimal("endamt")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        return 1;
    }

    public int unAbsorbBillCheck() {
        String unAbsorbSelect = "costobject,0.0 calcAmount,entryentity.amount as unAbsoubAmount";
        QFilter unAbsoubFeeFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        unAbsoubFeeFilter.and("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId());
        unAbsoubFeeFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        if (!CadEmptyUtils.isEmpty((Set)this.getContext().getInputArgs().getManuOrgIds())) {
            unAbsoubFeeFilter.and("costobject.manuorg", "in", (Object)this.getContext().getInputArgs().getManuOrgIds());
        }
        if (!CadEmptyUtils.isEmpty((List)this.getContext().getInputArgs().getCostCenterIds())) {
            unAbsoubFeeFilter.and("costobject.costcenter", "in", (Object)this.getContext().getInputArgs().getCostCenterIds());
        }
        unAbsoubFeeFilter.and("difftype", "=", (Object)"4");
        DataSet unAbsorbDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadSubElementUnAbsorb"), (String)"sca_unabsorbdiff", (String)unAbsorbSelect, (QFilter[])unAbsoubFeeFilter.toArray(), null);
        String unAbsorbCalcSelect = "unabsorbentry.mfgobj costobject,unabsorbentry.mfgpddiffamt as calcAmount,0.0 as unAbsoubAmount";
        QFilter qFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        qFilter.and("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId());
        qFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        if (!CadEmptyUtils.isEmpty((Set)this.getContext().getInputArgs().getManuOrgIds())) {
            unAbsoubFeeFilter.and("costobject.manuorg", "in", (Object)this.getContext().getInputArgs().getManuOrgIds());
        }
        if (!CadEmptyUtils.isEmpty((List)this.getContext().getInputArgs().getCostCenterIds())) {
            unAbsoubFeeFilter.and("costobject.costcenter", "in", (Object)this.getContext().getInputArgs().getCostCenterIds());
        }
        qFilter.and("unabsorbentry.mfgtype", "=", (Object)"5");
        qFilter.and("unabsorbentry.mfgpddiffamt", "!=", (Object)BigDecimal.ZERO);
        DataSet unAbsorbCalcDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadSubElementMfgFeeal"), (String)"sca_calcresult", (String)unAbsorbCalcSelect, (QFilter[])qFilter.toArray(), null);
        DataSet resultDs = unAbsorbDataSet.union(unAbsorbCalcDataSet);
        DataSet compareDs = resultDs.groupBy(new String[]{"costobject"}).sum("calcAmount").sum("unAbsoubAmount").finish();
        compareDs = compareDs.select("costobject,case when calcAmount is null then 0.0 else calcAmount end calcAmount,case when unAbsoubAmount is null then 0.0 else unAbsoubAmount end unAbsoubAmount");
        compareDs = compareDs.filter("calcAmount-unAbsoubAmount!=0");
        if (compareDs.isEmpty()) {
            logger.info("unAbsorbBillCheck-nodiff");
            return 0;
        }
        logger.info("unAbsorbBillCheck-hasdiff");
        Set costobjectIds = ScaCalcHelper.getLongIdSetFromDs((DataSet)compareDs, (String)"costobject", (boolean)false);
        unAbsorbSelect = "costobject.costcenter costcenter,costobject,entryentity.subelement as subelement,0.0 calcAmount,entryentity.amount as unAbsoubAmount";
        unAbsoubFeeFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        unAbsoubFeeFilter.and("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId());
        unAbsoubFeeFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        unAbsoubFeeFilter.and("costobject", "in", (Object)costobjectIds);
        unAbsoubFeeFilter.and("difftype", "=", (Object)"4");
        unAbsorbDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadSubElementUnAbsorb"), (String)"sca_unabsorbdiff", (String)unAbsorbSelect, (QFilter[])unAbsoubFeeFilter.toArray(), null);
        unAbsorbCalcSelect = "unabsorbentry.mfgobj.costcenter costcenter,unabsorbentry.mfgobj costobject,unabsorbentry.mfgsubelement as subelement,unabsorbentry.mfgpddiffamt as calcAmount,0.0 as unAbsoubAmount";
        qFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        qFilter.and("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId());
        qFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        qFilter.and("unabsorbentry.mfgobj", "in", (Object)costobjectIds);
        qFilter.and("unabsorbentry.mfgtype", "=", (Object)"1");
        qFilter.and("unabsorbentry.mfgpddiffamt", "!=", (Object)BigDecimal.ZERO);
        unAbsorbCalcDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadSubElementMfgFeeal"), (String)"sca_calcresult", (String)unAbsorbCalcSelect, (QFilter[])qFilter.toArray(), null);
        resultDs = unAbsorbDataSet.union(unAbsorbCalcDataSet);
        compareDs = resultDs.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("calcAmount").sum("unAbsoubAmount").finish();
        compareDs = compareDs.select("costcenter,costobject,subelement,case when calcAmount is null then 0.0 else calcAmount end calcAmount,case when unAbsoubAmount is null then 0.0 else unAbsoubAmount end unAbsoubAmount");
        compareDs = compareDs.filter("calcAmount-unAbsoubAmount!=0");
        if (compareDs.isEmpty()) {
            return 0;
        }
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u751f\u6210\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u5355\u91d1\u989d\u6b63\u786e\u3002", (String)"CalcDataCheckAction_41", (String)"macc-sca-mservice", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u5355\u91d1\u989d\u4e0e\u8ba1\u7b97\u7ed3\u679c\u5355\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\uff0c\u5b58\u5728\u5dee\u5f02\u3002", (String)"CalcDataCheckAction_42", (String)"macc-sca-mservice", (Object[])new Object[0]);
        long itemId = this.getItemId(curItem, detail);
        compareDs = this.relaSubElementData(compareDs);
        compareDs = compareDs.orderBy(new String[]{"costcenter", "costobject", "subelementNo"});
        DynamicObject checkDetail = this.createCheckDetailDyn(itemId, curItem);
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("costobject", (Object)row.getLong("costobject"));
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u5355\u3010%1$s/%2$s\u3011\u4e3a\u3010%3$s\u3011\uff0c\u8ba1\u7b97\u7ed3\u679c\u5355\u4e3a\u3010%4$s\u3011\uff0c\u4e0d\u76f8\u7b49\u3002", (String)"CalcDataCheckAction_43", (String)"macc-sca-mservice", (Object[])new Object[0]), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("calcAmount")), this.getBigDecimalStr(row.getBigDecimal("unAbsoubAmount")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        return 1;
    }

    public int unAbsorbCalcDataCheck() {
        String unAbsorbSelect = "bizstatus,costobject,unabsorbentry.mfgpdstartamt startamt,unabsorbentry.mfgpdcurramt currentamt,unabsorbentry.mfgpdendamt as endamt,unabsorbentry.mfgpddiffamt diffamt";
        QFilter qFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        qFilter.and("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId());
        qFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        if (!CadEmptyUtils.isEmpty((Set)this.getContext().getInputArgs().getManuOrgIds())) {
            qFilter.and("costobject.manuorg", "in", (Object)this.getContext().getInputArgs().getManuOrgIds());
        }
        if (!CadEmptyUtils.isEmpty((List)this.getContext().getInputArgs().getCostCenterIds())) {
            qFilter.and("costobject.costcenter", "in", (Object)this.getContext().getInputArgs().getCostCenterIds());
        }
        qFilter.and("unabsorbentry.mfgtype", "=", (Object)"5");
        DataSet unAbsorbDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadSubElementMfgFeeal"), (String)"sca_calcresult", (String)unAbsorbSelect, (QFilter[])qFilter.toArray(), null);
        DataSet compareDs = unAbsorbDataSet.groupBy(new String[]{"bizstatus", "costobject"}).sum("startamt").sum("currentamt").sum("endamt").sum("diffamt").finish();
        compareDs = compareDs.select("bizstatus,costobject,case when startamt is null then 0.0 else startamt end startamt,case when currentamt is null then 0.0 else currentamt end currentamt,case when endamt is null then 0.0 else endamt end endamt,case when diffamt is null then 0.0 else diffamt end diffamt");
        DataSet compareDs1 = compareDs.filter("bizstatus='A' and (startamt+currentamt-endamt-diffamt)<>0");
        DataSet compareDs0 = compareDs.filter("bizstatus='B' and (startamt+currentamt-diffamt)<>0");
        compareDs = compareDs1.union(compareDs0);
        if (compareDs.isEmpty()) {
            logger.info("unAbsorbCalcDataCheck-nodiff");
            return 0;
        }
        logger.info("unAbsorbCalcDataCheck-hasdiff");
        Set costobjectIds = ScaCalcHelper.getLongIdSetFromDs((DataSet)compareDs, (String)"costobject", (boolean)false);
        unAbsorbSelect = "bizstatus,costobject.costcenter costcenter,costobject,unabsorbentry.mfgsubelement as subelement,unabsorbentry.mfgpdstartamt startamt,unabsorbentry.mfgpdcurramt currentamt,unabsorbentry.mfgpdendamt as endamt,unabsorbentry.mfgpddiffamt diffamt";
        qFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        qFilter.and("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId());
        qFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        qFilter.and("costobject", "in", (Object)costobjectIds);
        qFilter.and("unabsorbentry.mfgtype", "=", (Object)"1");
        unAbsorbDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadSubElementMfgFeeal"), (String)"sca_calcresult", (String)unAbsorbSelect, (QFilter[])qFilter.toArray(), null);
        compareDs = unAbsorbDataSet.groupBy(new String[]{"bizstatus", "costcenter", "costobject", "subelement"}).sum("startamt").sum("currentamt").sum("endamt").sum("diffamt").finish();
        compareDs = compareDs.select("bizstatus,costcenter,costobject,subelement,case when startamt is null then 0.0 else startamt end startamt,case when currentamt is null then 0.0 else currentamt end currentamt,case when endamt is null then 0.0 else endamt end endamt,case when diffamt is null then 0.0 else diffamt end diffamt");
        compareDs1 = compareDs.filter("bizstatus='A' and (startamt+currentamt-endamt-diffamt)<>0");
        compareDs0 = compareDs.filter("bizstatus='B' and (startamt+currentamt-diffamt)<>0");
        compareDs = compareDs1.union(compareDs0);
        if (compareDs.isEmpty()) {
            return 0;
        }
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u201c\u671f\u521d+\u672c\u671f\u672a\u5438\u6536=\u671f\u672b\u5728\u4ea7+\u672c\u671f\u5dee\u5f02\u8f6c\u51fa\u201d", (String)"CalcDataCheckAction_20", (String)"macc-sca-mservice", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u671f\u521d+\u672c\u671f\u672a\u5438\u6536=\u671f\u672b\u5728\u4ea7+\u672c\u671f\u5dee\u5f02\u8f6c\u51fa\u201d\u5b58\u5728\u5dee\u5f02\u3002", (String)"CalcDataCheckAction_44", (String)"macc-sca-mservice", (Object[])new Object[0]);
        long itemId = this.getItemId(curItem, detail);
        compareDs = this.relaSubElementData(compareDs);
        compareDs = compareDs.orderBy(new String[]{"costcenter", "costobject", "subelementNo"});
        DynamicObject checkDetail = this.createCheckDetailDyn(itemId, curItem);
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("costobject", (Object)row.getLong("costobject"));
            String bizstatus = row.getString("bizstatus");
            if ("A".equals(bizstatus)) {
                newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u3010%1$s/%2$s\u3011\u4e0d\u6ee1\u8db3\u201c\u671f\u521d\u3010%3$s\u3011+\u672c\u671f\u672a\u5438\u6536\u3010%4$s\u3011=\u671f\u672b\u5728\u4ea7\u3010%5$s\u3011+\u672c\u671f\u5dee\u5f02\u8f6c\u51fa\u3010%6$s\u3011\u201d\u3002", (String)"CalcDataCheckAction_45", (String)"macc-sca-mservice", (Object[])new Object[0]), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("startamt")), this.getBigDecimalStr(row.getBigDecimal("currentamt")), this.getBigDecimalStr(row.getBigDecimal("endamt")), this.getBigDecimalStr(row.getBigDecimal("diffamt")))));
            } else {
                newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u3010%1$s/%2$s\u3011\u4e0d\u6ee1\u8db3\u201c\u671f\u521d\u3010%3$s\u3011+\u672c\u671f\u672a\u5438\u6536\u3010%4$s\u3011=\u672c\u671f\u5dee\u5f02\u8f6c\u51fa\u3010%5$s\u3011\u201d\u3002", (String)"CalcDataCheckAction_46", (String)"macc-sca-mservice", (Object[])new Object[0]), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("startamt")), this.getBigDecimalStr(row.getBigDecimal("currentamt")), this.getBigDecimalStr(row.getBigDecimal("diffamt")))));
            }
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        return 1;
    }

    public int finshDiffDataCheck() {
        ArrayList costobjectInIds = new ArrayList(this.getContext().getInputArgs().getCostObjectIds());
        QFilter resultFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        resultFilter.and(new QFilter("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId()));
        resultFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        resultFilter.and("entryentity.datatype", "in", (Object)new String[]{"98", "99"});
        String reaultSelectFields = "costobject,entryentity.pdstartamount as pdstartamount,entryentity.pdcurramount as pdcurramount,entryentity.pdcompanount as pdcompanount,entryentity.pdendamount as pdendamount,entryentity.diff as diffAmount";
        DataSet calcResultDs = InFilterHelper.queryDataSetIn((String)"sca_calcresult", (String)reaultSelectFields, (QFilter)resultFilter, (String)"costobject", costobjectInIds);
        DataSet compareDs = calcResultDs.groupBy(new String[]{"costobject"}).sum("pdstartamount").sum("pdcurramount").sum("pdcompanount").sum("pdendamount").sum("diffAmount").finish();
        compareDs = compareDs.select("costobject,case when pdstartamount is null then 0.0 else pdstartamount end pdstartamount,case when pdcurramount is null then 0.0 else pdcurramount end pdcurramount,case when pdcompanount is null then 0.0 else pdcompanount end pdcompanount,case when pdendamount is null then 0.0 else pdendamount end pdendamount,case when diffAmount is null then 0.0 else diffAmount end diffAmount");
        compareDs = this.getContext().getTaskType().getValue() != CalcTaskType.PeriodEndCalc.getValue() ? compareDs.filter("pdstartamount+pdcurramount-pdcompanount-diffAmount!=0") : compareDs.filter("pdstartamount+pdcurramount-pdcompanount-diffAmount-pdendamount!=0");
        if (compareDs.isEmpty()) {
            logger.info("finshDiffDataCheck-nodiff");
            return 0;
        }
        logger.info("finshDiffDataCheck-hasdiff");
        Set costobjectIds = ScaCalcHelper.getLongIdSetFromDs((DataSet)compareDs, (String)"costobject", (boolean)false);
        resultFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        resultFilter.and(new QFilter("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId()));
        resultFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        resultFilter.and("costobject", "in", (Object)costobjectIds);
        resultFilter.and("entryentity.caltype", "!=", (Object)"5");
        resultFilter.and("entryentity.datatype", "in", (Object)new String[]{"2"});
        reaultSelectFields = "costobject.costcenter costcenter,costobject,entryentity.subelement as subelement,entryentity.pdstartamount as pdstartamount,entryentity.pdcurramount as pdcurramount,entryentity.pdcompanount as pdcompanount,entryentity.pdendamount as pdendamount,entryentity.diff as diffAmount";
        calcResultDs = QueryServiceHelper.queryDataSet((String)"queryCalResult", (String)"sca_calcresult", (String)reaultSelectFields, (QFilter[])resultFilter.toArray(), (String)"");
        compareDs = calcResultDs.groupBy(new String[]{"costcenter", "costobject", "subelement"}).sum("pdstartamount").sum("pdcurramount").sum("pdcompanount").sum("pdendamount").sum("diffAmount").finish();
        compareDs = compareDs.select("costcenter,costobject,subelement,case when pdstartamount is null then 0.0 else pdstartamount end pdstartamount,case when pdcurramount is null then 0.0 else pdcurramount end pdcurramount,case when pdcompanount is null then 0.0 else pdcompanount end pdcompanount,case when pdendamount is null then 0.0 else pdendamount end pdendamount,case when diffAmount is null then 0.0 else diffAmount end diffAmount");
        compareDs = this.getContext().getTaskType().getValue() != CalcTaskType.PeriodEndCalc.getValue() ? compareDs.filter("pdstartamount+pdcurramount-pdcompanount-diffAmount!=0") : compareDs.filter("pdstartamount+pdcurramount-pdcompanount-diffAmount-pdendamount!=0");
        if (compareDs.isEmpty()) {
            return 0;
        }
        String curItem = "";
        curItem = this.getContext().getTaskType().getValue() != CalcTaskType.PeriodEndCalc.getValue() ? ResManager.loadKDString((String)"\u68c0\u67e5\u201c\u671f\u521d\u5728\u4ea7\u54c1\u91d1\u989d+\u672c\u671f\u6295\u5165\u91d1\u989d-\u672c\u671f\u5b8c\u5de5\u91d1\u989d=\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u91d1\u989d\u201d", (String)"CalcDataCheckAction_16", (String)"macc-sca-mservice", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u68c0\u67e5\u201c\u671f\u521d\u5728\u4ea7\u54c1+\u672c\u671f\u6295\u5165=\u672c\u671f\u5b8c\u5de5+\u671f\u672b\u5728\u4ea7\u54c1/\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u201d", (String)"CalcDataCheckAction_47", (String)"macc-sca-mservice", (Object[])new Object[0]);
        String detail = "";
        detail = this.getContext().getTaskType().getValue() != CalcTaskType.PeriodEndCalc.getValue() ? ResManager.loadKDString((String)"\u201c\u671f\u521d\u5728\u4ea7\u54c1+\u672c\u671f\u6295\u5165=\u672c\u671f\u5b8c\u5de5+\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u201d\u5b58\u5728\u5dee\u5f02\u3002", (String)"CalcDataCheckAction_48", (String)"macc-sca-mservice", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u201c\u671f\u521d\u5728\u4ea7\u54c1+\u672c\u671f\u6295\u5165=\u672c\u671f\u5b8c\u5de5+\u671f\u672b\u5728\u4ea7\u54c1/\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u201d\u5b58\u5728\u5dee\u5f02\u3002", (String)"CalcDataCheckAction_49", (String)"macc-sca-mservice", (Object[])new Object[0]);
        long itemId = this.getItemId(curItem, detail);
        compareDs = this.relaSubElementData(compareDs);
        compareDs = compareDs.orderBy(new String[]{"costcenter", "costobject", "subelementNo"});
        DynamicObject checkDetail = this.createCheckDetailDyn(itemId, curItem);
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("costobject", (Object)row.getLong("costobject"));
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u3010%1$s/%2$s\u3011\u4e0d\u6ee1\u8db3\u201c\u671f\u521d\u5728\u4ea7\u54c1\u3010%3$s\u3011+\u672c\u671f\u6295\u5165\u3010%4$s\u3011=\u672c\u671f\u5b8c\u5de5\u3010%5$s\u3011+\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u3010%6$s\u3011+\u671f\u672b\u5728\u4ea7\u3010%7$s\u3011\u201d\u3002", (String)"CalcDataCheckAction_50", (String)"macc-sca-mservice", (Object[])new Object[0]), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("pdstartamount")), this.getBigDecimalStr(row.getBigDecimal("pdcurramount")), this.getBigDecimalStr(row.getBigDecimal("pdcompanount")), this.getBigDecimalStr(row.getBigDecimal("diffAmount")), this.getBigDecimalStr(row.getBigDecimal("pdendamount")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        return 1;
    }

    public int finshDiffCheck(Set<Long> calcMainJoinSideCostObjectSet) {
        ArrayList<Long> costobjectInIds = new ArrayList<Long>(calcMainJoinSideCostObjectSet);
        String selectFields = "costobject,0.0 calcAmount,entryentity.amount diffAmount";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("period", "in", (Object)this.getContext().getInputArgs().getPeriodId()));
        filters.add(new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId()));
        filters.add(new QFilter("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId()));
        DataSet costDiffDs = InFilterHelper.queryDataSetIn((String)"sca_finishdiffbill", (String)selectFields, (QFilter)this.getQFilterToArr(filters.toArray(new QFilter[0])), (String)"costobject", costobjectInIds);
        costobjectInIds = new ArrayList(this.getContext().getInputArgs().getCostObjectIds());
        QFilter resultFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        resultFilter.and(new QFilter("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId()));
        resultFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        resultFilter.and("entryentity.datatype", "in", (Object)new String[]{"98", "99"});
        resultFilter.and("entryentity.diff", "!=", (Object)BigDecimal.ZERO);
        String reaultSelectFields = "entryentity.obj costobject,entryentity.diff as calcAmount,0.0 diffAmount";
        DataSet calcResultDs = InFilterHelper.queryDataSetIn((String)"sca_calcresult", (String)reaultSelectFields, (QFilter)resultFilter, (String)"costobject", costobjectInIds);
        DataSet resultDs = costDiffDs.union(calcResultDs);
        DataSet compareDs = resultDs.groupBy(new String[]{"costobject"}).sum("calcAmount").sum("diffAmount").finish();
        compareDs = compareDs.select("costobject,case when calcAmount is null then 0.0 else calcAmount end calcAmount,case when diffAmount is null then 0.0 else diffAmount end diffAmount");
        compareDs = compareDs.filter("calcAmount-diffAmount!=0");
        if (compareDs.isEmpty()) {
            logger.info("finshDiffCheck-nodiff");
            return 0;
        }
        logger.info("finshDiffCheck-hasdiff");
        Set costobjectIds = ScaCalcHelper.getLongIdSetFromDs((DataSet)compareDs, (String)"costobject", (boolean)false);
        selectFields = "costobject.costcenter costcenter,costobject,entryentity.difftype as difftype,entryentity.subelement as subelement,0.0 calcAmount,entryentity.amount diffAmount";
        filters = new ArrayList();
        filters.add(new QFilter("period", "in", (Object)this.getContext().getInputArgs().getPeriodId()));
        filters.add(new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId()));
        filters.add(new QFilter("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId()));
        filters.add(new QFilter("costobject", "in", (Object)costobjectIds));
        costDiffDs = QueryServiceHelper.queryDataSet((String)"CostAbsorbAdjust", (String)"sca_finishdiffbill", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        resultFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        resultFilter.and(new QFilter("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId()));
        resultFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        resultFilter.and("entryentity.obj", "in", (Object)costobjectIds);
        resultFilter.and("entryentity.datatype", "in", (Object)new String[]{"2"});
        resultFilter.and("entryentity.diff", "!=", (Object)BigDecimal.ZERO);
        reaultSelectFields = "entryentity.obj.costcenter costcenter,entryentity.obj costobject,entryentity.difftype as difftype,entryentity.subelement as subelement,entryentity.diff as calcAmount,0.0 diffAmount";
        calcResultDs = QueryServiceHelper.queryDataSet((String)"queryCalResult", (String)"sca_calcresult", (String)reaultSelectFields, (QFilter[])resultFilter.toArray(), (String)"");
        resultDs = costDiffDs.union(calcResultDs);
        compareDs = resultDs.groupBy(new String[]{"costcenter", "costobject", "difftype", "subelement"}).sum("calcAmount").sum("diffAmount").finish();
        compareDs = compareDs.select("costcenter,costobject,difftype,subelement,case when calcAmount is null then 0.0 else calcAmount end calcAmount,case when diffAmount is null then 0.0 else diffAmount end diffAmount");
        compareDs = compareDs.filter("calcAmount-diffAmount!=0");
        if (compareDs.isEmpty()) {
            return 0;
        }
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u751f\u6210\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355\u91d1\u989d\u6b63\u786e\u3002", (String)"CalcDataCheckAction_51", (String)"macc-sca-mservice", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355\u91d1\u989d\u4e0e\u8ba1\u7b97\u7ed3\u679c\u5355\u5206\u9879\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\uff0c\u5b58\u5728\u5dee\u5f02\u3002", (String)"CalcDataCheckAction_52", (String)"macc-sca-mservice", (Object[])new Object[0]);
        long itemId = this.getItemId(curItem, detail);
        compareDs = this.relaSubElementData(compareDs);
        compareDs = compareDs.orderBy(new String[]{"costcenter", "costobject", "subelementNo"});
        DynamicObject checkDetail = this.createCheckDetailDyn(itemId, curItem);
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            if (seq > 2000) break;
            DynamicObject newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)row.getLong("costcenter"));
            newEntry.set("costobject", (Object)row.getLong("costobject"));
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355\u3010%1$s\u3011\u3010%2$s/%3$s\u3011\u4e3a\u3010%4$s\u3011\uff0c\u8ba1\u7b97\u7ed3\u679c\u5355\u4e3a\u3010%5$s\u3011\uff0c\u4e0d\u76f8\u7b49\u3002", (String)"CalcDataCheckAction_53", (String)"macc-sca-mservice", (Object[])new Object[0]), this.getDiffType(row.getString("difftype")), row.getString("subelementNo"), row.getString("subelementName"), this.getBigDecimalStr(row.getBigDecimal("diffAmount")), this.getBigDecimalStr(row.getBigDecimal("calcAmount")))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        return 1;
    }

    public int subAndCompCheck() {
        ArrayList costobjectInIds = new ArrayList(this.getContext().getInputArgs().getCostObjectIds());
        QFilter resultFilter = new QFilter("org", "=", (Object)this.getContext().getInputArgs().getOrgId());
        resultFilter.and(new QFilter("costaccount", "=", (Object)this.getContext().getInputArgs().getCostAccountId()));
        resultFilter.and("period", "=", (Object)this.getContext().getInputArgs().getPeriodId());
        resultFilter.and("entryentity.caltype", "!=", (Object)"5");
        resultFilter.and("entryentity.datatype", "in", (Object)new String[]{"1", "2"});
        String reaultSelectFields = "entryentity.obj.costcenter costcenter,entryentity.obj costobject,entryentity.datatype datatype,entryentity.pdstartamount as pdstartamount,entryentity.pdcurramount as pdcurramount,entryentity.pdcompanount as pdcompanount,entryentity.pdendamount as pdendamount,entryentity.diff as diffAmount";
        DataSet calcResultDs = InFilterHelper.queryDataSetIn((String)"sca_calcresult", (String)reaultSelectFields, (QFilter)resultFilter, (String)"costobject", costobjectInIds);
        calcResultDs = calcResultDs.groupBy(new String[]{"costcenter", "costobject", "datatype"}).sum("pdstartamount").sum("pdcurramount").sum("pdcompanount").sum("pdendamount").sum("diffAmount").finish();
        DataSet subResultDs = calcResultDs.copy().filter("datatype='2'").select("costcenter,costobject,pdstartamount,pdcurramount,pdcompanount,pdendamount,diffAmount,0.0 as compdstartamount,0.0 as compdcurramount,0.0 as compdcompanount,0.0 as compdendamount,0.0 as comdiffAmount");
        DataSet compResultDs = calcResultDs.filter("datatype='1'").select("costcenter,costobject,0.0 as pdstartamount,0.0 as pdcurramount,0.0 as pdcompanount,0.0 as pdendamount,0.0 as diffAmount,pdstartamount as compdstartamount,pdcurramount as compdcurramount,pdcompanount as compdcompanount,pdendamount as compdendamount,diffAmount as comdiffAmount");
        DataSet compareDs = subResultDs.union(compResultDs);
        compareDs = compareDs.groupBy(new String[]{"costcenter", "costobject"}).sum("pdstartamount").sum("pdcurramount").sum("pdcompanount").sum("pdendamount").sum("diffAmount").sum("compdstartamount").sum("compdcurramount").sum("compdcompanount").sum("compdendamount").sum("comdiffAmount").finish();
        compareDs = compareDs.select("costcenter,costobject,case when pdstartamount is null then 0.0 else pdstartamount end pdstartamount,case when pdcurramount is null then 0.0 else pdcurramount end pdcurramount,case when pdcompanount is null then 0.0 else pdcompanount end pdcompanount,case when pdendamount is null then 0.0 else pdendamount end pdendamount,case when diffAmount is null then 0.0 else diffAmount end diffAmount,case when compdstartamount is null then 0.0 else compdstartamount end compdstartamount,case when compdcurramount is null then 0.0 else compdcurramount end compdcurramount,case when compdcompanount is null then 0.0 else compdcompanount end compdcompanount,case when compdendamount is null then 0.0 else compdendamount end compdendamount,case when comdiffAmount is null then 0.0 else comdiffAmount end comdiffAmount");
        compareDs = compareDs.filter("compdstartamount-pdstartamount!=0 or compdcurramount-pdcurramount!=0 or compdcompanount-pdcompanount!=0 or compdendamount-pdendamount!=0 or comdiffAmount-diffAmount!=0");
        if (compareDs.isEmpty()) {
            return 0;
        }
        String curItem = ResManager.loadKDString((String)"\u68c0\u67e5\u6210\u672c \u201c\u5206\u9879\u6210\u672c\u5408\u8ba1=\u7efc\u5408\u6210\u672c\u5408\u8ba1\u201d", (String)"CalcDataCheckAction_54", (String)"macc-sca-mservice", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u6210\u672c\u201c\u5206\u9879\u6210\u672c\u5408\u8ba1=\u7efc\u5408\u6210\u672c\u5408\u8ba1\u201d \u5b58\u5728\u5dee\u5f02\u3002", (String)"CalcDataCheckAction_55", (String)"macc-sca-mservice", (Object[])new Object[0]);
        long itemId = this.getItemId(curItem, detail);
        DynamicObject checkDetail = this.createCheckDetailDyn(itemId, curItem);
        DynamicObjectCollection entryList = checkDetail.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (Row row : compareDs) {
            DynamicObject newEntry;
            if (seq > 2000) break;
            Long costcenter = row.getLong("costcenter");
            Long costobject = row.getLong("costobject");
            BigDecimal compdstartamount = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal("compdstartamount"));
            BigDecimal compdcurramount = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal("compdcurramount"));
            BigDecimal compdcompanount = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal("compdcompanount"));
            BigDecimal compdendamount = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal("compdendamount"));
            BigDecimal comdiffAmount = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal("comdiffAmount"));
            BigDecimal pdstartamount = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal("pdstartamount"));
            BigDecimal pdcurramount = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal("pdcurramount"));
            BigDecimal pdcompanount = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal("pdcompanount"));
            BigDecimal pdendamount = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal("pdendamount"));
            BigDecimal diffAmount = BigDecimalUtils.getBigDecimalOrZero((BigDecimal)row.getBigDecimal("diffAmount"));
            if (compdstartamount.compareTo(pdstartamount) != 0) {
                newEntry = entryList.addNew();
                newEntry.set("entrycostcenter", (Object)costcenter);
                newEntry.set("costobject", (Object)costobject);
                newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u671f\u521d\u5728\u4ea7\u54c1\u6210\u672c\uff1a\u5206\u9879\u6210\u672c\u5408\u8ba1\u201c%1$s\u201d=\u7efc\u5408\u6210\u672c\u5408\u8ba1\u201c%2$s\u201d\u3002", (String)"CalcDataCheckAction_56", (String)"macc-sca-mservice", (Object[])new Object[0]), this.getBigDecimalStr(pdstartamount), this.getBigDecimalStr(compdstartamount))));
                newEntry.set("seq", (Object)seq++);
            }
            if (compdcurramount.compareTo(pdcurramount) != 0) {
                newEntry = entryList.addNew();
                newEntry.set("entrycostcenter", (Object)costcenter);
                newEntry.set("costobject", (Object)costobject);
                newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u672c\u671f\u6295\u5165\u6210\u672c\uff1a\u5206\u9879\u6210\u672c\u5408\u8ba1\u201c%1$s\u201d=\u7efc\u5408\u6210\u672c\u5408\u8ba1\u201c%2$s\u201d\u3002", (String)"CalcDataCheckAction_57", (String)"macc-sca-mservice", (Object[])new Object[0]), this.getBigDecimalStr(pdcurramount), this.getBigDecimalStr(compdcurramount))));
                newEntry.set("seq", (Object)seq++);
            }
            if (compdcompanount.compareTo(pdcompanount) != 0) {
                newEntry = entryList.addNew();
                newEntry.set("entrycostcenter", (Object)costcenter);
                newEntry.set("costobject", (Object)costobject);
                newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u672c\u671f\u5b8c\u5de5\u6210\u672c\uff1a\u5206\u9879\u6210\u672c\u5408\u8ba1\u201c%1$s\u201d=\u7efc\u5408\u6210\u672c\u5408\u8ba1\u201c%2$s\u201d\u3002", (String)"CalcDataCheckAction_58", (String)"macc-sca-mservice", (Object[])new Object[0]), this.getBigDecimalStr(pdcompanount), this.getBigDecimalStr(compdcompanount))));
                newEntry.set("seq", (Object)seq++);
            }
            if (compdendamount.compareTo(pdendamount) != 0) {
                newEntry = entryList.addNew();
                newEntry.set("entrycostcenter", (Object)costcenter);
                newEntry.set("costobject", (Object)costobject);
                newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u671f\u672b\u5728\u4ea7\u54c1\u6210\u672c\uff1a\u5206\u9879\u6210\u672c\u5408\u8ba1\u201c%1$s\u201d=\u7efc\u5408\u6210\u672c\u5408\u8ba1\u201c%2$s\u201d\u3002", (String)"CalcDataCheckAction_59", (String)"macc-sca-mservice", (Object[])new Object[0]), this.getBigDecimalStr(pdendamount), this.getBigDecimalStr(compdendamount))));
                newEntry.set("seq", (Object)seq++);
            }
            if (comdiffAmount.compareTo(diffAmount) == 0) continue;
            newEntry = entryList.addNew();
            newEntry.set("entrycostcenter", (Object)costcenter);
            newEntry.set("costobject", (Object)costobject);
            newEntry.set("checkdetail", (Object)this.tipSubStr(String.format(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\uff1a\u5206\u9879\u6210\u672c\u5408\u8ba1\u201c%1$s\u201d=\u7efc\u5408\u6210\u672c\u5408\u8ba1\u201c%2$s\u201d\u3002", (String)"CalcDataCheckAction_60", (String)"macc-sca-mservice", (Object[])new Object[0]), this.getBigDecimalStr(diffAmount), this.getBigDecimalStr(comdiffAmount))));
            newEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        return 1;
    }

    private String wrapExceptionErrorInfo(Exception ex) {
        StringBuilder erroStr = new StringBuilder();
        String errormsg = ex.getCause() == null ? (ex.getLocalizedMessage() == null ? "" : ex.getLocalizedMessage()) : ex.getCause().getMessage();
        erroStr.append(errormsg).append('\n');
        erroStr.append(ExceptionUtils.getStackTrace((Throwable)ex));
        return erroStr.toString();
    }

    private String getBigDecimalStr(BigDecimal val) {
        if (val == null) {
            return "0";
        }
        return val.stripTrailingZeros().toPlainString();
    }

    private synchronized long getItemId(String curItem, String detail) {
        long itemId = this.getResultManager().getTaskRecorder().createTaskRecordDetail(curItem, null);
        this.getResultManager().getTaskRecorder().upateTaskRecordDetail(itemId, "3");
        this.getContext().setCalcCheckRemaindCountAdd();
        this.getResultManager().getTaskRecorder().upateTaskRecordDetailPara(itemId, detail, null);
        return itemId;
    }

    private String getDiffType(String diffType) {
        if ("1".equals(diffType)) {
            return ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5dee\u5f02", (String)"CalcDataCheckAction_61", (String)"macc-sca-mservice", (Object[])new Object[0]);
        }
        if ("2".equals(diffType)) {
            return ResManager.loadKDString((String)"\u5236\u9020\u8d39\u8017\u7528\u5dee\u5f02", (String)"CalcDataCheckAction_62", (String)"macc-sca-mservice", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u6210\u672c\u66f4\u65b0\u5dee\u5f02", (String)"CalcDataCheckAction_63", (String)"macc-sca-mservice", (Object[])new Object[0]);
    }

    private DynamicObject createCheckDetailDyn(long itemId, String curItem) {
        DynamicObject checkDetail = BusinessDataServiceHelper.newDynamicObject((String)"sca_checkdetail");
        checkDetail.set("id", (Object)itemId);
        checkDetail.set("org", (Object)this.getContext().getInputArgs().getOrgId());
        checkDetail.set("costaccount", (Object)this.getContext().getInputArgs().getCostAccountId());
        checkDetail.set("period", (Object)this.getContext().getInputArgs().getPeriodId());
        checkDetail.set("currency", (Object)this.getContext().getInputArgs().getCurrencyId());
        checkDetail.set("checkitemdesc", (Object)curItem);
        checkDetail.set("calcdate", (Object)TimeServiceHelper.now());
        if (this.getContext().getInputArgs().getCostCenterIds() != null && !this.getContext().getInputArgs().getCostCenterIds().isEmpty()) {
            DynamicObjectCollection costcenterDyns = checkDetail.getDynamicObjectCollection("costcenter");
            for (Long costcenter : this.getContext().getInputArgs().getCostCenterIds()) {
                DynamicObject obj = costcenterDyns.addNew();
                obj.set("fbasedataid_id", (Object)costcenter);
            }
        }
        return checkDetail;
    }

    private String tipSubStr(String tip) {
        return StringUtils.substring((String)tip, (int)0, (int)250);
    }

    private DataSet relaSubElementData(DataSet ds) {
        DataSet subElementDs = QueryServiceHelper.queryDataSet((String)"queryCalResult", (String)"cad_subelement", (String)"id, number subelementNo,name subelementName", null, (String)"");
        return ds.leftJoin(subElementDs).on("subelement", "id").select(ds.getRowMeta().getFieldNames(), new String[]{"subelementNo", "subelementName"}).finish();
    }
}

