/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.sca.common.costcalc.CalcReportHeader;
import kd.macc.sca.mservice.costcalc.CostCalcContext;
import kd.macc.sca.mservice.costcalc.CostCalcResultManager;
import kd.macc.sca.mservice.costcalc.action.CreateCostConfirmAction;
import kd.macc.sca.mservice.costcalc.action.DeleteNotinCalcRangeResultAction;
import kd.macc.sca.mservice.costcalc.action.DeleteUnConfirmBillAction;
import kd.macc.sca.mservice.costcalc.action.ISingleBatchAction;
import kd.macc.sca.mservice.costcalc.action.MarkExpiredCalcResultAction;
import kd.macc.sca.mservice.costcalc.action.MatAllocAction;
import kd.macc.sca.mservice.costcalc.action.MatCalcAction;
import kd.macc.sca.mservice.costcalc.action.MatFinalCalcAction;
import kd.macc.sca.mservice.costcalc.action.MfgFeeCalcAction;
import kd.macc.sca.mservice.costcalc.action.MfgUnAbsorbFeeCalcAction;
import kd.macc.sca.mservice.costcalc.action.SaveCalcResultAction;
import kd.macc.sca.mservice.costcalc.action.SaveFinishDiffAction;
import kd.macc.sca.mservice.costcalc.action.SingleBatchContext;
import kd.macc.sca.mservice.costcalc.action.SingleBatchResultManager;
import kd.macc.sca.mservice.costcalc.action.SumAction;
import kd.macc.sca.mservice.costcalc.action.task.CalcTaskActionParam;

public class CalcExcuteAction {
    private static final Log logger = LogFactory.getLog(CalcExcuteAction.class);

    public void executeBatch(List<List<Object>> splitLists, Long manuOrg, int batchSize, int costObjectSize, CostCalcContext context, CostCalcResultManager resultManager, Float[] batchParamArr) {
        if (manuOrg != null) {
            context.getInputArgs().setManuOrgId(manuOrg);
        }
        for (int i = 0; i < splitLists.size(); ++i) {
            List<ISingleBatchAction> actions = this.createActions(context);
            SingleBatchContext singleBatchContext = new SingleBatchContext(context);
            singleBatchContext.setBatchCount(batchSize);
            singleBatchContext.setCurrBatchSeq(i + 1);
            singleBatchContext.setBatchSize(costObjectSize);
            singleBatchContext.setCostObjectIds(splitLists.get(i));
            singleBatchContext.setBatchProcess(CalcExcuteAction.getCurrBatchProcess(batchParamArr));
            SingleBatchResultManager singleBatchResultManager = new SingleBatchResultManager(resultManager);
            logger.info(String.format("\u5206\u6279\u8ba1\u7b97\uff1a\u5f00\u59cb\u7b2c%s\u6279(\u5171%s\u6279)\uff0c%s\u5f20", singleBatchContext.getCurrBatchSeq(), singleBatchContext.getBatchCount(), singleBatchContext.getCostObjectIds().size()));
            context.setCurrentBatch(context.getCurrentBatch() + 1);
            for (ISingleBatchAction action : actions) {
                action.setSingleBatchContext(singleBatchContext);
                action.setSingleBatchResultManager(singleBatchResultManager);
                action.execute();
            }
        }
    }

    private static int getCurrBatchProcess(Float[] batchParamArr) {
        float process = batchParamArr[0].floatValue();
        int currP = (int)(process += batchParamArr[1].floatValue());
        batchParamArr[0] = Float.valueOf(process -= (float)currP);
        return currP;
    }

    public void executeTask(List<Object> costObjectList, Long manuOrg, CalcTaskActionParam params) {
        CostCalcContext context = new CostCalcContext();
        context.setInputArgs(params.getInputArgs());
        context.setTaskType(params.getTaskType());
        context.setIsConcurrency(true);
        CostCalcResultManager resultManager = new CostCalcResultManager();
        IDataEntityType rptHeadType = CalcReportHeader.getDataEntityType();
        Object[] rptObjs = BusinessDataServiceHelper.load((Object[])new Object[]{context.getInputArgs().getCalcReportId()}, (IDataEntityType)rptHeadType);
        if (rptObjs != null && rptObjs.length > 0) {
            CalcReportHeader calcRpt = (CalcReportHeader)rptObjs[0];
            resultManager.setCalcReport(calcRpt);
        }
        if (manuOrg != null) {
            context.getInputArgs().setManuOrgId(manuOrg);
        }
        List<ISingleBatchAction> actions = this.createActions(context);
        SingleBatchContext singleBatchContext = new SingleBatchContext(context);
        singleBatchContext.getEquivalentMap().clear();
        singleBatchContext.getObjectInfosMap().clear();
        singleBatchContext.setCostObjectIds(costObjectList);
        singleBatchContext.setCurrBatchSeq(params.getCurrBatchSeq());
        singleBatchContext.setBatchCount(params.getBatchCount());
        singleBatchContext.setBatchProcess(params.getBatchProcess());
        SingleBatchResultManager singleBatchResultManager = new SingleBatchResultManager(resultManager);
        for (ISingleBatchAction action : actions) {
            action.setSingleBatchContext(singleBatchContext);
            action.setSingleBatchResultManager(singleBatchResultManager);
            action.execute();
        }
    }

    private List<ISingleBatchAction> createActions(CostCalcContext context) {
        ArrayList<ISingleBatchAction> actions = new ArrayList<ISingleBatchAction>(10);
        switch (context.getTaskType()) {
            case FinishCalc: 
            case RealtimeFinishCalc: {
                actions.add(new MarkExpiredCalcResultAction());
                actions.add(new MatAllocAction());
                actions.add(new MatCalcAction());
                actions.add(new MfgFeeCalcAction());
                actions.add(new MatFinalCalcAction());
                actions.add(new SumAction());
                actions.add(new SaveCalcResultAction());
                actions.add(new CreateCostConfirmAction());
                break;
            }
            case PeriodEndCalc: {
                actions.add(new MarkExpiredCalcResultAction());
                actions.add(new MatAllocAction());
                actions.add(new MatCalcAction());
                actions.add(new MfgFeeCalcAction());
                actions.add(new MatFinalCalcAction());
                actions.add(new DeleteUnConfirmBillAction());
                actions.add(new SumAction());
                actions.add(new MfgUnAbsorbFeeCalcAction());
                actions.add(new SaveCalcResultAction());
                actions.add(new SaveFinishDiffAction());
                actions.add(new DeleteNotinCalcRangeResultAction());
                break;
            }
        }
        return actions;
    }
}

