/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import java.util.Collections;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.macc.sca.common.costcalc.CostCalcArgs;
import kd.macc.sca.mservice.costcalc.CalcTaskType;
import kd.macc.sca.mservice.costcalc.action.AbstractCalcAction;
import kd.macc.sca.mservice.costcalc.action.CalcLogRunnable;

public class CalcLogAction
extends AbstractCalcAction {
    @Override
    protected void doExecute() {
        CalcTaskType taskType = this.getContext().getTaskType();
        CostCalcArgs calcArgs = this.getContext().getInputArgs();
        QFilter filter = new QFilter("org", "=", (Object)calcArgs.getOrgId());
        filter.and("costobject", "in", (Object)calcArgs.getCostObjectIds());
        filter.and("costaccount", "=", (Object)calcArgs.getCostAccountId());
        filter.and("period", "=", (Object)calcArgs.getPeriodId());
        if (taskType == CalcTaskType.FinishCalc) {
            filter.and("billstatus", "=", (Object)Character.valueOf('A'));
            Date today = TimeServiceHelper.now();
            DynamicObject[] calclogs = BusinessDataServiceHelper.load((String)"sca_autofinish_calclog", (String)"id,billstatus,modifytime", (QFilter[])filter.toArray());
            if (calclogs != null && calclogs.length > 0) {
                for (DynamicObject calclog : calclogs) {
                    calclog.set("modifytime", (Object)today);
                    calclog.set("billstatus", (Object)"B");
                }
                SaveServiceHelper.save((DynamicObject[])calclogs);
            }
        } else if (taskType == CalcTaskType.RealtimeFinishCalc) {
            ThreadPools.executeOnce((String)"kd.macc.sca.mservice.costcalc.action.doExecute", (Runnable)new CalcLogRunnable(Collections.singletonList(calcArgs), "2", null));
        }
    }
}

