/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.common.costcalc.CostCalcArgs;

@Deprecated
public class CalcLogRunnable
implements Runnable {
    private static final Log logger = LogFactory.getLog(CalcLogRunnable.class);
    private List<CostCalcArgs> calcArgs;
    private String logtype;
    private String message;

    public CalcLogRunnable(List<CostCalcArgs> calcArgs, String logtype, String message) {
        this.calcArgs = calcArgs;
        this.logtype = logtype;
        this.message = message;
    }

    @Override
    public void run() {
        if (this.calcArgs != null && !this.calcArgs.isEmpty()) {
            logger.info("\u7ebf\u7a0b\u5199\u5165\u81ea\u52a8\u5b8c\u5de5\u7ed3\u7b97\u65e5\u5fd7");
            String traceId = RequestContext.get().getTraceId();
            for (CostCalcArgs temp : this.calcArgs) {
                this.saveAutofinishCalclog(temp, traceId);
            }
        }
    }

    private void saveAutofinishCalclog(CostCalcArgs calcArgs, String traceId) {
        this.deleteAutofinishCalclog(calcArgs);
        String message = CalcLogRunnable.getMessage(calcArgs.getCostAccountId(), this.logtype, this.message);
        DynamicObjectCollection costobjects = this.getCostobjects(calcArgs);
        ArrayList<DynamicObject> calcLogList = new ArrayList<DynamicObject>();
        Date today = TimeServiceHelper.now();
        for (DynamicObject temp : costobjects) {
            DynamicObject calclog = BusinessDataServiceHelper.newDynamicObject((String)"sca_autofinish_calclog");
            String srcbillno = temp.getString("srcbillnumber");
            String billNo = srcbillno + "-" + today.getTime();
            calclog.set("billno", (Object)billNo);
            calclog.set("org", (Object)temp.getLong("org"));
            calclog.set("costaccount", (Object)calcArgs.getCostAccountId());
            if ("2".equals(this.logtype)) {
                calclog.set("billstatus", (Object)"B");
            } else {
                calclog.set("billstatus", (Object)"A");
            }
            calclog.set("period", (Object)calcArgs.getPeriodId());
            calclog.set("costobject", (Object)temp.getLong("id"));
            calclog.set("srcbillno", (Object)srcbillno);
            calclog.set("srcentryseq", (Object)temp.getLong("srcbillrow"));
            calclog.set("srcentryid", (Object)temp.getLong("probill"));
            calclog.set("logtype", (Object)this.logtype);
            calclog.set("logdetail", (Object)message);
            calclog.set("traceid", (Object)traceId);
            calclog.set("modifytime", (Object)today);
            calclog.set("createtime", (Object)today);
            calcLogList.add(calclog);
        }
        SaveServiceHelper.save((DynamicObject[])calcLogList.toArray(new DynamicObject[calcLogList.size()]));
    }

    private void deleteAutofinishCalclog(CostCalcArgs calcArgs) {
        logger.info("\u9884\u8ba1\u5220\u9664\u81ea\u52a8\u5b8c\u5de5\u7ed3\u7b97\u65e5\u5fd7\u6570\u91cf:" + calcArgs.getCostObjectIds().size());
        QFilter filter = new QFilter("org", "=", (Object)calcArgs.getOrgId());
        filter.and("costobject", "in", (Object)calcArgs.getCostObjectIds());
        filter.and("costaccount", "=", (Object)calcArgs.getCostAccountId());
        filter.and("period", "=", (Object)calcArgs.getPeriodId());
        int num = DeleteServiceHelper.delete((String)"sca_autofinish_calclog", (QFilter[])filter.toArray());
        logger.info("\u5b9e\u9645\u5220\u9664\u81ea\u52a8\u5b8c\u5de5\u7ed3\u7b97\u65e5\u5fd7\u6570\u91cf:" + num);
    }

    public static String getMessage(Long costAccountId, String logtype, String message) {
        if ("2".equals(logtype)) {
            return ResManager.loadKDString((String)"\u6210\u529f", (String)"CalcLogRunnable_3", (String)"macc-sca-mservice", (Object[])new Object[0]);
        }
        if ("0".equals(logtype)) {
            QFilter filter = new QFilter("id", "=", (Object)costAccountId);
            DynamicObject account = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"id,number,name,calorg.name orgname", (QFilter[])filter.toArray());
            return String.format(ResManager.loadKDString((String)"\u4e92\u65a5-%1$s,%2$s\u5176\u4ed6\u5de5\u5355\u6b63\u5728\u8fdb\u884c\u81ea\u52a8\u5b8c\u5de5\u7ed3\u7b97", (String)"CalcLogRunnable_11", (String)"macc-sca-mservice", (Object[])new Object[0]), account.getString("orgname"), account.getString("name"));
        }
        if ("1".equals(logtype)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u5f02\u5e38\u4e2d\u65ad\u539f\u56e0-%s", (String)"CalcLogRunnable_10", (String)"macc-sca-mservice", (Object[])new Object[0]), message);
            if (StringUtils.isEmpty((Object)message)) {
                errMsg = ResManager.loadKDString((String)"\u5f02\u5e38\u4e2d\u65ad", (String)"CalcLogRunnable_7", (String)"macc-sca-mservice", (Object[])new Object[0]);
            }
            if (errMsg.length() > 250) {
                errMsg = errMsg.substring(0, 250);
            }
            return errMsg;
        }
        if ("3".equals(logtype)) {
            return ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u6570\u636e\u4e0d\u5b8c\u6574\u3002", (String)"CalcLogRunnable_8", (String)"macc-sca-mservice", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7684\u65e5\u5fd7\u7c7b\u578b", (String)"CalcLogRunnable_9", (String)"macc-sca-mservice", (Object[])new Object[0]);
    }

    private DynamicObjectCollection getCostobjects(CostCalcArgs calcArgs) {
        QFilter filter = new QFilter("id", "in", (Object)calcArgs.getCostObjectIds());
        DynamicObjectCollection costobjects = QueryServiceHelper.query((String)"cad_costobject", (String)"id,org,costcenter,sotype,bizstatus,srcbillnumber,probill,srcbillrow", (QFilter[])filter.toArray());
        return costobjects;
    }
}

