/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.common.costcalc.CalcReportCostCenter;
import kd.macc.sca.common.costcalc.CalcReportHeader;
import kd.macc.sca.common.costcalc.CalcReportManuOrg;
import kd.macc.sca.mservice.costcalc.action.AbstractCalcAction;

class CreateCalcReportHeaderAction
extends AbstractCalcAction {
    private static final Log logger = LogFactory.getLog(CreateCalcReportHeaderAction.class);

    CreateCalcReportHeaderAction() {
    }

    @Override
    protected void doExecute() {
        IDataEntityType entryType;
        IDataEntityType rptHeadType = CalcReportHeader.getDataEntityType();
        Long id = this.getContext().getInputArgs().getCalcReportId();
        logger.info(String.format("\u521b\u5efa\u8ba1\u7b97\u62a5\u544a\uff1a\u5f00\u59cb, \u5df2\u4f20\u5165calcReportId: %s", id));
        if (id == null || Long.compare(0L, id) == 0) {
            id = DBServiceHelper.genGlobalLongId();
        } else {
            Object[] rptObjs = BusinessDataServiceHelper.load((Object[])new Object[]{id}, (IDataEntityType)rptHeadType);
            if (rptObjs != null && rptObjs.length > 0) {
                CalcReportHeader calcRpt = (CalcReportHeader)rptObjs[0];
                this.getResultManager().setCalcReport(calcRpt);
                logger.info("\u8ba1\u7b97\u62a5\u544a\u5df2\u5b58\u5728\uff0c\u4e0d\u9700\u521b\u5efa\uff0c\u9000\u51fa");
                return;
            }
        }
        this.getContext().setLogUniqueKey(id + "");
        DynamicObject taskConfig = this.getContext().getTaskConfig();
        CalcReportHeader reportHeader = new CalcReportHeader();
        ArrayList<CalcReportCostCenter> costCenters = new ArrayList<CalcReportCostCenter>();
        reportHeader.setId(id.longValue());
        reportHeader.setTaskName(taskConfig.getString("name"));
        if (this.getContext().getInputArgs().getStartTime() != null) {
            reportHeader.setStartTime(this.getContext().getInputArgs().getStartTime());
        } else {
            reportHeader.setStartTime(new Date());
        }
        reportHeader.setUseTime(0L);
        reportHeader.setStatus("2");
        reportHeader.setProgress(0);
        reportHeader.setExecutor(Long.parseLong(RequestContext.get().getUserId()));
        reportHeader.setReportType(this.getContext().getReportType());
        reportHeader.setOrg(this.getContext().getInputArgs().getOrgId().longValue());
        reportHeader.setCostAccount(this.getContext().getInputArgs().getCostAccountId().longValue());
        reportHeader.setCurrency(this.getContext().getInputArgs().getCurrencyId().longValue());
        reportHeader.setPeriod(this.getContext().getInputArgs().getPeriodId().longValue());
        if (this.getContext().getInputArgs().getCostCenterIds() != null) {
            for (Object costCenterId : this.getContext().getInputArgs().getCostCenterIds()) {
                CalcReportCostCenter costCenter = new CalcReportCostCenter();
                costCenter.setId(id.longValue());
                costCenter.setPkid(DBServiceHelper.genGlobalLongId());
                costCenter.setCostCenter(((Long)costCenterId).longValue());
                costCenters.add(costCenter);
            }
        }
        ArrayList<CalcReportManuOrg> manuOrgs = new ArrayList<CalcReportManuOrg>();
        if (this.getContext().getInputArgs().getManuOrgIds() != null) {
            for (Long manuOrgId : this.getContext().getInputArgs().getManuOrgIds()) {
                CalcReportManuOrg manuOrg = new CalcReportManuOrg();
                manuOrg.setId(id.longValue());
                manuOrg.setPkid(DBServiceHelper.genGlobalLongId());
                manuOrg.setManuOrg(manuOrgId.longValue());
                manuOrgs.add(manuOrg);
            }
        }
        SaveServiceHelper.save((IDataEntityType)rptHeadType, (Object[])new Object[]{reportHeader});
        this.getContext().getInputArgs().setCalcReportId(id);
        this.getResultManager().setCalcReport(reportHeader);
        if (!costCenters.isEmpty()) {
            entryType = OrmUtils.getDataEntityType(CalcReportCostCenter.class);
            SaveServiceHelper.save((IDataEntityType)entryType, (Object[])costCenters.toArray());
        }
        if (!manuOrgs.isEmpty()) {
            entryType = OrmUtils.getDataEntityType(CalcReportManuOrg.class);
            SaveServiceHelper.save((IDataEntityType)entryType, (Object[])manuOrgs.toArray());
        }
        logger.info(String.format("\u521b\u5efa\u8ba1\u7b97\u62a5\u544a\uff1a\u7ed3\u675f\u3002 calcReportId: %s", reportHeader.getId()));
    }
}

