/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.macc.sca.common.costcalc.CostCalcArgs;
import kd.macc.sca.mservice.costcalc.CostCalcFilterBuilder;
import kd.macc.sca.mservice.costcalc.action.AbstractSingleBatchAction;

class DeleteUnConfirmBillAction
extends AbstractSingleBatchAction {
    private static final Log logger = LogFactory.getLog(DeleteUnConfirmBillAction.class);
    private CostCalcArgs args;
    private CostCalcFilterBuilder filterBuilder;

    DeleteUnConfirmBillAction() {
    }

    @Override
    protected void doExecute() {
        this.args = this.getContext().getInputArgs();
        this.filterBuilder = this.getContext().getFilterBuilder();
        Set<Long> unConfirmBillIds = this.loadUnConfirmBillIds();
        if (!unConfirmBillIds.isEmpty()) {
            Object[] pks = unConfirmBillIds.toArray();
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"sca_costconfirm");
            DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])pks);
            logger.info(String.format("\u5220\u9664\u672a\u786e\u8ba4\u7684\u6210\u672c\u786e\u8ba4\u5355 %s \u5f20 : %s", unConfirmBillIds.size(), StringUtils.join((Object[])pks, (String)",")));
        } else {
            logger.info("\u5220\u9664\u672a\u786e\u8ba4\u7684\u6210\u672c\u786e\u8ba4\u53550\u5f20");
        }
    }

    private Set<Long> loadUnConfirmBillIds() {
        List<Object> costObjectIds = this.getSingleBatchContext().getCostObjectIds();
        if (costObjectIds.isEmpty()) {
            return new HashSet<Long>(0);
        }
        QFilter filter = this.filterBuilder.buildCalcResultCommonFilter(this.args, costObjectIds, true, true, true);
        filter.and(new QFilter("bizstatus", "=", (Object)"A"));
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadUnConfirmBillIds"), (String)"sca_costconfirm", (String)"id", (QFilter[])new QFilter[]{filter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ids.add(row.getLong("id"));
            }
        }
        logger.info(String.format("\u8bfb\u53d6\u5f53\u671f\u672a\u786e\u8ba4\u7684\u6210\u672c\u786e\u8ba4\u5355%s\u5f20\uff0c\u5f85\u5220\u9664\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", ids.size(), this.getContext().getFilterBuilder().buildQFilterLogString(filter)));
        return ids;
    }
}

