/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.macc.sca.algox.constants.FinshCalcCheck;
import kd.macc.sca.common.costcalc.CostCalcArgs;
import kd.macc.sca.mservice.costcalc.action.AbstractSingleBatchAction;

class MarkExpiredCalcResultAction
extends AbstractSingleBatchAction {
    private static final Log logger = LogFactory.getLog(MarkExpiredCalcResultAction.class);
    private static final String ALGO_KEY_LOAD_CALC_RESULT = "kd.macc.sca.mservice.costcalc.action.MarkExpiredCalcResultAction.loadCalcResult";
    private static final String ALGO_KEY_LOAD_COST_CONFIRM = "kd.macc.sca.mservice.costcalc.action.MarkExpiredCalcResultAction.loadCostConfirm";
    private static final String SQL_UPDATE_CALC_RESULT = "update t_sca_calcresult set forgid = ? where fid = ?";
    private CostCalcArgs args;
    private List<Object> costObjectIds;
    private Set<Long> expiredCalcResultIds = null;

    MarkExpiredCalcResultAction() {
    }

    @Override
    protected void doExecute() {
        logger.info("\u6e05\u9664\u5386\u53f2\u6570\u636e\uff1a\u5f00\u59cb");
        this.args = this.getContext().getInputArgs();
        this.costObjectIds = this.getSingleBatchContext().getCostObjectIds();
        if (!this.getContext().getIsConcurrency().booleanValue()) {
            this.upateTaskRecordDetail(FinshCalcCheck.CALCTASKCLEARCALCRES, "2");
        }
        this.expiredCalcResultIds = this.loadExpiredCalcResultIds();
        this.expireCalcResult(this.expiredCalcResultIds);
        this.getSingleBatchResultManager().getExpiredCalcResultIds().addAll(this.expiredCalcResultIds);
        if (!this.getContext().getIsConcurrency().booleanValue()) {
            this.upateTaskRecordProcess(FinshCalcCheck.CALCTASKCLEARCALCRES, "2");
            this.upateTaskRecordDetail(FinshCalcCheck.CALCTASKCLEARCALCRES, "4");
        }
        logger.info(String.format("\u6e05\u9664\u5386\u53f2\u6570\u636e\uff1a\u7ed3\u675f\u3002\u5171\u6807\u8bb0\u5931\u6548\u6210\u672c\u8ba1\u7b97\u5355 %s \u5f20", this.expiredCalcResultIds.size()));
    }

    private Set<Long> loadExpiredCalcResultIds() {
        QFilter filter = this.getContext().getFilterBuilder().buildCalcResultCommonFilter(this.args, this.costObjectIds, true, true, true);
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY_LOAD_CALC_RESULT, (String)"sca_calcresult", (String)"id", (QFilter[])new QFilter[]{filter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ids.add(row.getLong(0));
            }
        }
        logger.info(String.format("\u8bfb\u53d6\u5386\u53f2\u6210\u672c\u8ba1\u7b97\u7ed3\u679c\uff0c\u5171\u53d6\u51fa\u5355\u636e%s\u5f20\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", ids.size(), this.getContext().getFilterBuilder().buildQFilterLogString(filter)));
        return ids;
    }

    private void expireCalcResult(Set<Long> calcResultIds) {
        if (calcResultIds == null || calcResultIds.isEmpty()) {
            return;
        }
        ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(calcResultIds.size());
        for (Long id : calcResultIds) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("org", -5, (Object)999999L), new SqlParameter("id", -5, (Object)id)};
            paramsList.add(params);
        }
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_sca_calcresult", (HintCondition[])new HintCondition[]{new HintCondition("fperiodid", "=", (Object)this.getContext().getInputArgs().getPeriodId())});){
            DB.executeBatch((DBRoute)new DBRoute("cal"), (String)SQL_UPDATE_CALC_RESULT, paramsList);
        }
    }

    private Set<Long> loadExpiredCostConfirmIds() {
        QFilter filter = this.getContext().getFilterBuilder().buildCalcResultCommonFilter(this.args, this.costObjectIds, true, true, true);
        if (this.args.getCostCenterIds() != null && !this.args.getCostObjectIds().isEmpty()) {
            filter.and(new QFilter("costcenter", "=", (Object)this.args.getCostCenterIds()));
        }
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY_LOAD_COST_CONFIRM, (String)"sca_costconfirm", (String)"id", (QFilter[])new QFilter[]{filter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ids.add(row.getLong(0));
            }
        }
        logger.info(String.format("\u8bfb\u53d6\u5386\u53f2\u6210\u672c\u786e\u8ba4\u5355\uff0c\u5171\u53d6\u51fa\u5355\u636e%s\u5f20\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", ids.size(), this.getContext().getFilterBuilder().buildQFilterLogString(filter)));
        return ids;
    }

    private void deleteCostConfirm(Set<Long> costConfirmIds) {
        if (costConfirmIds == null || costConfirmIds.isEmpty()) {
            return;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"sca_costconfirm");
        DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])costConfirmIds.toArray());
    }
}

