/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import kd.macc.sca.algox.constants.FinshCalcCheck;
import kd.macc.sca.algox.utils.CostTypeHelper;
import kd.macc.sca.algox.utils.ScaCalcHelper;
import kd.macc.sca.algox.utils.TaskHelper;
import kd.macc.sca.algox.utils.TimeUtils;
import kd.macc.sca.common.costcalc.CalcResultEntryRow;
import kd.macc.sca.common.costcalc.CalcResultHeader;
import kd.macc.sca.mservice.costcalc.action.AbstractSingleBatchAction;
import kd.macc.sca.mservice.costcalc.action.MatCalcTailDiffFunction;
import kd.macc.sca.mservice.costcalc.groupkey.CostObjectItemIdKey;
import kd.macc.sca.mservice.costcalc.groupkey.CostObjectItemKey;
import kd.macc.sca.mservice.costcalc.groupkey.CostObjectKey;
import kd.macc.sca.mservice.costcalc.groupkey.CostObjectSubItemIdKey;
import kd.macc.sca.mservice.costcalc.groupkey.CostObjectSubItemKey;

class MatCalcAction
extends AbstractSingleBatchAction {
    private static final Log logger = LogFactory.getLog(MatCalcAction.class);
    private Map<CostObjectKey, Map<CostObjectItemKey, CalcResultEntryRow>> itemResultRows = new HashMap<CostObjectKey, Map<CostObjectItemKey, CalcResultEntryRow>>();
    private Map<CostObjectKey, Map<CostObjectSubItemKey, CalcResultEntryRow>> subItemResultRows = new HashMap<CostObjectKey, Map<CostObjectSubItemKey, CalcResultEntryRow>>();
    private Set<CostObjectItemIdKey> doneSrcBill_Items = new HashSet<CostObjectItemIdKey>();
    private Set<CostObjectSubItemIdKey> doneSrcBill_SubItems = new HashSet<CostObjectSubItemIdKey>();
    private Set<Long> onlyClearOnce = new HashSet<Long>();
    private int matAllocRowCount = 0;

    MatCalcAction() {
    }

    @Override
    public Long getDetailTaskConfigId() {
        if (this.getContext().isFinishCalc()) {
            return FinshCalcCheck.CALCTASKABSORBEDFEE;
        }
        return TaskHelper.PDENDENTRY_MATCALC_TASKID;
    }

    @Override
    protected void doExecute() {
        logger.info(String.format("\u5438\u6536\u6750\u6599\u8d39\u7528\uff1a\u5f00\u59cb\uff0c\u7b2c %s / %s\u6279\uff0c\u5171 %s \u5f20", this.getSingleBatchContext().getCurrBatchSeq(), this.getSingleBatchContext().getBatchCount(), this.getSingleBatchContext().getCostObjectIds().size()));
        if (!this.getContext().getIsConcurrency().booleanValue()) {
            this.upateTaskRecordDetail(this.getDetailTaskConfigId(), "2");
        }
        this.itemResultRows.clear();
        this.subItemResultRows.clear();
        this.doneSrcBill_Items.clear();
        this.doneSrcBill_SubItems.clear();
        this.onlyClearOnce.clear();
        this.doCalculate();
        if (!this.getContext().getIsConcurrency().booleanValue()) {
            this.upateTaskRecordProcess(this.getDetailTaskConfigId(), "2");
            this.upateTaskRecordDetail(this.getDetailTaskConfigId(), "4");
        }
        logger.info(String.format("\u5438\u6536\u6750\u6599\u8d39\u7528\uff1a\u7ed3\u675f\uff0c\u5171\u5904\u7406 %s \u6761\u6750\u6599\u5206\u914d\u5206\u5f55\u884c\uff0c\u5408\u5e76\u7efc\u5408\u9879%s\u884c\uff0c\u5206\u9879%s\u884c", this.matAllocRowCount, this.doneSrcBill_Items.size(), this.doneSrcBill_SubItems.size()));
    }

    private DataSet queryMatAllocDataSet() {
        boolean isUseMatVer = CostTypeHelper.isUseMatVer((Long)this.getContext().getInputArgs().getCostAccountId());
        String selectFields = "id,manuorg,org,costaccount,entryentity.costobejctentry.costcenter costcenter,currency,period,material material_count,entryentity.id entryid,entryentity.costobejctentry costobject,entryentity.costobejctentry.material material,entryentity.qty qty,entryentity.amount amount,matversion,auxpty,keycol,keycolid,calckeycol,matcostinfo matcostid,entryentity.elemententry element,entryentity.subelemententry subelement,entryentity.subentryentity.id subentryid,entryentity.subentryentity.submaterial material_sub,entryentity.subentryentity.element element_sub,entryentity.subentryentity.subelement subelement_sub,entryentity.subentryentity.submatverison matversion_sub,entryentity.subentryentity.subauxpty auxpty_sub,entryentity.subentryentity.standardamt amount_sub,entryentity.subentryentity.subqty qty_sub,entryentity.subentryentity.resource resource_sub,entryentity.subentryentity.calcbasis calcbasis_sub,entryentity.subentryentity.subentrykeycol keycol_sub,entryentity.subentryentity.subentrykeycolid keycolid_sub";
        if (!isUseMatVer) {
            selectFields = "id,manuorg,org,costaccount,entryentity.costobejctentry.costcenter costcenter,currency,period,material material_count,entryentity.id entryid,entryentity.costobejctentry costobject,entryentity.costobejctentry.material material,entryentity.qty qty,entryentity.amount amount,0 matversion,auxpty,keycol,keycolid,calckeycol,matcostinfo matcostid,entryentity.elemententry element,entryentity.subelemententry subelement,entryentity.subentryentity.id subentryid,entryentity.subentryentity.submaterial material_sub,entryentity.subentryentity.element element_sub,entryentity.subentryentity.subelement subelement_sub,0 matversion_sub,entryentity.subentryentity.subauxpty auxpty_sub,entryentity.subentryentity.standardamt amount_sub,entryentity.subentryentity.subqty qty_sub,entryentity.subentryentity.resource resource_sub,entryentity.subentryentity.calcbasis calcbasis_sub,entryentity.subentryentity.subentrykeycol keycol_sub,entryentity.subentryentity.subentrykeycolid keycolid_sub";
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject currency = this.getContext().getCurrencyObj();
        this.getContext().getFilterBuilder().warpQFilter4Period(filters, "org", true, this.getContext().getInputArgs());
        this.getContext().getFilterBuilder().wrapQFilter4CostObjects(filters, "entryentity.costobejctentry", this.getSingleBatchContext().getCostObjectIds());
        filters.add(new QFilter("allocstatus", "=", (Object)"2"));
        filters.add(new QFilter("appnum", "=", (Object)"sca"));
        logger.info(String.format("\u8bfb\u53d6\u6750\u6599\u8017\u8d39\u5f52\u96c6\u5355\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", this.getContext().getFilterBuilder().buildQFilterLogString(filters)));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.mservice.costcalc.action.MatCalcAction.queryMatAllocDataSet", (String)"sca_matalloc", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), (String)"");
        DataSet actDataSet = dataSet.filter("subentryid != 0 and subentryid is not null");
        DataSet stdDataSet = dataSet.filter("subentryid == 0 or subentryid is null");
        DataSet subItemStdDataSet = this.getSubItemStdDataSet(stdDataSet.copy());
        DataSet resultDataSet = stdDataSet.join(subItemStdDataSet, JoinType.LEFT).on("keycol", "keycol").on("keycolid", "keycolid").on("matcostid", "matcostid").select(new String[]{"id", "calckeycol", "entryid", "manuorg", "org", "costaccount", "costcenter", "currency", "period", "material_count", "costobject", "material", "qty", "amount", "matversion", "auxpty", "element", "subelement"}, subItemStdDataSet.getRowMeta().getFieldNames()).finish();
        JobSession session = AlgoX.createSession((String)"SctCalc-MatCalcTail");
        DataSetX resultDataSetX = session.fromInput((Input)new DataSetInput(resultDataSet));
        resultDataSetX = resultDataSetX.addFields(new Field[]{new Field("tmpamt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
        resultDataSetX = resultDataSetX.groupBy(new String[]{"id", "entryid"}).reduceGroup((GroupReduceFunction)new MatCalcTailDiffFunction(this.getContext().getCurrencyAmtScale()));
        DataSetOutput resultSet = new DataSetOutput(resultDataSetX.getRowMeta());
        resultDataSetX.output((Output)resultSet);
        try {
            long start = System.currentTimeMillis();
            session.commit(20, TimeUnit.MINUTES);
            logger.info("\u6807\u51c6\u6210\u672c\u8ba1\u7b97-\u6750\u6599\u8c03\u5dee\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error("\u6807\u51c6\u6210\u672c\u8ba1\u7b97-\u6750\u6599\u8c03\u5dee\u51fa\u9519\uff1a", (Throwable)e);
            throw e;
        }
        resultDataSet = session.readDataSet(resultSet.getId());
        resultDataSet = resultDataSet.filter("eid is not null").select("id,entryid,manuorg,org,costaccount,costcenter,currency,period,material_count,costobject,material,qty,amount,matversion,auxpty,keycol,keycolid,calckeycol,matcostid,element,subelement,subentryid,material_sub,element_sub,subelement_sub,matversion_sub,auxpty_sub,tmpamt amount_sub,qty*qty_sub qty_sub,resource_sub,calcbasis_sub,keycol_sub,keycolid_sub");
        return resultDataSet == null ? actDataSet : DataSetUtils.union((DataSet)actDataSet, (DataSet)resultDataSet);
    }

    private DataSet getSubItemStdDataSet(DataSet comStdDataSet) {
        HashSet<Long> matCostIds = new HashSet<Long>(200);
        while (comStdDataSet.hasNext()) {
            Row row = comStdDataSet.next();
            Long matcostid = row.getLong("matcostid");
            if (CadEmptyUtils.isEmpty((Long)matcostid)) continue;
            matCostIds.add(matcostid);
        }
        QFilter matCostIdFilter = new QFilter("matcostid", "in", matCostIds);
        QFilter calcTypeFilter = new QFilter("entryentity.datatype", "in", (Object)new String[]{"2", "3"});
        QFilter stdIsMainDataFilter = new QFilter("ismaindata", "=", (Object)1);
        DataSet effDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getSubItemStdDataSet"), (String)"cad_calceffectiveresult", (String)"id eid,keycol,keycolid,matcostid,entryentity.id subentryid,entryentity.submaterial.id material_sub,entryentity.element.masterid element_sub,entryentity.subelement.masterid subelement_sub,0 matversion_sub,entryentity.subauxproperty.id auxpty_sub,entryentity.stdprice amount_sub,entryentity.qty qty_sub,entryentity.resource.id resource_sub,entryentity.calcbasis calcbasis_sub,entryentity.datatype datatype_sub,entryentity.subkeycol keycol_sub,entryentity.subkeycolid keycolid_sub", (QFilter[])new QFilter[]{matCostIdFilter, calcTypeFilter, stdIsMainDataFilter}, null);
        Set effIds = ScaCalcHelper.getLongIdSetFromDs((DataSet)effDataSet, (String)"matcostid", (boolean)true);
        matCostIds.removeAll(effIds);
        if (matCostIds.isEmpty()) {
            return effDataSet;
        }
        QFilter idFilter = new QFilter("id", "in", matCostIds);
        DataSet purDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getSubItemStdDataSet"), (String)"cad_matcostinfo", (String)"id eid,keycol,keycolid, id matcostid,entryentity.id subentryid,material.id material_sub,entryentity.element.masterid element_sub,entryentity.subelement.masterid subelement_sub,0 matversion_sub,auxpty.id auxpty_sub,entryentity.standardcost amount_sub,1 qty_sub,0 resource_sub,'' calcbasis_sub,'' datatype_sub,keycol keycol_sub,keycolid keycolid_sub", (QFilter[])new QFilter[]{idFilter}, null);
        return effDataSet.union(purDataSet);
    }

    private void doCalculate() {
        this.matAllocRowCount = 0;
        try (DataSet dataSet = this.queryMatAllocDataSet();){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                this.doCalculateRow(row);
                ++this.matAllocRowCount;
            }
        }
    }

    private void doCalculateRow(Row row) {
        CostObjectKey costObjectKey = new CostObjectKey(row.getLong("org"), row.getLong("costaccount"), row.getLong("costcenter"), row.getLong("currency"), row.getLong("period"), row.getLong("costobject"));
        CalcResultHeader calcResultHeader = this.getSingleBatchResultManager().getCalcResults().get(costObjectKey.getCostObjectId());
        if (calcResultHeader == null) {
            calcResultHeader = this.addNewCalcResultHeader(row, costObjectKey);
            this.onlyClearOnce.add(calcResultHeader.getId());
        } else if (!this.onlyClearOnce.contains(calcResultHeader.getId())) {
            this.onlyClearOnce.add(calcResultHeader.getId());
        }
        this.doCalcCount(row, costObjectKey, calcResultHeader);
        this.doCalcSubCount(row, costObjectKey, calcResultHeader);
    }

    private CalcResultHeader addNewCalcResultHeader(Row row, CostObjectKey costObjectKey) {
        Object bizDate;
        CalcResultHeader calcResultHeader = new CalcResultHeader();
        this.getSingleBatchResultManager().getCalcResults().put(costObjectKey.getCostObjectId(), calcResultHeader);
        calcResultHeader.setId(DBServiceHelper.genGlobalLongId());
        calcResultHeader.setBillNo("NO." + System.currentTimeMillis());
        if (costObjectKey.getOrgId() != null) {
            calcResultHeader.setOrg(costObjectKey.getOrgId().longValue());
        }
        if (costObjectKey.getCostAccountId() != null) {
            calcResultHeader.setCostAccount(costObjectKey.getCostAccountId().longValue());
        }
        if (costObjectKey.getCostCenterId() != null) {
            calcResultHeader.setCostCenter(costObjectKey.getCostCenterId().longValue());
        }
        if (costObjectKey.getCurrencyId() != null) {
            calcResultHeader.setCurrency(costObjectKey.getCurrencyId().longValue());
        }
        if (this.getContext().getInputArgs().getPeriodId() != null) {
            calcResultHeader.setPeriod(this.getContext().getInputArgs().getPeriodId().longValue());
        }
        if (costObjectKey.getCostObjectId() != null) {
            calcResultHeader.setCostObject(costObjectKey.getCostObjectId().longValue());
        }
        if ((bizDate = TimeUtils.compareToEndDate((Date)this.getContext().getInputArgs().getEndDate())) != null) {
            if (bizDate instanceof Date) {
                calcResultHeader.setBizDate((Date)bizDate);
            } else if (bizDate instanceof Calendar) {
                calcResultHeader.setBizDate(((Calendar)bizDate).getTime());
            }
        }
        calcResultHeader.setBillStatus("A");
        calcResultHeader.setBizStatus("A");
        return calcResultHeader;
    }

    private void doCalcCount(Row row, CostObjectKey costObjectKey, CalcResultHeader calcResultHeader) {
        Long calckeycolId;
        CostObjectItemKey itemKey = new CostObjectItemKey(costObjectKey, row.getLong("material"), row.getLong("material_count"), row.getLong("matversion"), row.getLong("auxpty"), row.getLong("element"), row.getLong("subelement"), row.getString("keycol"), row.getLong("keycolid"));
        Long srcBillId = row.getLong("id");
        CostObjectItemIdKey idKey = new CostObjectItemIdKey(srcBillId, itemKey);
        if (this.doneSrcBill_Items.contains(idKey)) {
            return;
        }
        this.doneSrcBill_Items.add(idKey);
        this.itemResultRows.computeIfAbsent(costObjectKey, s -> new HashMap());
        CalcResultEntryRow entryRow = this.itemResultRows.get(costObjectKey).get(itemKey);
        if (entryRow == null) {
            entryRow = calcResultHeader.addNew();
            this.itemResultRows.get(costObjectKey).put(itemKey, entryRow);
            if (itemKey.getMaterialId_count() != null) {
                entryRow.setMaterial(itemKey.getMaterialId_count().longValue());
            }
            if (itemKey.getMatVersionId() != null) {
                entryRow.setMatVersion(itemKey.getMatVersionId().longValue());
            }
            if (itemKey.getAuxPtyId() != null) {
                entryRow.setAuxpty(itemKey.getAuxPtyId().longValue());
            }
            if (itemKey.getElementId() != null) {
                entryRow.setElement(itemKey.getElementId().longValue());
            }
            if (itemKey.getSubElementId() != null) {
                entryRow.setSubElement(itemKey.getSubElementId().longValue());
            }
            if (itemKey.getKeycol() != null) {
                entryRow.setKeycol(itemKey.getKeycol());
            }
            if (itemKey.getKeycolId() != null) {
                entryRow.setKeycolId(itemKey.getKeycolId().longValue());
            }
            entryRow.setCalType(this.getContext().getInputArgs().getMatCalType());
            entryRow.setDataType("1");
            entryRow.setDiffType(this.getContext().getMatSubElement().contains(entryRow.getSubElement()) ? "1" : "2");
            entryRow.setCostObject(row.getLong("costobject").longValue());
            entryRow.setProductType("C");
        }
        if (!CadEmptyUtils.isEmpty((Long)(calckeycolId = row.getLong("calckeycol")))) {
            entryRow.addKeycolVal(calckeycolId, row.getBigDecimal("qty"));
        }
        entryRow.addPdCurrQty(row.getBigDecimal("qty"));
        entryRow.addPdCurrAmount(row.getBigDecimal("amount"));
        entryRow.addTaskValInfo("sca_matalloc", srcBillId.toString(), "qty", "PdCurrQty", row.getBigDecimal("qty"));
        entryRow.addTaskValInfo("sca_matalloc", srcBillId.toString(), "amount", "PdCurrAmount", row.getBigDecimal("amount"));
    }

    private void doCalcSubCount(Row row, CostObjectKey costObjectKey, CalcResultHeader calcResultHeader) {
        String calcbasis = row.getString("calcbasis_sub");
        CostObjectSubItemKey subItemKey = new CostObjectSubItemKey(costObjectKey, row.getLong("subentryid"), row.getLong("material_sub"), row.getLong("matversion_sub"), row.getLong("auxpty_sub"), row.getLong("element_sub"), row.getLong("subelement_sub"), row.getLong("resource_sub"), StringUtils.isBlank((CharSequence)calcbasis) ? "0" : calcbasis, row.getString("keycol_sub"), row.getLong("keycolid_sub"));
        Long srcBillId = row.getLong("id");
        CostObjectSubItemIdKey idKey = new CostObjectSubItemIdKey(srcBillId, subItemKey);
        if (this.doneSrcBill_SubItems.contains(idKey)) {
            return;
        }
        this.doneSrcBill_SubItems.add(idKey);
        this.subItemResultRows.computeIfAbsent(costObjectKey, s -> new HashMap());
        CalcResultEntryRow entryRow = this.subItemResultRows.get(costObjectKey).get(subItemKey);
        if (entryRow == null) {
            entryRow = calcResultHeader.addNew();
            this.subItemResultRows.get(costObjectKey).put(subItemKey, entryRow);
            if (subItemKey.getMaterialId() != null) {
                entryRow.setMaterial(subItemKey.getMaterialId().longValue());
            }
            if (subItemKey.getMatVersionId() != null) {
                entryRow.setMatVersion(subItemKey.getMatVersionId().longValue());
            }
            if (subItemKey.getAuxPtyId() != null) {
                entryRow.setAuxpty(subItemKey.getAuxPtyId().longValue());
            }
            if (subItemKey.getElementId() != null) {
                entryRow.setElement(subItemKey.getElementId().longValue());
            }
            if (subItemKey.getSubElementId() != null) {
                entryRow.setSubElement(subItemKey.getSubElementId().longValue());
            }
            if (subItemKey.getResourceId() != null) {
                entryRow.setResource(subItemKey.getResourceId().longValue());
            }
            if (subItemKey.getKeycol() != null) {
                entryRow.setKeycol(subItemKey.getKeycol());
            }
            if (subItemKey.getKeycolId() != null) {
                entryRow.setKeycolId(subItemKey.getKeycolId().longValue());
            }
            entryRow.setCalcbasis(row.getString("calcbasis_sub"));
            entryRow.setCalType(this.getContext().getInputArgs().getMatCalType());
            entryRow.setDataType("2");
            entryRow.setDiffType(this.getContext().getMatSubElement().contains(entryRow.getSubElement()) ? "1" : "2");
            if ("2".equals(entryRow.getDiffType()) || entryRow.getResource() > 0L) {
                entryRow.setCostLevel("3");
            }
            entryRow.setCostObject(row.getLong("costobject").longValue());
            entryRow.setProductType("C");
        }
        entryRow.addPdCurrQty(row.getBigDecimal("qty_sub"));
        entryRow.addPdCurrAmount(row.getBigDecimal("amount_sub"));
        entryRow.addTaskValInfo("sca_matalloc", srcBillId.toString(), "subqty", "PdCurrQty", row.getBigDecimal("qty_sub"));
        entryRow.addTaskValInfo("sca_matalloc", srcBillId.toString(), "standardamt", "PdCurrAmount", row.getBigDecimal("amount_sub"));
    }
}

